/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.preference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.jsf.facesconfig.ui.preference.BaseFigureDecorator;
import org.eclipse.jst.jsf.facesconfig.ui.preference.IBaseFigure;
import org.eclipse.jst.jsf.facesconfig.ui.preference.InputPortFigure;
import org.eclipse.jst.jsf.facesconfig.ui.preference.ObserveVisibleXYLayout;
import org.eclipse.jst.jsf.facesconfig.ui.preference.OutputPortFigure;
import org.eclipse.jst.jsf.facesconfig.ui.preference.PortConnectionAnchor;
import org.eclipse.jst.jsf.facesconfig.ui.preference.PortFigure;
import org.eclipse.swt.graphics.Image;

public class BaseNodeFigure
extends Figure
implements IBaseFigure {
    protected IBaseFigure baseFigure;
    protected boolean anchorsVisible = true;
    protected Hashtable connectionAnchors = new Hashtable(7);
    protected Vector inputConnectionAnchors = new Vector(2, 2);
    protected Vector outputConnectionAnchors = new Vector(2, 2);
    protected Vector topConnectionAnchors = new Vector();
    protected Vector bottomConnectionAnchors = new Vector();
    protected Vector leftConnectionAnchors = new Vector();
    protected Vector rightConnectionAnchors = new Vector();

    public BaseNodeFigure(IBaseFigure figure) {
        this.setBaseFigure(figure);
        ObserveVisibleXYLayout layout = new ObserveVisibleXYLayout();
        layout.setObserveVisibility(true);
        this.setLayoutManager((LayoutManager)layout);
    }

    public void setBaseFigure(IBaseFigure figure) {
        this.setBaseFigure(figure, new Rectangle(0, 0, -1, -1));
    }

    public void setHighlight(boolean flag) {
        if (this.baseFigure != null) {
            BaseNodeFigure.moveToTop(this, this.baseFigure);
            this.baseFigure.setHighlight(flag);
        }
    }

    public void setBaseFigure(IBaseFigure figure, Rectangle constraint) {
        if (!this.getChildren().contains(figure)) {
            if (this.getChildren().contains(this.baseFigure)) {
                this.remove(this.baseFigure);
            }
            this.baseFigure = figure;
            if (!this.getChildren().contains(this.baseFigure)) {
                if (this.getParent() != null && this.getParent().getLayoutManager() != null) {
                    Rectangle r = this.getBounds().getCopy();
                    r.width = -1;
                    r.height = -1;
                    this.getParent().getLayoutManager().setConstraint((IFigure)this, (Object)r);
                }
                this.add(this.baseFigure, constraint, 0);
            }
        }
    }

    public IBaseFigure getBaseFigure() {
        return this.baseFigure;
    }

    public void addInput(String portName) {
        InputPortFigure inputPort = new InputPortFigure();
        this.add((IFigure)inputPort);
        inputPort.setToolTipText(portName);
        PortConnectionAnchor anchor = new PortConnectionAnchor((IFigure)inputPort);
        this.getTargetConnectionAnchors().add(anchor);
        this.connectionAnchors.put(portName, anchor);
    }

    public PortConnectionAnchor addOutput(String portName) {
        OutputPortFigure outputPort = new OutputPortFigure();
        this.add((IFigure)outputPort);
        outputPort.setToolTipText(portName);
        PortConnectionAnchor anchor = new PortConnectionAnchor((IFigure)outputPort);
        this.getSourceConnectionAnchors().add(anchor);
        this.connectionAnchors.put(portName, anchor);
        return anchor;
    }

    public ConnectionAnchor connectionAnchorAt(Point p) {
        long d;
        Point p2;
        ConnectionAnchor c;
        ConnectionAnchor closest = null;
        long min = Long.MAX_VALUE;
        Enumeration e = this.getSourceConnectionAnchors().elements();
        while (e.hasMoreElements()) {
            c = (ConnectionAnchor)e.nextElement();
            p2 = c.getLocation(null);
            d = p.getDistance2(p2);
            if (d >= min) continue;
            min = d;
            closest = c;
        }
        e = this.getTargetConnectionAnchors().elements();
        while (e.hasMoreElements()) {
            c = (ConnectionAnchor)e.nextElement();
            p2 = c.getLocation(null);
            d = p.getDistance2(p2);
            if (d >= min) continue;
            min = d;
            closest = c;
        }
        return closest;
    }

    public ConnectionAnchor getConnectionAnchor(String portName) {
        return (ConnectionAnchor)this.connectionAnchors.get(portName);
    }

    public String getConnectionAnchorName(ConnectionAnchor c) {
        Enumeration enumer = this.connectionAnchors.keys();
        while (enumer.hasMoreElements()) {
            String key = (String)enumer.nextElement();
            if (!this.connectionAnchors.get(key).equals(c)) continue;
            return key;
        }
        return null;
    }

    public ConnectionAnchor getSourceConnectionAnchorAt(Point p) {
        ConnectionAnchor closest = null;
        long min = Long.MAX_VALUE;
        Enumeration e = this.getSourceConnectionAnchors().elements();
        while (e.hasMoreElements()) {
            ConnectionAnchor c = (ConnectionAnchor)e.nextElement();
            Point p2 = c.getLocation(null);
            long d = p.getDistance2(p2);
            if (d >= min) continue;
            min = d;
            closest = c;
        }
        return closest;
    }

    public Vector getSourceConnectionAnchors() {
        return this.outputConnectionAnchors;
    }

    public ConnectionAnchor getTargetConnectionAnchorAt(Point p) {
        ConnectionAnchor closest = null;
        long min = Long.MAX_VALUE;
        Enumeration e = this.getTargetConnectionAnchors().elements();
        while (e.hasMoreElements()) {
            ConnectionAnchor c = (ConnectionAnchor)e.nextElement();
            Point p2 = c.getLocation(null);
            long d = p.getDistance2(p2);
            if (d >= min) continue;
            min = d;
            closest = c;
        }
        return closest;
    }

    public Vector getTargetConnectionAnchors() {
        return this.inputConnectionAnchors;
    }

    public String getNameForAnchor(ConnectionAnchor anchor) {
        if (anchor != null) {
            Iterator it = this.connectionAnchors.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                if (!anchor.equals(this.connectionAnchors.get(name))) continue;
                return name;
            }
        }
        return null;
    }

    public void setAnchorsVisible(boolean visible) {
        if (this.anchorsVisible != visible) {
            this.anchorsVisible = visible;
            ArrayList all = new ArrayList();
            all.addAll(this.getTargetConnectionAnchors());
            all.addAll(this.getSourceConnectionAnchors());
            Iterator it = all.iterator();
            while (it.hasNext()) {
                IFigure fig = ((ConnectionAnchor)it.next()).getOwner();
                fig.setVisible(visible);
            }
            this.validate();
        }
    }

    protected void determineAnchorPositions() {
        this.topConnectionAnchors.clear();
        this.bottomConnectionAnchors.clear();
        this.leftConnectionAnchors.clear();
        this.rightConnectionAnchors.clear();
        if (this.anchorsVisible) {
            Point otherLoc;
            ConnectionAnchor otherPort;
            PolylineConnection conn;
            Iterator itc;
            Point loc;
            int direction;
            PortConnectionAnchor port;
            this.baseFigure.getPreferredSize();
            Iterator it = this.getSourceConnectionAnchors().iterator();
            block0: while (it.hasNext()) {
                port = (PortConnectionAnchor)((Object)it.next());
                direction = port.getOrientation();
                if (direction == 0) {
                    loc = port.getOwner().getParent().getBounds().getLocation();
                    itc = port.getConnections().iterator();
                    if (itc.hasNext()) {
                        while (itc.hasNext()) {
                            conn = (PolylineConnection)itc.next();
                            otherPort = port == conn.getSourceAnchor() ? conn.getTargetAnchor() : conn.getSourceAnchor();
                            if (otherPort.getOwner() == null) continue;
                            otherLoc = otherPort.getOwner().getParent().getBounds().getLocation();
                            direction = loc.getPosition(otherLoc);
                            if (direction == 1) {
                                this.topConnectionAnchors.add(port);
                            } else if (direction == 4) {
                                this.bottomConnectionAnchors.add(port);
                            } else if (direction == 8) {
                                this.leftConnectionAnchors.add(port);
                            } else {
                                this.rightConnectionAnchors.add(port);
                            }
                            ((PortFigure)port.getOwner()).setOrientation(direction);
                            continue block0;
                        }
                        continue;
                    }
                    this.rightConnectionAnchors.add(port);
                    ((PortFigure)port.getOwner()).setOrientation(16);
                    continue;
                }
                if (direction == 1) {
                    this.topConnectionAnchors.add(port);
                    continue;
                }
                if (direction == 4) {
                    this.bottomConnectionAnchors.add(port);
                    continue;
                }
                if (direction == 8) {
                    this.leftConnectionAnchors.add(port);
                    continue;
                }
                this.rightConnectionAnchors.add(port);
            }
            it = this.getTargetConnectionAnchors().iterator();
            block2: while (it.hasNext()) {
                port = (PortConnectionAnchor)((Object)it.next());
                direction = port.getOrientation();
                if (direction == 0) {
                    loc = port.getOwner().getParent().getBounds().getLocation();
                    itc = port.getConnections().iterator();
                    if (itc.hasNext()) {
                        while (itc.hasNext()) {
                            conn = (PolylineConnection)itc.next();
                            otherPort = port == conn.getSourceAnchor() ? conn.getTargetAnchor() : conn.getSourceAnchor();
                            if (otherPort.getOwner() == null) continue;
                            otherLoc = otherPort.getOwner().getParent().getBounds().getLocation();
                            direction = loc.getPosition(otherLoc);
                            if (direction == 1) {
                                this.topConnectionAnchors.add(port);
                            } else if (direction == 4) {
                                this.bottomConnectionAnchors.add(port);
                            } else if (direction == 16) {
                                this.rightConnectionAnchors.add(port);
                            } else {
                                this.leftConnectionAnchors.add(port);
                            }
                            ((PortFigure)port.getOwner()).setOrientation(direction);
                            continue block2;
                        }
                        continue;
                    }
                    this.leftConnectionAnchors.add(port);
                    ((PortFigure)port.getOwner()).setOrientation(8);
                    continue;
                }
                if (direction == 1) {
                    this.topConnectionAnchors.add(port);
                    continue;
                }
                if (direction == 4) {
                    this.bottomConnectionAnchors.add(port);
                    continue;
                }
                if (direction == 16) {
                    this.rightConnectionAnchors.add(port);
                    continue;
                }
                this.leftConnectionAnchors.add(port);
            }
            Comparator comparePorts = new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    PortConnectionAnchor port0 = (PortConnectionAnchor)((Object)arg0);
                    if (port0.getConnections().size() < 1) {
                        return 0;
                    }
                    PortConnectionAnchor port1 = (PortConnectionAnchor)((Object)arg1);
                    if (port1.getConnections().size() < 1) {
                        return 0;
                    }
                    if (port0.getOrientation() != 0) {
                        return 0;
                    }
                    if (port1.getOrientation() != 0) {
                        return 0;
                    }
                    PolylineConnection conn0 = (PolylineConnection)port0.getConnections().get(0);
                    ConnectionAnchor otherPort0 = port0 == conn0.getSourceAnchor() ? conn0.getTargetAnchor() : conn0.getSourceAnchor();
                    Point otherLoc0 = otherPort0.getOwner().getParent().getBounds().getLocation();
                    PolylineConnection conn1 = (PolylineConnection)port1.getConnections().get(0);
                    ConnectionAnchor otherPort1 = port1 == conn1.getSourceAnchor() ? conn1.getTargetAnchor() : conn1.getSourceAnchor();
                    Point otherLoc1 = otherPort1.getOwner().getParent().getBounds().getLocation();
                    ((BaseNodeFigure)otherPort1.getOwner().getParent()).getBaseFigure().getPreferredSize();
                    switch (((PortFigure)port0.getOwner()).getOrientation()) {
                        case 1: 
                        case 4: {
                            return otherLoc0.x - otherLoc1.x;
                        }
                        case 8: 
                        case 16: {
                            return otherLoc0.y - otherLoc1.y;
                        }
                    }
                    return 0;
                }
            };
            Collections.sort(this.topConnectionAnchors, comparePorts);
            Collections.sort(this.leftConnectionAnchors, comparePorts);
            Collections.sort(this.bottomConnectionAnchors, comparePorts);
            Collections.sort(this.rightConnectionAnchors, comparePorts);
        }
    }

    protected void placeAnchors() {
        this.determineAnchorPositions();
        if (this.anchorsVisible) {
            Rectangle oldrect;
            PortConnectionAnchor port;
            Rectangle r;
            Dimension sz = this.baseFigure.getPreferredSize();
            LayoutManager layout = this.getLayoutManager();
            Dimension d = this.getAnchorSize();
            int x = 0;
            int y = 1;
            y += d.height;
            y += (sz.height - this.leftConnectionAnchors.size() * (d.height + 2)) / 2;
            Iterator it = this.leftConnectionAnchors.iterator();
            while (it.hasNext()) {
                r = new Rectangle(x, y, -1, -1);
                port = (PortConnectionAnchor)((Object)it.next());
                oldrect = (Rectangle)layout.getConstraint(port.getOwner());
                if (!r.equals((Object)oldrect)) {
                    layout.setConstraint(port.getOwner(), (Object)new Rectangle(x, y, -1, -1));
                }
                y += d.height + 2;
            }
            x = sz.width;
            x += d.width;
            y = 1;
            y += d.height;
            y += (sz.height - this.rightConnectionAnchors.size() * (d.height + 2)) / 2;
            it = this.rightConnectionAnchors.iterator();
            while (it.hasNext()) {
                r = new Rectangle(x, y, -1, -1);
                port = (PortConnectionAnchor)((Object)it.next());
                oldrect = (Rectangle)layout.getConstraint(port.getOwner());
                if (!r.equals((Object)oldrect)) {
                    layout.setConstraint(port.getOwner(), (Object)new Rectangle(x, y, -1, -1));
                }
                y += d.height + 2;
            }
            y = 0;
            x = 1;
            x += d.width;
            x += (sz.width - this.topConnectionAnchors.size() * (d.width + 2)) / 2;
            it = this.topConnectionAnchors.iterator();
            while (it.hasNext()) {
                r = new Rectangle(x, y, -1, -1);
                port = (PortConnectionAnchor)((Object)it.next());
                oldrect = (Rectangle)layout.getConstraint(port.getOwner());
                if (!r.equals((Object)oldrect)) {
                    layout.setConstraint(port.getOwner(), (Object)new Rectangle(x, y, -1, -1));
                }
                x += d.width + 2;
            }
            y = sz.height;
            y += d.height;
            x = 1;
            x += d.width;
            x += (sz.width - this.bottomConnectionAnchors.size() * (d.width + 2)) / 2;
            it = this.bottomConnectionAnchors.iterator();
            while (it.hasNext()) {
                r = new Rectangle(x, y, -1, -1);
                port = (PortConnectionAnchor)((Object)it.next());
                oldrect = (Rectangle)layout.getConstraint(port.getOwner());
                if (!r.equals((Object)oldrect)) {
                    layout.setConstraint(port.getOwner(), (Object)new Rectangle(x, y, -1, -1));
                }
                x += d.width + 2;
            }
        }
    }

    public Dimension getAnchorSize() {
        Dimension d = new Dimension(10, 10);
        if (!this.connectionAnchors.isEmpty()) {
            Iterator iter = this.connectionAnchors.values().iterator();
            PortConnectionAnchor a = (PortConnectionAnchor)((Object)iter.next());
            d = a.getOwner().getPreferredSize();
        }
        return d;
    }

    public Insets getAnchorInsets() {
        Insets in = new Insets(0, 0, 0, 0);
        Dimension d = this.getAnchorSize();
        in.left = d.width;
        in.right = d.width;
        in.top = d.height;
        in.bottom = d.height;
        return in;
    }

    public void invalidate() {
        super.invalidate();
    }

    public void validate() {
        this.placeAnchors();
        int x = 0;
        int y = 0;
        if (this.anchorsVisible) {
            Dimension d = this.getAnchorSize();
            x = d.width;
            y = d.height;
        }
        this.getLayoutManager().setConstraint((IFigure)this.baseFigure, (Object)new Rectangle(x, y, -1, -1));
        this.layout();
        super.validate();
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    public void setBounds(Rectangle rect) {
        Rectangle r = rect.getCopy();
        r.x = 0;
        r.y = 0;
        if (this.anchorsVisible) {
            Dimension d = this.getAnchorSize();
            r.x += d.width;
            r.width -= d.width;
            r.width -= d.width;
            r.y += d.height;
            r.height -= d.height;
            r.height -= d.height;
        }
        this.baseFigure.setBounds(r);
        r.setLocation(rect.getLocation());
        super.setBounds(r);
    }

    public Rectangle getBounds() {
        Dimension size = this.baseFigure.getBounds().getSize();
        if (this.anchorsVisible) {
            Dimension d = this.getAnchorSize();
            size.width += d.width;
            size.width += d.width;
            size.height += d.height;
            size.height += d.height;
        }
        Rectangle r = super.getBounds();
        r.setSize(size);
        return r;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension size = this.baseFigure.getPreferredSize(wHint, hHint).getCopy();
        if (this.anchorsVisible) {
            Dimension d = this.getAnchorSize();
            size.width += d.width;
            size.width += d.width;
            size.height += d.height;
            size.height += d.height;
        }
        return size;
    }

    public static void moveToTop(IFigure parent, IFigure child) {
        parent.getChildren().remove(child);
        parent.getChildren().add(child);
    }

    public void moveToTop() {
        IFigure parent = this.getParent();
        BaseNodeFigure child = this;
        while (parent != null && !(parent instanceof Layer)) {
            child = parent;
            parent = parent.getParent();
        }
        if (parent instanceof Layer) {
            parent.getChildren().remove(child);
            parent.getChildren().add(child);
        }
    }

    public void setText(String text) {
        this.baseFigure.setText(text);
    }

    public void setIcon(Image image) {
        this.baseFigure.setIcon(image);
    }

    public void setToolTipText(String text) {
        this.baseFigure.setToolTipText(text);
    }

    public void addDecorator(BaseFigureDecorator decorator) {
        this.baseFigure.addDecorator(decorator);
    }

    public void removeDecorator() {
        this.baseFigure.removeDecorator();
    }

    public void removeDecorator(int position) {
        this.baseFigure.removeDecorator(position);
    }

    public List getDecorators() {
        return this.baseFigure.getDecorators();
    }

    public String getText() {
        return this.baseFigure.getText();
    }

    public Rectangle getTextBounds() {
        Rectangle r = this.baseFigure.getTextBounds().getCopy();
        r.x += this.getBounds().x;
        r.y += this.getBounds().y;
        return r;
    }

    public Image getIcon() {
        return this.baseFigure.getIcon();
    }

    public String getToolTipText() {
        return this.baseFigure.getToolTipText();
    }
}

