/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.adapters.java;

import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.tests.projects.MappedSuperclassTestProject;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.orm.AttributeOverride;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.dali.orm.adapters.java.Type;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;

public class JavaAttributeOverrideModelAdapterTests
extends TestCase {
    private MappedSuperclassTestProject project;
    private PersistentType employeePersistentType;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.core.tests.adapters.java.JavaAttributeOverrideModelAdapterTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public JavaAttributeOverrideModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = new MappedSuperclassTestProject();
        this.project.setPersistenceNature();
        PersistenceFile employeePersistenceFile = DaliPlugin.getPersistenceFile((IFile)((IFile)this.project.getEmployeeType().getCompilationUnit().getResource()));
        this.employeePersistentType = (PersistentType)employeePersistenceFile.getPersistentTypes().get(0);
    }

    protected void tearDown() throws Exception {
        this.employeePersistentType = null;
        this.project.dispose();
        super.tearDown();
    }

    public void testPopulateAttributeOverrides() {
        EList attributeOverrides = ((Entity)this.employeePersistentType.getTypeMapping()).getAttributeOverrides();
        JavaAttributeOverrideModelAdapterTests.assertEquals((int)2, (int)attributeOverrides.size());
        AttributeOverride attributeOverride = (AttributeOverride)attributeOverrides.get(0);
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"id", (String)attributeOverride.getName());
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"id", (String)attributeOverride.getColumn().getDefaultName());
        attributeOverride = (AttributeOverride)attributeOverrides.get(1);
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"name", (String)attributeOverride.getName());
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"name", (String)attributeOverride.getColumn().getDefaultName());
    }

    public void testPopulatePersistenceModelWithAttributeOverrideAnnotation1() throws Exception {
        Type type = (Type)ClassTools.getFieldValue((Object)this.employeePersistentType.getModelAdapter(), (String)"type");
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                AST ast = bodyDeclaration.getAST();
                NormalAnnotation annotation = ASTTools.newNormalAnnotation((AST)ast, (String)"AttributeOverride");
                ASTTools.addLiteralMemberValuePair((NormalAnnotation)annotation, (String)"name", (String)"id");
                NormalAnnotation columnAnnotation = ASTTools.newNormalAnnotation((AST)ast, (String)"Column");
                ASTTools.addLiteralMemberValuePair((NormalAnnotation)columnAnnotation, (String)"name", (String)"MY_ID");
                MemberValuePair columnValuePair = ast.newMemberValuePair();
                columnValuePair.setName(ast.newSimpleName("column"));
                columnValuePair.setValue((Expression)columnAnnotation);
                ASTTools.addValuePair((NormalAnnotation)annotation, (MemberValuePair)columnValuePair);
                ASTTools.addAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)annotation);
            }
        });
        EList attributeOverrides = ((Entity)this.employeePersistentType.getTypeMapping()).getAttributeOverrides();
        JavaAttributeOverrideModelAdapterTests.assertEquals((int)2, (int)attributeOverrides.size());
        AttributeOverride attributeOverride = (AttributeOverride)attributeOverrides.get(0);
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"id", (String)attributeOverride.getName());
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"id", (String)attributeOverride.getColumn().getDefaultName());
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"MY_ID", (String)attributeOverride.getColumn().getSpecifiedName());
        attributeOverride = (AttributeOverride)attributeOverrides.get(1);
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"name", (String)attributeOverride.getName());
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"name", (String)attributeOverride.getColumn().getDefaultName());
    }

    public void testPopulatePersistenceModelWithAttributeOverrideAnnotation2() throws Exception {
        Type type = (Type)ClassTools.getFieldValue((Object)this.employeePersistentType.getModelAdapter(), (String)"type");
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                AST ast = bodyDeclaration.getAST();
                SingleMemberAnnotation attributeOverridesAnnotation = ASTTools.newSingleMemberAnnotation((AST)ast, (String)"AttributeOverrides");
                NormalAnnotation annotation = ASTTools.newNormalAnnotation((AST)ast, (String)"AttributeOverride");
                ASTTools.addLiteralMemberValuePair((NormalAnnotation)annotation, (String)"name", (String)"id");
                NormalAnnotation columnAnnotation = ASTTools.newNormalAnnotation((AST)ast, (String)"Column");
                ASTTools.addLiteralMemberValuePair((NormalAnnotation)columnAnnotation, (String)"name", (String)"MY_ID");
                MemberValuePair columnValuePair = ast.newMemberValuePair();
                columnValuePair.setName(ast.newSimpleName("column"));
                columnValuePair.setValue((Expression)columnAnnotation);
                ASTTools.addValuePair((NormalAnnotation)annotation, (MemberValuePair)columnValuePair);
                attributeOverridesAnnotation.setValue((Expression)annotation);
                ASTTools.addAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)attributeOverridesAnnotation);
            }
        });
        EList attributeOverrides = ((Entity)this.employeePersistentType.getTypeMapping()).getAttributeOverrides();
        JavaAttributeOverrideModelAdapterTests.assertEquals((int)2, (int)attributeOverrides.size());
        AttributeOverride attributeOverride = (AttributeOverride)attributeOverrides.get(0);
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"id", (String)attributeOverride.getName());
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"id", (String)attributeOverride.getColumn().getDefaultName());
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"MY_ID", (String)attributeOverride.getColumn().getSpecifiedName());
        attributeOverride = (AttributeOverride)attributeOverrides.get(1);
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"name", (String)attributeOverride.getName());
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"name", (String)attributeOverride.getColumn().getDefaultName());
    }

    public void testPopulatePersistenceModelWithAttributeOverrideAnnotation3() throws Exception {
        Type type = (Type)ClassTools.getFieldValue((Object)this.employeePersistentType.getModelAdapter(), (String)"type");
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                AST ast = bodyDeclaration.getAST();
                NormalAnnotation attributeOverridesAnnotation = ASTTools.newNormalAnnotation((AST)ast, (String)"AttributeOverrides");
                NormalAnnotation annotation = ASTTools.newNormalAnnotation((AST)ast, (String)"AttributeOverride");
                ASTTools.addLiteralMemberValuePair((NormalAnnotation)annotation, (String)"name", (String)"id");
                NormalAnnotation columnAnnotation = ASTTools.newNormalAnnotation((AST)ast, (String)"Column");
                ASTTools.addLiteralMemberValuePair((NormalAnnotation)columnAnnotation, (String)"name", (String)"MY_ID");
                MemberValuePair columnValuePair = ast.newMemberValuePair();
                columnValuePair.setName(ast.newSimpleName("column"));
                columnValuePair.setValue((Expression)columnAnnotation);
                ASTTools.addValuePair((NormalAnnotation)annotation, (MemberValuePair)columnValuePair);
                MemberValuePair valueValuePair = ast.newMemberValuePair();
                valueValuePair.setName(ast.newSimpleName("value"));
                valueValuePair.setValue((Expression)annotation);
                ASTTools.addValuePair((NormalAnnotation)attributeOverridesAnnotation, (MemberValuePair)valueValuePair);
                ASTTools.addAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)attributeOverridesAnnotation);
            }
        });
        EList attributeOverrides = ((Entity)this.employeePersistentType.getTypeMapping()).getAttributeOverrides();
        JavaAttributeOverrideModelAdapterTests.assertEquals((int)2, (int)attributeOverrides.size());
        AttributeOverride attributeOverride = (AttributeOverride)attributeOverrides.get(0);
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"id", (String)attributeOverride.getName());
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"id", (String)attributeOverride.getColumn().getDefaultName());
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"MY_ID", (String)attributeOverride.getColumn().getSpecifiedName());
        attributeOverride = (AttributeOverride)attributeOverrides.get(1);
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"name", (String)attributeOverride.getName());
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"name", (String)attributeOverride.getColumn().getDefaultName());
    }

    public void testPopulatePersistenceModelWithAttributeOverrideAnnotation4() throws Exception {
        Type type = (Type)ClassTools.getFieldValue((Object)this.employeePersistentType.getModelAdapter(), (String)"type");
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                AST ast = bodyDeclaration.getAST();
                SingleMemberAnnotation attributeOverridesAnnotation = ASTTools.newSingleMemberAnnotation((AST)ast, (String)"AttributeOverrides");
                NormalAnnotation annotation = ASTTools.newNormalAnnotation((AST)ast, (String)"AttributeOverride");
                ASTTools.addLiteralMemberValuePair((NormalAnnotation)annotation, (String)"name", (String)"id");
                NormalAnnotation columnAnnotation = ASTTools.newNormalAnnotation((AST)ast, (String)"Column");
                ASTTools.addLiteralMemberValuePair((NormalAnnotation)columnAnnotation, (String)"name", (String)"MY_ID");
                MemberValuePair columnValuePair = ast.newMemberValuePair();
                columnValuePair.setName(ast.newSimpleName("column"));
                columnValuePair.setValue((Expression)columnAnnotation);
                ASTTools.addValuePair((NormalAnnotation)annotation, (MemberValuePair)columnValuePair);
                ArrayInitializer arrayInitializer = ast.newArrayInitializer();
                List list = (List)arrayInitializer.getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY);
                list.add(annotation);
                attributeOverridesAnnotation.setValue((Expression)arrayInitializer);
                ASTTools.addAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)attributeOverridesAnnotation);
            }
        });
        EList attributeOverrides = ((Entity)this.employeePersistentType.getTypeMapping()).getAttributeOverrides();
        JavaAttributeOverrideModelAdapterTests.assertEquals((int)2, (int)attributeOverrides.size());
        AttributeOverride attributeOverride = (AttributeOverride)attributeOverrides.get(0);
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"id", (String)attributeOverride.getName());
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"id", (String)attributeOverride.getColumn().getDefaultName());
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"MY_ID", (String)attributeOverride.getColumn().getSpecifiedName());
        attributeOverride = (AttributeOverride)attributeOverrides.get(1);
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"name", (String)attributeOverride.getName());
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"name", (String)attributeOverride.getColumn().getDefaultName());
    }

    public void testPopulatePersistenceModelWithAttributeOverrideAnnotation5() throws Exception {
        Type type = (Type)ClassTools.getFieldValue((Object)this.employeePersistentType.getModelAdapter(), (String)"type");
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                AST ast = bodyDeclaration.getAST();
                NormalAnnotation attributeOverridesAnnotation = ASTTools.newNormalAnnotation((AST)ast, (String)"AttributeOverrides");
                NormalAnnotation annotation = ASTTools.newNormalAnnotation((AST)ast, (String)"AttributeOverride");
                ASTTools.addLiteralMemberValuePair((NormalAnnotation)annotation, (String)"name", (String)"id");
                NormalAnnotation columnAnnotation = ASTTools.newNormalAnnotation((AST)ast, (String)"Column");
                ASTTools.addLiteralMemberValuePair((NormalAnnotation)columnAnnotation, (String)"name", (String)"MY_ID");
                MemberValuePair columnValuePair = ast.newMemberValuePair();
                columnValuePair.setName(ast.newSimpleName("column"));
                columnValuePair.setValue((Expression)columnAnnotation);
                ASTTools.addValuePair((NormalAnnotation)annotation, (MemberValuePair)columnValuePair);
                ArrayInitializer arrayInitializer = ast.newArrayInitializer();
                List list = (List)arrayInitializer.getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY);
                list.add(annotation);
                MemberValuePair valueValuePair = ast.newMemberValuePair();
                valueValuePair.setName(ast.newSimpleName("value"));
                valueValuePair.setValue((Expression)arrayInitializer);
                ASTTools.addValuePair((NormalAnnotation)attributeOverridesAnnotation, (MemberValuePair)valueValuePair);
                ASTTools.addAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)attributeOverridesAnnotation);
            }
        });
        EList attributeOverrides = ((Entity)this.employeePersistentType.getTypeMapping()).getAttributeOverrides();
        JavaAttributeOverrideModelAdapterTests.assertEquals((int)2, (int)attributeOverrides.size());
        AttributeOverride attributeOverride = (AttributeOverride)attributeOverrides.get(0);
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"id", (String)attributeOverride.getName());
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"id", (String)attributeOverride.getColumn().getDefaultName());
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"MY_ID", (String)attributeOverride.getColumn().getSpecifiedName());
        attributeOverride = (AttributeOverride)attributeOverrides.get(1);
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"name", (String)attributeOverride.getName());
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"name", (String)attributeOverride.getColumn().getDefaultName());
    }

    public void testPopulatePersistenceModelWithAttributeOverrideAnnotationInvalidColumn() throws Exception {
        Type type = (Type)ClassTools.getFieldValue((Object)this.employeePersistentType.getModelAdapter(), (String)"type");
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                AST ast = bodyDeclaration.getAST();
                SingleMemberAnnotation attributeOverridesAnnotation = ASTTools.newSingleMemberAnnotation((AST)ast, (String)"AttributeOverrides");
                NormalAnnotation annotation = ASTTools.newNormalAnnotation((AST)ast, (String)"AttributeOverride");
                ASTTools.addLiteralMemberValuePair((NormalAnnotation)annotation, (String)"name", (String)"id");
                ASTTools.addLiteralMemberValuePair((NormalAnnotation)annotation, (String)"column", (String)"MY_ID");
                attributeOverridesAnnotation.setValue((Expression)annotation);
                ASTTools.addAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)attributeOverridesAnnotation);
            }
        });
        EList attributeOverrides = ((Entity)this.employeePersistentType.getTypeMapping()).getAttributeOverrides();
        JavaAttributeOverrideModelAdapterTests.assertEquals((int)2, (int)attributeOverrides.size());
        AttributeOverride attributeOverride = (AttributeOverride)attributeOverrides.get(0);
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"id", (String)attributeOverride.getName());
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"id", (String)attributeOverride.getColumn().getDefaultName());
        JavaAttributeOverrideModelAdapterTests.assertEquals(null, (String)attributeOverride.getColumn().getSpecifiedName());
        attributeOverride = (AttributeOverride)attributeOverrides.get(1);
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"name", (String)attributeOverride.getName());
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"name", (String)attributeOverride.getColumn().getDefaultName());
    }

    public void testPopulatePersistenceModelWithAttributeOverrideAnnotationNoName() throws Exception {
        Type type = (Type)ClassTools.getFieldValue((Object)this.employeePersistentType.getModelAdapter(), (String)"type");
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                AST ast = bodyDeclaration.getAST();
                SingleMemberAnnotation attributeOverridesAnnotation = ASTTools.newSingleMemberAnnotation((AST)ast, (String)"AttributeOverrides");
                NormalAnnotation annotation = ASTTools.newNormalAnnotation((AST)ast, (String)"AttributeOverride");
                ASTTools.addLiteralMemberValuePair((NormalAnnotation)annotation, (String)"column", (String)"MY_ID");
                attributeOverridesAnnotation.setValue((Expression)annotation);
                ASTTools.addAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)attributeOverridesAnnotation);
            }
        });
        EList attributeOverrides = ((Entity)this.employeePersistentType.getTypeMapping()).getAttributeOverrides();
        JavaAttributeOverrideModelAdapterTests.assertEquals((int)3, (int)attributeOverrides.size());
        AttributeOverride attributeOverride = (AttributeOverride)attributeOverrides.get(0);
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"id", (String)attributeOverride.getName());
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"id", (String)attributeOverride.getColumn().getDefaultName());
        JavaAttributeOverrideModelAdapterTests.assertEquals(null, (String)attributeOverride.getColumn().getSpecifiedName());
        attributeOverride = (AttributeOverride)attributeOverrides.get(1);
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"name", (String)attributeOverride.getName());
        JavaAttributeOverrideModelAdapterTests.assertEquals((String)"name", (String)attributeOverride.getColumn().getDefaultName());
    }
}

