/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.orm.AccessType;
import org.eclipse.dali.orm.MappedSuperclass;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.orm.provider.PersistentTypeItemProvider;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.ScrolledPageContent;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class MappedSuperclassComposite
extends Composite
implements IPersistenceComposite {
    private MappedSuperclass mappedSuperclass;
    private PersistentType persistentType;
    private ComboViewer accessTypeComboViewer;
    private PersistentTypeItemProvider persistentTypeItemProvider;
    private INotifyChangedListener persistentTypeListener;
    private EditingDomain editingDomain;
    private boolean populating;
    static /* synthetic */ Class class$0;

    public MappedSuperclassComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.persistentTypeItemProvider = (PersistentTypeItemProvider)adapterFactory.createPersistentTypeAdapter();
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setLayout((Layout)new FillLayout(512));
        ScrolledPageContent pageContent = new ScrolledPageContent(this);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite composite = pageContent.getBody();
        composite.setLayout((Layout)layout);
        Label accessTypeLabel = new Label(composite, 16384);
        accessTypeLabel.setText(DaliUiMessages.MappedSuperclassComposite_accessType);
        this.accessTypeComboViewer = this.buildAccessTypeCombo(composite);
        this.accessTypeComboViewer.getCombo().setEnabled(false);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.accessTypeComboViewer.getCombo().setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.accessTypeComboViewer.getCombo(), "org.eclipse.dali.ui.entity_accessType");
    }

    private ComboViewer buildAccessTypeCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(AccessType.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (MappedSuperclassComposite.this.populating) {
                    return;
                }
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    MappedSuperclassComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)MappedSuperclassComposite.this.editingDomain, (Object)MappedSuperclassComposite.this.persistentType, (Object)OrmPackage.eINSTANCE.getPersistentType_AccessType(), (Object)selection.getFirstElement()));
                }
            }
        });
        return viewer;
    }

    public void populate(EObject model) {
        this.populating = true;
        if (this.mappedSuperclass != null) {
            this.persistentType.eAdapters().remove((Object)this.persistentTypeItemProvider);
            this.persistentTypeItemProvider.removeListener(this.getPersistentTypeListener());
        }
        this.mappedSuperclass = (MappedSuperclass)model;
        if (this.mappedSuperclass == null) {
            return;
        }
        this.persistentType = this.mappedSuperclass.getPersistentType();
        this.persistentTypeItemProvider.addListener(this.getPersistentTypeListener());
        this.persistentType.eAdapters().add((Object)this.persistentTypeItemProvider);
        this.accessTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.mappedSuperclass.getPersistentType().getAccessType()));
        this.populating = false;
    }

    private INotifyChangedListener getPersistentTypeListener() {
        if (this.persistentTypeListener == null) {
            this.persistentTypeListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.dali.orm.PersistentType");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (notification.getFeatureID((Class)clazz) == 2) {
                        AccessType accessType = (AccessType)notification.getNewValue();
                        Display.getDefault().syncExec(new Runnable(this, accessType){
                            final /* synthetic */ 2 this$1;
                            private final /* synthetic */ AccessType val$accessType;
                            {
                                this.this$1 = var1_1;
                                this.val$accessType = accessType;
                            }

                            public void run() {
                                if (((StructuredSelection)MappedSuperclassComposite.access$3(2.access$0(this.this$1)).getSelection()).getFirstElement() != this.val$accessType) {
                                    MappedSuperclassComposite.access$3(2.access$0(this.this$1)).setSelection((ISelection)new StructuredSelection((Object)this.val$accessType));
                                }
                            }
                        });
                    }
                }

                static /* synthetic */ MappedSuperclassComposite access$0(2 var0) {
                    return var0.MappedSuperclassComposite.this;
                }
            };
        }
        return this.persistentTypeListener;
    }

    static /* synthetic */ ComboViewer access$3(MappedSuperclassComposite mappedSuperclassComposite) {
        return mappedSuperclassComposite.accessTypeComboViewer;
    }
}

