/*******************************************************************************
 * Copyright (c) 2014 Bosch Software Innovations GmbH and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * The Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 * Bosch Software Innovations GmbH - Please refer to git log
 *
 *******************************************************************************/
/*
 * generated by Xtext
 */
grammar InternalInformationModel;

options {
	superClass=AbstractInternalAntlrParser;
}

@lexer::header {
package org.eclipse.vorto.editor.infomodel.parser.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;
}

@parser::header {
package org.eclipse.vorto.editor.infomodel.parser.antlr.internal;

import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.parser.antlr.AntlrDatatypeRuleToken;
import org.eclipse.vorto.editor.infomodel.services.InformationModelGrammarAccess;

}

@parser::members {

 	private InformationModelGrammarAccess grammarAccess;

    public InternalInformationModelParser(TokenStream input, InformationModelGrammarAccess grammarAccess) {
        this(input);
        this.grammarAccess = grammarAccess;
        registerRules(grammarAccess.getGrammar());
    }

    @Override
    protected String getFirstRuleName() {
    	return "InformationModel";
   	}

   	@Override
   	protected InformationModelGrammarAccess getGrammarAccess() {
   		return grammarAccess;
   	}

}

@rulecatch {
    catch (RecognitionException re) {
        recover(input,re);
        appendSkippedTokens();
    }
}

// Entry rule entryRuleInformationModel
entryRuleInformationModel returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getInformationModelRule()); }
	iv_ruleInformationModel=ruleInformationModel
	{ $current=$iv_ruleInformationModel.current; }
	EOF;

// Rule InformationModel
ruleInformationModel returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getInformationModelAccess().getInformationModelAction_0(),
					$current);
			}
		)
		otherlv_1='namespace'
		{
			newLeafNode(otherlv_1, grammarAccess.getInformationModelAccess().getNamespaceKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getInformationModelAccess().getNamespaceQualifiedNameParserRuleCall_2_0());
				}
				lv_namespace_2_0=ruleQualifiedName
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getInformationModelRule());
					}
					set(
						$current,
						"namespace",
						lv_namespace_2_0,
						"org.eclipse.vorto.editor.infomodel.InformationModel.QualifiedName");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_3='version'
		{
			newLeafNode(otherlv_3, grammarAccess.getInformationModelAccess().getVersionKeyword_3());
		}
		(
			(
				lv_version_4_0=RULE_VERSION
				{
					newLeafNode(lv_version_4_0, grammarAccess.getInformationModelAccess().getVersionVERSIONTerminalRuleCall_4_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getInformationModelRule());
					}
					setWithLastConsumed(
						$current,
						"version",
						lv_version_4_0,
						"org.eclipse.vorto.editor.infomodel.InformationModel.VERSION");
				}
			)
		)
		otherlv_5='displayname'
		{
			newLeafNode(otherlv_5, grammarAccess.getInformationModelAccess().getDisplaynameKeyword_5());
		}
		(
			(
				lv_displayname_6_0=RULE_STRING
				{
					newLeafNode(lv_displayname_6_0, grammarAccess.getInformationModelAccess().getDisplaynameSTRINGTerminalRuleCall_6_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getInformationModelRule());
					}
					setWithLastConsumed(
						$current,
						"displayname",
						lv_displayname_6_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)
		(
			otherlv_7='description'
			{
				newLeafNode(otherlv_7, grammarAccess.getInformationModelAccess().getDescriptionKeyword_7_0());
			}
			(
				(
					lv_description_8_0=RULE_STRING
					{
						newLeafNode(lv_description_8_0, grammarAccess.getInformationModelAccess().getDescriptionSTRINGTerminalRuleCall_7_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getInformationModelRule());
						}
						setWithLastConsumed(
							$current,
							"description",
							lv_description_8_0,
							"org.eclipse.xtext.common.Terminals.STRING");
					}
				)
			)
		)?
		otherlv_9='category'
		{
			newLeafNode(otherlv_9, grammarAccess.getInformationModelAccess().getCategoryKeyword_8());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getInformationModelAccess().getCategoryCATEGORYParserRuleCall_9_0());
				}
				lv_category_10_0=ruleCATEGORY
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getInformationModelRule());
					}
					set(
						$current,
						"category",
						lv_category_10_0,
						"org.eclipse.vorto.editor.infomodel.InformationModel.CATEGORY");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getInformationModelAccess().getReferencesModelReferenceParserRuleCall_10_0());
				}
				lv_references_11_0=ruleModelReference
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getInformationModelRule());
					}
					add(
						$current,
						"references",
						lv_references_11_0,
						"org.eclipse.vorto.editor.infomodel.InformationModel.ModelReference");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_12='infomodel'
		{
			newLeafNode(otherlv_12, grammarAccess.getInformationModelAccess().getInfomodelKeyword_11());
		}
		(
			(
				lv_name_13_0=RULE_ID
				{
					newLeafNode(lv_name_13_0, grammarAccess.getInformationModelAccess().getNameIDTerminalRuleCall_12_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getInformationModelRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_13_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		otherlv_14='{'
		{
			newLeafNode(otherlv_14, grammarAccess.getInformationModelAccess().getLeftCurlyBracketKeyword_13());
		}
		(
			otherlv_15='functionblocks'
			{
				newLeafNode(otherlv_15, grammarAccess.getInformationModelAccess().getFunctionblocksKeyword_14_0());
			}
			otherlv_16='{'
			{
				newLeafNode(otherlv_16, grammarAccess.getInformationModelAccess().getLeftCurlyBracketKeyword_14_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getInformationModelAccess().getPropertiesFunctionblockPropertyParserRuleCall_14_2_0());
					}
					lv_properties_17_0=ruleFunctionblockProperty
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getInformationModelRule());
						}
						add(
							$current,
							"properties",
							lv_properties_17_0,
							"org.eclipse.vorto.editor.infomodel.InformationModel.FunctionblockProperty");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			otherlv_18='}'
			{
				newLeafNode(otherlv_18, grammarAccess.getInformationModelAccess().getRightCurlyBracketKeyword_14_3());
			}
		)?
		otherlv_19='}'
		{
			newLeafNode(otherlv_19, grammarAccess.getInformationModelAccess().getRightCurlyBracketKeyword_15());
		}
	)
;

// Entry rule entryRuleCATEGORY
entryRuleCATEGORY returns [String current=null]:
	{ newCompositeNode(grammarAccess.getCATEGORYRule()); }
	iv_ruleCATEGORY=ruleCATEGORY
	{ $current=$iv_ruleCATEGORY.current.getText(); }
	EOF;

// Rule CATEGORY
ruleCATEGORY returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_ID_0=RULE_ID
		{
			$current.merge(this_ID_0);
		}
		{
			newLeafNode(this_ID_0, grammarAccess.getCATEGORYAccess().getIDTerminalRuleCall_0());
		}
		(
			kw='/'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getCATEGORYAccess().getSolidusKeyword_1_0());
			}
			this_ID_2=RULE_ID
			{
				$current.merge(this_ID_2);
			}
			{
				newLeafNode(this_ID_2, grammarAccess.getCATEGORYAccess().getIDTerminalRuleCall_1_1());
			}
		)*
	)
;

// Entry rule entryRuleQualifiedName
entryRuleQualifiedName returns [String current=null]:
	{ newCompositeNode(grammarAccess.getQualifiedNameRule()); }
	iv_ruleQualifiedName=ruleQualifiedName
	{ $current=$iv_ruleQualifiedName.current.getText(); }
	EOF;

// Rule QualifiedName
ruleQualifiedName returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_ID_0=RULE_ID
		{
			$current.merge(this_ID_0);
		}
		{
			newLeafNode(this_ID_0, grammarAccess.getQualifiedNameAccess().getIDTerminalRuleCall_0());
		}
		(
			kw='.'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getQualifiedNameAccess().getFullStopKeyword_1_0());
			}
			this_ID_2=RULE_ID
			{
				$current.merge(this_ID_2);
			}
			{
				newLeafNode(this_ID_2, grammarAccess.getQualifiedNameAccess().getIDTerminalRuleCall_1_1());
			}
		)*
	)
;

// Entry rule entryRuleFunctionblockProperty
entryRuleFunctionblockProperty returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getFunctionblockPropertyRule()); }
	iv_ruleFunctionblockProperty=ruleFunctionblockProperty
	{ $current=$iv_ruleFunctionblockProperty.current; }
	EOF;

// Rule FunctionblockProperty
ruleFunctionblockProperty returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				lv_name_0_0=RULE_ID
				{
					newLeafNode(lv_name_0_0, grammarAccess.getFunctionblockPropertyAccess().getNameIDTerminalRuleCall_0_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getFunctionblockPropertyRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_0_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		otherlv_1='as'
		{
			newLeafNode(otherlv_1, grammarAccess.getFunctionblockPropertyAccess().getAsKeyword_1());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getFunctionblockPropertyRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getFunctionblockPropertyAccess().getTypeFunctionblockModelCrossReference_2_0());
				}
				ruleQualifiedName
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				lv_description_3_0=RULE_STRING
				{
					newLeafNode(lv_description_3_0, grammarAccess.getFunctionblockPropertyAccess().getDescriptionSTRINGTerminalRuleCall_3_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getFunctionblockPropertyRule());
					}
					setWithLastConsumed(
						$current,
						"description",
						lv_description_3_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)?
	)
;

// Entry rule entryRuleModelReference
entryRuleModelReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getModelReferenceRule()); }
	iv_ruleModelReference=ruleModelReference
	{ $current=$iv_ruleModelReference.current; }
	EOF;

// Rule ModelReference
ruleModelReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='using'
		{
			newLeafNode(otherlv_0, grammarAccess.getModelReferenceAccess().getUsingKeyword_0());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getModelReferenceAccess().getImportedNamespaceQualifiedNameParserRuleCall_1_0());
				}
				lv_importedNamespace_1_0=ruleQualifiedName
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getModelReferenceRule());
					}
					set(
						$current,
						"importedNamespace",
						lv_importedNamespace_1_0,
						"org.eclipse.vorto.editor.infomodel.InformationModel.QualifiedName");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2=';'
		{
			newLeafNode(otherlv_2, grammarAccess.getModelReferenceAccess().getSemicolonKeyword_2());
		}
		(
			(
				lv_version_3_0=RULE_VERSION
				{
					newLeafNode(lv_version_3_0, grammarAccess.getModelReferenceAccess().getVersionVERSIONTerminalRuleCall_3_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getModelReferenceRule());
					}
					setWithLastConsumed(
						$current,
						"version",
						lv_version_3_0,
						"org.eclipse.vorto.editor.infomodel.InformationModel.VERSION");
				}
			)
		)
	)
;

RULE_VERSION : ('0'..'9')* '.' ('0'..'9')* '.' ('0'..'9')* ('-' RULE_ID)?;

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

RULE_INT : ('0'..'9')+;

RULE_STRING : ('"' ('\\' .|~(('\\'|'"')))* '"'|'\'' ('\\' .|~(('\\'|'\'')))* '\'');

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_WS : (' '|'\t'|'\r'|'\n')+;

RULE_ANY_OTHER : .;
