/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.core.ui.model;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.api.model.model.ModelId;
import org.eclipse.vorto.core.api.model.model.ModelIdFactory;
import org.eclipse.vorto.core.api.model.model.ModelReference;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.vorto.core.ui.model.IModelElement;
import org.eclipse.vorto.core.ui.model.IModelProject;
import org.eclipse.vorto.core.ui.model.ModelNotFoundException;

public abstract class AbstractModelElement
implements IModelElement,
Comparable<IModelElement> {
    protected IModelProject modelProject;

    public AbstractModelElement(IModelProject modelProject) {
        this.modelProject = modelProject;
    }

    @Override
    public Image getImage() {
        return this.getImage(this.getImageURLAsString());
    }

    @Override
    public Image getErrorImage() {
        return this.getImage(this.getErrorImageURLAsString());
    }

    private Image getImage(String urlStr) {
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("URL to datatype model image is not correct!", e);
        }
        return ImageDescriptor.createFromURL((URL)url).createImage();
    }

    protected abstract String getImageURLAsString();

    protected abstract String getErrorImageURLAsString();

    @Override
    public ModelId getId() {
        return ModelIdFactory.newInstance((Model)this.getModel());
    }

    @Override
    public String getDescription() {
        return ModelIdFactory.newInstance((Model)this.getModel()).toString();
    }

    @Override
    public Set<IModelElement> getReferences() {
        TreeSet<IModelElement> references = new TreeSet<IModelElement>();
        block0: for (ModelReference modelReference : this.getModel().getReferences()) {
            ModelType[] modelTypeArray = this.getPossibleReferenceTypes();
            int n = modelTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModelType possibleType = modelTypeArray[n2];
                ModelId modelId = ModelIdFactory.newInstance((ModelType)possibleType, (ModelReference)modelReference);
                IModelElement modelElementReference = this.modelProject.getModelElementById(modelId);
                if (modelElementReference != null) {
                    references.add(modelElementReference);
                    continue block0;
                }
                ++n2;
            }
        }
        return references;
    }

    @Override
    public IModelElement addModelReference(ModelId modelId) {
        IModelElement reference = this.modelProject.getModelElementById(modelId);
        if (reference == null) {
            throw new ModelNotFoundException("Model with ID " + modelId + " does not exist in project", this.modelProject.getProject());
        }
        this.addModelReference(reference);
        return reference;
    }

    @Override
    public void addModelReference(IModelElement modelElementReference) {
        ModelReference referenceToAdd = modelElementReference.getId().asModelReference();
        for (ModelReference modelReference : this.getModel().getReferences()) {
            if (!EcoreUtil.equals((EObject)modelReference, (EObject)referenceToAdd)) continue;
            return;
        }
        this.getModel().getReferences().add((Object)referenceToAdd);
        this.getModel().eResource().getContents().add((Object)modelElementReference.getModel());
        EcoreUtil.resolveAll((EObject)this.getModel());
    }

    @Override
    public void save() {
        try {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("org.eclipse.xtext.resource.XtextResource.FORMAT", true);
            this.getModel().eResource().save(options);
        }
        catch (IOException e) {
            throw new RuntimeException("Something went wrong during model serialization", e);
        }
    }

    protected abstract ModelType[] getPossibleReferenceTypes();

    @Override
    public IModelProject getProject() {
        return this.modelProject;
    }

    @Override
    public int compareTo(IModelElement o) {
        if (o == null || o.getId() == null) {
            return -1;
        }
        return o.getId().compareTo(this.getId());
    }
}

