/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.vorto.codegen.api.ITemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.ui.context.IGeneratorProjectContext;
import org.eclipse.vorto.codegen.ui.progresstask.IProgressTask;
import org.eclipse.vorto.codegen.ui.tasks.EclipseProjectGenerator;
import org.eclipse.vorto.codegen.ui.tasks.LocationWrapper;
import org.eclipse.vorto.codegen.ui.wizard.generation.templates.GeneratorTemplate;
import org.eclipse.vorto.codegen.ui.wizard.generation.templates.ManifestFileTemplate;
import org.eclipse.vorto.codegen.ui.wizard.generation.templates.PluginBuildFileTemplate;
import org.eclipse.vorto.codegen.ui.wizard.generation.templates.PluginXMLFileTemplate;
import org.eclipse.vorto.codegen.ui.wizard.generation.templates.PomTemplate;
import org.eclipse.vorto.codegen.ui.wizard.generation.templates.server.ApplicationProfileProperties;
import org.eclipse.vorto.codegen.ui.wizard.generation.templates.server.ApplicationPropertiesTemplate;
import org.eclipse.vorto.codegen.ui.wizard.generation.templates.server.MicroServicePomTemplate;
import org.eclipse.vorto.codegen.ui.wizard.generation.templates.server.PlatformGeneratorMainTemplate;

public class ProjectCreationTask
implements IProgressTask {
    private static final String ERROR_MESSAGE = "Problem when creating project, error: ";
    private String errorMessage = "";
    private IGeneratorProjectContext context = null;
    private IWorkspace workspace;

    public ProjectCreationTask(IGeneratorProjectContext context) {
        this.context = context;
        this.workspace = ResourcesPlugin.getWorkspace();
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                this.createGeneratorProject(monitor);
                if (this.context.isMicroServiceSupport()) {
                    this.createMicroServiceProject(monitor);
                }
            }
            catch (CoreException e) {
                this.errorMessage = e.getMessage();
                throw new RuntimeException(ERROR_MESSAGE + e.getMessage(), e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void createMicroServiceProject(IProgressMonitor monitor) throws JavaModelException {
        EclipseProjectGenerator<IGeneratorProjectContext> generator = new EclipseProjectGenerator<IGeneratorProjectContext>(new LocationWrapper(this.context.getWorkspaceLocation(), String.valueOf(this.context.getPackageName()) + ".service"));
        generator.mavenNature((ITemplate<IGeneratorProjectContext>)new MicroServicePomTemplate(), "src/main/java", "src/main/resources", "src/test/java");
        generator.addTask(new PlatformGeneratorMainTemplate());
        generator.addTask(new ApplicationPropertiesTemplate());
        generator.addTask(new ApplicationProfileProperties());
        generator.generate(this.context, InvocationContext.simpleInvocationContext(), monitor);
    }

    private void createGeneratorProject(IProgressMonitor monitor) {
        EclipseProjectGenerator<IGeneratorProjectContext> generator = new EclipseProjectGenerator<IGeneratorProjectContext>(new LocationWrapper(this.context.getWorkspaceLocation(), String.valueOf(this.context.getPackageName()) + "." + this.context.getGeneratorName().toLowerCase()));
        generator.pluginNature((ITemplate<IGeneratorProjectContext>)new PluginBuildFileTemplate(), (ITemplate<IGeneratorProjectContext>)new ManifestFileTemplate(), "src", "xtend-gen");
        generator.addNature("org.eclipse.m2e.core.maven2Nature");
        generator.addTask(new GeneratorTemplate());
        generator.addTask(new PomTemplate());
        generator.addTask(new PluginXMLFileTemplate());
        generator.generate(this.context, InvocationContext.simpleInvocationContext(), monitor);
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public IGeneratorProjectContext getGenUserInut() {
        return this.context;
    }

    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(IWorkspace workspace) {
        this.workspace = workspace;
    }
}

