/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.ui.progressmonitor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.vorto.codegen.api.IVortoCodeGenInfrastructureProgressMonitor;
import org.eclipse.vorto.codegen.api.IVortoCodeGenProgressMonitor;
import org.eclipse.vorto.core.ui.MessageDisplayFactory;

public class VortoProgressMonitor
implements IVortoCodeGenInfrastructureProgressMonitor,
IVortoCodeGenProgressMonitor {
    private static VortoProgressMonitor fDefault = null;
    private static List<Status> generatorStatusList = new ArrayList<Status>();
    private static List<Status> infrastructureStatusList = new ArrayList<Status>();
    private static boolean warningPresent = false;
    private static final String PLUGIN_ID = "org.eclipse.vorto.vortonature";
    private static final String INFO_PREFIX = "[INFO] ";
    private static final String WARNING_PREFIX = "[WARNING] ";

    public static VortoProgressMonitor getDefault() {
        if (fDefault == null) {
            fDefault = new VortoProgressMonitor();
        }
        return fDefault;
    }

    public void monitorWarning(String message) {
        generatorStatusList.add(new Status(2, PLUGIN_ID, WARNING_PREFIX + message));
        warningPresent = true;
    }

    public void monitorInfo(String message) {
        generatorStatusList.add(new Status(1, PLUGIN_ID, INFO_PREFIX + message));
    }

    public void monitorInfrastructureWarning(String message) {
        infrastructureStatusList.add(new Status(2, PLUGIN_ID, WARNING_PREFIX + message));
        warningPresent = true;
    }

    public void monitorInfrastructureInfo(String message) {
        infrastructureStatusList.add(new Status(1, PLUGIN_ID, INFO_PREFIX + message));
    }

    public void display() {
        ArrayList<MultiStatus> buildResults = new ArrayList<MultiStatus>();
        if (!generatorStatusList.isEmpty()) {
            buildResults.add(new MultiStatus(PLUGIN_ID, 1, (IStatus[])generatorStatusList.toArray(new Status[0]), "Code Generator Status Messages", null));
        }
        if (!infrastructureStatusList.isEmpty()) {
            buildResults.add(new MultiStatus(PLUGIN_ID, 1, (IStatus[])infrastructureStatusList.toArray(new Status[0]), "Code Generator Infrastructure Status Messages", null));
        }
        String message = warningPresent ? "Code generation finished with warnings!" : "Code generation successul!";
        MessageDisplayFactory.getMessageDisplay().displayStatus((Status)new MultiStatus(PLUGIN_ID, 1, (IStatus[])buildResults.toArray(new Status[0]), message, null));
        generatorStatusList = new ArrayList<Status>();
        infrastructureStatusList = new ArrayList<Status>();
        warningPresent = false;
    }
}

