/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.ui.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.vorto.codegen.ui.context.IGeneratorProjectContext;
import org.eclipse.vorto.codegen.ui.progresstask.ProgressTaskExecutionService;
import org.eclipse.vorto.codegen.ui.utils.WizardUtil;
import org.eclipse.vorto.codegen.ui.wizard.GeneratorWizardPage;
import org.eclipse.vorto.codegen.ui.wizard.ProjectCreationTask;

public class GeneratorWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private static final String SLASH = "/";
    private static final String SRC_FOLDER = "src/";
    private static final String XTEND_FILE_ENDING = ".xtend";
    private GeneratorWizardPage generatorWizardPage;
    private IConfigurationElement configurationElement;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.generatorWizardPage = new GeneratorWizardPage("wizardPage");
        this.generatorWizardPage.setTitle("New Code Generator Project");
        this.generatorWizardPage.setDescription("Please enter the details for creating the project.");
        this.addPage((IWizardPage)this.generatorWizardPage);
    }

    public boolean performFinish() {
        ProgressTaskExecutionService progressTaskExecutionService = ProgressTaskExecutionService.getProgressTaskExecutionService();
        progressTaskExecutionService.syncRun(new ProjectCreationTask(this.generatorWizardPage));
        this.openFileWithDefaultEditor(String.valueOf(this.generatorWizardPage.getPackageName()) + "." + this.generatorWizardPage.getGeneratorName().toLowerCase(), this.getPath(this.generatorWizardPage));
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.getConfigurationElement());
        return true;
    }

    private String getPath(IGeneratorProjectContext metaData) {
        return SRC_FOLDER + metaData.getPackageFolders() + SLASH + metaData.getGeneratorName() + XTEND_FILE_ENDING;
    }

    private void openFileWithDefaultEditor(String projectName, String path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        String fileName = path;
        final IFile fbfile = project.getFile(fileName);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page;
                IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWindow != null && (page = activeWindow.getActivePage()) != null) {
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)fbfile);
                    }
                    catch (PartInitException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configurationElement = config;
    }

    public IConfigurationElement getConfigurationElement() {
        if (this.configurationElement != null) {
            return this.configurationElement;
        }
        return WizardUtil.getWizardConfigurationElement(((Object)((Object)this)).getClass().getName());
    }
}

