/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.latex.tasks;

import org.eclipse.vorto.codegen.api.AbstractTemplateGeneratorTask;
import org.eclipse.vorto.codegen.api.ITemplate;
import org.eclipse.vorto.codegen.latex.tasks.template.LatexComplexPropertyTemplate;
import org.eclipse.vorto.codegen.latex.tasks.template.LatexEntityTemplate;
import org.eclipse.vorto.codegen.latex.tasks.template.LatexEnumTemplate;
import org.eclipse.vorto.codegen.latex.tasks.template.LatexFBPropertyTemplate;
import org.eclipse.vorto.codegen.latex.tasks.template.LatexFunctionBlockTemplate;
import org.eclipse.vorto.codegen.latex.tasks.template.LatexOperationTemplate;
import org.eclipse.vorto.codegen.latex.tasks.template.LatexSimplePropertyConstraintTemplate;
import org.eclipse.vorto.codegen.latex.tasks.template.LatexSimplePropertyTemplate;
import org.eclipse.vorto.codegen.latex.tasks.template.ReviewInformationModelTemplate;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;

public class LatexInformationModelGeneratorTask
extends AbstractTemplateGeneratorTask<InformationModel> {
    private String latexFileExtension;
    private String targetPath;

    public LatexInformationModelGeneratorTask(String latexFileExtension, String targetPath) {
        this.latexFileExtension = latexFileExtension;
        this.targetPath = targetPath;
    }

    public String getFileName(InformationModel im) {
        return String.valueOf(im.getName()) + this.latexFileExtension;
    }

    public String getPath(InformationModel im) {
        return this.targetPath;
    }

    public ITemplate<InformationModel> getTemplate() {
        LatexOperationTemplate operationTemplate = new LatexOperationTemplate();
        LatexFBPropertyTemplate fbPropertyTemplate = new LatexFBPropertyTemplate();
        LatexComplexPropertyTemplate complexTemplate = new LatexComplexPropertyTemplate();
        LatexSimplePropertyTemplate simpleTemplate = new LatexSimplePropertyTemplate();
        LatexSimplePropertyConstraintTemplate constraintTemplate = new LatexSimplePropertyConstraintTemplate();
        LatexFunctionBlockTemplate fbTemplate = new LatexFunctionBlockTemplate(constraintTemplate, simpleTemplate, complexTemplate, operationTemplate);
        LatexEntityTemplate entityTemplate = new LatexEntityTemplate(constraintTemplate, simpleTemplate, complexTemplate);
        LatexEnumTemplate enumTemplate = new LatexEnumTemplate();
        return new ReviewInformationModelTemplate(fbPropertyTemplate, fbTemplate, entityTemplate, enumTemplate);
    }
}

