/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.webui.templates.service.bosch;

import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.webui.templates.TemplateUtils;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class ThingClientBuilderTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"ThingClientBuilder.java");
        return _builder.toString();
    }

    public String getPath(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _baseApplicationPath = TemplateUtils.getBaseApplicationPath(context);
        _builder.append((Object)_baseApplicationPath, "");
        _builder.append((Object)"/service/bosch");
        return _builder.toString();
    }

    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package com.example.iot.");
        String _name = element.getName();
        String _lowerCase = _name.toLowerCase();
        _builder.append((Object)_lowerCase, "");
        _builder.append((Object)".service.bosch;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"import org.apache.http.HttpHost;");
        _builder.newLine();
        _builder.append((Object)"import org.apache.http.client.config.RequestConfig;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.oauth2.client.OAuth2ClientContext;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import com.example.iot.");
        String _name_1 = element.getName();
        String _lowerCase_1 = _name_1.toLowerCase();
        _builder.append((Object)_lowerCase_1, "");
        _builder.append((Object)".service.bosch.internal.DefaultThingClient;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import com.example.iot.");
        String _name_2 = element.getName();
        String _lowerCase_2 = _name_2.toLowerCase();
        _builder.append((Object)_lowerCase_2, "");
        _builder.append((Object)".service.bosch.internal.ThingsInvocationTemplate;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"public class ThingClientBuilder {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private String endpointUrl;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private RequestConfig config;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private String apiToken;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private OAuth2ClientContext oauth2context;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ThingClientBuilder() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.endpointUrl = \"https://things.apps.bosch-iot-cloud.com\";");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ThingClientBuilder withEndpointUrl(final String endpointUrl) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.endpointUrl = endpointUrl;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ThingClientBuilder withApiToken(final String apiToken) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.apiToken = apiToken;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ThingClientBuilder withProxy(final String proxyHost, int proxyPort) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.config = RequestConfig.custom().setProxy(new HttpHost(proxyHost, proxyPort)).build();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ThingClient build() {\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return new DefaultThingClient(this.endpointUrl,new ThingsInvocationTemplate(apiToken, oauth2context), config);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ThingClientBuilder withOAuth2ClientContext(OAuth2ClientContext oauth2context) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.oauth2context = oauth2context;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder.toString();
    }
}

