/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.event;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventUtil {
    private EventUtil() {
    }

    public static void checkEventType(Class<?> eventType) {
        Asserts.assertNotNull(eventType, "eventType parameter can not be null");
        if (ClassUtil.isDefinitionContainsTypeVariables(eventType)) {
            throw new IllegalArgumentException("Event type : " + eventType.getName() + " can not be generic");
        }
    }

    public static void checkEventBindings(WebBeansContext webBeansContext, Annotation ... annotations) {
        for (Annotation ann : annotations) {
            Retention retention = ann.annotationType().getAnnotation(Retention.class);
            RetentionPolicy policy = retention.value();
            if (policy.equals((Object)RetentionPolicy.RUNTIME)) continue;
            throw new IllegalArgumentException("Event qualifiere RetentionPolicy must be RUNTIME for qualifier : " + ann);
        }
        webBeansContext.getAnnotationManager().checkQualifierConditions(annotations);
    }

    public static TransactionPhase getObserverMethodTransactionType(Method observerMethod) {
        Observes observes = AnnotationUtil.getMethodFirstParameterAnnotation(observerMethod, Observes.class);
        if (observes != null) {
            return observes.during();
        }
        return null;
    }

    public static void checkObserverMethodConditions(Method candidateObserverMethod, Class<?> clazz) {
        Asserts.assertNotNull(candidateObserverMethod, "candidateObserverMethod parameter can not be null");
        Asserts.nullCheckForClass(clazz);
        if (AnnotationUtil.hasMethodMultipleParameterAnnotation(candidateObserverMethod, Observes.class)) {
            throw new WebBeansConfigurationException("Observer method : " + candidateObserverMethod.getName() + " in class : " + clazz.getName() + " can not define two parameters with annotated @Observes");
        }
        if (AnnotationUtil.hasMethodAnnotation(candidateObserverMethod, Produces.class) || AnnotationUtil.hasMethodAnnotation(candidateObserverMethod, Inject.class)) {
            throw new WebBeansConfigurationException("Observer method : " + candidateObserverMethod.getName() + " in class : " + clazz.getName() + " can not annotated with annotation in the list {@Produces, @Initializer, @Destructor}");
        }
        if (AnnotationUtil.hasMethodParameterAnnotation(candidateObserverMethod, Disposes.class)) {
            throw new WebBeansConfigurationException("Observer method : " + candidateObserverMethod.getName() + " in class : " + clazz.getName() + " can not annotated with annotation @Disposes");
        }
    }

    public static boolean isReceptionIfExist(Method observerMethod) {
        Observes observes = AnnotationUtil.getMethodFirstParameterAnnotation(observerMethod, Observes.class);
        Reception reception = observes.notifyObserver();
        return reception.equals((Object)Reception.IF_EXISTS);
    }

    public static boolean checkObservableInjectionPointConditions(InjectionPoint injectionPoint) {
        ParameterizedType pt;
        Type type = injectionPoint.getType();
        Class candidateClazz = null;
        if (type instanceof Class) {
            candidateClazz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            pt = (ParameterizedType)type;
            candidateClazz = (Class)pt.getRawType();
        }
        if (!candidateClazz.equals(Event.class)) {
            return false;
        }
        if (!ClassUtil.isParametrizedType(injectionPoint.getType())) {
            throw new WebBeansConfigurationException("@Observable field injection " + injectionPoint + " must be ParametrizedType with actual type argument");
        }
        if (ClassUtil.isParametrizedType(injectionPoint.getType())) {
            pt = (ParameterizedType)injectionPoint.getType();
            Class rawType = (Class)pt.getRawType();
            Type[] typeArgs = pt.getActualTypeArguments();
            if (!rawType.equals(Event.class)) {
                return false;
            }
            if (typeArgs.length != 1) {
                throw new IllegalArgumentException("@Observable field injection " + injectionPoint.toString() + " must not have more than one actual type argument");
            }
        } else {
            throw new IllegalArgumentException("@Observable field injection " + injectionPoint.toString() + " must be defined as ParameterizedType with one actual type argument");
        }
        return true;
    }
}

