/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.trace;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.IEventDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfTestTraceUtils;
import org.eclipse.tracecompass.ctf.core.trace.CTFTraceReader;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TraceReadAllTracesTest {
    @Rule
    public TestRule globalTimeout = new Timeout(1L, TimeUnit.MINUTES);
    private final CtfTestTrace fTraceEnum;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getTracePaths() {
        CtfTestTrace[] values = CtfTestTrace.values();
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        CtfTestTrace[] ctfTestTraceArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            CtfTestTrace value = ctfTestTraceArray[n2];
            list.add(new Object[]{value.name(), value});
            ++n2;
        }
        return list;
    }

    public TraceReadAllTracesTest(String name, CtfTestTrace traceEnum) {
        this.fTraceEnum = traceEnum;
    }

    @Test
    public void readTraces() {
        if (this.fTraceEnum.getNbEvents() != -1) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (CTFTraceReader reader = new CTFTraceReader(CtfTestTraceUtils.getTrace(this.fTraceEnum));){
                    IEventDefinition currentEventDef = reader.getCurrentEventDef();
                    double start = currentEventDef.getTimestamp();
                    long count = 0L;
                    double end = start;
                    while (reader.hasMoreEvents()) {
                        reader.advance();
                        ++count;
                        currentEventDef = reader.getCurrentEventDef();
                        if (currentEventDef == null) continue;
                        end = currentEventDef.getTimestamp();
                        if (!currentEventDef.getDeclaration().getName().equals("Lost event")) continue;
                        count += ((IntegerDefinition)currentEventDef.getFields().getDefinition("Lost events")).getValue() - 1L;
                    }
                    Assert.assertEquals((String)"Event count", (long)this.fTraceEnum.getNbEvents(), (long)count);
                    Assert.assertEquals((String)"Trace duration", (double)this.fTraceEnum.getDuration(), (double)((end - start) * reader.getTrace().getClock().getClockScale() / 1.0E9), (double)1.0);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CTFException e) {
                Assert.fail((String)(this.fTraceEnum.name() + " " + e.getMessage()));
            }
        } else {
            Assume.assumeTrue((String)"Trace did not specify events count", (boolean)false);
        }
    }
}

