/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.ui.swtbot.tests.latency;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.statistics.AbstractSegmentsStatisticsView;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.statistics.SegmentStoreStatisticsView;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class SystemCallLatencyStatisticsTableAnalysisTest {
    private static final int MIN_COL = 1;
    private static final int MAX_COL = 2;
    private static final int AVERAGE_COL = 3;
    private static final int STDEV_COL = 4;
    private static final int COUNT_COL = 5;
    private static final String TRACE_TYPE = "org.eclipse.linuxtools.lttng2.kernel.tracetype";
    private static final String PROJECT_NAME = "test";
    private static final String PRIMARY_VIEW_ID = "org.eclipse.tracecompass.analysis.timing.ui.segstore.statistics";
    private static final String SECONDARY_VIEW_ID = "org.eclipse.tracecompass.analysis.os.linux.latency.syscall";
    private SWTBotTree fTreeBot;
    private static SWTWorkbenchBot fBot;

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBotTest");
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fBot = new SWTWorkbenchBot();
        WaitUtils.waitForJobs();
    }

    @Before
    public void createTree() {
        SWTBotUtils.openView((String)PRIMARY_VIEW_ID, (String)SECONDARY_VIEW_ID);
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotView viewBot = bot.viewById(PRIMARY_VIEW_ID);
        final IViewReference viewReference = viewBot.getViewReference();
        IViewPart viewPart = (IViewPart)UIThreadRunnable.syncExec((Result)new Result<IViewPart>(){

            public IViewPart run() {
                return viewReference.getView(true);
            }
        });
        Assert.assertTrue((String)"Could not instanciate view", (boolean)(viewPart instanceof SegmentStoreStatisticsView));
        this.fTreeBot = viewBot.bot().tree();
        Assert.assertNotNull((Object)this.fTreeBot);
    }

    @After
    public void closeTree() {
        SWTBotUtils.closeViewById((String)PRIMARY_VIEW_ID, (SWTWorkbenchBot)fBot);
    }

    @Test
    public void testWithTrace() throws IOException, NoSuchMethodException, SecurityException, IllegalArgumentException {
        String tracePath = FileUtils.toFile((URL)FileLocator.toFileURL((URL)CtfTestTrace.ARM_64_BIT_HEADER.getTraceURL())).getAbsolutePath();
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotView view = bot.viewById(PRIMARY_VIEW_ID);
        SWTBotUtils.closeViewById((String)PRIMARY_VIEW_ID, (SWTWorkbenchBot)fBot);
        SWTBotUtils.createProject((String)PROJECT_NAME);
        SWTBotUtils.openTrace((String)PROJECT_NAME, (String)tracePath, (String)TRACE_TYPE);
        WaitUtils.waitForJobs();
        this.createTree();
        WaitUtils.waitForJobs();
        SWTBotTreeItem totalEntry = this.fTreeBot.getTreeItem("bug446190").getNode("Total");
        SystemCallLatencyStatisticsTableAnalysisTest.validate(totalEntry, "Total", "1 \u00b5s", "5.904 s", "15.628 ms", "175.875 ms", "1801");
        Assert.assertEquals((long)55L, (long)totalEntry.getNodes().size());
        SystemCallLatencyStatisticsTableAnalysisTest.validate(totalEntry.getNode(2), "select", "13.6 \u00b5s", "1.509 s", "192.251 ms", "386.369 ms", "58");
        SystemCallLatencyStatisticsTableAnalysisTest.validate(totalEntry.getNode(3), "poll", "6.3 \u00b5s", "6.8 \u00b5s", "6.55 \u00b5s", "---", "2");
        SystemCallLatencyStatisticsTableAnalysisTest.validate(totalEntry.getNode(5), "set_tid_address", "2.3 \u00b5s", "2.3 \u00b5s", "2.3 \u00b5s", "---", "1");
        SystemCallLatencyStatisticsTableAnalysisTest.validate(totalEntry.getNode(7), "pipe", "27.9 \u00b5s", "29.7 \u00b5s", "28.8 \u00b5s", "---", "2");
        SystemCallLatencyStatisticsTableAnalysisTest.testToTsv(view);
        SWTBotMenu menuBot = view.viewMenu().menu(new String[]{"Export to TSV..."});
        Assert.assertTrue((boolean)menuBot.isEnabled());
        Assert.assertTrue((boolean)menuBot.isVisible());
        fBot.closeAllEditors();
        SWTBotUtils.deleteProject((String)PROJECT_NAME, (SWTWorkbenchBot)fBot);
    }

    private static void testToTsv(SWTBotView view) throws NoSuchMethodException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Assert.assertNotNull((Object)os);
        IViewPart viewPart = ((IViewReference)view.getReference()).getView(true);
        Assert.assertTrue((boolean)(viewPart instanceof AbstractSegmentsStatisticsView));
        Class<@NonNull AbstractSegmentsStatisticsView> clazz = AbstractSegmentsStatisticsView.class;
        Method method = clazz.getDeclaredMethod("exportToTsv", OutputStream.class);
        method.setAccessible(true);
        Exception[] except = new Exception[1];
        UIThreadRunnable.syncExec(() -> {
            try {
                method.invoke((Object)((AbstractSegmentsStatisticsView)viewPart), os);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                exceptionArray[0] = e;
            }
        });
        Assert.assertNull((Object)except[0]);
        String[] lines = String.valueOf(os).split(System.getProperty("line.separator"));
        Assert.assertNotNull((Object)lines);
        Assert.assertEquals((String)"header", (Object)"Level\tMinimum\tMaximum\tAverage\tStandard Deviation\tCount\tTotal", (Object)lines[0]);
        Assert.assertEquals((String)"line 1", (Object)"bug446190\t\t\t\t\t\t", (Object)lines[1]);
        Assert.assertEquals((String)"line 2", (Object)"Total\t1 \u00b5s\t5.904 s\t15.628 ms\t175.875 ms\t1801\t28.146 s", (Object)lines[2]);
    }

    private static void validate(SWTBotTreeItem treeItem, String nodeName, String min, String max, String avg, String stdev, String count) {
        Assert.assertEquals((Object)nodeName, (Object)treeItem.cell(0));
        Assert.assertEquals((Object)min, (Object)treeItem.cell(1));
        Assert.assertEquals((Object)max, (Object)treeItem.cell(2));
        Assert.assertEquals((Object)avg, (Object)treeItem.cell(3));
        Assert.assertEquals((Object)stdev, (Object)treeItem.cell(4));
        Assert.assertEquals((Object)count, (Object)treeItem.cell(5));
    }
}

