/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.cli.core.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.cli.core.parser.ICliParser;
import org.eclipse.tracecompass.internal.tmf.cli.core.Activator;

public final class CliParserConfigElement {
    private static final String TMF_CLI_ACTION_TYPE_ID = "org.eclipse.tracecompass.tmf.cli.parser.extension";
    private static final String PARSER_ELEMENT = "parser";
    private static final String CLASS_ATTR = "class";
    private static final String PRIORITY_ATTR = "priority";
    private static @Nullable CliParserConfigElement INSTANCE = null;
    private final List<ICliParser> fCliParsers = new ArrayList<ICliParser>();
    private static final Comparator<PrioritizedParser> COMPARATOR = Objects.requireNonNull(Comparator.comparingInt(PrioritizedParser::getPriority).thenComparing((o1, o2) -> o1 == o2 ? 0 : 1));

    private CliParserConfigElement() {
        this.populateCliActionList();
    }

    public static CliParserConfigElement getInstance() {
        CliParserConfigElement instance = INSTANCE;
        if (instance == null) {
            INSTANCE = instance = new CliParserConfigElement();
        }
        return instance;
    }

    private void populateCliActionList() {
        TreeSet<PrioritizedParser> parsers = new TreeSet<PrioritizedParser>(COMPARATOR);
        if (this.fCliParsers.isEmpty()) {
            IConfigurationElement[] config;
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_CLI_ACTION_TYPE_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                String elementName = ce.getName();
                if (elementName.equals(PARSER_ELEMENT)) {
                    try {
                        ICliParser parser = Objects.requireNonNull((ICliParser)ce.createExecutableExtension(CLASS_ATTR));
                        String attribute = ce.getAttribute(PRIORITY_ATTR);
                        int priority = 5;
                        try {
                            priority = Integer.parseInt(attribute);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        parsers.add(new PrioritizedParser(parser, priority));
                    }
                    catch (CoreException e) {
                        Activator.getInstance().logError("Error creation cli action object: ", (Throwable)e);
                    }
                }
                ++n2;
            }
            for (PrioritizedParser parser : parsers) {
                this.fCliParsers.add(parser.fParser);
            }
        }
    }

    public Collection<ICliParser> getParsers() {
        return this.fCliParsers;
    }

    private static class PrioritizedParser {
        private final int fPriority;
        private final ICliParser fParser;

        public PrioritizedParser(ICliParser parser, int priority) {
            this.fPriority = priority;
            this.fParser = parser;
        }

        public int getPriority() {
            return this.fPriority;
        }
    }
}

