/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.inandout.core.analysis;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.instrumented.InstrumentedCallStackAnalysis;
import org.eclipse.tracecompass.incubator.internal.inandout.core.Activator;
import org.eclipse.tracecompass.incubator.internal.inandout.core.analysis.InAndOutAnalysisStateProvider;
import org.eclipse.tracecompass.incubator.internal.inandout.core.analysis.SegmentSpecifier;
import org.eclipse.tracecompass.incubator.internal.inandout.core.analysis.SegmentSpecifierConfiguration;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfiguration;
import org.eclipse.tracecompass.tmf.core.config.TmfConfiguration;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfConfigurationException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public class InAndOutAnalysisModule
extends InstrumentedCallStackAnalysis {
    public static final String ID = "org.eclipse.tracecompass.incubator.inandout.analysis";
    public static final String JSON = ".config.json";
    private @Nullable ITmfConfiguration fConfiguration;
    private @Nullable List<@NonNull SegmentSpecifier> fSpecifiers;
    public static final SegmentSpecifier REFERENCE = new SegmentSpecifier("latency", "(\\S*)_entry", "(\\S*)_exit", "(\\S*)_entry", "(\\S*)_exit", "CPU");

    public @NonNull String getName() {
        ITmfConfiguration config = this.fConfiguration;
        if (config != null) {
            return config.getName();
        }
        return super.getName();
    }

    public @NonNull String getHelpText() {
        ITmfConfiguration config = this.fConfiguration;
        if (config != null) {
            return config.getDescription();
        }
        return super.getHelpText();
    }

    public void setConfiguration(ITmfConfiguration configuration) throws TmfConfigurationException {
        if (configuration == null) {
            throw new TmfConfigurationException("Can't set a null configuration");
        }
        SegmentSpecifierConfiguration config = SegmentSpecifierConfiguration.fromJsonMap(configuration.getParameters());
        this.fConfiguration = configuration;
        this.fSpecifiers = config.getSpecifiers();
    }

    public @Nullable ITmfConfiguration getConfiguration() {
        return this.fConfiguration;
    }

    public @NonNull String getId() {
        ITmfConfiguration config = this.fConfiguration;
        if (config == null || this.fSpecifiers == null) {
            return ID;
        }
        return ID + config.getId();
    }

    public boolean canExecute(@NonNull ITmfTrace trace) {
        ITmfConfiguration configuration = this.fConfiguration;
        if (configuration == null) {
            File config = InAndOutAnalysisModule.getConfig(trace);
            return config.exists() && super.canExecute(trace);
        }
        return true;
    }

    private static File getConfig(@NonNull ITmfTrace trace) {
        String folder = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace);
        File config = new File(folder + File.separator + "org.eclipse.tracecompass.incubator.inandout.analysis.config.json");
        if (!config.exists()) {
            ArrayList<@NonNull SegmentSpecifier> specifiers = new ArrayList<SegmentSpecifier>();
            specifiers.add(new SegmentSpecifier(REFERENCE));
            InAndOutAnalysisModule.write(config, specifiers);
        }
        return config;
    }

    protected @NonNull ITmfStateProvider createStateProvider() {
        ITmfTrace trace = Objects.requireNonNull(this.getTrace(), "Trace should not be null at this point");
        List<@NonNull SegmentSpecifier> specifiers = this.fSpecifiers;
        if (specifiers == null) {
            File configFile = InAndOutAnalysisModule.getConfig(trace);
            specifiers = InAndOutAnalysisModule.read(configFile);
        }
        return new InAndOutAnalysisStateProvider(trace, specifiers);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static List<@NonNull SegmentSpecifier> read(File file) {
        Type listType = new TypeToken<ArrayList<SegmentSpecifier>>(){}.getType();
        @NonNull List specifiers = Collections.emptyList();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileReader reader = new FileReader(file);){
                @NonNull List list = (List)new Gson().fromJson((Reader)reader, listType);
                if (list != null) {
                    specifiers = list;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
        }
        return specifiers;
    }

    public static void write(File file, List<@NonNull SegmentSpecifier> specifiers) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileWriter writer = new FileWriter(file);){
                ((Writer)writer).append(new Gson().toJson(specifiers));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
        }
    }

    public static InAndOutAnalysisModule create(@NonNull ITmfConfiguration config, @NonNull ITmfTrace trace, boolean writeConfig) throws TmfConfigurationException {
        InAndOutAnalysisModule module;
        block5: {
            module = new InAndOutAnalysisModule();
            module.setConfiguration(config);
            if (writeConfig) {
                IPath traceConfigPath = InAndOutAnalysisModule.getTraceRootFolder(trace, config.getSourceTypeId());
                TmfConfiguration.writeConfiguration((ITmfConfiguration)config, (IPath)traceConfigPath);
            }
            try {
                if (module.setTrace(trace)) {
                    IAnalysisModule oldModule = trace.addAnalysisModule((IAnalysisModule)module);
                    if (oldModule != null) {
                        oldModule.dispose();
                        oldModule.clearPersistentData();
                    }
                    break block5;
                }
                module.dispose();
                throw new TmfConfigurationException("InAndOut analysis module can't be created");
            }
            catch (TmfAnalysisException | TmfTraceException e) {
                module.dispose();
                throw new TmfConfigurationException("Exception when setting trace", e);
            }
        }
        return module;
    }

    public static void remove(ITmfConfiguration config, @NonNull ITmfTrace trace) throws TmfConfigurationException {
        IPath traceConfig = InAndOutAnalysisModule.getTraceRootFolder(trace, config.getSourceTypeId());
        File configFile = (traceConfig = traceConfig.append(File.separator).append(config.getId()).addFileExtension("json")).toFile();
        if (!configFile.exists() || !configFile.delete()) {
            throw new TmfConfigurationException("InAndOut configuration file can't be deleted from trace: configId=" + config.getId());
        }
        try {
            IAnalysisModule module = trace.removeAnalysisModule(ID + config.getId());
            if (module != null) {
                module.dispose();
                module.clearPersistentData();
            }
        }
        catch (TmfTraceException e) {
            throw new TmfConfigurationException("Error removing analysis module from trace: analysis ID=org.eclipse.tracecompass.incubator.inandout.analysis" + config.getId(), (Throwable)e);
        }
    }

    private static @NonNull IPath getTraceRootFolder(@NonNull ITmfTrace trace, String subFolder) {
        String supplFolder = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace);
        Path supplPath = new Path(supplFolder);
        supplPath = supplPath.addTrailingSeparator().append(subFolder);
        return supplPath;
    }

    public static @NonNull List<ITmfConfiguration> readConfigurations(@NonNull ITmfTrace trace) throws TmfConfigurationException {
        IPath rootPath = InAndOutAnalysisModule.getTraceRootFolder(trace, "org.eclipse.tracecompass.incubator.internal.inandout.core.config");
        File folder = rootPath.toFile();
        ArrayList<ITmfConfiguration> list = new ArrayList<ITmfConfiguration>();
        if (folder.exists()) {
            File[] listOfFiles;
            File[] fileArray = listOfFiles = folder.listFiles();
            int n = listOfFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                Path path = new Path(file.getName());
                if (path.getFileExtension().equals("json")) {
                    ITmfConfiguration config = TmfConfiguration.fromJsonFile((File)file);
                    list.add(config);
                }
                ++n2;
            }
        }
        return list;
    }
}

