/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.BindingKey;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTRequestor;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsModel;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsSolver;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ICommentProvider;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.CompilationUnitRange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextEditBasedChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.ui.CodeGeneration;

public abstract class SuperTypeRefactoringProcessor
extends RefactoringProcessor
implements IScriptableRefactoring,
ICommentProvider {
    protected static final String ATTRIBUTE_INSTANCEOF = "instanceof";
    protected static final String ATTRIBUTE_REPLACE = "replace";
    protected static final GroupCategorySet SET_SUPER_TYPE = new GroupCategorySet(new GroupCategory("org.eclipse.wst.jsdt.internal.corext.superType", RefactoringCoreMessages.SuperTypeRefactoringProcessor_category_name, RefactoringCoreMessages.SuperTypeRefactoringProcessor_category_description));
    private static final int SIZE_BATCH = 500;
    protected String fComment;
    protected boolean fInstanceOf = false;
    protected Map fObsoleteCasts = null;
    protected final WorkingCopyOwner fOwner = new WorkingCopyOwner(){};
    protected boolean fReplace = false;
    protected CodeGenerationSettings fSettings;
    protected final Set fStaticBindings = new HashSet();
    protected final Set fTypeBindings = new HashSet();
    protected Map fTypeOccurrences = null;

    protected static ASTNode createCorrespondingNode(CompilationUnitRewrite rewrite, TType type) {
        return rewrite.getImportRewrite().addImportFromSignature(new BindingKey(type.getBindingKey()).toSignature(), rewrite.getAST());
    }

    protected SuperTypeRefactoringProcessor(CodeGenerationSettings settings) {
        this.fSettings = settings;
    }

    protected void addSuperTypeSettings(JDTRefactoringDescriptorComment comment, boolean addUseSupertype) {
        Assert.isNotNull((Object)comment);
        if (this.fReplace) {
            if (addUseSupertype) {
                comment.addSetting(RefactoringCoreMessages.SuperTypeRefactoringProcessor_user_supertype_setting);
            }
            if (this.fInstanceOf) {
                comment.addSetting(RefactoringCoreMessages.SuperTypeRefactoringProcessor_use_in_instanceof_setting);
            }
        }
    }

    @Override
    public boolean canEnableComment() {
        return true;
    }

    protected abstract SuperTypeConstraintsSolver createContraintSolver(SuperTypeConstraintsModel var1);

    protected void createMemberDeclarations(CompilationUnitRewrite sourceRewrite, ASTRewrite targetRewrite, AbstractTypeDeclaration targetDeclaration) throws CoreException {
    }

    protected final void createTypeDeclaration(CompilationUnitRewrite sourceRewrite, IType subType, String superName, AbstractTypeDeclaration sourceDeclaration, StringBuffer buffer, boolean isInterface, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)sourceRewrite);
        Assert.isNotNull((Object)subType);
        Assert.isNotNull((Object)superName);
        Assert.isNotNull((Object)sourceDeclaration);
        Assert.isNotNull((Object)buffer);
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask("", 100);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
            String delimiter = StubUtility.getLineDelimiterUsed(subType.getJavaScriptProject());
            if (JdtFlags.isPublic((IMember)subType)) {
                buffer.append("public");
                buffer.append(" ");
            }
            if (isInterface) {
                buffer.append("interface ");
            } else {
                buffer.append("class ");
            }
            buffer.append(superName);
            buffer.append(" {");
            buffer.append(delimiter);
            buffer.append(delimiter);
            buffer.append('}');
            Document document = new Document(buffer.toString());
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(document.get().toCharArray());
            JavaScriptUnit unit = (JavaScriptUnit)parser.createAST((IProgressMonitor)new SubProgressMonitor(monitor, 100));
            ASTRewrite targetRewrite = ASTRewrite.create((AST)unit.getAST());
            AbstractTypeDeclaration targetDeclaration = (AbstractTypeDeclaration)unit.types().get(0);
            this.createMemberDeclarations(sourceRewrite, targetRewrite, targetDeclaration);
            TextEdit edit = targetRewrite.rewriteAST((IDocument)document, subType.getJavaScriptProject().getOptions(true));
            try {
                edit.apply((IDocument)document, 2);
            }
            catch (MalformedTreeException exception) {
                JavaScriptPlugin.log(exception);
            }
            catch (BadLocationException exception) {
                JavaScriptPlugin.log(exception);
            }
            buffer.setLength(0);
            buffer.append(document.get());
        }
        finally {
            monitor.done();
        }
    }

    protected final String createTypeImports(IJavaScriptUnit unit, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask("", 100);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
            ImportRewrite rewrite = StubUtility.createImportRewrite(unit, true);
            ITypeBinding type2 = null;
            for (ITypeBinding type2 : this.fTypeBindings) {
                rewrite.addImport(type2);
            }
            IBinding binding2 = null;
            for (IBinding binding2 : this.fStaticBindings) {
                rewrite.addStaticImport(binding2);
            }
            Document document = new Document();
            try {
                rewrite.rewriteImports((IProgressMonitor)new SubProgressMonitor(monitor, 100)).apply((IDocument)document);
            }
            catch (MalformedTreeException exception) {
                JavaScriptPlugin.log(exception);
            }
            catch (BadLocationException exception) {
                JavaScriptPlugin.log(exception);
            }
            catch (CoreException exception) {
                JavaScriptPlugin.log(exception);
            }
            this.fTypeBindings.clear();
            this.fStaticBindings.clear();
            String string = document.get();
            return string;
        }
        finally {
            monitor.done();
        }
    }

    protected final String createTypeSource(IJavaScriptUnit copy, IType subType, String superName, CompilationUnitRewrite sourceRewrite, AbstractTypeDeclaration declaration, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        String source;
        block10: {
            Assert.isNotNull((Object)copy);
            Assert.isNotNull((Object)subType);
            Assert.isNotNull((Object)superName);
            Assert.isNotNull((Object)sourceRewrite);
            Assert.isNotNull((Object)declaration);
            Assert.isNotNull((Object)status);
            Assert.isNotNull((Object)monitor);
            source = null;
            try {
                monitor.beginTask("", 100);
                monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
                String delimiter = StubUtility.getLineDelimiterUsed(subType.getJavaScriptProject());
                String typeComment = null;
                String fileComment = null;
                if (this.fSettings.createComments) {
                    typeComment = CodeGeneration.getTypeComment(copy, superName, delimiter);
                    fileComment = CodeGeneration.getFileComment(copy, delimiter);
                }
                StringBuffer buffer = new StringBuffer(64);
                this.createTypeDeclaration(sourceRewrite, subType, superName, declaration, buffer, true, status, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                String imports = this.createTypeImports(copy, (IProgressMonitor)new SubProgressMonitor(monitor, 60));
                source = this.createTypeTemplate(copy, imports, fileComment, typeComment, buffer.toString());
                if (source == null) {
                    if (!subType.getPackageFragment().isDefaultPackage()) {
                        if (imports.length() > 0) {
                            buffer.insert(0, imports);
                        }
                        buffer.insert(0, "package " + subType.getPackageFragment().getElementName() + ";");
                    }
                    source = buffer.toString();
                }
                Document document = new Document(source);
                TextEdit edit = CodeFormatterUtil.format2(8, source, 0, delimiter, copy.getJavaScriptProject().getOptions(true));
                if (edit == null) break block10;
                try {
                    edit.apply((IDocument)document, 2);
                }
                catch (MalformedTreeException exception) {
                    JavaScriptPlugin.log(exception);
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error));
                }
                catch (BadLocationException exception) {
                    JavaScriptPlugin.log(exception);
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error));
                }
                source = document.get();
            }
            finally {
                monitor.done();
            }
        }
        return source;
    }

    protected final String createTypeTemplate(IJavaScriptUnit unit, String imports, String fileComment, String comment, String content) throws CoreException {
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)imports);
        Assert.isNotNull((Object)content);
        IPackageFragment fragment = (IPackageFragment)unit.getParent();
        StringBuffer buffer = new StringBuffer();
        String delimiter = StubUtility.getLineDelimiterUsed(unit.getJavaScriptProject());
        if (!fragment.isDefaultPackage()) {
            buffer.append("package " + fragment.getElementName() + ";");
            buffer.append(delimiter);
            buffer.append(delimiter);
        }
        if (imports.length() > 0) {
            buffer.append(imports);
        }
        return StubUtility.getCompilationUnitContent(unit, buffer.toString(), fileComment, comment, content, delimiter);
    }

    protected void finalize() throws Throwable {
        this.resetWorkingCopies();
    }

    @Override
    public final String getComment() {
        return this.fComment;
    }

    protected final IField getCorrespondingField(VariableDeclarationFragment fragment) throws JavaScriptModelException {
        IJavaScriptUnit unit;
        IJavaScriptElement element;
        IVariableBinding variable;
        IBinding binding = fragment.getName().resolveBinding();
        if (binding instanceof IVariableBinding && (variable = (IVariableBinding)binding).isField() && (element = (unit = RefactoringASTParser.getCompilationUnit((ASTNode)fragment)).getElementAt(fragment.getStartPosition())) instanceof IField) {
            return (IField)element;
        }
        return null;
    }

    protected final void getFieldReferencingCompilationUnits(Map units, ASTNode[] nodes) throws JavaScriptModelException {
        ASTNode node = null;
        IField field = null;
        IJavaScriptProject project = null;
        int index = 0;
        while (index < nodes.length) {
            node = nodes[index];
            project = RefactoringASTParser.getCompilationUnit(node).getJavaScriptProject();
            if (project != null) {
                List fields = this.getReferencingFields(node, project);
                int offset = 0;
                while (offset < fields.size()) {
                    IJavaScriptUnit unit;
                    field = (IField)fields.get(offset);
                    HashSet<IJavaScriptUnit> set = (HashSet<IJavaScriptUnit>)units.get(project);
                    if (set == null) {
                        set = new HashSet<IJavaScriptUnit>();
                        units.put(project, set);
                    }
                    if ((unit = field.getJavaScriptUnit()) != null) {
                        set.add(unit);
                    }
                    ++offset;
                }
            }
            ++index;
        }
    }

    protected final void getMethodReferencingCompilationUnits(Map units, ASTNode[] nodes) throws JavaScriptModelException {
        ASTNode node = null;
        IFunction method = null;
        IJavaScriptProject project = null;
        int index = 0;
        while (index < nodes.length) {
            node = nodes[index];
            project = RefactoringASTParser.getCompilationUnit(node).getJavaScriptProject();
            if (project != null && (method = this.getReferencingMethod(node)) != null) {
                IJavaScriptUnit unit;
                HashSet<IJavaScriptUnit> set = (HashSet<IJavaScriptUnit>)units.get(project);
                if (set == null) {
                    set = new HashSet<IJavaScriptUnit>();
                    units.put(project, set);
                }
                if ((unit = method.getJavaScriptUnit()) != null) {
                    set.add(unit);
                }
            }
            ++index;
        }
    }

    protected final Map getReferencingCompilationUnits(IType type, IProgressMonitor monitor, RefactoringStatus status) throws JavaScriptModelException {
        try {
            monitor.beginTask("", 100);
            monitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
            RefactoringSearchEngine2 engine = new RefactoringSearchEngine2();
            engine.setOwner(this.fOwner);
            engine.setFiltering(true, true);
            engine.setStatus(status);
            engine.setScope(RefactoringScopeFactory.create((IJavaScriptElement)type));
            engine.setPattern(SearchPattern.createPattern((IJavaScriptElement)type, (int)2, (int)24));
            engine.searchPattern((IProgressMonitor)new SubProgressMonitor(monitor, 100));
            Map map = engine.getAffectedProjects();
            return map;
        }
        finally {
            monitor.done();
        }
    }

    protected final List getReferencingFields(ASTNode node, IJavaScriptProject project) throws JavaScriptModelException {
        BodyDeclaration parent;
        ArrayList<IField> result = Collections.EMPTY_LIST;
        if (node instanceof Type && (parent = (BodyDeclaration)ASTNodes.getParent(node, BodyDeclaration.class)) instanceof FieldDeclaration) {
            List fragments = ((FieldDeclaration)parent).fragments();
            result = new ArrayList<IField>(fragments.size());
            VariableDeclarationFragment fragment2 = null;
            for (VariableDeclarationFragment fragment2 : fragments) {
                IField field = this.getCorrespondingField(fragment2);
                if (field == null) continue;
                result.add(field);
            }
        }
        return result;
    }

    protected final IFunction getReferencingMethod(ASTNode node) throws JavaScriptModelException {
        IJavaScriptUnit unit;
        IJavaScriptElement element;
        IFunctionBinding binding;
        BodyDeclaration parent;
        if (node instanceof Type && (parent = (BodyDeclaration)ASTNodes.getParent(node, BodyDeclaration.class)) instanceof FunctionDeclaration && (binding = ((FunctionDeclaration)parent).resolveBinding()) != null && (element = (unit = RefactoringASTParser.getCompilationUnit(node)).getElementAt(node.getStartPosition())) instanceof IFunction) {
            return (IFunction)element;
        }
        return null;
    }

    protected IJavaScriptUnit getSharedWorkingCopy(IJavaScriptUnit unit, IProgressMonitor monitor) throws JavaScriptModelException {
        try {
            IJavaScriptUnit copy = unit.findWorkingCopy(this.fOwner);
            if (copy == null) {
                copy = unit.getWorkingCopy(this.fOwner, monitor);
            }
            IJavaScriptUnit iJavaScriptUnit = copy;
            return iJavaScriptUnit;
        }
        finally {
            monitor.done();
        }
    }

    public final boolean isInstanceOf() {
        return this.fInstanceOf;
    }

    public final boolean isReplace() {
        return this.fReplace;
    }

    protected final void performFirstPass(SuperTypeConstraintsCreator creator, Map units, Map groups, IJavaScriptUnit unit, JavaScriptUnit node, IProgressMonitor monitor) {
        try {
            monitor.beginTask("", 100);
            monitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
            node.accept((ASTVisitor)creator);
            monitor.worked(20);
            SearchResultGroup group = (SearchResultGroup)groups.get(unit);
            if (group != null) {
                ASTNode[] nodes = ASTNodeSearchUtil.getAstNodes(group.getSearchResults(), node);
                try {
                    this.getMethodReferencingCompilationUnits(units, nodes);
                    monitor.worked(40);
                    this.getFieldReferencingCompilationUnits(units, nodes);
                    monitor.worked(40);
                }
                catch (JavaScriptModelException exception) {
                    JavaScriptPlugin.log(exception);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected final void performSecondPass(SuperTypeConstraintsCreator creator, IJavaScriptUnit unit, JavaScriptUnit node, IProgressMonitor monitor) {
        try {
            monitor.beginTask("", 20);
            monitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
            node.accept((ASTVisitor)creator);
            monitor.worked(20);
        }
        finally {
            monitor.done();
        }
    }

    protected void resetWorkingCopies() {
        IJavaScriptUnit[] units = JavaScriptCore.getWorkingCopies((WorkingCopyOwner)this.fOwner);
        int index = 0;
        while (index < units.length) {
            IJavaScriptUnit unit = units[index];
            try {
                unit.discardWorkingCopy();
            }
            catch (Exception exception) {}
            ++index;
        }
    }

    protected void resetWorkingCopies(IJavaScriptUnit unit) {
        IJavaScriptUnit[] units = JavaScriptCore.getWorkingCopies((WorkingCopyOwner)this.fOwner);
        int index = 0;
        while (index < units.length) {
            if (!units[index].equals(unit)) {
                try {
                    units[index].discardWorkingCopy();
                }
                catch (Exception exception) {}
            } else {
                try {
                    units[index].getBuffer().setContents(unit.getPrimary().getBuffer().getContents());
                    JavaModelUtil.reconcile(units[index]);
                }
                catch (JavaScriptModelException exception) {
                    JavaScriptPlugin.log(exception);
                }
            }
            ++index;
        }
    }

    protected final void rewriteTypeOccurrence(CompilationUnitRange range, TType estimate, ASTRequestor requestor, CompilationUnitRewrite rewrite, JavaScriptUnit copy, Set replacements, TextEditGroup group) {
        ASTNode node = null;
        IVariableBinding binding = null;
        JavaScriptUnit target = rewrite.getRoot();
        node = NodeFinder.perform((ASTNode)copy, range.getSourceRange());
        if (node != null) {
            if ((node = ASTNodes.getNormalizedNode(node).getParent()) instanceof VariableDeclaration) {
                binding = ((VariableDeclaration)node).resolveBinding();
                if ((node = target.findDeclaringNode(binding.getKey())) instanceof SingleVariableDeclaration) {
                    this.rewriteTypeOccurrence(estimate, rewrite, (ASTNode)((SingleVariableDeclaration)node).getType(), group);
                    if (node.getParent() instanceof FunctionDeclaration && (binding = ((VariableDeclaration)node).resolveBinding()) != null) {
                        replacements.add(binding.getKey());
                    }
                }
            } else if (node instanceof VariableDeclarationStatement) {
                binding = ((VariableDeclaration)((VariableDeclarationStatement)node).fragments().get(0)).resolveBinding();
                if ((node = target.findDeclaringNode(binding.getKey())) instanceof VariableDeclarationFragment) {
                    this.rewriteTypeOccurrence(estimate, rewrite, (ASTNode)((VariableDeclarationStatement)((VariableDeclarationFragment)node).getParent()).getType(), group);
                }
            } else if (node instanceof FunctionDeclaration) {
                binding = ((FunctionDeclaration)node).resolveBinding();
                if ((node = target.findDeclaringNode(binding.getKey())) instanceof FunctionDeclaration) {
                    this.rewriteTypeOccurrence(estimate, rewrite, (ASTNode)((FunctionDeclaration)node).getReturnType2(), group);
                }
            } else if (node instanceof FieldDeclaration) {
                binding = ((VariableDeclaration)((FieldDeclaration)node).fragments().get(0)).resolveBinding();
                if ((node = target.findDeclaringNode(binding.getKey())) instanceof VariableDeclarationFragment && (node = node.getParent()) instanceof FieldDeclaration) {
                    this.rewriteTypeOccurrence(estimate, rewrite, (ASTNode)((FieldDeclaration)node).getType(), group);
                }
            } else if (node instanceof ArrayType) {
                ASTNode type = node;
                while (node != null && !(node instanceof FunctionDeclaration) && !(node instanceof VariableDeclarationFragment)) {
                    node = node.getParent();
                }
                if (node != null) {
                    int delta = node.getStartPosition() + node.getLength() - type.getStartPosition();
                    if (node instanceof FunctionDeclaration) {
                        binding = ((FunctionDeclaration)node).resolveBinding();
                    } else if (node instanceof VariableDeclarationFragment) {
                        binding = ((VariableDeclarationFragment)node).resolveBinding();
                    }
                    if (binding != null && ((node = target.findDeclaringNode(binding.getKey())) instanceof FunctionDeclaration || node instanceof VariableDeclarationFragment) && (node = NodeFinder.perform((ASTNode)target, node.getStartPosition() + node.getLength() - delta, 0)) instanceof SimpleName) {
                        this.rewriteTypeOccurrence(estimate, rewrite, node, group);
                    }
                }
            } else if (node instanceof QualifiedName) {
                ASTNode name = node;
                while (node != null && !(node instanceof FunctionDeclaration) && !(node instanceof VariableDeclarationFragment)) {
                    node = node.getParent();
                }
                if (node != null) {
                    int delta = node.getStartPosition() + node.getLength() - name.getStartPosition();
                    if (node instanceof FunctionDeclaration) {
                        binding = ((FunctionDeclaration)node).resolveBinding();
                    } else if (node instanceof VariableDeclarationFragment) {
                        binding = ((VariableDeclarationFragment)node).resolveBinding();
                    }
                    if (binding != null && ((node = target.findDeclaringNode(binding.getKey())) instanceof SimpleName || node instanceof FunctionDeclaration || node instanceof VariableDeclarationFragment) && (node = NodeFinder.perform((ASTNode)target, node.getStartPosition() + node.getLength() - delta, 0)) instanceof SimpleName) {
                        this.rewriteTypeOccurrence(estimate, rewrite, node, group);
                    }
                }
            }
        }
    }

    protected final void rewriteTypeOccurrence(TType estimate, CompilationUnitRewrite rewrite, ASTNode node, TextEditGroup group) {
        rewrite.getImportRemover().registerRemovedNode(node);
        rewrite.getASTRewrite().replace(node, SuperTypeRefactoringProcessor.createCorrespondingNode(rewrite, estimate), group);
    }

    protected abstract void rewriteTypeOccurrences(TextEditBasedChangeManager var1, ASTRequestor var2, CompilationUnitRewrite var3, IJavaScriptUnit var4, JavaScriptUnit var5, Set var6, IProgressMonitor var7) throws CoreException;

    protected final void rewriteTypeOccurrences(TextEditBasedChangeManager manager, ASTRequestor sourceRequestor, CompilationUnitRewrite sourceRewrite, IJavaScriptUnit subUnit, JavaScriptUnit subNode, Set replacements, RefactoringStatus status, IProgressMonitor monitor) {
        block16: {
            try {
                monitor.beginTask("", 300);
                monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
                if (this.fTypeOccurrences == null) break block16;
                HashSet units = new HashSet(this.fTypeOccurrences.keySet());
                if (subUnit != null) {
                    units.remove(subUnit);
                }
                HashMap<IJavaScriptProject, ArrayList<IJavaScriptUnit>> projects = new HashMap<IJavaScriptProject, ArrayList<IJavaScriptUnit>>();
                Collection collection = null;
                IJavaScriptProject project2 = null;
                IJavaScriptUnit current2 = null;
                for (IJavaScriptUnit current2 : units) {
                    project2 = current2.getJavaScriptProject();
                    collection = (ArrayList<IJavaScriptUnit>)projects.get(project2);
                    if (collection == null) {
                        collection = new ArrayList<IJavaScriptUnit>();
                        projects.put(project2, (ArrayList<IJavaScriptUnit>)collection);
                    }
                    collection.add(current2);
                }
                ASTParser parser = ASTParser.newParser((int)3);
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 320);
                try {
                    Set keySet = projects.keySet();
                    subMonitor.beginTask("", keySet.size() * 100);
                    subMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
                    for (IJavaScriptProject project2 : keySet) {
                        collection = (Collection)projects.get(project2);
                        parser.setWorkingCopyOwner(this.fOwner);
                        parser.setResolveBindings(true);
                        parser.setProject(project2);
                        parser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaScriptElement)project2));
                        SubProgressMonitor subsubMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 100);
                        try {
                            subsubMonitor.beginTask("", collection.size() * 100 + 200);
                            subsubMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
                            parser.createASTs(collection.toArray(new IJavaScriptUnit[collection.size()]), new String[0], new ASTRequestor((IProgressMonitor)subsubMonitor, sourceRewrite, manager, replacements, status){
                                private final /* synthetic */ IProgressMonitor val$subsubMonitor;
                                private final /* synthetic */ CompilationUnitRewrite val$sourceRewrite;
                                private final /* synthetic */ TextEditBasedChangeManager val$manager;
                                private final /* synthetic */ Set val$replacements;
                                private final /* synthetic */ RefactoringStatus val$status;
                                {
                                    this.val$subsubMonitor = iProgressMonitor;
                                    this.val$sourceRewrite = compilationUnitRewrite;
                                    this.val$manager = textEditBasedChangeManager;
                                    this.val$replacements = set;
                                    this.val$status = refactoringStatus;
                                }

                                public final void acceptAST(IJavaScriptUnit unit, JavaScriptUnit node) {
                                    SubProgressMonitor subsubsubMonitor = new SubProgressMonitor(this.val$subsubMonitor, 100);
                                    try {
                                        try {
                                            subsubsubMonitor.beginTask("", 100);
                                            subsubsubMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
                                            if (this.val$sourceRewrite != null) {
                                                SuperTypeRefactoringProcessor.this.rewriteTypeOccurrences(this.val$manager, this, this.val$sourceRewrite, unit, node, this.val$replacements, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subsubsubMonitor, 100));
                                            }
                                        }
                                        catch (CoreException exception) {
                                            this.val$status.merge(RefactoringStatus.createFatalErrorStatus((String)exception.getLocalizedMessage()));
                                            subsubsubMonitor.done();
                                        }
                                    }
                                    finally {
                                        subsubsubMonitor.done();
                                    }
                                }

                                public final void acceptBinding(String key, IBinding binding) {
                                }
                            }, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subsubMonitor, 200));
                        }
                        finally {
                            subsubMonitor.done();
                        }
                    }
                    try {
                        if (subUnit != null && subNode != null && sourceRewrite != null && sourceRequestor != null) {
                            this.rewriteTypeOccurrences(manager, sourceRequestor, sourceRewrite, subUnit, subNode, replacements, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 20));
                        }
                    }
                    catch (CoreException exception) {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)exception.getLocalizedMessage()));
                    }
                }
                finally {
                    subMonitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    @Override
    public final void setComment(String comment) {
        this.fComment = comment;
    }

    public final void setInstanceOf(boolean rewrite) {
        this.fInstanceOf = rewrite;
    }

    public final void setReplace(boolean replace) {
        this.fReplace = replace;
    }

    protected final void solveSuperTypeConstraints(IJavaScriptUnit subUnit, JavaScriptUnit subNode, IType subType, ITypeBinding subBinding, ITypeBinding superBinding, IProgressMonitor monitor, RefactoringStatus status) throws JavaScriptModelException {
        Assert.isNotNull((Object)subType);
        Assert.isNotNull((Object)subBinding);
        Assert.isNotNull((Object)superBinding);
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)status);
        int level = 3;
        TypeEnvironment environment = new TypeEnvironment();
        SuperTypeConstraintsModel model = new SuperTypeConstraintsModel(environment, environment.create(subBinding), environment.create(superBinding));
        final SuperTypeConstraintsCreator creator = new SuperTypeConstraintsCreator(model, this.fInstanceOf);
        try {
            monitor.beginTask("", 300);
            monitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
            Map firstPass = this.getReferencingCompilationUnits(subType, (IProgressMonitor)new SubProgressMonitor(monitor, 100), status);
            final HashMap secondPass = new HashMap();
            IJavaScriptProject project2 = null;
            Collection collection = null;
            try {
                Set keySet;
                ASTParser parser = ASTParser.newParser((int)3);
                Object element = null;
                IJavaScriptUnit current = null;
                SearchResultGroup group2 = null;
                SearchMatch[] matches = null;
                final HashMap<IJavaScriptUnit, SearchResultGroup> groups = new HashMap<IJavaScriptUnit, SearchResultGroup>();
                for (IJavaScriptProject project2 : firstPass.keySet()) {
                    if (level == 3 && !JavaModelUtil.is50OrHigher(project2)) {
                        level = 2;
                    }
                    if ((collection = (Collection)firstPass.get(project2)) == null) continue;
                    for (SearchResultGroup group2 : collection) {
                        matches = group2.getSearchResults();
                        int index = 0;
                        while (index < matches.length) {
                            element = matches[index].getElement();
                            if (element instanceof IMember && (current = ((IMember)element).getJavaScriptUnit()) != null) {
                                groups.put(current, group2);
                            }
                            ++index;
                        }
                    }
                }
                HashSet<IJavaScriptUnit> units = null;
                final HashSet<IJavaScriptUnit> processed = new HashSet<IJavaScriptUnit>();
                if (subUnit != null) {
                    processed.add(subUnit);
                }
                model.beginCreation();
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 120);
                try {
                    keySet = firstPass.keySet();
                    subMonitor.beginTask("", keySet.size() * 100);
                    subMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
                    for (IJavaScriptProject project2 : keySet) {
                        collection = (Collection)firstPass.get(project2);
                        if (collection == null) continue;
                        units = new HashSet<IJavaScriptUnit>(collection.size());
                        for (SearchResultGroup group2 : collection) {
                            matches = group2.getSearchResults();
                            int index = 0;
                            while (index < matches.length) {
                                element = matches[index].getElement();
                                if (element instanceof IMember && (current = ((IMember)element).getJavaScriptUnit()) != null) {
                                    units.add(current);
                                }
                                ++index;
                            }
                        }
                        ArrayList batches = new ArrayList(units);
                        int size = batches.size();
                        int iterations = (size - 1) / 500 + 1;
                        SubProgressMonitor subsubMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 100);
                        try {
                            subsubMonitor.beginTask("", iterations * 100);
                            subsubMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
                            Map options = RefactoringASTParser.getCompilerOptions((IJavaScriptElement)project2);
                            int index = 0;
                            while (index < iterations) {
                                List iteration = batches.subList(index * 500, Math.min(size, (index + 1) * 500));
                                parser.setWorkingCopyOwner(this.fOwner);
                                parser.setResolveBindings(true);
                                parser.setProject(project2);
                                parser.setCompilerOptions(options);
                                SubProgressMonitor subsubsubMonitor = new SubProgressMonitor((IProgressMonitor)subsubMonitor, 100);
                                try {
                                    int count = iteration.size();
                                    subsubsubMonitor.beginTask("", count * 100);
                                    subsubsubMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
                                    parser.createASTs(iteration.toArray(new IJavaScriptUnit[count]), new String[0], new ASTRequestor((IProgressMonitor)subsubsubMonitor){
                                        private final /* synthetic */ IProgressMonitor val$subsubsubMonitor;
                                        {
                                            this.val$subsubsubMonitor = iProgressMonitor;
                                        }

                                        public final void acceptAST(IJavaScriptUnit unit, JavaScriptUnit node) {
                                            if (!processed.contains(unit)) {
                                                SuperTypeRefactoringProcessor.this.performFirstPass(creator, secondPass, groups, unit, node, (IProgressMonitor)new SubProgressMonitor(this.val$subsubsubMonitor, 100));
                                                processed.add(unit);
                                            } else {
                                                this.val$subsubsubMonitor.worked(100);
                                            }
                                        }

                                        public final void acceptBinding(String key, IBinding binding) {
                                        }
                                    }, (IProgressMonitor)new NullProgressMonitor());
                                }
                                finally {
                                    subsubsubMonitor.done();
                                }
                                ++index;
                            }
                        }
                        finally {
                            subsubMonitor.done();
                        }
                    }
                }
                finally {
                    firstPass.clear();
                    subMonitor.done();
                }
                if (subUnit != null && subNode != null) {
                    this.performFirstPass(creator, secondPass, groups, subUnit, subNode, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 20));
                }
                subMonitor = new SubProgressMonitor(monitor, 100);
                try {
                    keySet = secondPass.keySet();
                    subMonitor.beginTask("", keySet.size() * 100);
                    subMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
                    for (IJavaScriptProject project2 : keySet) {
                        if (level == 3 && !JavaModelUtil.is50OrHigher(project2)) {
                            level = 2;
                        }
                        if ((collection = (Collection)secondPass.get(project2)) == null) continue;
                        parser.setWorkingCopyOwner(this.fOwner);
                        parser.setResolveBindings(true);
                        parser.setProject(project2);
                        parser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaScriptElement)project2));
                        SubProgressMonitor subsubMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 100);
                        try {
                            subsubMonitor.beginTask("", collection.size() * 100);
                            subsubMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
                            parser.createASTs(collection.toArray(new IJavaScriptUnit[collection.size()]), new String[0], new ASTRequestor((IProgressMonitor)subsubMonitor){
                                private final /* synthetic */ IProgressMonitor val$subsubMonitor;
                                {
                                    this.val$subsubMonitor = iProgressMonitor;
                                }

                                public final void acceptAST(IJavaScriptUnit unit, JavaScriptUnit node) {
                                    if (!processed.contains(unit)) {
                                        SuperTypeRefactoringProcessor.this.performSecondPass(creator, unit, node, (IProgressMonitor)new SubProgressMonitor(this.val$subsubMonitor, 100));
                                    } else {
                                        this.val$subsubMonitor.worked(100);
                                    }
                                }

                                public final void acceptBinding(String key, IBinding binding) {
                                }
                            }, (IProgressMonitor)new NullProgressMonitor());
                        }
                        finally {
                            subsubMonitor.done();
                        }
                    }
                }
                finally {
                    secondPass.clear();
                    subMonitor.done();
                }
            }
            finally {
                model.endCreation();
                model.setCompliance(level);
            }
            SuperTypeConstraintsSolver solver = this.createContraintSolver(model);
            solver.solveConstraints();
            this.fTypeOccurrences = solver.getTypeOccurrences();
            this.fObsoleteCasts = solver.getObsoleteCasts();
        }
        finally {
            monitor.done();
        }
    }
}

