/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.core.base;

import java.util.Collection;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.base.ICallStackSymbol;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderUtils;

public class ResolvableSymbol
implements ICallStackSymbol {
    private final long fAddr;
    private final int fPid;
    private final long fTime;

    public ResolvableSymbol(long addr, int pid, long timestamp) {
        this.fAddr = addr;
        this.fPid = pid;
        this.fTime = timestamp;
    }

    @Override
    public String resolve(Collection<ISymbolProvider> providers) {
        return SymbolProviderUtils.getSymbolText(providers, (int)this.fPid, (long)this.fTime, (long)this.fAddr);
    }

    public int hashCode() {
        return Long.valueOf(this.fAddr).hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ResolvableSymbol)) {
            return false;
        }
        ResolvableSymbol other = (ResolvableSymbol)obj;
        return this.fAddr == other.fAddr && this.fPid == other.fPid;
    }

    public String toString() {
        return "0x" + Long.toHexString(this.fAddr) + " in " + this.fPid;
    }
}

