/*
 * Copyright (c) 2021, 2025 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

package org.eclipse.trace4cps.core.impl;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.eclipse.trace4cps.core.ITSSeries;
import org.eclipse.trace4cps.core.ITimeSeries;

/**
 * Default implementation of the {@link ITimeSeries} type.
 */
public final class TimeSeries extends AttributeAware implements ITimeSeries {
    private Map<Integer, ITSSeries> series = new TreeMap<>();  // use TreeMap to keep the keys sorted

    /**
     * {@inheritDoc}
     */
    @Override
    public void addSeries(Integer id, ITSSeries series) {
        this.series.put(id, series);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ITSSeries getSeries(Integer id) {
        return series.get(id);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public List<ITSSeries> getAllSeries() {
        return series.values().stream().toList();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("TimeSeries[attributes=" + getAttributes());
        b.append(", series:\n");
        for (ITSSeries s: series.values()) {
            b.append("\t").append(s.toString()).append("\n");
        }
        b.append("]\n");
        return b.toString();
    }
}
