/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.function.DoubleFunction;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.panel.CrosshairOverlay;
import org.jfree.chart.panel.Overlay;
import org.jfree.chart.plot.Crosshair;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.xy.IntervalXYDataset;

public class IntervalRangeValueCrosshair
extends CrosshairOverlay {
    private static final long serialVersionUID = -5903584362110518312L;
    private final Crosshair crosshair = new Crosshair(Double.NaN, (Paint)Color.DARK_GRAY, (Stroke)new BasicStroke(1.0f));

    public static IntervalRangeValueCrosshair connectTo(ChartPanel chartPanel) {
        return IntervalRangeValueCrosshair.connectTo(chartPanel, String::valueOf);
    }

    public static IntervalRangeValueCrosshair connectTo(ChartPanel chartPanel, DoubleFunction<String> labelGenerator) {
        return new IntervalRangeValueCrosshair(chartPanel, labelGenerator);
    }

    private IntervalRangeValueCrosshair(final ChartPanel chartPanel, DoubleFunction<String> labelGenerator) {
        this.crosshair.setLabelVisible(true);
        this.crosshair.setLabelGenerator(ch -> (String)labelGenerator.apply(ch.getValue()));
        this.crosshair.setLabelAnchor(RectangleAnchor.TOP_LEFT);
        this.crosshair.setLabelBackgroundPaint((Paint)new Color(192, 192, 192, 192));
        this.crosshair.setLabelOutlinePaint((Paint)Color.DARK_GRAY);
        this.crosshair.setLabelPaint((Paint)Color.BLACK);
        this.addRangeCrosshair(this.crosshair);
        chartPanel.addOverlay((Overlay)this);
        chartPanel.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseMoved(ChartMouseEvent event) {
                Rectangle2D screenDataArea = chartPanel.getScreenDataArea();
                XYPlot xyPlot = event.getChart().getXYPlot();
                ValueAxis domainAxis = xyPlot.getDomainAxis();
                RectangleEdge domainAxisEdge = xyPlot.getDomainAxisEdge();
                IntervalXYDataset dataset = (IntervalXYDataset)xyPlot.getDataset();
                double x = domainAxis.java2DToValue((double)event.getTrigger().getX(), screenDataArea, domainAxisEdge);
                double y = Double.NaN;
                if (domainAxis.getRange().contains(x)) {
                    int i = 0;
                    while (i < dataset.getSeriesCount() && Double.isNaN(y)) {
                        y = IntervalRangeValueCrosshair.this.findYValue(dataset, i, x);
                        ++i;
                    }
                }
                IntervalRangeValueCrosshair.this.crosshair.setVisible(!Double.isNaN(y));
                IntervalRangeValueCrosshair.this.crosshair.setValue(y);
            }

            public void chartMouseClicked(ChartMouseEvent arg0) {
            }
        });
    }

    public Crosshair getCrosshair() {
        return this.crosshair;
    }

    private double findYValue(IntervalXYDataset dataset, int series, double x) {
        int item = 0;
        while (item < dataset.getItemCount(series)) {
            double startX = dataset.getStartXValue(series, item);
            double endX = dataset.getEndXValue(series, item);
            if (x >= startX && x <= endX) {
                return dataset.getYValue(series, item);
            }
            ++item;
        }
        return Double.NaN;
    }
}

