/*
 * Copyright (c) 2021, 2025 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

package org.eclipse.trace4cps.vis.jfree;

import org.eclipse.trace4cps.core.ITSSeries;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class TimeSeriesDataItem extends XYDataItem {
    private static final long serialVersionUID = -7106555274909083446L;

    private final ITSSeries series;

    TimeSeriesDataItem(Number x, Number y, ITSSeries series) {
        super(x, y);
        this.series = series;
    }

    public ITSSeries getTimeSeries() {
        return series;
    }

    public static TimeSeriesDataItem getFrom(XYDataset ds, int series, int item) {
        if (ds instanceof XYSeriesCollection) {
            XYSeriesCollection sc = (XYSeriesCollection)ds;
            XYSeries s = sc.getSeries(series);
            Object o = s.getDataItem(item);
            if (o instanceof TimeSeriesDataItem) {
                return (TimeSeriesDataItem)o;
            }
        }
        return null;
    }
}
