/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.processes.core.subsystem.impl;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.processes.IHostProcess;
import org.eclipse.rse.services.clientserver.processes.IHostProcessFilter;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcess;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcessContext;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcessSubSystem;
import org.eclipse.rse.ui.SystemBasePlugin;

public class RemoteProcessImpl
implements IRemoteProcess {
    public static final char CONNECTION_DELIMITER = ':';
    protected IRemoteProcessContext _context;
    protected IHostProcess _underlyingProcess;
    protected IRemoteProcess _parentProcess;

    public RemoteProcessImpl(IRemoteProcessContext context, IHostProcess process) {
        this._context = context;
        if (context != null && context.getParentRemoteProcessSubSystem() != null && !context.getParentRemoteProcessSubSystem().isConnected()) {
            try {
                context.getParentRemoteProcessSubSystem().connect((IProgressMonitor)new NullProgressMonitor(), false);
            }
            catch (Exception exception) {}
        }
        this._underlyingProcess = process;
    }

    public IRemoteProcessSubSystem getParentRemoteProcessSubSystem() {
        return this._context.getParentRemoteProcessSubSystem();
    }

    public IHost getSystemConnection() {
        IRemoteProcessSubSystem ss = this._context.getParentRemoteProcessSubSystem();
        if (ss == null) {
            return null;
        }
        return ss.getHost();
    }

    public IHostProcessFilter getFilterString() {
        return this._context.getFilterString();
    }

    public void setFilterString(IHostProcessFilter filterString) {
        this._context.setFilterString(filterString);
    }

    public String getAbsolutePathPlusConnection() {
        IHost conn = this.getSystemConnection();
        if (conn == null) {
            return this.getAbsolutePath();
        }
        return String.valueOf(conn.getSystemProfileName()) + '.' + conn.getAliasName() + ':' + this.getAbsolutePath();
    }

    public IRemoteProcess getParentRemoteProcess() {
        if (this._parentProcess == null) {
            IRemoteProcessSubSystem ss;
            IRemoteProcess parentProcess = this._context.getParentRemoteProcess();
            if (parentProcess == null && this.getPPid() != -1L && (ss = this._context.getParentRemoteProcessSubSystem()) != null) {
                try {
                    parentProcess = ss.getRemoteProcessObject(this.getPPid());
                }
                catch (SystemMessageException e) {
                    SystemBasePlugin.logError((String)"UniversalProcessImpl.getParentRemoteProcess()", (Throwable)e);
                }
            }
            this._parentProcess = parentProcess;
        }
        return this._parentProcess;
    }

    public IRemoteProcessContext getContext() {
        return this._context;
    }

    public String getAbsolutePath() {
        return "/proc/" + this.getPid();
    }

    public long getPid() {
        return this._underlyingProcess.getPid();
    }

    public long getPPid() {
        return this._underlyingProcess.getPPid();
    }

    public String getName() {
        return this._underlyingProcess.getName();
    }

    public String getState() {
        return this._underlyingProcess.getState();
    }

    public long getTgid() {
        return this._underlyingProcess.getTgid();
    }

    public long getTracerPid() {
        return this._underlyingProcess.getTracerPid();
    }

    public long getUid() {
        return this._underlyingProcess.getUid();
    }

    public String getUsername() {
        return this._underlyingProcess.getUsername();
    }

    public long getGid() {
        return this._underlyingProcess.getGid();
    }

    public boolean isRoot() {
        return this._underlyingProcess.isRoot();
    }

    public String getAllProperties() {
        return this._underlyingProcess.getAllProperties();
    }

    public long getVmSizeInKB() {
        return this._underlyingProcess.getVmSizeInKB();
    }

    public long getVmRSSInKB() {
        return this._underlyingProcess.getVmRSSInKB();
    }

    public String getLabel() {
        return this._underlyingProcess.getLabel();
    }

    public Object getObject() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

