/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.connectorservice.dstore;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dstore.core.client.ClientConnection;
import org.eclipse.dstore.core.client.ConnectionStatus;
import org.eclipse.dstore.core.java.IRemoteClassInstance;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.IDataStoreProvider;
import org.eclipse.dstore.core.model.ISSLProperties;
import org.eclipse.dstore.extra.IDomainListener;
import org.eclipse.dstore.internal.core.client.ClientSSLProperties;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.connectorservice.dstore.util.ConnectionStatusListener;
import org.eclipse.rse.connectorservice.dstore.util.StatusMonitor;
import org.eclipse.rse.connectorservice.dstore.util.StatusMonitorFactory;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.comm.ISystemKeystoreProvider;
import org.eclipse.rse.core.comm.SystemKeystoreProviderManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IRemoteServerLauncher;
import org.eclipse.rse.core.subsystems.IServerLauncher;
import org.eclipse.rse.core.subsystems.IServerLauncherProperties;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ServerLaunchType;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.internal.connectorservice.dstore.ConnectorServiceResources;
import org.eclipse.rse.internal.connectorservice.dstore.RexecDstoreServer;
import org.eclipse.rse.internal.ui.SystemPropertyResources;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.actions.DisplayHidableSystemMessageAction;
import org.eclipse.rse.ui.actions.DisplaySystemMessageAction;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.subsystems.StandardConnectorService;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class DStoreConnectorService
extends StandardConnectorService
implements IDataStoreProvider {
    private ClientConnection clientConnection = null;
    private ConnectionStatusListener _connectionStatusListener = null;
    private IServerLauncher starter = null;
    private IServerLauncherProperties _remoteServerLauncherProperties = null;
    private boolean _isConnecting = false;
    private transient DataElement sysInfo = null;
    private transient DataElement installInfo = null;
    private transient DataElement clientIP = null;
    private static String DSTORE_PACKAGE = "org.eclipse.dstore.core";
    private Exception connectException;

    public DStoreConnectorService(String name, String description, IHost host) {
        super(name, description, host, 0);
    }

    public int getServerVersion() {
        return this.clientConnection.getServerVersion();
    }

    public int getServerMinor() {
        return this.clientConnection.getServerMinor();
    }

    private String getSystemInfoProperty(String propertyName) {
        DataElement propertyNode;
        if (!this.isConnected()) {
            try {
                ISubSystem ss = this.getPrimarySubSystem();
                if (ss != null) {
                    if (Display.getCurrent() == null) {
                        ss.connect((IProgressMonitor)new NullProgressMonitor(), false);
                    } else {
                        ss.connect(false, null);
                    }
                }
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)"UniversalSystem.getSystemInfoProperty: error during connect", (Throwable)e);
                return "";
            }
        }
        String propertyValue = null;
        DataElement envMinerData = null;
        DataStore ds = this.getDataStore();
        if (this.sysInfo == null && (envMinerData = ds.findMinerInformation("org.eclipse.rse.dstore.universal.miners.EnvironmentMiner")) != null) {
            this.sysInfo = ds.find(envMinerData, 2, "systemInfo", 1);
        }
        propertyValue = this.sysInfo != null ? ((propertyNode = ds.find(this.sysInfo, 2, propertyName, 1)) != null ? propertyNode.getSource() : "") : "";
        return propertyValue;
    }

    public String getVersionReleaseModification() {
        if (!this.isConnected()) {
            return SystemPropertyResources.RESID_TERM_NOTAVAILABLE;
        }
        StringBuffer buffer = new StringBuffer(this.getSystemInfoProperty("os.name"));
        buffer.append(" ");
        buffer.append(this.getSystemInfoProperty("os.version"));
        return buffer.toString();
    }

    public String getHomeDirectory() {
        return this.getSystemInfoProperty("user.home");
    }

    public boolean runClassInstanceRemotely(IRemoteClassInstance instance) {
        DataStore dataStore = this.getDataStore();
        dataStore.registerLocalClassLoader(instance.getClass().getClassLoader());
        dataStore.runRemoteClassInstance(instance);
        return true;
    }

    public String getServerInstallPath() {
        if (this.clientConnection != null) {
            if (this.installInfo == null) {
                DataStore ds = this.clientConnection.getDataStore();
                this.installInfo = ds.queryInstall();
            }
            return this.installInfo.getAttribute(4);
        }
        return "";
    }

    public String getClientIP() {
        if (this.clientConnection != null && this.clientConnection.isConnected()) {
            if (this.clientIP == null) {
                DataStore ds = this.clientConnection.getDataStore();
                this.clientIP = ds.queryClientIP();
            }
            return this.clientIP.getAttribute(4);
        }
        return RSECorePlugin.getLocalMachineIPAddress();
    }

    public String getTempDirectory() {
        return this.getSystemInfoProperty("temp.dir");
    }

    protected int getSocketTimeOutValue() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        return store.getInt("org.eclipse.rse.connectorservice.dstore.ui.preferences.sockettimeout");
    }

    protected void internalDisconnect(IProgressMonitor monitor) throws Exception {
        try {
            if (this.clientConnection != null) {
                if (this._connectionStatusListener != null && this._connectionStatusListener.isConnectionDown()) {
                    this.notifyError();
                } else {
                    this.fireCommunicationsEvent(3);
                }
                DataStore dataStore = this.getDataStore();
                if (dataStore != null && this._connectionStatusListener != null) {
                    dataStore.getDomainNotifier().removeDomainListener((IDomainListener)this._connectionStatusListener);
                }
                if (this.clientConnection != null) {
                    this.clientConnection.disconnect();
                }
                this.notifyDisconnection();
                this.clientConnection = null;
                this.clearPassword(false, true);
                this.sysInfo = null;
                this.installInfo = null;
                this.clientIP = null;
            }
        }
        catch (Exception exc) {
            throw new InvocationTargetException(exc);
        }
    }

    private IRemoteServerLauncher getDStoreServerLauncher() {
        IServerLauncherProperties sl = this.getRemoteServerLauncherProperties();
        if (sl != null && sl instanceof IRemoteServerLauncher) {
            return (IRemoteServerLauncher)sl;
        }
        return null;
    }

    protected void setPluginPathProperty() {
        Bundle bundle = RSEUIPlugin.getDefault().getBundle();
        URL pluginsURL = bundle.getEntry("/");
        try {
            String path = FileLocator.resolve((URL)pluginsURL).getPath();
            File systemsPluginDir = new File(path);
            path = systemsPluginDir.getParentFile().getAbsolutePath();
            String version = (String)bundle.getHeaders().get("Bundle-Version");
            Version v = new Version(version);
            String versionString = v.toString();
            String dstorePath = this.getDStorePath(path, versionString);
            System.setProperty("A_PLUGIN_PATH", dstorePath);
        }
        catch (IOException iOException) {}
    }

    private String getDStorePath(String pluginDir, String version) {
        File dstorePath = new File(String.valueOf(pluginDir) + "/" + DSTORE_PACKAGE + "_" + version);
        if (!dstorePath.exists()) {
            dstorePath = new File(String.valueOf(pluginDir) + "/" + DSTORE_PACKAGE);
        }
        return dstorePath.getAbsolutePath();
    }

    public boolean getRexecLaunchEnabled(SubSystem subsystemImpl) {
        return this.isServerLaunchTypeEnabled((ISubSystem)subsystemImpl, ServerLaunchType.REXEC_LITERAL);
    }

    public boolean getNoLaunchEnabled(SubSystem subsystemImpl) {
        return this.isServerLaunchTypeEnabled((ISubSystem)subsystemImpl, ServerLaunchType.RUNNING_LITERAL);
    }

    public IServerLauncher getRemoteServerLauncher() {
        if (this.starter == null) {
            this.starter = new RexecDstoreServer();
        }
        ((RexecDstoreServer)this.starter).setClientConnection(this.clientConnection);
        ((RexecDstoreServer)this.starter).setSocketTimeoutValue(this.getSocketTimeOutValue());
        return this.starter;
    }

    public IServerLauncherProperties getRemoteServerLauncherProperties() {
        return this._remoteServerLauncherProperties;
    }

    public void setRemoteServerLauncherProperties(IServerLauncherProperties newRemoteServerLauncher) {
        if (this._remoteServerLauncherProperties != newRemoteServerLauncher) {
            this._remoteServerLauncherProperties = newRemoteServerLauncher;
            this.setDirty(true);
        }
    }

    protected void internalConnect(IProgressMonitor monitor) throws Exception {
        String cmsg;
        String cmsg2;
        if (this.isConnected() || this._isConnecting) {
            return;
        }
        this._isConnecting = true;
        boolean alertedNONSSL = false;
        this.setPluginPathProperty();
        this.fireCommunicationsEvent(1);
        ConnectionStatus connectStatus = null;
        ConnectionStatus launchStatus = null;
        this.clientConnection = new ClientConnection(this.getPrimarySubSystem().getHost().getAliasName());
        this.clientConnection.setHost(this.getHostName());
        this.clientConnection.setPort(Integer.toString(this.getPort()));
        this.getPrimarySubSystem();
        IRemoteServerLauncher serverLauncher = this.getDStoreServerLauncher();
        ServerLaunchType serverLauncherType = null;
        boolean autoDetectSSL = true;
        if (serverLauncher != null) {
            serverLauncherType = serverLauncher.getServerLaunchType();
            autoDetectSSL = serverLauncher.getAutoDetectSSL();
        }
        SystemMessage msg = null;
        boolean launchFailed = false;
        int timeout = this.getSocketTimeOutValue();
        if (serverLauncherType == ServerLaunchType.REXEC_LITERAL) {
            if (monitor != null) {
                String cmsg3 = ConnectorServiceResources.MSG_STARTING_SERVER_VIA_REXEC;
                monitor.subTask(cmsg3);
            }
            SystemSignonInformation info = this.getSignonInformation();
            IServerLauncher starter = this.getRemoteServerLauncher();
            starter.setSignonInformation(info);
            starter.setServerLauncherProperties((IServerLauncherProperties)serverLauncher);
            if (starter instanceof RexecDstoreServer) {
                ((RexecDstoreServer)starter).setSocketTimeoutValue(timeout);
            }
            if (autoDetectSSL) {
                timeout = 3000;
            } else {
                this.setSSLProperties(this.isUsingSSL());
            }
            int iServerPort = this.launchUsingRexec(info, (IServerLauncherProperties)serverLauncher, monitor);
            if (iServerPort != 0) {
                this.clientConnection.setPort("" + iServerPort);
                if (monitor != null) {
                    cmsg2 = NLS.bind((String)ConnectorServiceResources.MSG_CONNECTING_TO_SERVER, (Object)this.clientConnection.getPort());
                    monitor.subTask(cmsg2);
                }
                if (!(connectStatus = this.clientConnection.connect(null, timeout)).isConnected() && connectStatus.getMessage().startsWith("Cannot connect to server.") && autoDetectSSL && this.setSSLProperties(true) && (iServerPort = this.launchUsingRexec(info, (IServerLauncherProperties)serverLauncher, monitor)) != 0) {
                    this.clientConnection.setPort("" + iServerPort);
                    connectStatus = this.clientConnection.connect(null, timeout);
                }
            } else {
                launchFailed = true;
                connectStatus = new ConnectionStatus(false);
                msg = starter.getErrorMessage();
                String errorMsg = null;
                errorMsg = msg == null ? NLS.bind((String)ConnectorServiceResources.MSG_COMM_CONNECT_FAILED, (Object)this.getHostName()) : msg.getLevelTwoText();
                connectStatus.setMessage(errorMsg);
            }
        } else if (serverLauncherType == ServerLaunchType.DAEMON_LITERAL) {
            ISystemKeystoreProvider provider;
            List certs;
            Throwable conE;
            SystemSignonInformation info;
            if (monitor != null) {
                String cmsg4 = ConnectorServiceResources.MSG_STARTING_SERVER_VIA_DAEMON;
                monitor.subTask(cmsg4);
            }
            if ((info = this.getSignonInformation()) == null) {
                SystemBasePlugin.logError((String)"password info = null!");
            }
            int daemonPort = 0;
            if (serverLauncher != null) {
                daemonPort = serverLauncher.getDaemonPort();
            }
            boolean usedSSL = true;
            this.setSSLProperties(true);
            launchStatus = this.launchServer(this.clientConnection, info, daemonPort, monitor, timeout);
            if (!launchStatus.isConnected() && !this.clientConnection.isKnownStatus(launchStatus.getMessage())) {
                conE = launchStatus.getException();
                if (conE instanceof SSLHandshakeException && (certs = launchStatus.getUntrustedCertificates()) != null && certs.size() > 0 && (provider = SystemKeystoreProviderManager.getInstance().getDefaultProvider()) != null) {
                    this._isConnecting = false;
                    if (provider.importCertificates(certs, this.getHostName())) {
                        this.internalConnect(monitor);
                        return;
                    }
                    throw new InterruptedException();
                }
                if (this.setSSLProperties(false)) {
                    usedSSL = false;
                    boolean allowNonSSL = true;
                    IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
                    if (store.getBoolean("org.eclipse.rse.preferences.alert.nonssl")) {
                        String cmsg5 = NLS.bind((String)ConnectorServiceResources.MSG_COMM_NOT_USING_SSL, (Object)this.getHostName());
                        msg = this.createSystemMessage("RSEC2315", 1, cmsg5);
                        DisplayHidableSystemMessageAction msgAction = new DisplayHidableSystemMessageAction(msg, store, "org.eclipse.rse.preferences.alert.nonssl");
                        Display.getDefault().syncExec((Runnable)msgAction);
                        if (msgAction.getReturnCode() != 2) {
                            allowNonSSL = false;
                        } else {
                            alertedNONSSL = true;
                        }
                    }
                    if (allowNonSSL) {
                        launchStatus = this.launchServer(this.clientConnection, info, daemonPort, monitor, timeout);
                    } else {
                        this._isConnecting = false;
                        this.clientConnection = null;
                        throw new OperationCanceledException();
                    }
                }
            }
            if (!launchStatus.isConnected()) {
                String pmsg;
                String launchMsg = launchStatus.getMessage();
                if (launchMsg != null && (this.isPasswordExpired(launchMsg) || this.isNewPasswordInvalid(launchMsg))) {
                    SystemSignonInformation oldCredentials = (SystemSignonInformation)this.getCredentialsProvider().getCredentials();
                    SystemSignonInformation newCredentials = null;
                    while (launchMsg != null && (this.isPasswordExpired(launchMsg) || this.isNewPasswordInvalid(launchMsg))) {
                        pmsg = null;
                        String pmsgDetails = null;
                        String msgId = null;
                        boolean expired = this.isPasswordExpired(launchMsg);
                        if (expired) {
                            pmsg = ConnectorServiceResources.MSG_VALIDATE_PASSWORD_EXPIRED;
                            pmsgDetails = ConnectorServiceResources.MSG_VALIDATE_PASSWORD_EXPIRED_DETAILS;
                            msgId = "RSEG1036";
                        } else {
                            pmsg = ConnectorServiceResources.MSG_VALIDATE_PASSWORD_INVALID;
                            pmsgDetails = ConnectorServiceResources.MSG_VALIDATE_PASSWORD_INVALID_DETAILS;
                            msgId = "RSEG1297";
                        }
                        SystemMessage message = this.createSystemMessage(msgId, 4, pmsg, pmsgDetails);
                        try {
                            this.getCredentialsProvider().repairCredentials(message);
                        }
                        catch (OperationCanceledException e) {
                            this._isConnecting = false;
                            this.clientConnection = null;
                            throw e;
                        }
                        newCredentials = (SystemSignonInformation)this.getCredentialsProvider().getCredentials();
                        launchStatus = this.changePassword(this.clientConnection, oldCredentials, (IServerLauncherProperties)serverLauncher, monitor, newCredentials.getPassword());
                        launchMsg = launchStatus.getMessage();
                    }
                    if (newCredentials != null) {
                        info = newCredentials;
                    }
                    if (launchMsg != null && launchMsg.equals("attempt reconnect")) {
                        this._isConnecting = false;
                        this.internalConnect(monitor);
                        return;
                    }
                } else {
                    if (launchMsg != null && this.isPortOutOfRange(launchMsg)) {
                        this._isConnecting = false;
                        launchFailed = true;
                        int colonIndex = launchMsg.indexOf(58);
                        String portRange = launchMsg.substring(colonIndex + 1);
                        pmsg = NLS.bind((String)ConnectorServiceResources.MSG_PORT_OUT_RANGE, (Object)portRange);
                        SystemMessage message = this.createSystemMessage("RSEC2316", 4, pmsg);
                        ShowConnectMessage msgAction = new ShowConnectMessage(message);
                        Display.getDefault().asyncExec((Runnable)msgAction);
                        return;
                    }
                    launchFailed = true;
                    SystemBasePlugin.logError((String)("Error launching server: " + launchStatus.getMessage()), null);
                }
            }
            if (launchStatus.isConnected()) {
                if (monitor != null) {
                    if (this.clientConnection == null) {
                        SystemBasePlugin.logError((String)"client connection is null!");
                    }
                    String pmsg = NLS.bind((String)ConnectorServiceResources.MSG_CONNECTING_TO_SERVER, (Object)this.clientConnection.getPort());
                    monitor.subTask(pmsg);
                }
                connectStatus = this.clientConnection.connect(launchStatus.getTicket(), timeout);
                conE = connectStatus.getException();
                if (!connectStatus.isConnected() && (connectStatus.getMessage().startsWith("Cannot connect to server.") || conE instanceof SSLException)) {
                    this._isConnecting = false;
                    if (conE instanceof SSLHandshakeException && (certs = connectStatus.getUntrustedCertificates()) != null && certs.size() > 0 && (provider = SystemKeystoreProviderManager.getInstance().getDefaultProvider()) != null) {
                        if (provider.importCertificates(certs, this.getHostName())) {
                            this.internalConnect(monitor);
                            return;
                        }
                        throw new InterruptedException();
                    }
                    launchStatus = this.launchServer(this.clientConnection, info, daemonPort, monitor);
                    if (!launchStatus.isConnected()) {
                        launchFailed = true;
                    } else if (this.setSSLProperties(!usedSSL)) {
                        connectStatus = this.clientConnection.connect(launchStatus.getTicket(), timeout);
                    }
                }
                if (!connectStatus.isConnected() && connectStatus.isSLLProblem()) {
                    this._isConnecting = false;
                    this.importCertsAndReconnect(connectStatus, monitor);
                    return;
                }
            } else {
                connectStatus = new ConnectionStatus(false);
                cmsg2 = NLS.bind((String)ConnectorServiceResources.MSG_COMM_CONNECT_FAILED, (Object)this.getHostName());
                connectStatus.setMessage(cmsg2);
            }
        } else if (serverLauncherType == ServerLaunchType.RUNNING_LITERAL) {
            if (monitor != null) {
                String cmsg6 = NLS.bind((String)ConnectorServiceResources.MSG_CONNECTING_TO_SERVER, (Object)this.clientConnection.getPort());
                monitor.subTask(cmsg6);
            }
            boolean useSSL = this.isUsingSSL();
            this.setSSLProperties(useSSL);
            connectStatus = this.clientConnection.connect(null, timeout);
        } else {
            SystemSignonInformation info = this.getSignonInformation();
            connectStatus = this.launchServer(this.clientConnection, info, (IServerLauncherProperties)serverLauncher, monitor);
            if (!connectStatus.isConnected() && !this.clientConnection.isKnownStatus(connectStatus.getMessage()) && this.setSSLProperties(true) && !(connectStatus = this.launchServer(this.clientConnection, info, (IServerLauncherProperties)serverLauncher, monitor)).isConnected() && connectStatus.isSLLProblem()) {
                this._isConnecting = false;
                this.importCertsAndReconnect(connectStatus, monitor);
                return;
            }
        }
        if (connectStatus != null && connectStatus.isConnected()) {
            IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
            if (this.clientConnection.getDataStore().usingSSL() && store.getBoolean("org.eclipse.rse.preferences.alert.ssl")) {
                cmsg = NLS.bind((String)ConnectorServiceResources.MSG_COMM_USING_SSL, (Object)this.getHostName());
                msg = this.createSystemMessage("RSEC2314", 1, cmsg);
                DisplayHidableSystemMessageAction msgAction = new DisplayHidableSystemMessageAction(msg, store, "org.eclipse.rse.preferences.alert.ssl");
                Display.getDefault().syncExec((Runnable)msgAction);
                if (msgAction.getReturnCode() != 2) {
                    this.internalDisconnect(monitor);
                    this._isConnecting = false;
                    throw new InterruptedException();
                }
            } else if (!this.clientConnection.getDataStore().usingSSL() && store.getBoolean("org.eclipse.rse.preferences.alert.nonssl") && !alertedNONSSL) {
                cmsg = NLS.bind((String)ConnectorServiceResources.MSG_COMM_NOT_USING_SSL, (Object)this.getHostName());
                msg = this.createSystemMessage("RSEC2315", 1, cmsg);
                DisplayHidableSystemMessageAction msgAction = new DisplayHidableSystemMessageAction(msg, store, "org.eclipse.rse.preferences.alert.nonssl");
                Display.getDefault().syncExec((Runnable)msgAction);
                if (msgAction.getReturnCode() != 2) {
                    this.internalDisconnect(monitor);
                    this._isConnecting = false;
                    throw new InterruptedException();
                }
            }
            DataStore dataStore = this.clientConnection.getDataStore();
            this._connectionStatusListener = new ConnectionStatusListener(dataStore.getStatus(), (IConnectorService)this);
            dataStore.getDomainNotifier().addDomainListener((IDomainListener)this._connectionStatusListener);
            StatusMonitor statusMonitor = StatusMonitorFactory.getInstance().getStatusMonitorFor((IConnectorService)this, dataStore);
            if (launchStatus != null && launchStatus.isConnected()) {
                DataElement ticket = dataStore.createTicket(launchStatus.getTicket());
                dataStore.queryShowTicket(ticket);
            } else {
                dataStore.showTicket(null);
            }
            StartSpiritThread thread = new StartSpiritThread(dataStore);
            thread.start();
            this.fireCommunicationsEvent(2);
            String message = connectStatus.getMessage();
            if (message != null) {
                String cmsgDetail;
                String cmsg7;
                if (message.startsWith("Older DataStore Client.")) {
                    cmsg7 = NLS.bind((String)ConnectorServiceResources.MSG_COMM_CLIENT_OLDER_WARNING, (Object)this.getHostName());
                    cmsgDetail = ConnectorServiceResources.MSG_COMM_CLIENT_OLDER_WARNING_DETAILS;
                    msg = this.createSystemMessage("RSEC2309", 2, cmsg7, cmsgDetail);
                } else if (message.startsWith("Older DataStore Server.")) {
                    cmsg7 = NLS.bind((String)ConnectorServiceResources.MSG_COMM_SERVER_OLDER_WARNING, (Object)this.getHostName());
                    cmsgDetail = ConnectorServiceResources.MSG_COMM_SERVER_OLDER_WARNING_DETAILS;
                    msg = this.createSystemMessage("RSEC2308", 2, cmsg7, cmsgDetail);
                }
                if (store.getBoolean("org.eclipse.rse.connectorservice.dstore.ui.alert.mismatched.server")) {
                    DisplayHidableSystemMessageAction msgAction = new DisplayHidableSystemMessageAction(msg, store, "org.eclipse.rse.connectorservice.dstore.ui.alert.mismatched.server", false);
                    Display.getDefault().syncExec((Runnable)msgAction);
                }
            }
            dataStore.registerLocalClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            int serverVersion = this.getServerVersion();
            if (serverVersion >= 8 || serverVersion == 7 && this.getServerMinor() >= 1) {
                boolean cacheRemoteClasses = store.getBoolean("org.eclipse.rse.connectorservice.dstore.ui.preferences.cacheremoteclasses");
                dataStore.setPreference("Class.Caching", cacheRemoteClasses ? "true" : "false", true);
                if (serverVersion >= 8) {
                    int socketTimeout;
                    boolean doKeepalive = store.getBoolean("org.eclipse.rse.connectorservice.dstore.ui.preferences.dokeepalive");
                    int keepaliveResponseTimeout = store.getInt("org.eclipse.rse.connectorservice.dstore.ui.preferences.keepalivetimeout");
                    if (keepaliveResponseTimeout == 0) {
                        keepaliveResponseTimeout = store.getDefaultInt("org.eclipse.rse.connectorservice.dstore.ui.preferences.keepalivetimeout");
                    }
                    if ((socketTimeout = store.getInt("org.eclipse.rse.connectorservice.dstore.ui.preferences.socketreadtimeout")) == 0) {
                        socketTimeout = store.getDefaultInt("org.eclipse.rse.connectorservice.dstore.ui.preferences.socketreadtimeout");
                    }
                    dataStore.setPreference("DSTORE_KEEPALIVE_ENABLED", doKeepalive ? "true" : "false", false);
                    dataStore.setPreference("DSTORE_KEEPALIVE_RESPONSE_TIMEOUT", "" + keepaliveResponseTimeout, false);
                    dataStore.setPreference("DSTORE_IO_SOCKET_READ_TIMEOUT", "" + socketTimeout, false);
                }
            } else {
                dataStore.addMinersLocation(".");
                dataStore.getSchema();
                if (monitor != null) {
                    String imsg = ConnectorServiceResources.MSG_INITIALIZING_SERVER;
                    monitor.subTask(imsg);
                }
                DataElement initStatus = dataStore.initMiners();
                statusMonitor.waitForUpdate(initStatus);
            }
        } else {
            String msgDetails;
            String msgTxt;
            if (launchFailed && launchStatus != null && launchStatus.isSLLProblem() && launchStatus.isSLLProblem()) {
                launchStatus.getException();
                List certs = launchStatus.getUntrustedCertificates();
                if (certs.size() > 0) {
                    ISystemKeystoreProvider provider = SystemKeystoreProviderManager.getInstance().getDefaultProvider();
                    if (provider != null && provider.importCertificates(certs, this.getHostName())) {
                        this._isConnecting = false;
                        this.internalConnect(monitor);
                        return;
                    }
                } else {
                    cmsg = NLS.bind((String)ConnectorServiceResources.MSG_CONNECT_SSL_EXCEPTION, (Object)launchStatus.getMessage());
                    String cmsgDetails = ConnectorServiceResources.MSG_CONNECT_SSL_EXCEPTION_DETAILS;
                    msg = this.createSystemMessage("RSEC2307", 4, cmsg, cmsgDetails);
                }
            }
            if (launchFailed && launchStatus != null) {
                String launchMsg = launchStatus.getMessage();
                if (launchStatus.getException() != null && serverLauncher != null) {
                    Throwable exception = launchStatus.getException();
                    String fmsg = NLS.bind((String)ConnectorServiceResources.MSG_CONNECT_DAEMON_FAILED_EXCEPTION, (Object)this.getHostName(), (Object)("" + serverLauncher.getDaemonPort()));
                    msg = this.createSystemMessage("RSEG1243", 4, fmsg, exception);
                } else {
                    if (launchMsg != null && launchMsg.indexOf("Authentification Failed") != -1) {
                        this._isConnecting = false;
                        if (launchFailed) {
                            this.clearPassword(true, true);
                        }
                        msgTxt = CommonMessages.MSG_COMM_AUTH_FAILED;
                        String msgDetails2 = NLS.bind((String)CommonMessages.MSG_COMM_AUTH_FAILED_DETAILS, (Object)this.getHostName());
                        msg = this.createSystemMessage("RSEC1002", 4, msgTxt, msgDetails2);
                        DisplaySystemMessageAction msgAction = new DisplaySystemMessageAction(msg);
                        Display.getDefault().syncExec((Runnable)msgAction);
                        this.connectException = null;
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                try {
                                    DStoreConnectorService.this.acquireCredentials(true);
                                }
                                catch (OperationCanceledException e) {
                                    DStoreConnectorService.this.connectException = (Exception)((Object)e);
                                }
                            }
                        });
                        if (this.connectException instanceof OperationCanceledException) {
                            throw this.connectException;
                        }
                        this.internalConnect(monitor);
                        return;
                    }
                    if (launchMsg != null && (this.isPasswordExpired(launchMsg) || this.isNewPasswordInvalid(launchMsg))) {
                        this._isConnecting = false;
                        SystemSignonInformation oldCredentials = (SystemSignonInformation)this.getCredentialsProvider().getCredentials();
                        SystemSignonInformation newCredentials = null;
                        while (launchMsg != null && (this.isPasswordExpired(launchMsg) || this.isNewPasswordInvalid(launchMsg))) {
                            String msgTxt2 = ConnectorServiceResources.MSG_VALIDATE_PASSWORD_INVALID;
                            String msgDetails3 = ConnectorServiceResources.MSG_VALIDATE_PASSWORD_INVALID_DETAILS;
                            String msgId = "RSEG1297";
                            if (this.isPasswordExpired(launchMsg)) {
                                msgTxt2 = ConnectorServiceResources.MSG_VALIDATE_PASSWORD_EXPIRED;
                                msgDetails3 = ConnectorServiceResources.MSG_VALIDATE_PASSWORD_EXPIRED_DETAILS;
                                msgId = "RSEG1036";
                            }
                            SystemMessage message = this.createSystemMessage(msgId, 4, msgTxt2, msgDetails3);
                            this.getCredentialsProvider().repairCredentials(message);
                            newCredentials = (SystemSignonInformation)this.getCredentialsProvider().getCredentials();
                            launchStatus = this.changePassword(this.clientConnection, oldCredentials, (IServerLauncherProperties)serverLauncher, monitor, newCredentials.getPassword());
                            launchMsg = launchStatus.getMessage();
                        }
                        if (launchMsg != null && launchMsg.equals("attempt reconnect")) {
                            this.internalConnect(monitor);
                            return;
                        }
                    } else if (launchMsg != null) {
                        msgTxt = NLS.bind((String)ConnectorServiceResources.MSG_CONNECT_DAEMON_FAILED, (Object)this.getHostName(), (Object)this.clientConnection.getPort());
                        msg = this.createSystemMessage("RSEG1242", 4, msgTxt, launchMsg);
                    }
                }
            } else if (connectStatus != null && !connectStatus.isConnected()) {
                if (connectStatus.getMessage().startsWith("Incompatible DataStore.")) {
                    String msgTxt3 = NLS.bind((String)ConnectorServiceResources.MSG_COMM_INCOMPATIBLE_UPDATE, (Object)this.getHostName());
                    msgDetails = ConnectorServiceResources.MSG_COMM_INCOMPATIBLE_UPDATE_DETAILS;
                    msg = this.createSystemMessage("RSEC2304", 4, msgTxt3, msgDetails);
                } else if (connectStatus.getMessage().startsWith("Incompatible Protocol.")) {
                    String msgTxt4 = NLS.bind((String)ConnectorServiceResources.MSG_COMM_INCOMPATIBLE_PROTOCOL, (Object)this.getHostName());
                    msgDetails = ConnectorServiceResources.MSG_COMM_INCOMPATIBLE_PROTOCOL_DETAILS;
                    msg = this.createSystemMessage("RSEC2303", 4, msgTxt4, msgDetails);
                } else {
                    Throwable exception = connectStatus.getException();
                    if (exception instanceof SSLHandshakeException) {
                        ISystemKeystoreProvider provider;
                        List certs = connectStatus.getUntrustedCertificates();
                        if (certs != null && certs.size() > 0 && (provider = SystemKeystoreProviderManager.getInstance().getDefaultProvider()) != null) {
                            this._isConnecting = false;
                            provider.importCertificates(certs, this.getHostName());
                            this._isConnecting = false;
                            if (serverLauncherType != ServerLaunchType.RUNNING_LITERAL) {
                                this.internalConnect(monitor);
                            }
                            return;
                        }
                    } else if (exception != null) {
                        msgTxt = NLS.bind((String)CommonMessages.MSG_CONNECT_FAILED, (Object)this.getHostName());
                        msg = this.createSystemMessage("RSEG1056", 4, msgTxt, exception);
                    }
                }
            } else if (connectStatus == null) {
                SystemBasePlugin.logError((String)"Failed to connect to remote system", null);
                String msgTxt5 = NLS.bind((String)ConnectorServiceResources.MSG_COMM_CONNECT_FAILED, (Object)this.getHostName());
                msgDetails = NLS.bind((String)ConnectorServiceResources.MSG_COMM_CONNECT_FAILED_DETAILS, (Object)this.getHostName());
                msg = this.createSystemMessage("RSEC1001", 4, msgTxt5, msgDetails);
            }
            if (msg == null && connectStatus != null) {
                SystemBasePlugin.logError((String)("Failed to connect to remote system" + connectStatus.getMessage()), null);
                String msgTxt6 = NLS.bind((String)ConnectorServiceResources.MSG_COMM_CONNECT_FAILED, (Object)this.getHostName());
                msgDetails = NLS.bind((String)ConnectorServiceResources.MSG_COMM_CONNECT_FAILED_DETAILS, (Object)this.getHostName());
                msg = this.createSystemMessage("RSEC1001", 4, msgTxt6, msgDetails);
            }
            this.clientConnection.disconnect();
            this.clientConnection = null;
            if (msg != null && msg.getLevelOneText().startsWith(NLS.bind((String)ConnectorServiceResources.MSG_COMM_INVALID_LOGIN, (Object)this.getHostName()))) {
                if (launchFailed) {
                    this.clearPassword(true, true);
                }
                DisplaySystemMessageAction msgAction = new DisplaySystemMessageAction(msg);
                Display.getDefault().syncExec((Runnable)msgAction);
                this.connectException = null;
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        try {
                            DStoreConnectorService.this.acquireCredentials(true);
                        }
                        catch (OperationCanceledException e) {
                            DStoreConnectorService.this.connectException = (Exception)((Object)e);
                        }
                    }
                });
                this._isConnecting = false;
                if (this.connectException instanceof OperationCanceledException) {
                    throw this.connectException;
                }
                this.internalConnect(monitor);
                return;
            }
            this._isConnecting = false;
            throw new SystemMessageException(msg);
        }
        this._isConnecting = false;
    }

    protected boolean isPortOutOfRange(String message) {
        return message.indexOf("specified port out of range:") != -1;
    }

    protected boolean isPasswordExpired(String message) {
        return message.indexOf("password expired") != -1;
    }

    protected boolean isNewPasswordInvalid(String message) {
        return message.indexOf("new password not valid") != -1;
    }

    protected void importCertsAndReconnect(ConnectionStatus connectStatus, IProgressMonitor monitor) throws Exception {
        ISystemKeystoreProvider provider;
        List certs = connectStatus.getUntrustedCertificates();
        if (certs != null && certs.size() > 0 && (provider = SystemKeystoreProviderManager.getInstance().getDefaultProvider()) != null) {
            if (provider.importCertificates(certs, this.getHostName())) {
                this.internalConnect(monitor);
                return;
            }
            throw new InterruptedException();
        }
    }

    protected int launchUsingRexec(SystemSignonInformation info, IServerLauncherProperties serverLauncherProperties, IProgressMonitor monitor) throws Exception {
        IServerLauncher starter = this.getRemoteServerLauncher();
        starter.setSignonInformation(info);
        starter.setServerLauncherProperties(serverLauncherProperties);
        String serverPort = (String)starter.launch(monitor);
        if (monitor.isCanceled()) {
            SystemMessage msg = this.createSystemMessage("RSEG1067", 8, CommonMessages.MSG_OPERATION_CANCELLED);
            throw new SystemMessageException(msg);
        }
        int iServerPort = 0;
        if (serverPort != null) {
            iServerPort = Integer.parseInt(serverPort);
        }
        return iServerPort;
    }

    protected boolean setSSLProperties(boolean enable) {
        ISystemKeystoreProvider provider = SystemKeystoreProviderManager.getInstance().getDefaultProvider();
        if (provider != null) {
            String keyStore = provider.getKeyStorePath();
            String password = provider.getKeyStorePassword();
            ClientSSLProperties properties = new ClientSSLProperties(enable, keyStore, password);
            this.clientConnection.setSSLProperties((ISSLProperties)properties);
            return true;
        }
        return false;
    }

    protected boolean promptForTrusting(X509Certificate cert) {
        return true;
    }

    protected ConnectionStatus launchServer(ClientConnection clientConnection, SystemSignonInformation info, int daemonPort, IProgressMonitor monitor) {
        return this.launchServer(clientConnection, info, daemonPort, monitor, 0);
    }

    protected ConnectionStatus launchServer(ClientConnection clientConnection, SystemSignonInformation info, int daemonPort, IProgressMonitor monitor, int timeout) {
        return clientConnection.launchServer(info.getUserId(), info.getPassword(), daemonPort, timeout);
    }

    protected ConnectionStatus launchServer(ClientConnection clientConnection, SystemSignonInformation info, IServerLauncherProperties launcher, IProgressMonitor monitor) {
        return null;
    }

    protected ConnectionStatus changePassword(ClientConnection clientConnection, SystemSignonInformation info, IServerLauncherProperties serverLauncherProperties, IProgressMonitor monitor, String newPassword) {
        return new ConnectionStatus(false, "Authentification Failed");
    }

    public boolean isConnected() {
        if (this.clientConnection != null) {
            return this.clientConnection.isConnected();
        }
        return false;
    }

    public boolean isNetworkError() {
        if (this._connectionStatusListener != null) {
            return this._connectionStatusListener.isConnectionDown();
        }
        return false;
    }

    public DataStore getDataStore() {
        if (this.clientConnection != null) {
            return this.clientConnection.getDataStore();
        }
        return null;
    }

    public boolean supportsRemoteServerLaunching() {
        return true;
    }

    public boolean supportsServerLaunchProperties() {
        return true;
    }

    public boolean supportsPassword() {
        boolean result = super.supportsPassword();
        IHost host = this.getHost();
        if (host.getSystemType().isWindows()) {
            result = false;
        }
        return result;
    }

    public boolean supportsUserId() {
        boolean result = super.supportsUserId();
        if (this.getHost().getSystemType().isWindows()) {
            result = false;
        }
        return result;
    }

    protected SystemMessage createSystemMessage(String msgId, int severity, String msg) {
        return this.createSystemMessage(msgId, severity, msg, (String)null);
    }

    protected SystemMessage createSystemMessage(String msgId, int severity, String msg, Throwable e) {
        return new SimpleSystemMessage("org.eclipse.rse.connectorservice.dstore", msgId, severity, msg, e);
    }

    protected SystemMessage createSystemMessage(String msgId, int severity, String msg, String msgDetails) {
        return new SimpleSystemMessage("org.eclipse.rse.connectorservice.dstore", msgId, severity, msg, msgDetails);
    }

    private class ShowConnectMessage
    implements Runnable {
        private SystemMessage _msg;

        public ShowConnectMessage(SystemMessage msg) {
            this._msg = msg;
        }

        public void run() {
            SystemMessageDialog dlg = new SystemMessageDialog(SystemBasePlugin.getActiveWorkbenchShell(), this._msg);
            dlg.open();
        }
    }

    private class StartSpiritThread
    extends Thread {
        private DataStore _dataStore;

        public StartSpiritThread(DataStore dataStore) {
            this._dataStore = dataStore;
        }

        public void run() {
            if (this._dataStore.isDoSpirit()) {
                this._dataStore.queryServerSpiritState();
            }
        }
    }
}

