/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.marte.hrm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PldTechnology implements Enumerator
{
    SRAM(0, "sram", "sram"),
    ANTIFUSE(1, "antifuse", "antifuse"),
    FLASH(2, "flash", "flash"),
    OTHER(3, "other", "other"),
    UNDEF(4, "undef", "undef");

    public static final int SRAM_VALUE = 0;
    public static final int ANTIFUSE_VALUE = 1;
    public static final int FLASH_VALUE = 2;
    public static final int OTHER_VALUE = 3;
    public static final int UNDEF_VALUE = 4;
    private static final PldTechnology[] VALUES_ARRAY;
    public static final List<PldTechnology> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PldTechnology[]{SRAM, ANTIFUSE, FLASH, OTHER, UNDEF};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PldTechnology get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PldTechnology result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PldTechnology getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PldTechnology result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PldTechnology get(int value) {
        switch (value) {
            case 0: {
                return SRAM;
            }
            case 1: {
                return ANTIFUSE;
            }
            case 2: {
                return FLASH;
            }
            case 3: {
                return OTHER;
            }
            case 4: {
                return UNDEF;
            }
        }
        return null;
    }

    private PldTechnology(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

