/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.editor.pages;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.amalgam.explorer.activity.ui.ActivityExplorerActivator;
import org.eclipse.amalgam.explorer.activity.ui.api.actions.DescriptionAction;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.ActivityExplorerEditor;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.input.ActivityExplorerEditorInput;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.CommonActivityExplorerPage;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.FormHelper;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.HTMLHelper;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.predicates.IPredicate;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.sections.ActivityExplorerSection;
import org.eclipse.amalgam.explorer.activity.ui.api.manager.ActivityExplorerManager;
import org.eclipse.amalgam.explorer.activity.ui.internal.actions.util.FormTextPageLinkAdapter;
import org.eclipse.amalgam.explorer.activity.ui.internal.actions.util.MDSashForm;
import org.eclipse.amalgam.explorer.activity.ui.internal.extension.point.manager.ActivityExplorerExtensionManager;
import org.eclipse.amalgam.explorer.activity.ui.internal.util.ActivityExplorerLoggerService;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ActivityExplorerPage
extends CommonActivityExplorerPage
implements IPropertyChangeListener {
    private MDSashForm _sashForm;
    private Composite _sectionContainer;
    private String title;
    private Image headerImageOff;
    private Image headerImageOn;
    private String description;
    private TreeSet<ActivityExplorerSection> sections = new TreeSet();

    public ActivityExplorerPage() {
        this.createContributedSections();
    }

    protected void adjustImageHRef(FormText richText, ActivityExplorerActivator activator) {
        if (this.headerImageOff != null) {
            this.adjustImageHRef(richText, this.headerImageOff, this.getId());
        }
    }

    protected void adjustImageHRef(FormText richText, Image image, String id) {
        if (image != null) {
            richText.setImage(id, image);
        }
    }

    private void createContributedSections() {
        List<IConfigurationElement> sections = ActivityExplorerExtensionManager.getSectionsFromPageId(this.getId());
        if (sections != null) {
            for (IConfigurationElement contributor : sections) {
                try {
                    this.handleContributedSectionsFor(contributor);
                }
                catch (NumberFormatException e) {
                    StringBuilder message = new StringBuilder();
                    message.append("ActivityExplorerPage.createContributedSections() _ ");
                    message.append("The contribution ");
                    message.append(ActivityExplorerExtensionManager.getId(contributor));
                    message.append(" has wrong index format (");
                    message.append(ActivityExplorerExtensionManager.getIndex(contributor));
                    message.append("). Only integers are valid");
                    ActivityExplorerLoggerService.getInstance().log(4, message.toString(), e);
                }
            }
        }
    }

    private void initContributedSections(Composite sectionContainer, IManagedForm managedForm) {
        for (ActivityExplorerSection s : this.getVisibleSections()) {
            this.initializeSection(s, sectionContainer, managedForm);
        }
    }

    protected List<ActivityExplorerSection> getVisibleSections() {
        ArrayList<ActivityExplorerSection> visibleSections = new ArrayList<ActivityExplorerSection>();
        for (ActivityExplorerSection s : this.getSections()) {
            if (!s.isVisible()) continue;
            visibleSections.add(s);
        }
        return visibleSections;
    }

    protected void initializeSection(ActivityExplorerSection section, Composite sectionContainer, IManagedForm managedForm) {
        section.initialize(sectionContainer, (IFormPage)this, managedForm);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        form.setText(this.getHeaderTitle());
        GridLayout layout = new GridLayout();
        Composite body = form.getBody();
        body.setLayout((Layout)layout);
        this._sashForm = new MDSashForm(body, 0);
        this._sashForm.setData("form", managedForm);
        managedForm.getToolkit().adapt((Control)this._sashForm, false, false);
        this._sashForm.setMenu(form.getBody().getMenu());
        this._sashForm.setLayout((Layout)new GridLayout(2, false));
        this._sashForm.setLayoutData(new GridData(1808));
        this._sectionContainer = this.createSectionContainer((Composite)this._sashForm, managedForm);
        this.createHeaderSections(this._sectionContainer, managedForm);
        this.initContributedSections(this._sectionContainer, managedForm);
        this.hookResizeListener();
        ActivityExplorerActivator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        managedForm.reflow(true);
    }

    public void updatePageForm() {
        if (!this._sectionContainer.isDisposed()) {
            Control[] controlArray = this._sectionContainer.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
            this.createHeaderSections(this._sectionContainer, this.getManagedForm());
            this.initContributedSections(this._sectionContainer, this.getManagedForm());
        }
    }

    protected void createOverviewSection(Composite sectionContainer, IManagedForm managedForm) {
        IFormPage previousPage = this.getEditor().getPreviousPage((IFormPage)this);
        IFormPage nextPage = this.getEditor().getNextPage((IFormPage)this);
        String body = HTMLHelper.breadcrumbForm(previousPage, (IFormPage)this, nextPage);
        FormText richText = FormHelper.createRichText(managedForm.getToolkit(), sectionContainer, body, (IHyperlinkListener)new FormTextPageLinkAdapter((FormEditor)this.getEditor()));
        this.adjustImageHRef(richText, this.getHeaderImageOn(), this.getId());
        if (previousPage != null && previousPage instanceof ActivityExplorerPage) {
            this.adjustImageHRef(richText, ((ActivityExplorerPage)previousPage).getHeaderImageOff(), previousPage.getId());
        }
        if (nextPage != null && nextPage instanceof ActivityExplorerPage) {
            this.adjustImageHRef(richText, ((ActivityExplorerPage)nextPage).getHeaderImageOff(), nextPage.getId());
        }
        richText.marginHeight = 0;
        richText.marginWidth = 0;
    }

    protected Composite createSectionContainer(Composite parent, IManagedForm managedForm) {
        Composite container = FormHelper.createCompositeWithLayoutType(managedForm.getToolkit(), parent, FormHelper.LayoutType.TABLEWRAP_LAYOUT, 1, true);
        container.setLayoutData((Object)new GridData(4, 4, false, true));
        return container;
    }

    protected void createHeaderSections(Composite sectionContainer, IManagedForm managedForm) {
        DescriptionAction displayDescription = new DescriptionAction(sectionContainer.getShell(), this.getPageDescription());
        Form formWidget = managedForm.getForm().getForm();
        formWidget.getMenuManager().add((IAction)displayDescription);
        formWidget.getToolBarManager().add((IAction)displayDescription);
        formWidget.getToolBarManager().update(true);
        this.createOverviewSection(sectionContainer, managedForm);
    }

    public void dispose() {
        ActivityExplorerActivator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    protected boolean doPropertyChange(PropertyChangeEvent event, boolean value, String property) {
        boolean result = false;
        if (this.isSection(property)) {
            this.updatePageForm();
            result = true;
        }
        return result;
    }

    private boolean isSection(String id) {
        return ActivityExplorerExtensionManager.isSection(this.getId(), id);
    }

    protected ActivityExplorerSection getSectionById(String id) {
        ActivityExplorerSection result = null;
        for (ActivityExplorerSection section : this.getSections()) {
            if (!section.getId().equals(id)) continue;
            result = section;
        }
        return result;
    }

    @Override
    public ActivityExplorerEditor getEditor() {
        return (ActivityExplorerEditor)super.getEditor();
    }

    public ActivityExplorerEditorInput getEditorInput() {
        return (ActivityExplorerEditorInput)super.getEditorInput();
    }

    protected String getHeaderTitle() {
        return this.title;
    }

    protected void setHeaderTitle(String title) {
    }

    public String getPageDescription() {
        return this.description;
    }

    protected Composite getSectionContainer() {
        return this._sectionContainer;
    }

    public Set<ActivityExplorerSection> getSections() {
        return this.sections;
    }

    protected void handleContributedSectionsFor(IConfigurationElement contributor) {
        ActivityExplorerSection section = new ActivityExplorerSection(contributor){

            @Override
            protected IAction[] getToolBarActions() {
                IAction[] toolbarActions = new IAction[]{new DescriptionAction(ActivityExplorerPage.this.getSite().getShell(), ActivityExplorerPage.this.description)};
                return toolbarActions;
            }
        };
        this.sections.add(section);
    }

    protected void hookResizeListener() {
        Control[] children;
        Listener listener = this._sashForm.getListener();
        Control[] controlArray = children = this._sashForm.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            if (!(element instanceof Sash)) {
                element.addListener(11, listener);
            }
            ++n2;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        boolean value = (Boolean)event.getNewValue();
        if (this.doPropertyChange(event, value, property) && ActivityExplorerManager.INSTANCE.getEditor() != null && ActivityExplorerManager.INSTANCE.getEditor().getActivePageInstance() != null) {
            ActivityExplorerManager.INSTANCE.getEditor().getActivePageInstance().getManagedForm().reflow(true);
        }
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.updateActionBars();
        }
    }

    public void updateActionBars() {
        IActionBars editorActionBars = this.getEditorSite().getActionBars();
        editorActionBars.updateActionBars();
    }

    @Override
    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        String description;
        super.setInitializationData(cfig, propertyName, data);
        String title = ActivityExplorerExtensionManager.getTitle(cfig);
        this.setHeaderTitle(title);
        Image image = ActivityExplorerExtensionManager.getImageOff(cfig);
        if (image != null) {
            this.setHeaderImageOff(image);
        }
        if ((image = ActivityExplorerExtensionManager.getImageOn(cfig)) != null) {
            this.setHeaderImageOn(image);
        }
        if ((description = ActivityExplorerExtensionManager.getDescription(cfig)) != null) {
            this.setPageDescription(HTMLHelper.formWrapper(description));
        }
    }

    private void setPageDescription(String description) {
    }

    protected void setHeaderImageOff(Image image) {
        this.headerImageOff = image;
    }

    protected void setHeaderImageOn(Image image) {
        this.headerImageOn = image;
    }

    public Image getHeaderImageOff() {
        return this.headerImageOff;
    }

    public Image getHeaderImageOn() {
        return this.headerImageOn;
    }

    public IPredicate getPredicate() {
        return this.predicate;
    }
}

