/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.trace.graphviz.popup.actions;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.polarsys.time4sys.trace.Slice;
import org.polarsys.time4sys.trace.Trace;

public class ExportHierarchyAsGraphviz
implements IObjectActionDelegate {
    protected Shell shell;
    protected Slice slice = null;
    protected Trace trace = null;
    private File output;
    private FileOutputStream os;
    private OutputStreamWriter w;

    public static void export(Slice slice, File output) throws IOException, ParserConfigurationException, TransformerException {
        new ExportHierarchyAsGraphviz().run(slice, output);
    }

    public static void export(Trace trace, File output) throws IOException, ParserConfigurationException, TransformerException {
        new ExportHierarchyAsGraphviz().run(trace, output);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        if (this.slice == null && this.trace == null) {
            System.out.println("Selection was empty");
            return;
        }
        this.output = new File("slices.dot");
        try {
            this.os = new FileOutputStream(this.output);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        this.w = new OutputStreamWriter(this.os);
        try {
            this.export();
            this.w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        String label = "";
        if (this.slice != null) {
            label = String.valueOf(label) + "Slice " + this.slice.getName();
        }
        if (this.trace != null) {
            label = String.valueOf(label) + "Trace ";
        }
        if (MessageDialog.openQuestion((Shell)this.shell, (String)"Trace Graphviz exporter", (String)(String.valueOf(label) + " exported in " + this.output.getAbsolutePath() + ".\n" + "Would you view it?")) && this.output.exists() && this.output.isFile()) {
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(this.output.toURI());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            }
            catch (PartInitException partInitException) {}
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.slice = null;
        this.trace = null;
        if (selection.isEmpty()) {
            return;
        }
        Object obj = null;
        if (selection instanceof IStructuredSelection) {
            obj = ((IStructuredSelection)selection).getFirstElement();
        }
        if (obj instanceof Slice) {
            this.slice = (Slice)obj;
        }
        if (obj instanceof Trace) {
            this.trace = (Trace)obj;
        }
    }

    public void run(Slice slc, File output) throws IOException {
        assert (output != null);
        this.slice = slc;
        this.output = output;
        this.run(new FileOutputStream(output));
    }

    public void run(Trace trc, File output) throws IOException {
        assert (output != null);
        this.trace = trc;
        this.output = output;
        this.run(new FileOutputStream(output));
    }

    public void run(FileOutputStream fileOutputStream) throws IOException {
        assert (fileOutputStream != null);
        this.os = fileOutputStream;
        this.run(new OutputStreamWriter(this.os));
        this.w.close();
    }

    public void run(OutputStreamWriter outputStreamWriter) throws IOException {
        assert (outputStreamWriter != null);
        assert (this.slice != null || this.trace != null);
        this.w = outputStreamWriter;
        this.export();
        this.w.flush();
    }

    protected void export() throws IOException {
        VisitingQueue<Slice> toBeDone = new VisitingQueue<Slice>();
        if (this.slice != null) {
            toBeDone.add(this.slice);
        }
        if (this.trace != null) {
            toBeDone.addAll((Collection<Slice>)this.trace.getSlices());
        }
        this.w.write("digraph SlicesHierarchy {\n");
        while (toBeDone.notEmpty()) {
            Slice cur = (Slice)toBeDone.poll();
            this.w.write("  ");
            this.writeId(cur);
            this.w.write("[label=\"");
            this.w.write(cur.getName());
            this.w.write(":");
            this.w.write(cur.getKindLabel());
            this.w.write("\"];\n");
            for (Slice child : cur.getOwnedSubSlices()) {
                this.w.write("  ");
                this.writeId(child);
                this.w.write("->");
                this.writeId(cur);
                this.w.write(";\n");
                toBeDone.add(child);
            }
            for (Slice child : cur.getSubSlices()) {
                this.w.write("  ");
                this.writeId(child);
                this.w.write("->");
                this.writeId(cur);
                this.w.write("[style=dotted];\n");
                toBeDone.add(child);
            }
            toBeDone.finish(cur);
        }
        this.w.write("}\n");
    }

    private void writeId(Slice cur) throws IOException {
        this.w.write("S");
        this.w.write(Integer.toString(System.identityHashCode(cur)));
    }

    protected static class VisitingQueue<T> {
        final Set<T> done = new HashSet<T>();
        final Queue<T> toBeDone = new LinkedBlockingQueue<T>();

        protected VisitingQueue() {
        }

        public boolean addAll(Collection<? extends T> c) {
            boolean result = true;
            for (T cur : c) {
                boolean bl = result = result && this.add(cur);
            }
            return result;
        }

        public boolean isEmpty() {
            return this.toBeDone.isEmpty();
        }

        public boolean add(T value) {
            if (this.done.contains(value)) {
                return false;
            }
            return this.toBeDone.add(value);
        }

        public T poll() {
            return this.toBeDone.poll();
        }

        public boolean notEmpty() {
            return !this.isEmpty();
        }

        public boolean finish(T cur) {
            return this.done.add(cur);
        }
    }
}

