/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.editor.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.polarsys.time4sys.model.time4sys.Time4sysPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Time4SysCommonDropAdapterAssistant
extends CommonDropAdapterAssistant {
    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        Collection<EObject> extractDragSource;
        IStatus status = Status.CANCEL_STATUS;
        if (2 == operation && target instanceof EObject && Time4sysPackage.eINSTANCE == ((EObject)target).eClass().getEPackage() && !(extractDragSource = this.extractDragSource(LocalSelectionTransfer.getTransfer().getSelection())).isEmpty()) {
            status = Status.OK_STATUS;
        }
        return status;
    }

    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        Collection<EObject> droppedEObjects;
        EObject target;
        TransactionalEditingDomain domain;
        IStatus status = Status.CANCEL_STATUS;
        if (aTarget instanceof EObject && (domain = TransactionUtil.getEditingDomain((EObject)(target = (EObject)aTarget))) != null && Time4sysPackage.eINSTANCE == target.eClass().getEPackage() && !(droppedEObjects = this.extractDragSource(aDropTargetEvent.data)).isEmpty()) {
            Command dragAndDropCmd = DragAndDropCommand.create((EditingDomain)domain, (Object)target, (float)this.getLocation(aDropTargetEvent), (int)aDropTargetEvent.operations, (int)2, droppedEObjects);
            domain.getCommandStack().execute(dragAndDropCmd);
        }
        return status;
    }

    protected float getLocation(DropTargetEvent event) {
        float result = 0.0f;
        if (event.item instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)event.item;
            Tree control = treeItem.getParent();
            Point point = control.toControl(new Point(event.x, event.y));
            Rectangle bounds = treeItem.getBounds();
            result = (float)(point.y - bounds.y) / (float)bounds.height;
        } else if (event.item instanceof TableItem) {
            TableItem tableItem = (TableItem)event.item;
            Table control = tableItem.getParent();
            Point point = control.toControl(new Point(event.x, event.y));
            Rectangle bounds = tableItem.getBounds(0);
            result = (float)(point.y - bounds.y) / (float)bounds.height;
        }
        return result;
    }

    protected Collection<EObject> extractDragSource(Object object) {
        ArrayList<EObject> droppedEObjects = new ArrayList<EObject>();
        if (object instanceof IStructuredSelection) {
            List list = ((IStructuredSelection)object).toList();
            for (Object obj : list) {
                EObject eObject;
                if (!(obj instanceof EObject) || Time4sysPackage.eINSTANCE != (eObject = (EObject)obj).eClass().getEPackage()) continue;
                droppedEObjects.add(eObject);
            }
        }
        return droppedEObjects;
    }
}

