/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.simulation.commands;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.polarsys.time4sys.simulation.commands.AutoRecordingCommand;
import org.polarsys.time4sys.simulation.commands.RecWrapper;

public class CommandRunner {
    protected Object obj;
    private TransactionalEditingDomain theDomain;
    private IWorkbenchPage page;

    public static CommandStack getCommandStack(IWorkbenchPage page, TransactionalEditingDomain theDomain) {
        CommandStack commandStack = null;
        if (theDomain == null && page != null) {
            IEditorPart activeEditor = page.getActiveEditor();
            if (activeEditor instanceof IEditingDomainProvider) {
                EditingDomain editingDomain = ((IEditingDomainProvider)activeEditor).getEditingDomain();
                commandStack = editingDomain.getCommandStack();
            }
        } else {
            commandStack = theDomain.getCommandStack();
        }
        return commandStack;
    }

    public CommandRunner(IWorkbenchWindow window, Object value) {
        this(window.getActivePage(), value);
    }

    public CommandRunner(IWorkbenchPage page, Object value) {
        this.obj = value;
        this.page = page;
        this.theDomain = TransactionUtil.getEditingDomain((Object)this.obj);
    }

    public void execute(AutoRecordingCommand aCmd) {
        if (aCmd == null) {
            return;
        }
        CommandStack commandStack = CommandRunner.getCommandStack(this.page, this.theDomain);
        if (commandStack == null) {
            aCmd.doExecute();
        } else {
            Object theCmd = this.theDomain == null ? new RecWrapper(aCmd) : aCmd;
            commandStack.execute((Command)theCmd);
        }
    }

    public TransactionalEditingDomain getDomain() {
        return this.theDomain;
    }
}

