/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swtbot.generator.framework.GenerationSimpleRule;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public class SelectTableItemRule
extends GenerationSimpleRule {
    private int index;
    boolean useIndices = false;
    private TableItem[] selectedItems;
    private int[] selectedIndices;
    private Table table;

    @Override
    public boolean appliesTo(Event event) {
        return event.widget instanceof Table && event.type == 13 && event.detail != 32;
    }

    @Override
    public void initializeForEvent(Event event) {
        this.table = (Table)event.widget;
        this.index = WidgetUtils.getIndex((Control)this.table);
        this.selectedIndices = this.table.getSelectionIndices();
        TableItem[] tableItemArray = this.selectedItems = this.table.getSelection();
        int n = this.selectedItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem selectedItem = tableItemArray[n2];
            int nbOccurrences = 0;
            TableItem[] tableItemArray2 = this.table.getItems();
            int n3 = tableItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TableItem item = tableItemArray2[n4];
                if (item.getText().equals(selectedItem.getText())) {
                    ++nbOccurrences;
                }
                ++n4;
            }
            if (nbOccurrences > 1) {
                this.useIndices = true;
            }
            ++n2;
        }
    }

    @Override
    public List<String> getActions() {
        ArrayList<String> actions = new ArrayList<String>();
        StringBuilder code = new StringBuilder();
        code.append("bot.table(");
        if (this.index != 0) {
            code.append(this.index);
        }
        code.append(")");
        code.append(".select(");
        if (this.useIndices) {
            int i = 0;
            while (i < this.selectedIndices.length) {
                code.append(this.selectedIndices[i]);
                if (i < this.selectedIndices.length - 1) {
                    code.append(", ");
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.selectedItems.length) {
                code.append('\"');
                code.append(this.selectedItems[i].getText());
                code.append('\"');
                if (i < this.selectedIndices.length - 1) {
                    code.append(", ");
                }
                ++i;
            }
        }
        code.append(')');
        actions.add(code.toString());
        return actions;
    }

    @Override
    public List<String> getImports() {
        return null;
    }

    public Table getWidget() {
        return this.table;
    }
}

