/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.framework.rules.simple;

import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swtbot.generator.framework.GenerationSimpleRule;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public abstract class AbstractTableGenerationRule
extends GenerationSimpleRule {
    private int index;
    private Table table;
    private TableItem currentItem;
    boolean useIndex = false;

    @Override
    public boolean appliesTo(Event event) {
        return event.widget instanceof Table && event.item instanceof TableItem;
    }

    @Override
    public void initializeForEvent(Event event) {
        this.table = (Table)event.widget;
        this.index = WidgetUtils.getIndex((Control)this.table);
        this.currentItem = (TableItem)event.item;
        int nbOccurrences = 0;
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getText().equals(((TableItem)event.item).getText()) && ++nbOccurrences > 1) {
                this.useIndex = true;
                break;
            }
            ++n2;
        }
    }

    public String getWidgetAccessor() {
        StringBuilder res = new StringBuilder();
        res.append("bot.table(");
        if (this.index != 0) {
            res.append(this.index);
        }
        res.append(")");
        res.append(".getTableItem(");
        if (this.useIndex) {
            res.append(this.table.indexOf(this.currentItem));
        } else {
            res.append("\"" + this.currentItem.getText() + "\"");
        }
        res.append(")");
        return res.toString();
    }

    public Table getWidget() {
        return this.table;
    }
}

