/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.rpmlint.builder;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.linuxtools.internal.rpm.rpmlint.RpmlintLog;
import org.eclipse.linuxtools.internal.rpm.rpmlint.builder.RpmlintBuilder;
import org.eclipse.linuxtools.internal.rpm.rpmlint.parser.RpmlintItem;
import org.eclipse.linuxtools.internal.rpm.rpmlint.parser.RpmlintParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpmlintMarkerVisitor
implements IResourceVisitor {
    private List<RpmlintItem> rpmlintItems;
    private RpmlintBuilder builder;
    private boolean firstWarningInResource;

    public RpmlintMarkerVisitor(RpmlintBuilder builder, List<RpmlintItem> rpmlintItems) {
        this.rpmlintItems = rpmlintItems;
        this.builder = builder;
    }

    public boolean visit(IResource resource) throws CoreException {
        block8: {
            block7: {
                if (!"spec".equals(resource.getFileExtension())) break block7;
                this.firstWarningInResource = true;
                for (RpmlintItem item : this.rpmlintItems) {
                    int lineNumber;
                    if (!item.getFileName().equals(resource.getLocation().toOSString())) continue;
                    IFile currentFile = (IFile)resource;
                    if (this.firstWarningInResource) {
                        RpmlintParser.getInstance().deleteMarkers(resource);
                        currentFile.deleteMarkers("org.eclipse.linuxtools.rpm.ui.editor.specfileerror", false, 0);
                        this.firstWarningInResource = false;
                    }
                    String specContent = this.fileToString(currentFile);
                    if (item.getId().equals("configure-without-libdir-spec")) {
                        item.setLineNbr(-1);
                        lineNumber = RpmlintParser.getInstance().getRealLineNbr(specContent, "./configure");
                        if (lineNumber == -1) {
                            lineNumber = RpmlintParser.getInstance().getRealLineNbr(specContent, "%configure");
                        }
                        item.setLineNbr(lineNumber);
                    }
                    if ((lineNumber = item.getLineNbr()) == -1 && (lineNumber = RpmlintParser.getInstance().getRealLineNbr(specContent, item.getRefferedContent())) == -1) {
                        lineNumber = 1;
                    }
                    --lineNumber;
                    this.builder.getSpecfileParser().setErrorHandler(this.builder.getSpecfileErrorHandler(currentFile, specContent));
                    this.builder.getSpecfileParser().setTaskHandler(this.builder.getSpecfileTaskHandler(currentFile, specContent));
                    this.builder.getSpecfileParser().parse(specContent);
                    Document document = new Document(specContent);
                    int charStart = RpmlintMarkerVisitor.getLineOffset((IDocument)document, lineNumber);
                    int charEnd = charStart + RpmlintMarkerVisitor.getLineLength((IDocument)document, lineNumber);
                    RpmlintParser.getInstance().addMarker(currentFile, String.valueOf(item.getId()) + ": " + item.getMessage(), lineNumber, charStart, charEnd, item.getSeverity(), item.getId(), item.getRefferedContent());
                }
                break block8;
            }
            if (!"rpm".equals(resource.getFileExtension())) break block8;
            this.firstWarningInResource = true;
            for (RpmlintItem item : this.rpmlintItems) {
                IFile currentFile = (IFile)resource;
                if (this.firstWarningInResource) {
                    RpmlintParser.getInstance().deleteMarkers(resource);
                    currentFile.deleteMarkers("org.eclipse.linuxtools.rpm.ui.editor.specfileerror", false, 0);
                    this.firstWarningInResource = false;
                }
                RpmlintParser.getInstance().addMarker(currentFile, String.valueOf(item.getId()) + ": " + item.getMessage(), item.getSeverity(), item.getId(), item.getRefferedContent());
            }
        }
        return true;
    }

    private static int getLineOffset(IDocument document, int lineNumber) {
        try {
            return document.getLineOffset(lineNumber);
        }
        catch (BadLocationException e) {
            RpmlintLog.logError(e);
            return 1;
        }
    }

    private static int getLineLength(IDocument document, int lineNumber) {
        try {
            return document.getLineLength(lineNumber);
        }
        catch (BadLocationException e) {
            RpmlintLog.logError(e);
            return 1;
        }
    }

    private String fileToString(IFile file) {
        String ret = "";
        try {
            InputStream in = file.getContents();
            int nbrOfByte = in.available();
            byte[] bytes = new byte[nbrOfByte];
            in.read(bytes);
            ret = new String(bytes);
            in.close();
        }
        catch (CoreException e) {
            RpmlintLog.logError(e);
        }
        catch (IOException e) {
            RpmlintLog.logError(e);
        }
        return ret;
    }
}

