/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.model.js;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.s.model.js.enums.ES6ClassEnumScoutEnum;
import org.eclipse.scout.sdk.core.s.model.js.enums.ES6ClassTypeAliasScoutEnum;
import org.eclipse.scout.sdk.core.s.model.js.enums.IScoutJsEnum;
import org.eclipse.scout.sdk.core.s.model.js.enums.ScoutJsEnumQuery;
import org.eclipse.scout.sdk.core.s.model.js.enums.VariableScoutEnum;
import org.eclipse.scout.sdk.core.s.model.js.objects.IScoutJsObject;
import org.eclipse.scout.sdk.core.s.model.js.objects.JavaScriptScoutObject;
import org.eclipse.scout.sdk.core.s.model.js.objects.ScoutJsObjectQuery;
import org.eclipse.scout.sdk.core.s.model.js.objects.TypeScriptScoutObject;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElement;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeModule;
import org.eclipse.scout.sdk.core.typescript.model.api.IVariable;
import org.eclipse.scout.sdk.core.typescript.model.api.Modifier;
import org.eclipse.scout.sdk.core.typescript.model.spi.NodeModuleSpi;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.Strings;

public class ScoutJsModel {
    private static final Pattern NAMESPACE_PATTERN_WITHOUT_CLASS_REFERENCE = Pattern.compile("window\\.([\\w._]+)\\s*=\\s*Object\\.assign\\(window\\.");
    private static final Pattern NAMESPACE_PATTERN_WITH_CLASS_REFERENCE = Pattern.compile("ObjectFactory\\.get\\(\\)\\.registerNamespace\\('([\\w._]+)',");
    private final INodeModule m_nodeModule;
    private final IES6Class m_widgetClass;
    private final FinalValue<Optional<String>> m_namespace;
    private final FinalValue<List<IScoutJsObject>> m_objects;
    private final FinalValue<List<IScoutJsEnum>> m_enums;
    private final FinalValue<Boolean> m_useClassReference;

    protected ScoutJsModel(INodeModule module, IES6Class widgetClass) {
        this.m_nodeModule = module;
        this.m_widgetClass = widgetClass;
        this.m_namespace = new FinalValue();
        this.m_objects = new FinalValue();
        this.m_enums = new FinalValue();
        this.m_useClassReference = new FinalValue();
    }

    public ScoutJsObjectQuery findScoutObjects() {
        return new ScoutJsObjectQuery(this);
    }

    public List<IScoutJsObject> scoutObjects() {
        return (List)this.m_objects.computeIfAbsentAndGet(this::parseScoutObjects);
    }

    protected List<IScoutJsObject> parseScoutObjects() {
        IES6Class widgetClass = this.widgetClass();
        return Stream.concat(this.nodeModule().classes().filter(INodeElement::isTypeScript).filter(c -> !c.isTypeAlias() && !c.isEnum()).map(element -> TypeScriptScoutObject.create(this, element).orElseThrow()), this.nodeModule().classes().filter(Predicate.not(INodeElement::isTypeScript)).filter(c -> !c.name().endsWith("Adapter") && !c.name().endsWith("Model")).flatMap(element -> JavaScriptScoutObject.create(this, element, (IDataType)widgetClass).stream())).toList();
    }

    public ScoutJsEnumQuery findScoutEnums() {
        return new ScoutJsEnumQuery(this);
    }

    public List<IScoutJsEnum> scoutEnums() {
        return (List)this.m_enums.computeIfAbsentAndGet(this::parseScoutEnums);
    }

    protected List<IScoutJsEnum> parseScoutEnums() {
        return Stream.concat(this.nodeModule().classes().filter(INodeElement::isTypeScript).flatMap(element -> Stream.concat(ES6ClassEnumScoutEnum.create(this, element).stream(), ES6ClassTypeAliasScoutEnum.create(this, element).stream())), Stream.concat(this.nodeModule().classes().filter(Predicate.not(INodeElement::isTypeScript)).flatMap(element -> element.fields().withModifier(Modifier.STATIC).stream().filter(field -> field.dataType().flatMap(IDataType::objectLiteral).isPresent()).flatMap(field -> VariableScoutEnum.create(this, (IVariable)field).stream())), this.nodeModule().elements().stream().filter(Predicate.not(INodeElement::isTypeScript)).filter(IVariable.class::isInstance).map(IVariable.class::cast).flatMap(variable -> VariableScoutEnum.create(this, variable).stream()))).toList();
    }

    public Stream<INodeModule> scoutJsDependenciesRecursively() {
        LinkedHashSet collector = new LinkedHashSet();
        HashSet visited = new HashSet();
        this.nodeModule().packageJson().spi().dependencies().forEach(d -> ScoutJsModel.collectScoutCoreModules(d, collector, visited));
        return collector.stream().map(NodeModuleSpi::api);
    }

    protected static boolean collectScoutCoreModules(NodeModuleSpi module, Set<NodeModuleSpi> collector, Set<NodeModuleSpi> visited) {
        if (visited.contains(module)) {
            return collector.contains(module);
        }
        visited.add(module);
        if ("@eclipse-scout/core".equals(module.packageJson().api().name())) {
            collector.add(module);
            return true;
        }
        boolean added = false;
        for (NodeModuleSpi child : module.packageJson().dependencies()) {
            boolean containsScoutCore = ScoutJsModel.collectScoutCoreModules(child, collector, visited);
            if (!containsScoutCore || added) continue;
            collector.add(module);
            added = true;
        }
        return added;
    }

    public IES6Class widgetClass() {
        return this.m_widgetClass;
    }

    public boolean supportsClassReference() {
        return (Boolean)this.m_useClassReference.computeIfAbsentAndGet(() -> this.widgetClass().containingModule().packageJson().mainContent().map(NAMESPACE_PATTERN_WITH_CLASS_REFERENCE::matcher).filter(Matcher::find).isPresent());
    }

    public Optional<String> namespace() {
        return (Optional)this.m_namespace.computeIfAbsentAndGet(() -> this.nodeModule().packageJson().mainContent().flatMap(ScoutJsModel::parseNamespace));
    }

    protected static Optional<String> parseNamespace(CharSequence content) {
        return ScoutJsModel.firstGroup(NAMESPACE_PATTERN_WITH_CLASS_REFERENCE.matcher(content).results()).or(() -> ScoutJsModel.firstGroup(NAMESPACE_PATTERN_WITHOUT_CLASS_REFERENCE.matcher(content).results()));
    }

    private static Optional<String> firstGroup(Stream<MatchResult> matches) {
        return matches.map(match -> match.group(1)).filter(Strings::hasText).findAny();
    }

    public INodeModule nodeModule() {
        return this.m_nodeModule;
    }

    public String toString() {
        return this.nodeModule().toString();
    }
}

