/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.model.spi;

import java.lang.ref.WeakReference;
import java.util.function.Function;
import org.eclipse.scout.sdk.core.java.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.java.model.spi.JavaEnvironmentSpi;

public abstract class AbstractSpiElement<API> {
    private final JavaEnvironmentSpi m_env;
    private WeakReference<API> m_apiRef;

    protected AbstractSpiElement(JavaEnvironmentSpi env) {
        this.m_env = env;
    }

    public JavaEnvironmentSpi getJavaEnvironment() {
        return this.m_env;
    }

    public final API wrap() {
        API api = this.getExistingApi();
        if (api == null) {
            api = this.internalCreateApi();
            this.internalSetApi(api);
        }
        return api;
    }

    public final API internalSetApi(API api) {
        API previous = this.getExistingApi();
        this.m_apiRef = api == null ? null : new WeakReference<API>(api);
        return previous;
    }

    protected <T, R> R withNewElement(Function<T, R> function) {
        JavaElementSpi newSpi = this.internalFindNewElement();
        if (newSpi == null) {
            return null;
        }
        return function.apply(newSpi);
    }

    public final API getExistingApi() {
        WeakReference<API> existing = this.m_apiRef;
        if (existing == null) {
            return null;
        }
        return (API)existing.get();
    }

    protected abstract API internalCreateApi();

    public abstract JavaElementSpi internalFindNewElement();
}

