/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import java.util.List;
import org.eclipse.scout.sdk.core.java.ecj.AbstractJavaElementWithEcj;
import org.eclipse.scout.sdk.core.java.model.api.IPackage;
import org.eclipse.scout.sdk.core.java.model.api.internal.PackageImplementor;
import org.eclipse.scout.sdk.core.java.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.spi.AnnotationSpi;
import org.eclipse.scout.sdk.core.java.model.spi.PackageSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SourceRange;
import org.eclipse.scout.sdk.core.util.Strings;

public class PackageWithEcj
extends AbstractJavaElementWithEcj<IPackage>
implements PackageSpi {
    private final String m_name;
    private final FinalValue<TypeSpi> m_packageInfo;

    protected PackageWithEcj(AbstractJavaEnvironment env, String name) {
        super(env);
        this.m_name = name;
        this.m_packageInfo = new FinalValue();
    }

    public PackageSpi internalFindNewElement() {
        return this.getJavaEnvironment().getPackage(this.getElementName());
    }

    protected IPackage internalCreateApi() {
        return new PackageImplementor((PackageSpi)this);
    }

    public String getElementName() {
        return this.m_name;
    }

    public SourceRange getSource() {
        return null;
    }

    public TypeSpi getPackageInfo() {
        return (TypeSpi)this.m_packageInfo.computeIfAbsentAndGet(() -> this.getJavaEnvironment().findType(this.getElementName() + ".package-info"));
    }

    public PackageSpi getParentPackage() {
        if (Strings.isBlank((CharSequence)this.m_name)) {
            return null;
        }
        int lastDot = this.m_name.lastIndexOf(46);
        if (lastDot < 0) {
            return this.javaEnvWithEcj().createDefaultPackage();
        }
        return this.javaEnvWithEcj().createPackage(this.m_name.substring(0, lastDot));
    }

    public List<? extends AnnotationSpi> getAnnotations() {
        throw new UnsupportedOperationException();
    }
}

