/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.dom.rewrite.imports;

import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ImportDeclaration;

public final class ImportName {
    public final boolean isStatic;
    public final String containerName;
    public final String simpleName;
    public final String qualifiedName;

    static ImportName createFor(ImportDeclaration importDeclaration) {
        String declName = importDeclaration.getName().getFullyQualifiedName();
        if (importDeclaration.isOnDemand()) {
            return ImportName.createOnDemand(importDeclaration.isStatic(), declName);
        }
        return ImportName.createFor(importDeclaration.isStatic(), declName);
    }

    static ImportName createOnDemand(boolean isStatic, String containerName) {
        return new ImportName(isStatic, containerName, "*");
    }

    public static ImportName createFor(boolean isStatic, String qualifiedName) {
        String containerName = Signature.getQualifier(qualifiedName);
        String simpleName = Signature.getSimpleName(qualifiedName);
        return new ImportName(isStatic, containerName, simpleName);
    }

    private ImportName(boolean isStatic, String containerName, String simpleName) {
        this.isStatic = isStatic;
        this.containerName = containerName;
        this.simpleName = simpleName;
        this.qualifiedName = containerName.isEmpty() ? simpleName : containerName + "." + simpleName;
    }

    public String toString() {
        String template = this.isStatic ? "staticImport(%s)" : "typeImport(%s)";
        return String.format(template, this.qualifiedName);
    }

    public int hashCode() {
        int result = this.qualifiedName.hashCode();
        result = 31 * result + (this.isStatic ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ImportName)) {
            return false;
        }
        ImportName other = (ImportName)obj;
        return this.qualifiedName.equals(other.qualifiedName) && this.isStatic == other.isStatic;
    }

    public boolean isOnDemand() {
        return this.simpleName.equals("*");
    }

    ImportName getContainerOnDemand() {
        if (this.isOnDemand()) {
            return this;
        }
        return ImportName.createOnDemand(this.isStatic, this.containerName);
    }
}

