/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.activity.ui;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mylyn.internal.commons.activity.ui.ActivityUiPlugin;
import org.eclipse.mylyn.internal.commons.activity.ui.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ActivityUiPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int MS_MINUTES = 60000;
    private Spinner timeoutMinutes;
    private Button timeoutEnabledButton;
    private Button activityTrackingEnabledButton;
    private Label timeoutLabel1;
    private Label timeoutLabel2;

    public ActivityUiPreferencePage() {
        this.setPreferenceStore(ActivityUiPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        this.createTaskActivityGroup(container);
        this.updateControls();
        this.applyDialogFont(container);
        return container;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("org.eclipse.mylyn..activity.ui.timeout.enabled", this.timeoutEnabledButton.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.activity.ui.timeout", this.timeoutMinutes.getSelection() * 60 * 1000);
        this.getPreferenceStore().setValue("org.eclipse.mylyn.activity.ui.tracking.enabled", this.activityTrackingEnabledButton.getSelection());
        return true;
    }

    public boolean performCancel() {
        int minutes = this.getPreferenceStore().getInt("org.eclipse.mylyn.activity.ui.timeout") / 60000;
        this.timeoutMinutes.setSelection(minutes);
        this.timeoutEnabledButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn..activity.ui.timeout.enabled"));
        this.activityTrackingEnabledButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.activity.ui.tracking.enabled"));
        return true;
    }

    public void performDefaults() {
        super.performDefaults();
        int activityTimeoutMinutes = this.getPreferenceStore().getDefaultInt("org.eclipse.mylyn.activity.ui.timeout") / 60000;
        this.timeoutMinutes.setSelection(activityTimeoutMinutes);
        this.timeoutEnabledButton.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn..activity.ui.timeout.enabled"));
        this.activityTrackingEnabledButton.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.activity.ui.tracking.enabled"));
    }

    private Group createTaskActivityGroup(Composite container) {
        Group group = new Group(container, 16);
        group.setText(Messages.TasksUiPreferencePage_Task_Timing);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        boolean activityTrackingEnabled = this.getPreferenceStore().getBoolean("org.eclipse.mylyn.activity.ui.tracking.enabled");
        boolean timeoutEnabled = this.getPreferenceStore().getBoolean("org.eclipse.mylyn..activity.ui.timeout.enabled");
        this.activityTrackingEnabledButton = new Button((Composite)group, 32);
        this.activityTrackingEnabledButton.setText(Messages.TasksUiPreferencePage_Enable_Time_Tracking);
        this.activityTrackingEnabledButton.setSelection(activityTrackingEnabled);
        this.activityTrackingEnabledButton.setToolTipText(Messages.TasksUiPreferencePage_Track_Time_Spent);
        this.activityTrackingEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivityUiPreferencePage.this.updateControls();
            }
        });
        GridDataFactory.swtDefaults().span(3, 1).applyTo((Control)this.activityTrackingEnabledButton);
        this.timeoutEnabledButton = new Button((Composite)group, 32);
        this.timeoutEnabledButton.setText(Messages.TasksUiPreferencePage_Enable_inactivity_timeouts);
        this.timeoutEnabledButton.setSelection(timeoutEnabled);
        this.timeoutEnabledButton.setToolTipText(Messages.TasksUiPreferencePage_If_disabled);
        this.timeoutEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivityUiPreferencePage.this.updateControls();
            }
        });
        GridDataFactory.swtDefaults().span(3, 1).applyTo((Control)this.timeoutEnabledButton);
        this.timeoutLabel1 = new Label((Composite)group, 0);
        this.timeoutLabel1.setText(Messages.TasksUiPreferencePage_Stop_time_accumulation_after);
        this.timeoutMinutes = new Spinner((Composite)group, 2048);
        this.timeoutMinutes.setDigits(0);
        this.timeoutMinutes.setIncrement(5);
        this.timeoutMinutes.setMaximum(60);
        this.timeoutMinutes.setMinimum(1);
        long minutes = this.getPreferenceStore().getLong("org.eclipse.mylyn.activity.ui.timeout") / 60000L;
        this.timeoutMinutes.setSelection((int)minutes);
        this.timeoutMinutes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivityUiPreferencePage.this.updateControls();
            }
        });
        this.timeoutLabel2 = new Label((Composite)group, 0);
        this.timeoutLabel2.setText(Messages.TasksUiPreferencePage_minutes_of_inactivity);
        return group;
    }

    public void updateControls() {
        if (this.activityTrackingEnabledButton.getSelection()) {
            this.timeoutEnabledButton.setEnabled(true);
            this.timeoutMinutes.setEnabled(this.timeoutEnabledButton.getSelection());
            this.timeoutLabel1.setEnabled(this.timeoutEnabledButton.getSelection());
            this.timeoutLabel2.setEnabled(this.timeoutEnabledButton.getSelection());
        } else {
            this.timeoutEnabledButton.setEnabled(false);
            this.timeoutMinutes.setEnabled(false);
            this.timeoutLabel1.setEnabled(false);
            this.timeoutLabel2.setEnabled(false);
        }
    }
}

