/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.commons.progress;

import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lemminx.commons.progress.ProgressSupport;
import org.eclipse.lsp4j.WorkDoneProgressBegin;
import org.eclipse.lsp4j.WorkDoneProgressCreateParams;
import org.eclipse.lsp4j.WorkDoneProgressEnd;
import org.eclipse.lsp4j.WorkDoneProgressReport;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class ProgressMonitor
implements CancelChecker {
    private final String progressId;
    private final ProgressSupport progressSupport;
    private CompletableFuture<Void> future;

    public ProgressMonitor(ProgressSupport progressSupport) {
        this(UUID.randomUUID().toString(), progressSupport);
    }

    public ProgressMonitor(String progressId, ProgressSupport progressSupport) {
        this.progressId = progressId;
        this.progressSupport = progressSupport;
        WorkDoneProgressCreateParams create = new WorkDoneProgressCreateParams(Either.forLeft(progressId));
        this.future = progressSupport.createProgress(create);
    }

    public void begin(String title, String message, Integer percentage, Boolean cancellable) {
        WorkDoneProgressBegin begin = new WorkDoneProgressBegin();
        begin.setTitle(title);
        begin.setMessage(message);
        begin.setPercentage(percentage);
        begin.setCancellable(cancellable);
        this.progressSupport.notifyProgress(this.progressId, begin);
    }

    public void report(String message, Integer percentage, Boolean cancellable) {
        WorkDoneProgressReport report = new WorkDoneProgressReport();
        report.setMessage(message);
        report.setPercentage(percentage);
        report.setCancellable(cancellable);
        this.progressSupport.notifyProgress(this.progressId, report);
    }

    public void end(String message) {
        WorkDoneProgressEnd end = new WorkDoneProgressEnd();
        end.setMessage(message);
        this.progressSupport.notifyProgress(this.progressId, end);
    }

    @Override
    public void checkCanceled() {
        if (this.future != null && this.future.isCancelled()) {
            throw new CancellationException();
        }
    }

    @Override
    public boolean isCanceled() {
        return this.future != null ? this.future.isCancelled() : true;
    }
}

