/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.browser.embedded;

import org.eclipse.core.runtime.Platform;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpApplication;
import org.eclipse.help.ui.internal.browser.embedded.EmbeddedBrowser;
import org.eclipse.help.ui.internal.browser.embedded.IBrowserCloseListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public class EmbeddedBrowserAdapter
implements IBrowser,
IBrowserCloseListener {
    private EmbeddedBrowser browser;
    private UIThread2 secondThread;

    public Display getBrowserDisplay() {
        boolean useUIThread2;
        boolean bl = useUIThread2 = BaseHelpSystem.getMode() == 0 && "win32".equalsIgnoreCase(Platform.getOS()) && !"wpf".equalsIgnoreCase(SWT.getPlatform());
        if (useUIThread2) {
            if (this.secondThread == null) {
                this.secondThread = new UIThread2();
                this.secondThread.start();
            }
            return this.secondThread.getDisplay();
        }
        return Display.getDefault();
    }

    public void browserClosed() {
        this.browser = null;
        if (this.secondThread != null) {
            this.secondThread.dispose();
            this.secondThread = null;
        }
    }

    public synchronized void displayURL(final String url) {
        if (!HelpApplication.isShutdownOnClose()) {
            this.close();
        }
        if (this.getBrowserDisplay() == Display.getCurrent()) {
            this.uiDisplayURL(url);
        } else {
            this.getBrowserDisplay().asyncExec(new Runnable(){

                public void run() {
                    EmbeddedBrowserAdapter.this.uiDisplayURL(url);
                }
            });
        }
    }

    private void uiDisplayURL(String url) {
        this.getBrowser().displayUrl(url);
    }

    public synchronized void close() {
        if (this.getBrowserDisplay() == Display.getCurrent()) {
            this.uiClose();
        } else {
            this.getBrowserDisplay().syncExec(new Runnable(){

                public void run() {
                    EmbeddedBrowserAdapter.this.uiClose();
                }
            });
        }
    }

    private void uiClose() {
        if (this.browser != null && !this.browser.isDisposed()) {
            this.browser.close();
        }
        if (this.secondThread != null) {
            this.secondThread.dispose();
            this.secondThread = null;
        }
    }

    private EmbeddedBrowser getBrowser() {
        if (this.browser == null || this.browser.isDisposed()) {
            this.browser = new EmbeddedBrowser();
            this.browser.addCloseListener(this);
        }
        return this.browser;
    }

    public boolean isCloseSupported() {
        return true;
    }

    public boolean isSetLocationSupported() {
        return true;
    }

    public boolean isSetSizeSupported() {
        return true;
    }

    public synchronized void setLocation(final int x, final int y) {
        if (this.getBrowserDisplay() == Display.getCurrent()) {
            this.uiSetLocation(x, y);
        } else {
            this.getBrowserDisplay().asyncExec(new Runnable(){

                public void run() {
                    EmbeddedBrowserAdapter.this.uiSetLocation(x, y);
                }
            });
        }
    }

    private void uiSetLocation(int x, int y) {
        this.getBrowser().setLocation(x, y);
    }

    public synchronized void setSize(final int width, final int height) {
        if (this.getBrowserDisplay() == Display.getCurrent()) {
            this.uiSetSize(width, height);
        } else {
            this.getBrowserDisplay().asyncExec(new Runnable(){

                public void run() {
                    EmbeddedBrowserAdapter.this.uiSetSize(width, height);
                }
            });
        }
    }

    private void uiSetSize(int width, int height) {
        this.getBrowser().setSize(width, height);
    }

    class UIThread2
    extends Thread {
        Display d;
        boolean runEventLoop = true;

        public UIThread2() {
            this.setDaemon(true);
            this.setName("Help Browser UI");
        }

        public void run() {
            this.d = new Display();
            while (this.runEventLoop) {
                if (this.d.readAndDispatch()) continue;
                this.d.sleep();
            }
            this.d.dispose();
        }

        public Display getDisplay() {
            while (this.d == null && this.isAlive()) {
                try {
                    UIThread2.sleep(40L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.d;
        }

        public void dispose() {
            this.runEventLoop = false;
        }
    }
}

