/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.scripteditor.util;

import java.util.HashMap;
import org.eclipse.actf.model.dom.dombycom.AnalyzedResult;
import org.eclipse.actf.model.dom.dombycom.INodeEx;
import org.eclipse.actf.model.dom.dombycom.INodeExVideo;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.model.ui.util.ModelServiceUtils;
import org.w3c.dom.Node;

public class WebBrowserFactory {
    private static final int SEC2MSEC = 1000;
    private static WebBrowserFactory ownInst = null;
    private IWebBrowserACTF curBrowser = null;
    private MediaInfo curMediaInfo = null;
    private HashMap<IWebBrowserACTF, MediaInfo> mediaMap = new HashMap();

    private WebBrowserFactory() {
    }

    public static WebBrowserFactory getInstance() {
        if (ownInst == null) {
            ownInst = new WebBrowserFactory();
        }
        return ownInst;
    }

    public void setCurrentWebBrowser(IWebBrowserACTF webBrowser) {
        this.curBrowser = webBrowser;
        this.curMediaInfo = this.getMediaInfo(webBrowser);
    }

    public void removeWebBrowser(IWebBrowserACTF webBrowser) {
        this.mediaMap.remove(webBrowser);
        this.curBrowser = null;
        this.curMediaInfo = null;
    }

    public void mediaSearchRequest(IWebBrowserACTF webBrowser) {
        this.getMediaInfo((IWebBrowserACTF)webBrowser).checkFlag = true;
    }

    private MediaInfo getMediaInfo(IWebBrowserACTF webBrowser) {
        if (this.mediaMap.containsKey(webBrowser)) {
            return this.mediaMap.get(webBrowser);
        }
        MediaInfo tmp = new MediaInfo();
        this.mediaMap.put(webBrowser, tmp);
        return tmp;
    }

    private void checkVideo() {
        if (this.curBrowser == null) {
            IModelService model = ModelServiceUtils.getActiveModelService();
            if (model instanceof IWebBrowserACTF) {
                this.setCurrentWebBrowser((IWebBrowserACTF)model);
            } else {
                return;
            }
        }
        if (this.curMediaInfo.checkFlag) {
            this.searchVideo();
        } else if (this.curMediaInfo.videos.length == 0) {
            ++this.curMediaInfo.counter;
            if (this.curMediaInfo.counter >= 50) {
                this.curMediaInfo.checkFlag = true;
                this.searchVideo();
            }
        }
    }

    public void searchVideo() {
        if (this.curBrowser == null) {
            IModelService model = ModelServiceUtils.getActiveModelService();
            if (model instanceof IWebBrowserACTF) {
                this.setCurrentWebBrowser((IWebBrowserACTF)model);
            } else {
                return;
            }
        }
        if (!this.curMediaInfo.checkFlag) {
            return;
        }
        AnalyzedResult analyzedResult = new AnalyzedResult();
        this.curMediaInfo.curRoot = this.curBrowser.getLiveDocument().getDocumentElement();
        if (this.curMediaInfo.curRoot instanceof INodeEx) {
            analyzedResult = ((INodeEx)this.curMediaInfo.curRoot).analyze(analyzedResult);
        }
        this.curMediaInfo.videos = analyzedResult.getVideoNodes();
        this.curMediaInfo.checkFlag = false;
        this.curMediaInfo.counter = 0;
    }

    public boolean pauseMedia() {
        this.searchVideo();
        boolean r = true;
        if (this.curMediaInfo == null) {
            return r;
        }
        int i = 0;
        while (i < this.curMediaInfo.videos.length) {
            r &= this.curMediaInfo.videos[i].pauseMedia();
            ++i;
        }
        return r;
    }

    public boolean playMedia() {
        this.searchVideo();
        boolean r = true;
        if (this.curMediaInfo == null) {
            return r;
        }
        int i = 0;
        while (i < this.curMediaInfo.videos.length) {
            r &= this.curMediaInfo.videos[i].playMedia();
            ++i;
        }
        return r;
    }

    public boolean rewindMedia() {
        this.searchVideo();
        boolean r = true;
        if (this.curMediaInfo == null) {
            return r;
        }
        int i = 0;
        while (i < this.curMediaInfo.videos.length) {
            r &= this.curMediaInfo.videos[i].stopMedia();
            ++i;
        }
        return r;
    }

    public int getCurrentPosition() {
        this.checkVideo();
        if (this.curMediaInfo != null && this.curMediaInfo.videos.length > 0) {
            int localTime = 0;
            int i = 0;
            while (i < this.curMediaInfo.videos.length) {
                double realTime = this.curMediaInfo.videos[i].getCurrentPosition();
                localTime = (int)(realTime * 1000.0);
                ++i;
            }
            return localTime;
        }
        return 0;
    }

    public boolean setCurrentPosition(int pos) {
        this.checkVideo();
        boolean result = true;
        if (this.curMediaInfo != null && this.curMediaInfo.videos.length > 0) {
            double readTime = pos / 1000;
            int i = 0;
            while (i < this.curMediaInfo.videos.length) {
                result = this.curMediaInfo.videos[i].setCurrentPosition(readTime) & result;
                ++i;
            }
            return result;
        }
        return false;
    }

    public void showCurrentImage() {
        int status = this.getVideoStatus();
        if (status == 2 || status == 3) {
            this.playMedia();
            this.pauseMedia();
        }
    }

    public String getVideoURL() {
        this.checkVideo();
        if (this.curMediaInfo != null && this.curMediaInfo.videos.length > 0) {
            return this.curMediaInfo.videos[0].getVideoURL();
        }
        return null;
    }

    public int getTotalLength() {
        this.checkVideo();
        if (this.curMediaInfo != null && this.curMediaInfo.videos.length > 0) {
            double max = 0.0;
            double tmp = 0.0;
            int i = 0;
            while (i < this.curMediaInfo.videos.length) {
                tmp = this.curMediaInfo.videos[i].getTotalLength();
                if (tmp > max) {
                    max = tmp;
                }
                ++i;
            }
            int length = (int)Math.ceil(max * 1000.0);
            if (length == 0) {
                length = 600000;
            }
            return length;
        }
        return 0;
    }

    public int getVideoStatus() {
        this.checkVideo();
        if (this.curMediaInfo != null && this.curMediaInfo.videos.length > 0) {
            int currentStatus = 0;
            int i = 0;
            while (i < this.curMediaInfo.videos.length) {
                INodeExVideo.VideoState vs = this.curMediaInfo.videos[i].getCurrentState();
                switch (vs) {
                    case STATE_PLAY: 
                    case STATE_FASTFORWARD: 
                    case STATE_FASTREVERSE: {
                        currentStatus = 1;
                        break;
                    }
                    case STATE_STOP: {
                        currentStatus = 2;
                        break;
                    }
                    case STATE_PAUSE: 
                    case STATE_WAITING: {
                        currentStatus = 3;
                        break;
                    }
                }
                ++i;
            }
            return currentStatus;
        }
        return -1;
    }

    private class MediaInfo {
        Node curRoot = null;
        INodeExVideo[] videos = new INodeExVideo[0];
        boolean checkFlag = false;
        int counter = 0;

        private MediaInfo() {
        }
    }
}

