/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.internal.ui.scripteditor;

import java.net.URI;
import java.util.Locale;
import org.eclipse.actf.ai.internal.ui.scripteditor.ScriptAudioComposite;
import org.eclipse.actf.ai.internal.ui.scripteditor.TimeLineCanvas;
import org.eclipse.actf.ai.internal.ui.scripteditor.VolumeLevelCanvas;
import org.eclipse.actf.ai.internal.ui.scripteditor.XMLFileMessageBox;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.EventManager;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.SyncTimeEvent;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.SyncTimeEventListener;
import org.eclipse.actf.ai.scripteditor.data.ScriptData;
import org.eclipse.actf.ai.scripteditor.preferences.CSVRulePreferenceUtil;
import org.eclipse.actf.ai.tts.ITTSEngine;
import org.eclipse.actf.ai.ui.scripteditor.views.EditPanelView;
import org.eclipse.actf.ai.ui.scripteditor.views.IUNIT;
import org.eclipse.actf.ai.ui.scripteditor.views.ScriptListView;
import org.eclipse.actf.ai.ui.scripteditor.views.TimeLineView;
import org.eclipse.actf.examples.scripteditor.Activator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class EditPanelTab
implements IUNIT,
SyncTimeEventListener {
    Composite ownComposite;
    private String[] langList = ITTSEngine.LANGSET.toArray(new String[ITTSEngine.LANGSET.size()]);
    private static EditPanelTab ownInst = null;
    private ScriptData instScriptData;
    private boolean makeupAudioLabelStatus = false;
    private int indexAudioLabel = -1;
    private String strAudioLabel = null;
    private int currentEndTime = 0;
    private boolean currentStatAppend = true;
    private boolean currentModeAppend = true;
    private boolean currentStatDelete = true;
    private boolean currentStatCancel = true;
    private boolean currentStatPreview = true;
    private boolean currentEditDescription = false;
    private boolean currentMultiSelection = false;
    private Object[] storeObjs = null;
    private boolean modifyMultiExtended = false;
    private boolean modifyMultiGender = false;
    private boolean modifyMultiLang = false;
    private boolean modifyMultiSpeed = false;
    private boolean modifyMultiPitch = false;
    private boolean modifyMultiVolume = false;
    private int updateScriptStartTime = 0;
    private String currentDescLang = "en-US";
    private Label labelVPitch;
    private Label labelVVolume;
    private Label labelVSpeed;
    private Scale scaleVoiceVolume;
    private Scale scaleVoicePitch;
    private Scale scaleVoiceSpeed;
    private Label labelCaution;
    private Label labelImageSpeaker;
    private Button buttonVoicePreview;
    private Label labelFemale;
    private Button rButtonFemale;
    private Label labelMale;
    private Button rButtonMale;
    private Label labelExtended;
    private Button chkBoxExtended;
    private Text textAreaDescription;
    private Label labelDescription;
    private Label textEndTime;
    private Label labelEndTime;
    private Label labelStartTime;
    private Button buttonVoiceAppend;
    private Button buttonVoiceDelete;
    private Button buttonVoiceCancel;
    private Label labelLang;
    private Combo comboLang;
    private Text textStartTimeMM;
    private Label labelStartTimeMM;
    private Text textStartTimeSS;
    private Label labelStartTimeSS;
    private Text textStartTimeMS;
    private static EventManager eventManager = null;

    public EditPanelTab(CTabFolder parent) {
        ownInst = this;
        eventManager = EventManager.getInstance();
        this.initTab(parent);
    }

    public void initTab(CTabFolder parent) {
        this.ownComposite = new Composite((Composite)parent, 0);
        this.instScriptData = ScriptData.getInstance();
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        this.initGUI(display);
        eventManager.addSyncTimeEventListener(this);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                eventManager.removeSyncTimeEventListener(ownInst);
            }
        });
    }

    public void setFocus() {
        this.ownComposite.setFocus();
    }

    private FormData prepareFormData(int width, int height, int[] left, int[] top) {
        FormData tmpData = new FormData(-1, -1);
        tmpData.left = new FormAttachment(left[0], left[1], left[2]);
        tmpData.top = new FormAttachment(top[0], top[1], top[2]);
        return tmpData;
    }

    private void initGUI(Display parentDisp) {
        try {
            int i;
            FormLayout groupEditPanelLayout = new FormLayout();
            FormData groupEditPanelLData = new FormData(925, 128);
            groupEditPanelLData.top = new FormAttachment(0, 1000, 0);
            groupEditPanelLData.left = new FormAttachment(0, 1000, 0);
            groupEditPanelLData.right = new FormAttachment(1000, 1000, 0);
            groupEditPanelLData.bottom = new FormAttachment(1000, 1000, 0);
            this.ownComposite.setLayoutData((Object)groupEditPanelLData);
            this.ownComposite.setLayout((Layout)groupEditPanelLayout);
            this.textStartTimeMM = new Text(this.ownComposite, 2048);
            int[] nArray = new int[3];
            nArray[1] = 1000;
            nArray[2] = 78;
            int[] nArray2 = new int[3];
            nArray2[1] = 1000;
            nArray2[2] = 9;
            this.textStartTimeMM.setLayoutData((Object)this.prepareFormData(12, 12, nArray, nArray2));
            this.textStartTimeMM.setTextLimit(2);
            this.labelStartTimeMM = new Label(this.ownComposite, 0);
            int[] nArray3 = new int[3];
            nArray3[1] = 1000;
            nArray3[2] = 100;
            int[] nArray4 = new int[3];
            nArray4[1] = 1000;
            nArray4[2] = 11;
            this.labelStartTimeMM.setLayoutData((Object)this.prepareFormData(4, 12, nArray3, nArray4));
            this.labelStartTimeMM.setText(":");
            this.textStartTimeSS = new Text(this.ownComposite, 2048);
            int[] nArray5 = new int[3];
            nArray5[1] = 1000;
            nArray5[2] = 104;
            int[] nArray6 = new int[3];
            nArray6[1] = 1000;
            nArray6[2] = 9;
            this.textStartTimeSS.setLayoutData((Object)this.prepareFormData(12, 12, nArray5, nArray6));
            this.textStartTimeSS.setTextLimit(2);
            this.labelStartTimeSS = new Label(this.ownComposite, 0);
            int[] nArray7 = new int[3];
            nArray7[1] = 1000;
            nArray7[2] = 126;
            int[] nArray8 = new int[3];
            nArray8[1] = 1000;
            nArray8[2] = 11;
            this.labelStartTimeSS.setLayoutData((Object)this.prepareFormData(4, 12, nArray7, nArray8));
            this.labelStartTimeSS.setText(".");
            this.textStartTimeMS = new Text(this.ownComposite, 2048);
            int[] nArray9 = new int[3];
            nArray9[1] = 1000;
            nArray9[2] = 130;
            int[] nArray10 = new int[3];
            nArray10[1] = 1000;
            nArray10[2] = 9;
            this.textStartTimeMS.setLayoutData((Object)this.prepareFormData(18, 12, nArray9, nArray10));
            this.textStartTimeMS.setTextLimit(3);
            this.textStartTimeMM.setText("00");
            this.textStartTimeSS.setText("00");
            this.textStartTimeMS.setText("000");
            this.textStartTimeMM.addListener(25, (Listener)new DefaultNumCheckListener());
            this.textStartTimeSS.addListener(25, (Listener)new TimeSSNumCheck());
            this.textStartTimeMS.addListener(25, (Listener)new DefaultNumCheckListener());
            this.labelStartTime = new Label(this.ownComposite, 0);
            int[] nArray11 = new int[3];
            nArray11[1] = 1000;
            nArray11[2] = 5;
            int[] nArray12 = new int[3];
            nArray12[1] = 1000;
            nArray12[2] = 11;
            this.labelStartTime.setLayoutData((Object)this.prepareFormData(54, 12, nArray11, nArray12));
            this.labelStartTime.setText("Start Time");
            this.textEndTime = new Label(this.ownComposite, 0);
            int[] nArray13 = new int[3];
            nArray13[1] = 1000;
            nArray13[2] = 240;
            int[] nArray14 = new int[3];
            nArray14[1] = 1000;
            nArray14[2] = 11;
            this.textEndTime.setLayoutData((Object)this.prepareFormData(84, 12, nArray13, nArray14));
            this.textEndTime.setText("00 : 00 . 000");
            this.labelEndTime = new Label(this.ownComposite, 0);
            int[] nArray15 = new int[3];
            nArray15[1] = 1000;
            nArray15[2] = 176;
            int[] nArray16 = new int[3];
            nArray16[1] = 1000;
            nArray16[2] = 11;
            this.labelEndTime.setLayoutData((Object)this.prepareFormData(48, 12, nArray15, nArray16));
            this.labelEndTime.setText("End Time");
            this.labelDescription = new Label(this.ownComposite, 0);
            int[] nArray17 = new int[3];
            nArray17[1] = 1000;
            nArray17[2] = 2;
            int[] nArray18 = new int[3];
            nArray18[1] = 1000;
            nArray18[2] = 35;
            this.labelDescription.setLayoutData((Object)this.prepareFormData(58, 12, nArray17, nArray18));
            this.labelDescription.setText("Description");
            int scrollbarWidth = 17;
            FormData textAreaDescriptionLData = new FormData();
            textAreaDescriptionLData.width = 415 - scrollbarWidth;
            textAreaDescriptionLData.height = 80;
            textAreaDescriptionLData.left = new FormAttachment(0, 1000, 79);
            textAreaDescriptionLData.top = new FormAttachment(0, 1000, 35);
            this.textAreaDescription = new Text(this.ownComposite, 2626);
            this.textAreaDescription.setLayoutData((Object)textAreaDescriptionLData);
            this.textAreaDescription.addListener(24, (Listener)new descriptionModifyListener());
            FormData buttonVoiceAppendLData = new FormData();
            buttonVoiceAppendLData.width = 52;
            buttonVoiceAppendLData.height = 22;
            buttonVoiceAppendLData.left = new FormAttachment(0, 1000, 69);
            buttonVoiceAppendLData.top = new FormAttachment(0, 1000, 126);
            this.buttonVoiceAppend = new Button(this.ownComposite, 0x1000008);
            this.buttonVoiceAppend.setLayoutData((Object)buttonVoiceAppendLData);
            this.setVisibleAppend(false, false);
            this.buttonVoiceAppend.addSelectionListener((SelectionListener)new AppendScriptButtonAdapter());
            this.buttonVoiceAppend.addMouseTrackListener((MouseTrackListener)new ButtonMouseCursorTrackAdapter());
            FormData buttonVoiceDeleteLData = new FormData();
            buttonVoiceDeleteLData.width = 52;
            buttonVoiceDeleteLData.height = 22;
            buttonVoiceDeleteLData.left = new FormAttachment(0, 1000, 125);
            buttonVoiceDeleteLData.top = new FormAttachment(0, 1000, 126);
            this.buttonVoiceDelete = new Button(this.ownComposite, 0x1000008);
            this.buttonVoiceDelete.setLayoutData((Object)buttonVoiceDeleteLData);
            Image imgDelete = Activator.getImageDescriptor("/icons/delete.jpg").createImage();
            this.buttonVoiceDelete.setImage(imgDelete);
            this.setVisibleDelete(false);
            this.buttonVoiceDelete.addSelectionListener((SelectionListener)new DeleteScriptButtonAdapter());
            this.buttonVoiceDelete.addMouseTrackListener((MouseTrackListener)new ButtonMouseCursorTrackAdapter());
            FormData buttonVoiceCancelLData = new FormData();
            buttonVoiceCancelLData.width = 52;
            buttonVoiceCancelLData.height = 22;
            buttonVoiceCancelLData.left = new FormAttachment(0, 1000, 181);
            buttonVoiceCancelLData.top = new FormAttachment(0, 1000, 126);
            this.buttonVoiceCancel = new Button(this.ownComposite, 0x1000008);
            this.buttonVoiceCancel.setLayoutData((Object)buttonVoiceCancelLData);
            Image imgCancel = Activator.getImageDescriptor("/icons/cancel.jpg").createImage();
            this.buttonVoiceCancel.setImage(imgCancel);
            this.setVisibleCancel(false);
            this.buttonVoiceCancel.addSelectionListener((SelectionListener)new CancelScriptButtonAdapter());
            this.buttonVoiceCancel.addMouseTrackListener((MouseTrackListener)new ButtonMouseCursorTrackAdapter());
            FormData labelCautionLData = new FormData();
            labelCautionLData.left = new FormAttachment(0, 1000, 504);
            labelCautionLData.top = new FormAttachment(0, 1000, 94);
            this.labelCaution = new Label(this.ownComposite, 0);
            this.labelCaution.setLayoutData((Object)labelCautionLData);
            this.labelCaution.setText("Play Audio Description");
            FormData labelImageSpeakerLData = new FormData();
            labelImageSpeakerLData.width = 16;
            labelImageSpeakerLData.height = 20;
            labelImageSpeakerLData.left = new FormAttachment(0, 1000, 622);
            labelImageSpeakerLData.top = new FormAttachment(0, 1000, 90);
            this.labelImageSpeaker = new Label(this.ownComposite, 0);
            this.labelImageSpeaker.setLayoutData((Object)labelImageSpeakerLData);
            Image imgSpeaker = Activator.getImageDescriptor("/icons/speaker.bmp").createImage();
            this.labelImageSpeaker.setImage(imgSpeaker);
            FormData buttonVoicePreviewLData = new FormData();
            buttonVoicePreviewLData.width = 52;
            buttonVoicePreviewLData.height = 22;
            buttonVoicePreviewLData.left = new FormAttachment(0, 1000, 501);
            buttonVoicePreviewLData.top = new FormAttachment(0, 1000, 68);
            this.buttonVoicePreview = new Button(this.ownComposite, 0x1000008);
            this.buttonVoicePreview.setLayoutData((Object)buttonVoicePreviewLData);
            Image imgPreview = Activator.getImageDescriptor("/icons/preview.jpg").createImage();
            this.buttonVoicePreview.setImage(imgPreview);
            this.setVisiblePreview(false);
            this.buttonVoicePreview.addSelectionListener((SelectionListener)new PreviewButtonAdapter());
            this.buttonVoicePreview.addMouseTrackListener((MouseTrackListener)new ButtonMouseCursorTrackAdapter());
            FormData labelExtendedLData = new FormData();
            labelExtendedLData.left = new FormAttachment(0, 1000, 518);
            labelExtendedLData.top = new FormAttachment(0, 1000, 6);
            this.labelExtended = new Label(this.ownComposite, 0);
            this.labelExtended.setLayoutData((Object)labelExtendedLData);
            this.labelExtended.setText("Extended");
            this.labelExtended.setVisible(true);
            FormData chkBoxExtendedLData = new FormData();
            chkBoxExtendedLData.width = 13;
            chkBoxExtendedLData.height = 16;
            chkBoxExtendedLData.left = new FormAttachment(0, 1000, 501);
            chkBoxExtendedLData.top = new FormAttachment(0, 1000, 4);
            this.chkBoxExtended = new Button(this.ownComposite, 16416);
            this.chkBoxExtended.setLayoutData((Object)chkBoxExtendedLData);
            this.chkBoxExtended.setSelection(false);
            this.chkBoxExtended.addMouseTrackListener((MouseTrackListener)new ButtonMouseCursorTrackAdapter());
            this.chkBoxExtended.addListener(13, (Listener)new ExtendExtendedListener());
            this.chkBoxExtended.setVisible(true);
            FormData labelMaleLData = new FormData();
            labelMaleLData.left = new FormAttachment(0, 1000, 518);
            labelMaleLData.top = new FormAttachment(0, 1000, 28);
            this.labelMale = new Label(this.ownComposite, 0);
            this.labelMale.setLayoutData((Object)labelMaleLData);
            this.labelMale.setText("Male");
            FormData rButtonMaleLData = new FormData();
            rButtonMaleLData.left = new FormAttachment(0, 1000, 501);
            rButtonMaleLData.top = new FormAttachment(0, 1000, 26);
            this.rButtonMale = new Button(this.ownComposite, 16400);
            this.rButtonMale.setLayoutData((Object)rButtonMaleLData);
            this.rButtonMale.setSelection(true);
            this.rButtonMale.addMouseTrackListener((MouseTrackListener)new ButtonMouseCursorTrackAdapter());
            this.rButtonMale.addListener(13, (Listener)new ExtendGenderListener());
            FormData labelFemaleLData = new FormData();
            labelFemaleLData.left = new FormAttachment(0, 1000, 572);
            labelFemaleLData.top = new FormAttachment(0, 1000, 28);
            this.labelFemale = new Label(this.ownComposite, 0);
            this.labelFemale.setLayoutData((Object)labelFemaleLData);
            this.labelFemale.setText("Female");
            FormData rButtonFemaleLData = new FormData();
            rButtonFemaleLData.left = new FormAttachment(0, 1000, 555);
            rButtonFemaleLData.top = new FormAttachment(0, 1000, 26);
            this.rButtonFemale = new Button(this.ownComposite, 16400);
            this.rButtonFemale.setLayoutData((Object)rButtonFemaleLData);
            this.rButtonFemale.addMouseTrackListener((MouseTrackListener)new ButtonMouseCursorTrackAdapter());
            this.rButtonFemale.addListener(13, (Listener)new ExtendGenderListener());
            FormData labelLangLData = new FormData();
            labelLangLData.left = new FormAttachment(0, 1000, 501);
            labelLangLData.top = new FormAttachment((Control)this.textAreaDescription, -4);
            this.labelLang = new Label(this.ownComposite, 0);
            this.labelLang.setLayoutData((Object)labelLangLData);
            this.labelLang.setText("Language");
            FormData comboLangLData = new FormData();
            comboLangLData.left = new FormAttachment(0, 1000, 501);
            comboLangLData.top = new FormAttachment((Control)this.labelLang, 2);
            this.comboLang = new Combo(this.ownComposite, 4);
            this.comboLang.setLayoutData((Object)comboLangLData);
            this.comboLang.setItems(this.langList);
            if (Locale.getDefault().toString().startsWith("ja")) {
                i = 0;
                while (i < this.langList.length) {
                    if ("ja-JP".equals(this.langList[i])) {
                        this.comboLang.select(i);
                        break;
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.langList.length) {
                    if ("en-US".equals(this.langList[i])) {
                        this.comboLang.select(i);
                        break;
                    }
                    ++i;
                }
            }
            this.comboLang.addListener(13, (Listener)new DescLangListener());
            FormData labelVSpeedLData = new FormData();
            labelVSpeedLData.left = new FormAttachment(0, 1000, 662);
            labelVSpeedLData.top = new FormAttachment(0, 1000, 22);
            this.labelVSpeed = new Label(this.ownComposite, 0);
            this.labelVSpeed.setLayoutData((Object)labelVSpeedLData);
            this.labelVSpeed.setText("Speed");
            FormData labelVPitchLData = new FormData();
            labelVPitchLData.left = new FormAttachment(0, 1000, 667);
            labelVPitchLData.top = new FormAttachment(0, 1000, 68);
            this.labelVPitch = new Label(this.ownComposite, 0);
            this.labelVPitch.setLayoutData((Object)labelVPitchLData);
            this.labelVPitch.setText("Pitch");
            this.labelVPitch.setVisible(false);
            FormData labelVVolumeLData = new FormData();
            labelVVolumeLData.left = new FormAttachment(0, 1000, 656);
            labelVVolumeLData.top = new FormAttachment(0, 1000, 118);
            this.labelVVolume = new Label(this.ownComposite, 0);
            this.labelVVolume.setLayoutData((Object)labelVVolumeLData);
            this.labelVVolume.setText("Volume");
            this.labelVVolume.setVisible(false);
            FormData scaleVoiceSpeedLData = new FormData();
            scaleVoiceSpeedLData.width = 219;
            scaleVoiceSpeedLData.height = 42;
            scaleVoiceSpeedLData.left = new FormAttachment(0, 1000, 700);
            scaleVoiceSpeedLData.top = new FormAttachment(0, 1000, 6);
            this.scaleVoiceSpeed = new Scale(this.ownComposite, 256);
            this.scaleVoiceSpeed.setLayoutData((Object)scaleVoiceSpeedLData);
            this.scaleVoiceSpeed.setMinimum(0);
            this.scaleVoiceSpeed.setMaximum(100);
            this.scaleVoiceSpeed.setIncrement(10);
            this.scaleVoiceSpeed.setSelection(50);
            this.scaleVoiceSpeed.setToolTipText("50/100");
            this.scaleVoiceSpeed.addSelectionListener((SelectionListener)new ScaleSelectionAdapter());
            this.scaleVoiceSpeed.addMouseTrackListener((MouseTrackListener)new ScaleMouseCursorTrackAdapter());
            FormData scaleVoicePitchLData = new FormData();
            scaleVoicePitchLData.width = 219;
            scaleVoicePitchLData.height = 42;
            scaleVoicePitchLData.left = new FormAttachment(0, 1000, 700);
            scaleVoicePitchLData.top = new FormAttachment(0, 1000, 54);
            this.scaleVoicePitch = new Scale(this.ownComposite, 0);
            this.scaleVoicePitch.setLayoutData((Object)scaleVoicePitchLData);
            this.scaleVoicePitch.setMinimum(0);
            this.scaleVoicePitch.setMaximum(100);
            this.scaleVoicePitch.setIncrement(10);
            this.scaleVoicePitch.setSelection(50);
            this.scaleVoicePitch.setToolTipText("50/100");
            this.scaleVoicePitch.setVisible(false);
            this.scaleVoicePitch.addSelectionListener((SelectionListener)new ScaleSelectionAdapter());
            this.scaleVoicePitch.addMouseTrackListener((MouseTrackListener)new ScaleMouseCursorTrackAdapter());
            FormData scaleVoiceVolumeLData = new FormData();
            scaleVoiceVolumeLData.width = 219;
            scaleVoiceVolumeLData.height = 42;
            scaleVoiceVolumeLData.left = new FormAttachment(0, 1000, 700);
            scaleVoiceVolumeLData.top = new FormAttachment(0, 1000, 102);
            this.scaleVoiceVolume = new Scale(this.ownComposite, 0);
            this.scaleVoiceVolume.setLayoutData((Object)scaleVoiceVolumeLData);
            this.scaleVoiceVolume.setMinimum(0);
            this.scaleVoiceVolume.setMaximum(100);
            this.scaleVoiceVolume.setIncrement(10);
            this.scaleVoiceVolume.setSelection(50);
            this.scaleVoiceVolume.setToolTipText("50/100");
            this.scaleVoiceVolume.setVisible(false);
            this.scaleVoiceVolume.addSelectionListener((SelectionListener)new ScaleSelectionAdapter());
            this.scaleVoiceVolume.addMouseTrackListener((MouseTrackListener)new ScaleMouseCursorTrackAdapter());
            this.ownComposite.layout();
            this.ownComposite.pack();
        }
        catch (Exception e) {
            System.out.println("EditPanelTab : Exception = " + e);
        }
    }

    public Composite getOwnComposite() {
        return this.ownComposite;
    }

    public void popupWarningNoScriptData() {
        XMLFileMessageBox noDescMB = new XMLFileMessageBox(3, null);
        noDescMB.open();
    }

    public void popupWarningNoExistData() {
        XMLFileMessageBox noExistMB = new XMLFileMessageBox(4, null);
        noExistMB.open();
    }

    private void setVisibleAppend(boolean stat, boolean mode) {
        if (this.currentStatAppend != stat) {
            this.currentStatAppend = stat;
            if (stat) {
                this.currentModeAppend = mode;
                Image imgAppend = mode ? Activator.getImageDescriptor("/icons/update.jpg").createImage() : Activator.getImageDescriptor("/icons/add.jpg").createImage();
                this.buttonVoiceAppend.setImage(imgAppend);
            } else {
                this.currentEditDescription = false;
            }
            this.buttonVoiceAppend.setVisible(stat);
        }
    }

    public void setEnablePreview(int stat) {
        if (stat == 0) {
            this.buttonVoicePreview.setEnabled(true);
        } else {
            this.buttonVoicePreview.setEnabled(false);
        }
    }

    public void setFocusDescriptionTextArea() {
        this.setFocus();
        this.textAreaDescription.setFocus();
    }

    public int getStarTimeEditPanel() {
        int startTime = this.instScriptData.parseIntStartTime(this.textStartTimeMM.getText(), this.textStartTimeSS.getText(), this.textStartTimeMS.getText());
        return startTime;
    }

    private void setVisibleDelete(boolean stat) {
        if (this.currentStatDelete != stat) {
            this.currentStatDelete = stat;
            this.buttonVoiceDelete.setVisible(stat);
        }
    }

    private void setVisibleCancel(boolean stat) {
        if (this.currentStatCancel != stat) {
            this.currentStatCancel = stat;
            this.buttonVoiceCancel.setVisible(stat);
        }
    }

    private void setVisiblePreview(boolean stat) {
        if (this.currentStatPreview != stat) {
            this.currentStatPreview = stat;
            this.buttonVoicePreview.setVisible(stat);
            this.labelCaution.setVisible(stat);
            this.labelImageSpeaker.setVisible(stat);
        }
    }

    public boolean getCurrentGender() {
        return this.rButtonMale.getSelection();
    }

    public int getCurrentSpeed() {
        return this.scaleVoiceSpeed.getSelection();
    }

    public int getCurrentPitch() {
        return this.scaleVoicePitch.getSelection();
    }

    public int getCurrentVolume() {
        return this.scaleVoiceVolume.getSelection();
    }

    public String getCurrentDescription() {
        return this.textAreaDescription.getText();
    }

    public void repaintTextScriptData(int index) {
        int intScriptStartTime = this.instScriptData.getScriptStartTime(index);
        this.textStartTimeMM.setText(this.instScriptData.makeFormatMM(intScriptStartTime));
        this.textStartTimeSS.setText(this.instScriptData.makeFormatSS(intScriptStartTime));
        this.textStartTimeMS.setText(this.instScriptData.makeFormatMS(intScriptStartTime));
        this.chkBoxExtended.setSelection(this.instScriptData.getExtendExtended(index).booleanValue());
        if (this.instScriptData.getExtendGender(index).booleanValue()) {
            this.rButtonFemale.setSelection(false);
            this.rButtonMale.setSelection(true);
        } else {
            this.rButtonMale.setSelection(false);
            this.rButtonFemale.setSelection(true);
        }
        this.scaleVoiceSpeed.setSelection(this.instScriptData.getExtendSpeed(index));
        this.scaleVoicePitch.setSelection(this.instScriptData.getExtendPitch(index));
        this.scaleVoiceVolume.setSelection(this.instScriptData.getExtendVolume(index));
        this.scaleVoiceSpeed.setToolTipText(String.valueOf(String.valueOf(this.scaleVoiceSpeed.getSelection())) + "/100");
        this.scaleVoicePitch.setToolTipText(String.valueOf(String.valueOf(this.scaleVoicePitch.getSelection())) + "/100");
        this.scaleVoiceVolume.setToolTipText(String.valueOf(String.valueOf(this.scaleVoiceVolume.getSelection())) + "/100");
        TimeLineView.getInstance().repaintTimeLine();
        int endTime = this.instScriptData.getScriptEndTime(index);
        this.textEndTime.setText(this.instScriptData.makeFormatMMSSMS(endTime));
        this.currentDescLang = this.instScriptData.getExtendLang(index);
        int i = 0;
        while (i < this.langList.length) {
            if (this.langList[i].equals(this.currentDescLang)) {
                this.comboLang.select(i);
            }
            ++i;
        }
        this.setVisibleAppend(true, true);
        this.setVisibleDelete(true);
        this.setVisibleCancel(true);
        this.setVisiblePreview(true);
        this.textAreaDescription.setText(this.instScriptData.getScriptData(index));
        this.updateScriptStartTime = intScriptStartTime;
    }

    public void startSelectMultiItems(Object[] targetObjs) {
        this.storeObjs = targetObjs;
        this.initDispEditPanel();
        VolumeLevelCanvas.getInstance().clearSamplingLengthVolumeLevel();
        EditPanelView.getInstance().setSelectMultiItemsMode(true);
        this.setMultiSelectMode(true);
        this.setVisibleAppend(true, true);
        this.setVisibleDelete(true);
        this.setVisibleCancel(true);
    }

    public void appendSelectMultiItems(Object[] targetObjs) {
        this.storeObjs = targetObjs;
    }

    public void endSelectMultiItems() {
        EditPanelView.getInstance().setSelectMultiItemsMode(false);
        this.setMultiSelectMode(false);
        this.storeObjs = null;
        this.modifyMultiExtended = false;
        this.modifyMultiGender = false;
        this.modifyMultiLang = false;
        this.modifyMultiSpeed = false;
        this.modifyMultiPitch = false;
        this.modifyMultiVolume = false;
        this.setVisibleAppend(false, this.currentModeAppend);
        this.setVisibleDelete(false);
        this.setVisibleCancel(false);
    }

    public void setMultiSelectMode(boolean newMode) {
        if (this.currentMultiSelection != newMode) {
            this.currentMultiSelection = newMode;
            if (this.currentMultiSelection) {
                this.textStartTimeMM.setEnabled(false);
                this.textStartTimeSS.setEnabled(false);
                this.textStartTimeMS.setEnabled(false);
                this.textAreaDescription.setEnabled(false);
                this.setGrayedExtendParam(true);
            } else {
                ScriptListView.getInstance().getInstScriptList().setCurrentSelectionMode(false);
                this.textStartTimeMM.setEnabled(true);
                this.textStartTimeSS.setEnabled(true);
                this.textStartTimeMS.setEnabled(true);
                this.textAreaDescription.setEnabled(true);
                this.setGrayedExtendParam(false);
            }
        }
    }

    private void setGrayedExtendParam(boolean sw) {
        if (sw) {
            ScriptData firstData = (ScriptData)this.storeObjs[0];
            int index = this.instScriptData.getIndexScriptData(firstData.getScriptStartTime(0));
            boolean extended = this.instScriptData.getExtendExtended(index);
            boolean gender = this.instScriptData.getExtendGender(index);
            String lang = this.instScriptData.getExtendLang(index);
            int speed = this.instScriptData.getExtendSpeed(index);
            int pitch = this.instScriptData.getExtendPitch(index);
            int volume = this.instScriptData.getExtendVolume(index);
            if (this.isDiffExtended()) {
                this.chkBoxExtended.setSelection(true);
                this.chkBoxExtended.setGrayed(true);
            } else {
                this.chkBoxExtended.setSelection(extended);
            }
            if (this.isDiffGender()) {
                this.rButtonMale.setGrayed(true);
                this.rButtonFemale.setGrayed(true);
            }
            if (gender) {
                this.rButtonMale.setSelection(true);
            } else {
                this.rButtonFemale.setSelection(true);
            }
            if (this.isDiffSpeed()) {
                this.scaleVoiceSpeed.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(20));
            }
            this.scaleVoiceSpeed.setSelection(speed);
            if (this.isDiffPitch()) {
                this.scaleVoicePitch.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(20));
            }
            this.scaleVoicePitch.setSelection(pitch);
            if (this.isDiffVolume()) {
                this.scaleVoiceVolume.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(20));
            }
            this.scaleVoiceVolume.setSelection(volume);
            if (this.isDiffLang()) {
                this.comboLang.setForeground(PlatformUI.getWorkbench().getDisplay().getSystemColor(15));
                this.comboLang.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(22));
            }
            int i = 0;
            while (i < this.langList.length) {
                if (this.langList[i].equals(lang)) {
                    this.comboLang.select(i);
                }
                ++i;
            }
        } else {
            this.chkBoxExtended.setGrayed(false);
            this.rButtonMale.setGrayed(false);
            this.rButtonFemale.setGrayed(false);
            this.scaleVoiceSpeed.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(22));
            this.scaleVoicePitch.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(22));
            this.scaleVoiceVolume.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(22));
            this.comboLang.setForeground(PlatformUI.getWorkbench().getDisplay().getSystemColor(2));
            this.comboLang.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(1));
        }
    }

    private boolean isDiffExtended() {
        boolean result = false;
        ScriptData wrkData = (ScriptData)this.storeObjs[0];
        int index = this.instScriptData.getIndexScriptData(wrkData.getScriptStartTime(0));
        boolean firstData = this.instScriptData.getExtendExtended(index);
        int i = 1;
        while (i < this.storeObjs.length) {
            wrkData = (ScriptData)this.storeObjs[i];
            index = this.instScriptData.getIndexScriptData(wrkData.getScriptStartTime(0));
            boolean nextData = this.instScriptData.getExtendExtended(index);
            if (firstData != nextData) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    private boolean isDiffGender() {
        boolean result = false;
        ScriptData wrkData = (ScriptData)this.storeObjs[0];
        int index = this.instScriptData.getIndexScriptData(wrkData.getScriptStartTime(0));
        boolean firstData = this.instScriptData.getExtendGender(index);
        int i = 1;
        while (i < this.storeObjs.length) {
            wrkData = (ScriptData)this.storeObjs[i];
            index = this.instScriptData.getIndexScriptData(wrkData.getScriptStartTime(0));
            boolean nextData = this.instScriptData.getExtendGender(index);
            if (firstData != nextData) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    private boolean isDiffLang() {
        boolean result = false;
        ScriptData wrkData = (ScriptData)this.storeObjs[0];
        int index = this.instScriptData.getIndexScriptData(wrkData.getScriptStartTime(0));
        String firstData = this.instScriptData.getExtendLang(index);
        int i = 1;
        while (i < this.storeObjs.length) {
            wrkData = (ScriptData)this.storeObjs[i];
            index = this.instScriptData.getIndexScriptData(wrkData.getScriptStartTime(0));
            String nextData = this.instScriptData.getExtendLang(index);
            if (!firstData.equals(nextData)) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    private boolean isDiffSpeed() {
        boolean result = false;
        ScriptData wrkData = (ScriptData)this.storeObjs[0];
        int index = this.instScriptData.getIndexScriptData(wrkData.getScriptStartTime(0));
        int firstData = this.instScriptData.getExtendSpeed(index);
        int i = 1;
        while (i < this.storeObjs.length) {
            wrkData = (ScriptData)this.storeObjs[i];
            index = this.instScriptData.getIndexScriptData(wrkData.getScriptStartTime(0));
            int nextData = this.instScriptData.getExtendSpeed(index);
            if (firstData != nextData) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    private boolean isDiffPitch() {
        boolean result = false;
        ScriptData wrkData = (ScriptData)this.storeObjs[0];
        int index = this.instScriptData.getIndexScriptData(wrkData.getScriptStartTime(0));
        int firstData = this.instScriptData.getExtendPitch(index);
        int i = 1;
        while (i < this.storeObjs.length) {
            wrkData = (ScriptData)this.storeObjs[i];
            index = this.instScriptData.getIndexScriptData(wrkData.getScriptStartTime(0));
            int nextData = this.instScriptData.getExtendPitch(index);
            if (firstData != nextData) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    private boolean isDiffVolume() {
        boolean result = false;
        ScriptData wrkData = (ScriptData)this.storeObjs[0];
        int index = this.instScriptData.getIndexScriptData(wrkData.getScriptStartTime(0));
        int firstData = this.instScriptData.getExtendVolume(index);
        int i = 1;
        while (i < this.storeObjs.length) {
            wrkData = (ScriptData)this.storeObjs[i];
            index = this.instScriptData.getIndexScriptData(wrkData.getScriptStartTime(0));
            int nextData = this.instScriptData.getExtendVolume(index);
            if (firstData != nextData) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    private boolean isModifiedVoiceParam() {
        return this.modifyMultiExtended || this.modifyMultiGender || this.modifyMultiLang || this.modifyMultiSpeed || this.modifyMultiPitch || this.modifyMultiVolume;
    }

    public void repaintTextEndTime() {
        if (this.scaleVoiceSpeed.isDisposed()) {
            return;
        }
        int extendSpeed = this.scaleVoiceSpeed.getSelection();
        String extendLang = this.currentDescLang;
        String currentDesc = this.textAreaDescription.getText();
        int newEndTime = TimeLineView.getInstance().setEndTimeVolumeLevel(currentDesc, extendSpeed, extendLang);
        this.textEndTime.setText(this.instScriptData.makeFormatMMSSMS(newEndTime));
    }

    public int setEndTimeScriptData(int lenData) {
        int startTime = this.instScriptData.parseIntStartTime(this.textStartTimeMM.getText(), this.textStartTimeSS.getText(), this.textStartTimeMS.getText());
        int newEndTime = startTime + lenData;
        this.textEndTime.setText(this.instScriptData.makeFormatMMSSMS(newEndTime));
        this.makeupAudioLabel(newEndTime);
        return newEndTime;
    }

    private void preMakeupAudioLabel(int index, String strAudio) {
        this.makeupAudioLabelStatus = true;
        this.indexAudioLabel = index;
        this.strAudioLabel = strAudio;
    }

    private void makeupAudioLabel(int newEndTime) {
        if (this.isMakeupAudioLabel()) {
            int startTime = this.instScriptData.getScriptStartTime(this.indexAudioLabel);
            boolean extended = this.instScriptData.getExtendExtended(this.indexAudioLabel);
            boolean enableWav = false;
            int index = this.instScriptData.getIndexWavList(startTime);
            if (index >= 0) {
                enableWav = this.instScriptData.getEnableWavList(index);
            }
            if (!enableWav) {
                TimeLineView.getInstance().putScriptAudio(this.indexAudioLabel, startTime, newEndTime, this.strAudioLabel, extended);
            }
            this.postMakeupAudioLabel();
        }
    }

    private void postMakeupAudioLabel() {
        this.makeupAudioLabelStatus = false;
        this.indexAudioLabel = -1;
        this.strAudioLabel = null;
    }

    private boolean isMakeupAudioLabel() {
        return this.makeupAudioLabelStatus;
    }

    public void reqUpdateEndTimeAudioLabel(int index, int newEndTime) {
        int startTime = this.instScriptData.getScriptStartTime(index);
        String strAudioLabel = this.instScriptData.getScriptData(index);
        boolean extended = this.instScriptData.getExtendExtended(index);
        TimeLineView.getInstance().putScriptAudio(index, startTime, newEndTime, strAudioLabel, extended);
    }

    public void synchronizeTimeLine(int nowTime) {
        if (!this.buttonVoiceAppend.getVisible()) {
            this.textStartTimeMM.setText(this.instScriptData.makeFormatMM(nowTime));
            this.textStartTimeSS.setText(this.instScriptData.makeFormatSS(nowTime));
            this.textStartTimeMS.setText(this.instScriptData.makeFormatMS(nowTime));
        }
    }

    private void playPreviewDescription(String currentScriptText) {
        if (TimeLineView.getInstance().isSamplingScriptAudio().booleanValue()) {
            TimeLineView.getInstance().reqStopScriptAudio();
        }
        try {
            String strGender = this.rButtonMale.getSelection() ? "male" : "female";
            int speed = this.scaleVoiceSpeed.getSelection();
            int pitch = this.scaleVoicePitch.getSelection();
            int volume = this.scaleVoiceVolume.getSelection();
            String lang = this.langList[this.comboLang.getSelectionIndex()];
            TimeLineView.getInstance().reqSetupScriptAudio(lang, strGender, speed, pitch, volume);
            TimeLineView.getInstance().reqPlayScriptAudio(currentScriptText);
        }
        catch (Exception ee) {
            System.out.println("playPreviewDescription() : Exception = " + ee);
        }
    }

    public void appendScriptData(String strStart, String strDuration, String strDescription, String extended, String extGender, String extSpeed, String extPitch, String extVolume, String extLang) {
        int index;
        int duration;
        int endTime;
        int startTime = this.instScriptData.parseIntStartTime(strStart);
        boolean result = this.instScriptData.appendScriptData(strDescription, startTime, endTime = startTime + (duration = this.instScriptData.parseIntStartTime(strDuration)));
        if (result && (index = this.instScriptData.getIndexScriptData(startTime)) >= 0) {
            Boolean extendExtended = "true".equals(extended);
            Boolean extendSex = "male".equals(extGender);
            int extendSpeed = Integer.parseInt(extSpeed);
            int extendPitch = Integer.parseInt(extPitch);
            int extendVolume = Integer.parseInt(extVolume);
            this.instScriptData.appendExtendData(index, startTime, extendExtended, extendSex, extendSpeed, extendPitch, extendVolume, extLang);
        }
    }

    public boolean appendScriptData(int startTime, String strDescription, boolean extended, boolean gender, String lang, int speed, int pitch, int volume) {
        int endTime;
        boolean result;
        Boolean extendExtended = extended;
        Boolean extendGender = gender;
        int extendSpeed = speed;
        int extendPitch = pitch;
        int extendVolume = volume;
        String extendLang = lang;
        int index = -1;
        if (CSVRulePreferenceUtil.getPreferenceCsvSaveRule() == 0 && (index = this.instScriptData.getIndexScriptData(startTime)) >= 0) {
            extendExtended = this.instScriptData.getExtendExtended(index);
            extendGender = this.instScriptData.getExtendGender(index);
            extendSpeed = this.instScriptData.getExtendSpeed(index);
            extendPitch = this.instScriptData.getExtendPitch(index);
            extendVolume = this.instScriptData.getExtendVolume(index);
            extendLang = this.instScriptData.getExtendLang(index);
        }
        if ((result = this.instScriptData.appendScriptData(strDescription, startTime, endTime = startTime + TimeLineView.getInstance().sumMoraCount(strDescription, extendSpeed, extendLang))) && (index = this.instScriptData.getIndexScriptData(startTime)) >= 0) {
            this.instScriptData.appendExtendData(index, startTime, extendExtended, extendGender, extendSpeed, extendPitch, extendVolume, extendLang);
            this.instScriptData.setStatusSaveScripts(5, true);
        }
        return result;
    }

    public void appendDataWavList(String strStartTime, String strDurationTime, String strLocalUri, String strSpeed, boolean enable) {
        int wavStartTime = this.instScriptData.parseIntStartTime(strStartTime);
        int wavEndTime = wavStartTime + this.instScriptData.parseIntStartTime(strDurationTime);
        URI wavFileUri = URI.create(strLocalUri);
        float wavCompRatio = Float.parseFloat(strSpeed);
        if (wavCompRatio >= 50.0f && wavCompRatio <= 200.0f) {
            wavCompRatio /= 100.0f;
        }
        this.instScriptData.appendDataWavList(wavStartTime, wavEndTime, wavFileUri, enable, wavCompRatio);
    }

    public void appendDataWavList(int startTime, int duration, URI localUri, boolean enable, float speed) {
        int wavEndTime = startTime + duration;
        float wavCompRatio = speed;
        boolean wavEnabled = enable && duration != -1;
        this.instScriptData.appendDataWavList(startTime, wavEndTime, localUri, wavEnabled, wavCompRatio);
    }

    public void initDispEditPanel() {
        this.textAreaDescription.setText("");
        int nowTimeLine = TimeLineCanvas.getInstance().getCurrentPositionMarkerTimeLine();
        this.textStartTimeMM.setText(this.instScriptData.makeFormatMM(nowTimeLine));
        this.textStartTimeSS.setText(this.instScriptData.makeFormatSS(nowTimeLine));
        this.textStartTimeMS.setText(this.instScriptData.makeFormatMS(nowTimeLine));
        this.textEndTime.setText(this.instScriptData.makeFormatMMSSMS(nowTimeLine));
        this.chkBoxExtended.setSelection(false);
        this.scaleVoiceSpeed.setSelection(50);
        this.scaleVoicePitch.setSelection(50);
        this.scaleVoiceVolume.setSelection(50);
        this.scaleVoiceSpeed.setToolTipText(String.valueOf(String.valueOf(this.scaleVoiceSpeed.getSelection())) + "/100");
        this.scaleVoicePitch.setToolTipText(String.valueOf(String.valueOf(this.scaleVoicePitch.getSelection())) + "/100");
        this.scaleVoiceVolume.setToolTipText(String.valueOf(String.valueOf(this.scaleVoiceVolume.getSelection())) + "/100");
        this.setVisibleAppend(false, this.currentModeAppend);
        this.setVisibleDelete(false);
        this.setVisibleCancel(false);
        this.setVisiblePreview(false);
    }

    public void refreshScriptData(int currentStartTime, int newStartTime, int newEndTime, boolean dspMode) {
        int index = this.instScriptData.searchScriptData(currentStartTime);
        if (index >= 0) {
            String currentScriptData = this.instScriptData.getScriptData(index);
            boolean currentExtended = this.instScriptData.getExtendExtended(index);
            boolean currentGender = this.instScriptData.getExtendGender(index);
            int currentSpeed = this.instScriptData.getExtendSpeed(index);
            int currentPitch = this.instScriptData.getExtendPitch(index);
            int currentVolume = this.instScriptData.getExtendVolume(index);
            String currentLang = this.instScriptData.getExtendLang(index);
            this.instScriptData.deleteScriptData(index);
            this.instScriptData.deleteExtendData(currentStartTime);
            this.currentEndTime = newEndTime;
            boolean result = this.instScriptData.appendScriptData(currentScriptData, newStartTime, newEndTime);
            if (result) {
                index = this.instScriptData.getIndexScriptData(newStartTime);
                if (index >= 0) {
                    this.instScriptData.appendExtendData(index, newStartTime, currentExtended, currentGender, currentSpeed, currentPitch, currentVolume, currentLang);
                    if (dspMode) {
                        this.repaintTextScriptData(index);
                    }
                }
            } else {
                this.popupWarningNoScriptData();
            }
            ScriptListView.getInstance().getInstScriptList().reloadScriptList();
        }
    }

    @Override
    public void handleSyncTimeEvent(SyncTimeEvent e) {
        if (e.getEventType() == 0) {
            this.synchronizeTimeLine(e.getCurrentTime());
        } else {
            e.getEventType();
        }
    }

    abstract class AbstructNumCheckListener
    implements Listener {
        AbstructNumCheckListener() {
        }

        public void handleEvent(Event e) {
            int val = -1;
            if (e.text != null && !"".equals(e.text)) {
                try {
                    val = Integer.parseInt(e.text);
                }
                catch (Exception exception) {
                    e.doit = false;
                }
                if (e.doit) {
                    this.additionalCheck(e, val);
                }
            }
        }

        abstract void additionalCheck(Event var1, int var2);
    }

    class AppendScriptButtonAdapter
    extends SelectionAdapter {
        AppendScriptButtonAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (!EditPanelTab.this.currentMultiSelection) {
                this.appendSingleScript();
            } else {
                if (EditPanelTab.this.isModifiedVoiceParam()) {
                    this.updateMultiScripts();
                }
                EditPanelTab.this.endSelectMultiItems();
            }
        }

        private void appendSingleScript() {
            int indexWav;
            boolean result = false;
            int index = -1;
            String strDesc = EditPanelTab.this.textAreaDescription.getText();
            int startTime = EditPanelTab.this.instScriptData.parseIntStartTime(EditPanelTab.this.textStartTimeMM.getText(), EditPanelTab.this.textStartTimeSS.getText(), EditPanelTab.this.textStartTimeMS.getText());
            int newEndTime = EditPanelTab.this.currentEndTime;
            boolean update_mode_flg = false;
            Boolean extendExtended = EditPanelTab.this.chkBoxExtended.getSelection();
            Boolean extendSex = EditPanelTab.this.rButtonMale.getSelection();
            int extendSpeed = EditPanelTab.this.scaleVoiceSpeed.getSelection();
            int extendPitch = EditPanelTab.this.scaleVoicePitch.getSelection();
            int extendVolume = EditPanelTab.this.scaleVoiceVolume.getSelection();
            String extendLang = EditPanelTab.this.currentDescLang;
            if (EditPanelTab.this.currentModeAppend && startTime != EditPanelTab.this.updateScriptStartTime) {
                index = EditPanelTab.this.instScriptData.getIndexScriptData(EditPanelTab.this.updateScriptStartTime);
                if (index >= 0) {
                    result = true;
                    int startTimeWav = 0;
                    int endTimeWav = 0;
                    int indexWav2 = EditPanelTab.this.instScriptData.getIndexWavList(EditPanelTab.this.updateScriptStartTime);
                    if (indexWav2 >= 0) {
                        startTimeWav = EditPanelTab.this.instScriptData.getStartTimeWavList(indexWav2);
                        endTimeWav = EditPanelTab.this.instScriptData.getEndTimeWavList(indexWav2);
                        endTimeWav = endTimeWav - startTimeWav + startTime;
                        if (ScriptData.getInstance().getEnableWavList(indexWav2)) {
                            newEndTime = endTimeWav;
                        }
                    }
                    TimeLineView.getInstance().reqRefreshScriptData(EditPanelTab.this.updateScriptStartTime, startTime, EditPanelTab.this.currentEndTime, endTimeWav, false);
                    update_mode_flg = true;
                }
            } else {
                result = EditPanelTab.this.instScriptData.appendScriptData(strDesc, EditPanelTab.this.textStartTimeMM.getText(), EditPanelTab.this.textStartTimeSS.getText(), EditPanelTab.this.textStartTimeMS.getText(), EditPanelTab.this.currentEndTime);
            }
            if (result) {
                index = EditPanelTab.this.instScriptData.getIndexScriptData(startTime);
                if (index >= 0) {
                    EditPanelTab.this.instScriptData.appendExtendData(index, startTime, extendExtended, extendSex, extendSpeed, extendPitch, extendVolume, extendLang);
                    EditPanelTab.this.preMakeupAudioLabel(index, strDesc);
                    newEndTime = TimeLineView.getInstance().setEndTimeVolumeLevel(strDesc, extendSpeed, extendLang);
                    EditPanelTab.this.instScriptData.updateScriptEndTime(startTime, newEndTime);
                    int stat = 5;
                    String filePath = TimeLineView.getInstance().reqGetXMLFilePath();
                    if (filePath != null) {
                        stat = 2;
                    }
                    EditPanelTab.this.instScriptData.setStatusSaveScripts(stat, true);
                    TimeLineView.getInstance().reqExpandTimeLine();
                    TimeLineView.getInstance().reqSetupTimeLine();
                    VolumeLevelCanvas.getInstance().clearSamplingLengthVolumeLevel();
                }
            } else {
                EditPanelTab.this.popupWarningNoScriptData();
            }
            if ((indexWav = EditPanelTab.this.instScriptData.getIndexWavList(startTime)) >= 0 && ScriptData.getInstance().getEnableWavList(indexWav)) {
                newEndTime = EditPanelTab.this.instScriptData.getEndTimeWavList(indexWav);
            }
            if (update_mode_flg) {
                ScriptAudioComposite.getInstance().deleteAudioLabel(EditPanelTab.this.updateScriptStartTime);
            }
            ScriptAudioComposite.getInstance().putAudioLabel(index, startTime, newEndTime, strDesc, extendExtended);
            ScriptAudioComposite.getInstance().redrawAudioLabelAll();
            ScriptListView.getInstance().getInstScriptList().reloadScriptList();
            EditPanelTab.this.initDispEditPanel();
            EditPanelView.getInstance().getInstanceTabSelWAVFile().initDescriptionStruct();
            EditPanelView.getInstance().getInstanceTabSelWAVFile().initDispSelWavFile();
        }

        private void updateMultiScripts() {
            if (EditPanelTab.this.storeObjs != null) {
                VolumeLevelCanvas.getInstance().clearSamplingLengthVolumeLevel();
                Boolean extendExtended = EditPanelTab.this.chkBoxExtended.getSelection();
                Boolean extendGender = EditPanelTab.this.rButtonMale.getSelection();
                int extendSpeed = EditPanelTab.this.scaleVoiceSpeed.getSelection();
                int extendPitch = EditPanelTab.this.scaleVoicePitch.getSelection();
                int extendVolume = EditPanelTab.this.scaleVoiceVolume.getSelection();
                String extendLang = EditPanelTab.this.currentDescLang;
                int i = 0;
                while (i < EditPanelTab.this.storeObjs.length) {
                    ScriptData tempScriptData = (ScriptData)EditPanelTab.this.storeObjs[i];
                    int startTime = tempScriptData.getScriptStartTime(0);
                    int newEndTime = tempScriptData.getScriptEndTime(0);
                    String strDesc = tempScriptData.getScriptData(0);
                    int index = EditPanelTab.this.instScriptData.searchScriptData(startTime);
                    EditPanelTab.this.textStartTimeMM.setText(EditPanelTab.this.instScriptData.makeFormatMM(startTime));
                    EditPanelTab.this.textStartTimeSS.setText(EditPanelTab.this.instScriptData.makeFormatSS(startTime));
                    EditPanelTab.this.textStartTimeMS.setText(EditPanelTab.this.instScriptData.makeFormatMS(startTime));
                    if (!EditPanelTab.this.modifyMultiExtended) {
                        extendExtended = EditPanelTab.this.instScriptData.getExtendExtended(index);
                    }
                    if (!EditPanelTab.this.modifyMultiGender) {
                        extendGender = EditPanelTab.this.instScriptData.getExtendGender(index);
                    }
                    if (!EditPanelTab.this.modifyMultiLang) {
                        extendLang = EditPanelTab.this.instScriptData.getExtendLang(index);
                    }
                    if (!EditPanelTab.this.modifyMultiSpeed) {
                        extendSpeed = EditPanelTab.this.instScriptData.getExtendSpeed(index);
                    }
                    if (!EditPanelTab.this.modifyMultiPitch) {
                        extendPitch = EditPanelTab.this.instScriptData.getExtendPitch(index);
                    }
                    if (!EditPanelTab.this.modifyMultiVolume) {
                        extendVolume = EditPanelTab.this.instScriptData.getExtendVolume(index);
                    }
                    if (index >= 0) {
                        EditPanelTab.this.instScriptData.appendExtendData(index, startTime, extendExtended, extendGender, extendSpeed, extendPitch, extendVolume, extendLang);
                        newEndTime = TimeLineView.getInstance().setEndTimeVolumeLevel(strDesc, extendSpeed, extendLang);
                        EditPanelTab.this.preMakeupAudioLabel(index, strDesc);
                        EditPanelTab.this.instScriptData.updateScriptEndTime(startTime, newEndTime);
                        int endTimeWav = 0;
                        int indexWav = EditPanelTab.this.instScriptData.getIndexWavList(startTime);
                        if (indexWav >= 0) {
                            endTimeWav = EditPanelTab.this.instScriptData.getEndTimeWavList(indexWav);
                            if (ScriptData.getInstance().getEnableWavList(indexWav)) {
                                newEndTime = endTimeWav;
                            }
                        }
                        ScriptAudioComposite.getInstance().deleteAudioLabel(startTime);
                        ScriptAudioComposite.getInstance().putAudioLabel(index, startTime, newEndTime, strDesc, extendExtended);
                    }
                    ++i;
                }
                int stat = 5;
                String filePath = TimeLineView.getInstance().reqGetXMLFilePath();
                if (filePath != null) {
                    stat = 2;
                }
                EditPanelTab.this.instScriptData.setStatusSaveScripts(stat, true);
                TimeLineView.getInstance().reqExpandTimeLine();
                TimeLineView.getInstance().reqSetupTimeLine();
                ScriptAudioComposite.getInstance().redrawAudioLabelAll();
                ScriptListView.getInstance().getInstScriptList().reloadScriptList();
            }
        }
    }

    class ButtonMouseCursorTrackAdapter
    extends MouseTrackAdapter {
        ButtonMouseCursorTrackAdapter() {
        }

        public void mouseEnter(MouseEvent e) {
            Button parentButton = (Button)e.getSource();
            parentButton.setCursor(new Cursor(null, 21));
        }

        public void mouseExit(MouseEvent e) {
            Button parentButton = (Button)e.getSource();
            parentButton.setCursor(new Cursor(null, 21));
        }
    }

    class CancelScriptButtonAdapter
    extends SelectionAdapter {
        CancelScriptButtonAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            EditPanelTab.this.initDispEditPanel();
            EditPanelView.getInstance().getInstanceTabSelWAVFile().initDescriptionStruct();
            EditPanelView.getInstance().getInstanceTabSelWAVFile().initDispSelWavFile();
            VolumeLevelCanvas.getInstance().clearSamplingLengthVolumeLevel();
            EditPanelTab.this.endSelectMultiItems();
        }
    }

    class DefaultNumCheckListener
    extends AbstructNumCheckListener {
        DefaultNumCheckListener() {
        }

        @Override
        void additionalCheck(Event e, int val) {
        }
    }

    class DeleteScriptButtonAdapter
    extends SelectionAdapter {
        DeleteScriptButtonAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (!EditPanelTab.this.currentMultiSelection) {
                this.deleteSingleScript();
            } else {
                this.deleteMultiScripts();
                EditPanelTab.this.endSelectMultiItems();
            }
        }

        private void deleteSingleScript() {
            boolean result = EditPanelTab.this.instScriptData.deleteScriptData(EditPanelTab.this.textStartTimeMM.getText(), EditPanelTab.this.textStartTimeSS.getText(), EditPanelTab.this.textStartTimeMS.getText());
            if (result) {
                int startTime = EditPanelTab.this.instScriptData.parseIntStartTime(EditPanelTab.this.textStartTimeMM.getText(), EditPanelTab.this.textStartTimeSS.getText(), EditPanelTab.this.textStartTimeMS.getText());
                EditPanelTab.this.instScriptData.deleteExtendData(startTime);
                EditPanelTab.this.initDispEditPanel();
                EditPanelView.getInstance().getInstanceTabSelWAVFile().initDescriptionStruct();
                EditPanelView.getInstance().getInstanceTabSelWAVFile().initDispSelWavFile();
                ScriptListView.getInstance().getInstScriptList().reloadScriptList();
                TimeLineView.getInstance().reqDeleteScriptData(startTime);
                int stat = 5;
                String filePath = TimeLineView.getInstance().reqGetXMLFilePath();
                if (filePath != null) {
                    stat = 2;
                }
                EditPanelTab.this.instScriptData.setStatusSaveScripts(stat, true);
                TimeLineView.getInstance().reqSetupTimeLine();
                VolumeLevelCanvas.getInstance().clearSamplingLengthVolumeLevel();
            } else {
                EditPanelTab.this.popupWarningNoExistData();
            }
        }

        private void deleteMultiScripts() {
            if (EditPanelTab.this.storeObjs != null) {
                int i = 0;
                while (i < EditPanelTab.this.storeObjs.length) {
                    ScriptData tempScriptData = (ScriptData)EditPanelTab.this.storeObjs[i];
                    int startTime = tempScriptData.getScriptStartTime(0);
                    int index = EditPanelTab.this.instScriptData.searchScriptData(startTime);
                    boolean result = EditPanelTab.this.instScriptData.deleteScriptData(index);
                    if (result) {
                        EditPanelTab.this.instScriptData.deleteExtendData(startTime);
                        TimeLineView.getInstance().reqDeleteScriptData(startTime);
                    }
                    ++i;
                }
                ScriptListView.getInstance().getInstScriptList().reloadScriptList();
                int stat = 5;
                String filePath = TimeLineView.getInstance().reqGetXMLFilePath();
                if (filePath != null) {
                    stat = 2;
                }
                EditPanelTab.this.instScriptData.setStatusSaveScripts(stat, true);
                TimeLineView.getInstance().reqSetupTimeLine();
                VolumeLevelCanvas.getInstance().clearSamplingLengthVolumeLevel();
            }
        }
    }

    class DescLangListener
    implements Listener {
        DescLangListener() {
        }

        public void handleEvent(Event e) {
            Combo combo = (Combo)e.widget;
            EditPanelTab.this.currentDescLang = EditPanelTab.this.langList[combo.getSelectionIndex()];
            if (EditPanelTab.this.currentMultiSelection) {
                EditPanelTab.this.modifyMultiLang = true;
                EditPanelTab.this.comboLang.setForeground(PlatformUI.getWorkbench().getDisplay().getSystemColor(2));
                EditPanelTab.this.comboLang.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(1));
            }
        }
    }

    class ExtendExtendedListener
    implements Listener {
        ExtendExtendedListener() {
        }

        public void handleEvent(Event e) {
            if (EditPanelTab.this.currentMultiSelection) {
                EditPanelTab.this.modifyMultiExtended = true;
                EditPanelTab.this.chkBoxExtended.setGrayed(false);
            }
        }
    }

    class ExtendGenderListener
    implements Listener {
        ExtendGenderListener() {
        }

        public void handleEvent(Event e) {
            if (EditPanelTab.this.currentMultiSelection) {
                EditPanelTab.this.modifyMultiGender = true;
                EditPanelTab.this.rButtonMale.setGrayed(false);
                EditPanelTab.this.rButtonFemale.setGrayed(false);
            }
        }
    }

    class PreviewButtonAdapter
    extends SelectionAdapter {
        PreviewButtonAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            String currentScriptText = new String(EditPanelTab.this.textAreaDescription.getText());
            if (!currentScriptText.isEmpty()) {
                EditPanelTab.this.playPreviewDescription(currentScriptText);
            }
        }
    }

    class ScaleMouseCursorTrackAdapter
    extends MouseTrackAdapter {
        ScaleMouseCursorTrackAdapter() {
        }

        public void mouseEnter(MouseEvent e) {
            Scale parentScale = (Scale)e.getSource();
            parentScale.setCursor(new Cursor(null, 21));
        }

        public void mouseExit(MouseEvent e) {
            Scale parentScale = (Scale)e.getSource();
            parentScale.setCursor(new Cursor(null, 0));
        }
    }

    class ScaleSelectionAdapter
    extends SelectionAdapter {
        ScaleSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            Scale scale = (Scale)e.widget;
            scale.setToolTipText(String.valueOf(String.valueOf(scale.getSelection())) + "/100");
            if (EditPanelTab.this.currentMultiSelection) {
                if (EditPanelTab.this.scaleVoiceSpeed.equals(scale)) {
                    EditPanelTab.this.modifyMultiSpeed = true;
                    EditPanelTab.this.scaleVoiceSpeed.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(22));
                } else if (EditPanelTab.this.scaleVoicePitch.equals(scale)) {
                    EditPanelTab.this.modifyMultiPitch = true;
                    EditPanelTab.this.scaleVoicePitch.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(22));
                } else if (EditPanelTab.this.scaleVoiceVolume.equals(scale)) {
                    EditPanelTab.this.modifyMultiVolume = true;
                    EditPanelTab.this.scaleVoiceVolume.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(22));
                }
            }
        }
    }

    class TimeSSNumCheck
    extends AbstructNumCheckListener {
        TimeSSNumCheck() {
        }

        @Override
        void additionalCheck(Event e, int val) {
            if (e.start == 0) {
                int limit = 5;
                if (e.end >= 1) {
                    limit = 59;
                }
                if (EditPanelTab.this.textStartTimeSS.getText().length() > 0 && val > limit) {
                    e.doit = false;
                }
            } else if (e.start == 1 && Integer.parseInt(EditPanelTab.this.textStartTimeSS.getText()) > 5) {
                e.doit = false;
            }
        }
    }

    class descriptionModifyListener
    implements Listener {
        descriptionModifyListener() {
        }

        public void handleEvent(Event e) {
            if (!EditPanelTab.this.currentEditDescription && !EditPanelTab.this.currentStatAppend) {
                EditPanelTab.this.currentEditDescription = true;
                EditPanelTab.this.setVisibleAppend(true, false);
                EditPanelTab.this.setVisibleDelete(false);
                EditPanelTab.this.setVisibleCancel(true);
                EditPanelTab.this.setVisiblePreview(true);
            }
        }
    }
}

