/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash;

import com.ibm.icu.text.MessageFormat;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.actf.model.flash.ASAccInfo;
import org.eclipse.actf.model.flash.IASNode;
import org.eclipse.actf.model.flash.IFlashConst;
import org.eclipse.actf.model.flash.IFlashPlayer;
import org.eclipse.actf.model.flash.as.ASObject;
import org.eclipse.actf.model.internal.flash.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASNodeImplV9
implements IFlashConst,
IASNode {
    private static final String LEVEL0_FOCUS_MANAGER = "_level0.focusManager";
    private static final String LEVEL0_RESERVED = "_level0.reserved";
    private IFlashPlayer player;
    private ASObject asObject;
    private IASNode parent;
    private int level;
    private int id;
    private ASAccInfo accInfo;
    private boolean isReference = false;
    private boolean skipChildren = false;
    private boolean isAccProperties = false;
    private Boolean hasOnRelease;
    private String strIconType = "others";
    private String strType;
    private String strClassName;
    private String strObjectName;
    private String strTarget;
    private boolean isUIComponent;

    public ASNodeImplV9(IASNode iASNode, IFlashPlayer iFlashPlayer, ASObject aSObject) {
        this.parent = iASNode;
        this.level = iASNode != null ? iASNode.getLevel() + 1 : 0;
        this.player = iFlashPlayer;
        this.asObject = aSObject;
        this.strType = this.getString("type");
        this.strClassName = this.getString("className");
        this.strObjectName = this.getString("objectName");
        this.strTarget = this.getString("target");
        Object object = this.asObject.get("id");
        this.id = object instanceof Integer ? (Integer)object : -1;
        this.isUIComponent = "true".equals(this.getString("isUIComponent"));
        if (iASNode != null) {
            String string;
            String string2 = iASNode.getTarget();
            if (string2 != null && !this.strTarget.equals(String.valueOf(string2) + "." + this.strObjectName)) {
                this.isReference = true;
            }
            if ("_accProps".equals(string = iASNode.getObjectName()) || "_accImpl".equals(string)) {
                this.isAccProperties = true;
            }
        }
        if ("number".equals(this.strType) || "null".equals(this.strType) || "boolean".equals(this.strType) || "string".equals(this.strType) || "undefined".equals(this.strType)) {
            this.skipChildren = true;
        } else if ("object".equals(this.strType)) {
            if (this.strClassName == null || "Array".equals(this.strClassName)) {
                this.skipChildren = true;
            }
        } else if ("movieclip".equals(this.strType) && (LEVEL0_RESERVED.equals(this.strTarget) || LEVEL0_FOCUS_MANAGER.equals(this.strTarget))) {
            this.skipChildren = true;
        }
        this.accInfo = ASAccInfo.create(this.asObject);
        this.initIconType();
    }

    private void initIconType() {
        if ("movieclip".equals(this.strType)) {
            int n;
            this.strIconType = this.strType;
            if (this.accInfo != null && -1 != (n = this.accInfo.getRole())) {
                this.strIconType = "accrole_" + n;
                return;
            }
            if (this.hasOnRelease()) {
                this.strIconType = "Button";
            }
        } else if ("object".equals(this.strType)) {
            this.strIconType = this.strType;
            if ("Button".equals(this.strClassName)) {
                this.strIconType = "Button";
            } else if (this.strClassName.startsWith("TextField")) {
                this.strIconType = "text";
            } else if ("_accImpl".equals(this.strObjectName) || "_accProps".equals(this.strObjectName)) {
                this.strIconType = "accprops";
            }
        } else if ("function".equals(this.strType) || "string".equals(this.strType)) {
            this.strIconType = this.strType;
        } else if ("number".equals(this.strType) || "null".equals(this.strType) || "boolean".equals(this.strType) || "undefined".equals(this.strType)) {
            this.strIconType = "variable";
        } else if ("displayobject".equals(this.strType)) {
            if (this.strClassName.contains("TextField")) {
                this.strIconType = "text";
            } else if (this.strClassName.contains("mx.controls::RichTextEditor") || this.strClassName.contains("mx.controls::DateChooser")) {
                this.strIconType = "accrole_9";
            } else if (this.strClassName.contains("mx.controls::Shape")) {
                this.strIconType = "accrole_40";
            } else if (this.strClassName.contains("AVM1Movie")) {
                this.strIconType = "movieclip";
            } else if (this.strClassName.contains("Bitmap")) {
                this.strIconType = "Image";
            } else if (this.strClassName.contains("SimpleButton")) {
                this.strIconType = "Button";
            } else if (this.strClassName.contains("mx.controls::Text") || this.strClassName.contains("flash.text::StaticText")) {
                this.strIconType = "accrole_41";
            } else if (this.strClassName.contains("CheckBox")) {
                this.strIconType = "CheckBox";
            } else if (this.strClassName.contains("ComboBox") || this.strClassName.contains("mx.controls::DateField")) {
                this.strIconType = "ComboBox";
            } else if (this.strClassName.contains("DataGridHeader")) {
                this.strIconType = "accrole_26";
            } else if (this.strClassName.contains("mx.controls::DataGrid")) {
                this.strIconType = "DataGrid";
            } else if (this.strClassName.contains("ScrollBar")) {
                this.strIconType = "ScrollBar";
            } else if (this.strClassName.contains("Slider")) {
                this.strIconType = "Slider";
            } else if (this.strClassName.contains("Image")) {
                this.strIconType = "Image";
            } else if (this.strClassName.contains("Label")) {
                this.strIconType = "Label";
            } else if (this.strClassName.contains("ListItem")) {
                this.strIconType = "accrole_34";
            } else if (this.strClassName.contains("List")) {
                this.strIconType = "List";
            } else if (this.strClassName.contains("ProgressBar")) {
                this.strIconType = "ProgressBar";
            } else if (this.strClassName.contains("TreeItem")) {
                this.strIconType = "accrole_36";
            } else if (this.strClassName.contains("Tree")) {
                this.strIconType = "Tree";
            } else if (this.strClassName.contains("SWFLoader")) {
                this.strIconType = "movieclip";
            } else if (this.strClassName.contains("Loader")) {
                this.strIconType = "movieclip";
            } else if (this.strClassName.contains("RadioButton")) {
                this.strIconType = "RadioButton";
            } else if (this.strClassName.contains("mx.containers::HBox") || this.strClassName.contains("mx.containers::VBox") || this.strClassName.contains("mx.controls::Spacer")) {
                this.strIconType = "accrole_10";
            } else if (this.strClassName.contains("Button")) {
                this.strIconType = "Button";
            } else {
                int n;
                this.strIconType = this.isUIComponent ? "component" : "component";
                if (this.accInfo != null && -1 != (n = this.accInfo.getRole())) {
                    this.strIconType = "accrole_" + n;
                    return;
                }
                if (this.hasOnRelease()) {
                    this.strIconType = "Button";
                }
            }
        }
    }

    @Override
    public String getType() {
        return this.strType;
    }

    @Override
    public String getClassName() {
        return this.strClassName;
    }

    @Override
    public String getObjectName() {
        return this.strObjectName;
    }

    @Override
    public String getTarget() {
        return this.strTarget;
    }

    @Override
    public boolean isUIComponent() {
        return this.isUIComponent;
    }

    @Override
    public String getValue() {
        if (this.asObject != null) {
            return this.decodeString(this.getString("value"));
        }
        return null;
    }

    @Override
    public String getText() {
        return this.getText(true);
    }

    @Override
    public String getText(boolean bl) {
        String string = null;
        if (bl && this.accInfo != null) {
            string = this.accInfo.getName();
        }
        if (string == null) {
            if (this.asObject != null) {
                string = this.getString("text");
            }
        } else {
            string = "[" + string + "]";
        }
        return this.decodeString(string);
    }

    @Override
    public String getTitle() {
        if (this.asObject != null) {
            return this.decodeString(this.getString("title"));
        }
        return null;
    }

    private String getString(String string) {
        if (this.asObject != null) {
            Object object = this.asObject.get(string);
            return object == null ? null : object.toString();
        }
        return null;
    }

    private Number getNumber(String string) {
        if (this.asObject != null) {
            Object object = this.asObject.get(string);
            if (object == null) {
                return null;
            }
            if (object instanceof Number) {
                return (Number)object;
            }
            return null;
        }
        return null;
    }

    @Override
    public Object getObject(String string) {
        if (this.asObject != null) {
            return this.asObject.get(string);
        }
        return null;
    }

    private String decodeString(String string) {
        if (string != null) {
            try {
                return URLDecoder.decode(string, "UTF-8");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string;
    }

    private double getDoubleValue(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return Double.NaN;
    }

    @Override
    public IASNode getParent() {
        return this.parent;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    private boolean shouldSkip() {
        return this.skipChildren && !this.isAccProperties || this.isReference;
    }

    @Override
    public boolean isAccProperties() {
        return this.isAccProperties;
    }

    @Override
    public boolean hasChild(boolean bl) {
        return this.hasChild(bl, false);
    }

    @Override
    public boolean hasChild(boolean bl, boolean bl2) {
        if (this.level >= 50) {
            throw new Error(String.valueOf(MessageFormat.format((String)Messages.flash_error_target_length, (Object[])new Object[]{new Integer(this.level)})) + "\n" + this.strTarget);
        }
        return this.player.hasChild(this, bl, bl2);
    }

    @Override
    public IASNode[] getChildren(boolean bl) {
        return this.getChildren(bl, false);
    }

    @Override
    public IASNode[] getEntireChildren() {
        return this.getChildren(false, true);
    }

    private IASNode[] getChildren(boolean bl, boolean bl2) {
        IASNode[] iASNodeArray = this.player.getChildren(this, bl, bl2);
        ArrayList<ASNodeImplV9> arrayList = new ArrayList<ASNodeImplV9>();
        IASNode[] iASNodeArray2 = iASNodeArray;
        int n = iASNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASNode iASNode = iASNodeArray2[n2];
            if (iASNode instanceof ASNodeImplV9) {
                ASNodeImplV9 aSNodeImplV9 = (ASNodeImplV9)iASNode;
                if (bl2 || bl || !aSNodeImplV9.shouldSkip()) {
                    arrayList.add(aSNodeImplV9);
                }
            }
            ++n2;
        }
        return arrayList.toArray(new IASNode[arrayList.size()]);
    }

    @Override
    public boolean setMarker() {
        if (this.asObject != null) {
            try {
                return this.player.setMarker(this.getNumber("x"), this.getNumber("y"), this.getNumber("w"), this.getNumber("h"));
            }
            catch (Exception exception) {}
        }
        return false;
    }

    @Override
    public IFlashPlayer getPlayer() {
        return this.player;
    }

    @Override
    public ASAccInfo getAccInfo() {
        return this.accInfo;
    }

    @Override
    public Set<String> getKeys() {
        if (this.asObject != null) {
            return this.asObject.getKeys();
        }
        return null;
    }

    @Override
    public boolean hasOnRelease() {
        if (this.hasOnRelease == null) {
            IASNode iASNode = this.player.getNodeFromPath(String.valueOf(this.strTarget) + ".onRelease");
            this.hasOnRelease = iASNode != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.hasOnRelease;
    }

    @Override
    public double getX() {
        return this.getDoubleValue(this.asObject.get("x"));
    }

    @Override
    public double getY() {
        return this.getDoubleValue(this.asObject.get("y"));
    }

    @Override
    public double getWidth() {
        return this.getDoubleValue(this.asObject.get("w"));
    }

    @Override
    public double getHeight() {
        return this.getDoubleValue(this.asObject.get("h"));
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getDepth() {
        Integer n = (Integer)this.asObject.get("depth");
        if (n != null) {
            return n;
        }
        return -16384;
    }

    @Override
    public int getCurrentFrame() {
        Integer n = (Integer)this.asObject.get("currentFrame");
        if (n != null) {
            return n;
        }
        return -1;
    }

    @Override
    public boolean isInputable() {
        Boolean bl = (Boolean)this.asObject.get("isInputable");
        if (bl == null) {
            return false;
        }
        return bl;
    }

    @Override
    public boolean isOpaqueObject() {
        Boolean bl = (Boolean)this.asObject.get("isOpaqueObject");
        if (bl == null) {
            return false;
        }
        return bl;
    }

    @Override
    public int getTabIndex() {
        Number number = this.getNumber("tabIndex");
        if (number == null) {
            return -1;
        }
        return number.intValue();
    }

    @Override
    public String getIconType() {
        return this.strIconType;
    }
}

