/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui.editor.dialogs;

import java.util.Map;
import org.eclipse.actf.model.internal.ui.editor.dialogs.FavoritesAddDialog;
import org.eclipse.actf.model.ui.util.ModelServiceMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FavoritesArrangeDialog
extends Dialog {
    private Map<String, String> _favoritesMap;
    private boolean modified = false;

    public FavoritesArrangeDialog(Shell shell, Map<String, String> map) {
        super(shell);
        this._favoritesMap = map;
    }

    protected Control createDialogArea(Composite composite) {
        String string2;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        final Table table = new Table(composite2, 67586);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 100;
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] stringArray = new String[]{ModelServiceMessages.DialogConst_Name_Label, "URL: "};
        TableColumn tableColumn = new TableColumn(table, 1);
        tableColumn.setText(stringArray[0]);
        tableColumn.setWidth(200);
        tableColumn = new TableColumn(table, 1);
        tableColumn.setText(stringArray[1]);
        tableColumn.setWidth(300);
        for (String string2 : this._favoritesMap.keySet()) {
            TableItem tableItem = new TableItem(table, 0);
            tableItem.setText(0, string2);
            tableItem.setText(1, this._favoritesMap.get(string2));
        }
        string2 = new Button(composite2, 8);
        string2.setText(ModelServiceMessages.DialogArrangeFavorite_Modify_Name);
        string2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (table.getSelectionCount() > 0) {
                    String string = table.getSelection()[0].getText(0);
                    FavoritesAddDialog favoritesAddDialog = new FavoritesAddDialog(FavoritesArrangeDialog.this.getShell(), FavoritesArrangeDialog.this._favoritesMap, string);
                    int n = favoritesAddDialog.open();
                    String string2 = favoritesAddDialog.getName();
                    if (n == 0 && !string2.equals(string)) {
                        table.getSelection()[0].setText(0, string2);
                        FavoritesArrangeDialog.this._favoritesMap.put(string2, (String)FavoritesArrangeDialog.this._favoritesMap.get(string));
                        FavoritesArrangeDialog.this._favoritesMap.remove(string);
                        FavoritesArrangeDialog.this.modified = true;
                    }
                }
            }
        });
        string2 = new Button(composite2, 8);
        string2.setText(ModelServiceMessages.DialogArrangeFavorite_Delete);
        string2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (table.getSelectionCount() > 0) {
                    TableItem[] tableItemArray = table.getSelection();
                    int n = 0;
                    while (n < tableItemArray.length) {
                        FavoritesArrangeDialog.this._favoritesMap.remove(tableItemArray[n].getText(0));
                        ++n;
                    }
                    table.remove(table.getSelectionIndices());
                    FavoritesArrangeDialog.this.modified = true;
                }
            }
        });
        return composite2;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ModelServiceMessages.DialogArrangeFavorite_Title);
    }

    public Map<String, String> getFavoritesMap() {
        return this._favoritesMap;
    }

    public boolean isModified() {
        return this.modified;
    }
}

