/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.httpproxy.core.IMessageBody;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessage;

public abstract class HTTPResponseMessage
extends HTTPMessage
implements IHTTPResponseMessage {
    private static final byte[] STATUS_NO_CONTENT_A = "204".getBytes();
    private static final byte[] STATUS_NOT_MODIFIED_A = "304".getBytes();
    private static final int WRITEBODY_DEFAULT_WAIT_DENOM = 10;

    protected HTTPResponseMessage(long l) {
        super(l);
    }

    protected boolean isBodyEmpty() {
        byte[] byArray = this.getStatusCodeAsBytes();
        return Arrays.equals(byArray, STATUS_NO_CONTENT_A) || Arrays.equals(byArray, STATUS_NOT_MODIFIED_A);
    }

    public abstract String getStatusCodeAsString();

    public abstract byte[] getStatusCodeAsBytes();

    public abstract String getReasonPhraseAsString();

    public abstract byte[] getReasonPhraseAsBytes();

    protected void writeBodyWithoutContentLength(long l, IMessageBody iMessageBody, OutputStream outputStream) throws IOException {
        if (this.isConnectionToBeClosed()) {
            int n;
            InputStream inputStream = iMessageBody.getMessageBodyInputStream();
            while ((n = inputStream.read()) >= 0) {
                outputStream.write(n);
            }
        } else {
            InputStream inputStream = iMessageBody.getMessageBodyTimeoutInputStream();
            long l2 = l / 10L;
            if (LOGGER.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("keepAliveTimeout=" + l2 + " ms");
                LOGGER.debug(stringBuffer.toString());
                System.out.println(stringBuffer.toString());
            }
            long l3 = System.currentTimeMillis();
            long l4 = System.currentTimeMillis();
            while (System.currentTimeMillis() - l4 < l2) {
                int n;
                try {
                    n = inputStream.read();
                    if (n < 0) break;
                    l4 = System.currentTimeMillis();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    continue;
                }
                outputStream.write(n);
            }
            if (LOGGER.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("elapsed " + (System.currentTimeMillis() - l3) + " ms");
                LOGGER.debug(stringBuffer.toString());
                System.out.println(stringBuffer.toString());
            }
        }
    }
}

