/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.accservice.swtbridge.internal;

import java.util.HashMap;
import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.IAccessible;
import org.eclipse.actf.accservice.swtbridge.IServiceProvider;
import org.eclipse.actf.accservice.swtbridge.MSAA;
import org.eclipse.actf.accservice.swtbridge.ia2.Accessible2;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleAction;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleApplication;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleComponent;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleEditableText;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleHyperlink;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleHypertext;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleImage;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleTable;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleText;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleValue;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessible2;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleAction;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleApplication;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleComponent;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleEditableText;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleHyperlink;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleHypertext;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleImage;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleTable;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleText;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleValue;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessible2;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleAction;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleApplication;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleComponent;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleEditableText;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleHyperlink;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleHypertext;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleImage;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleTable;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleText;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleValue;
import org.eclipse.actf.util.win32.NativeIntAccess;
import org.eclipse.actf.util.win32.NativeStringAccess;
import org.eclipse.actf.util.win32.NativeVariantAccess;
import org.eclipse.actf.util.win32.WindowUtil;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.ole.win32.Variant;

public class InternalAccessibleObject
implements AccessibleObject {
    private InternalAccessibleObject parent = null;
    private Variant varChildIndex = null;
    private IAccessible iAccessible = null;
    private Accessible2 accessible2 = null;
    private AccessibleAction accessibleAction = null;
    private AccessibleApplication accessibleApplication = null;
    private AccessibleComponent accessibleComponent = null;
    private AccessibleEditableText accessibleEditableText = null;
    private AccessibleHyperlink accessibleHyperlink = null;
    private AccessibleHypertext accessibleHypertext = null;
    private AccessibleImage accessibleImage = null;
    private AccessibleTable accessibleTable = null;
    private AccessibleText accessibleText = null;
    private AccessibleValue accessibleValue = null;
    private HashMap<String, InternalAccessibleObject> childMap = new HashMap();
    private InternalAccessibleObject[] cachedChildren = new InternalAccessibleObject[0];
    private boolean disposed = false;
    private int accRole;
    private int ia1Role;
    private int ia2Role;
    private int accWindow;
    private String strClassName;
    private static final String STR_NULL = null;

    private InternalAccessibleObject(int n) {
        this(null, new Variant(new IDispatch(n)));
    }

    public InternalAccessibleObject(InternalAccessibleObject internalAccessibleObject, Variant variant) {
        this.parent = internalAccessibleObject;
        this.varChildIndex = variant;
        switch (variant.getType()) {
            case 3: {
                variant = internalAccessibleObject.getAccChild(variant);
                if (variant == null || 9 != variant.getType()) break;
            }
            case 9: {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                if (variant.getDispatch().QueryInterface(IServiceProvider.IID, nArray2) == 0) {
                    IServiceProvider iServiceProvider = new IServiceProvider(nArray2[0]);
                    try {
                        if (iServiceProvider.QueryService(IAccessible.IID, IAccessible2.IID, nArray) == 0) {
                            this.iAccessible = new IAccessible2(nArray[0]);
                            this.iAccessible.AddRef();
                            this.accessible2 = new InternalAccessible2((IAccessible2)this.iAccessible);
                            if (iServiceProvider.QueryService(IAccessible.IID, IAccessibleAction.IID, nArray) == 0) {
                                this.accessibleAction = new InternalAccessibleAction(nArray[0]);
                            }
                            if (iServiceProvider.QueryService(IAccessible.IID, IAccessibleApplication.IID, nArray) == 0) {
                                this.accessibleApplication = new InternalAccessibleApplication(nArray[0]);
                            }
                            if (iServiceProvider.QueryService(IAccessible.IID, IAccessibleComponent.IID, nArray) == 0) {
                                this.accessibleComponent = new InternalAccessibleComponent(nArray[0]);
                            }
                            if (iServiceProvider.QueryService(IAccessible.IID, IAccessibleEditableText.IID, nArray) == 0) {
                                this.accessibleEditableText = new InternalAccessibleEditableText(nArray[0]);
                            }
                            if (iServiceProvider.QueryService(IAccessible.IID, IAccessibleHyperlink.IID, nArray) == 0) {
                                this.accessibleHyperlink = new InternalAccessibleHyperlink(nArray[0]);
                            }
                            if (iServiceProvider.QueryService(IAccessible.IID, IAccessibleHypertext.IID, nArray) == 0) {
                                this.accessibleHypertext = new InternalAccessibleHypertext(nArray[0]);
                            }
                            if (iServiceProvider.QueryService(IAccessible.IID, IAccessibleImage.IID, nArray) == 0) {
                                this.accessibleImage = new InternalAccessibleImage(nArray[0]);
                            }
                            if (iServiceProvider.QueryService(IAccessible.IID, IAccessibleTable.IID, nArray) == 0) {
                                this.accessibleTable = new InternalAccessibleTable(nArray[0]);
                            }
                            if (iServiceProvider.QueryService(IAccessible.IID, IAccessibleText.IID, nArray) == 0) {
                                this.accessibleText = new InternalAccessibleText(nArray[0]);
                            }
                            if (iServiceProvider.QueryService(IAccessible.IID, IAccessibleValue.IID, nArray) == 0) {
                                this.accessibleValue = new InternalAccessibleValue(nArray[0]);
                            }
                        } else if (iServiceProvider.QueryService(IAccessible.IID, IAccessible.IID, nArray) == 0) {
                            this.iAccessible = new IAccessible(nArray[0]);
                            this.iAccessible.AddRef();
                        }
                    }
                    finally {
                        iServiceProvider.Release();
                    }
                }
                if (this.iAccessible == null) {
                    if (variant.getDispatch().QueryInterface(IAccessible.IID, nArray) == 0) {
                        this.iAccessible = new IAccessible(nArray[0]);
                        this.iAccessible.AddRef();
                    } else {
                        System.out.println("Error: Can not get IAccessible");
                    }
                }
                this.varChildIndex = new Variant(0);
                variant.dispose();
            }
        }
        this.reset();
    }

    public void reset() {
        this.disposeChildren();
        NativeVariantAccess nativeVariantAccess = new NativeVariantAccess();
        try {
            if (this.getIAccessible().get_accRole(3, 0, this.varChildIndex.getInt(), 0, nativeVariantAccess.getAddress()) == 0) {
                this.accRole = nativeVariantAccess.getInt();
            }
        }
        finally {
            nativeVariantAccess.dispose();
        }
        this.accWindow = -1;
        this.strClassName = null;
        this.ia1Role = this.accRole;
        this.ia2Role = -1;
        Accessible2 accessible2 = this.getAccessible2();
        if (accessible2 != null) {
            this.ia2Role = this.accRole = accessible2.getAccessibleRole();
        }
    }

    public void dispose() throws Exception {
        if (this.disposed) {
            throw new Exception("Already disposed");
        }
        this.disposed = true;
        this.disposeChildren();
        if (this.iAccessible != null) {
            this.iAccessible.Release();
            this.iAccessible = null;
        }
        if (this.accessible2 != null) {
            this.accessible2.dispose();
            this.accessible2 = null;
        }
        if (this.accessibleAction != null) {
            this.accessibleAction.dispose();
            this.accessibleAction = null;
        }
        if (this.accessibleApplication != null) {
            this.accessibleApplication.dispose();
            this.accessibleApplication = null;
        }
        if (this.accessibleComponent != null) {
            this.accessibleComponent.dispose();
            this.accessibleComponent = null;
        }
        if (this.accessibleEditableText != null) {
            this.accessibleEditableText.dispose();
            this.accessibleEditableText = null;
        }
        if (this.accessibleHyperlink != null) {
            this.accessibleHyperlink.dispose();
            this.accessibleHyperlink = null;
        }
        if (this.accessibleHypertext != null) {
            this.accessibleHypertext.dispose();
            this.accessibleHypertext = null;
        }
        if (this.accessibleImage != null) {
            this.accessibleImage.dispose();
            this.accessibleImage = null;
        }
        if (this.accessibleTable != null) {
            this.accessibleTable.dispose();
            this.accessibleTable = null;
        }
        if (this.accessibleText != null) {
            this.accessibleText.dispose();
            this.accessibleText = null;
        }
        if (this.accessibleValue != null) {
            this.accessibleValue.dispose();
            this.accessibleValue = null;
        }
        if (this.varChildIndex != null) {
            this.varChildIndex.dispose();
            this.varChildIndex = null;
        }
        if (this.parent != null) {
            this.parent.removeChildObject(this);
        }
    }

    private void disposeChildren() {
        this.cachedChildren = new InternalAccessibleObject[0];
        InternalAccessibleObject[] internalAccessibleObjectArray = this.childMap.values().toArray(new InternalAccessibleObject[this.childMap.size()]);
        int n = 0;
        while (n < internalAccessibleObjectArray.length) {
            try {
                internalAccessibleObjectArray[n].dispose();
            }
            catch (Exception exception) {}
            ++n;
        }
    }

    public static AccessibleObject getAccessibleObjectFromPoint(Point point) {
        int[] nArray = new int[1];
        int n = MSAA.getAccessibleObjectFromPoint(point, nArray);
        return InternalAccessibleObject.newInstance(n, nArray[0]);
    }

    public static AccessibleObject getAccessibleObjectFromWindow(int n) {
        int n2 = MSAA.AccessibleObjectFromWindow(n);
        return InternalAccessibleObject.newInstance(n2);
    }

    public static AccessibleObject getAccessibleObjectFromEvent(int n, int n2, int n3) {
        int[] nArray = new int[1];
        int n4 = MSAA.getAccessibleObjectFromEvent(n, n2, n3, nArray);
        return InternalAccessibleObject.newInstance(n4, nArray[0]);
    }

    public static AccessibleObject newInstance(int n) {
        if (n == 0) {
            return null;
        }
        return new InternalAccessibleObject(n);
    }

    private static AccessibleObject newInstance(int n, int n2) {
        AccessibleObject accessibleObject = InternalAccessibleObject.newInstance(n);
        if (accessibleObject != null && n2 != 0) {
            return ((InternalAccessibleObject)accessibleObject).getChildObject(new Variant(n2));
        }
        return accessibleObject;
    }

    public AccessibleObject getCachedParent() {
        return this.parent;
    }

    public AccessibleObject[] getCachedChildren() {
        return this.cachedChildren;
    }

    public AccessibleObject[] getChildren() {
        int n = Math.max(0, this.getChildCount());
        if (n == this.cachedChildren.length) {
            return this.cachedChildren;
        }
        if (n > 32768) {
            System.err.println("Too many children(" + n + "), we don't fectch.");
            if (this.accessibleTable != null) {
                int n2 = this.accessibleTable.getAccessibleRowCount();
                int n3 = this.accessibleTable.getAccessibleColumnCount();
                if (65536 == n2 && 256 == n3) {
                    if (256 == this.cachedChildren.length) {
                        return this.cachedChildren;
                    }
                    this.cachedChildren = new InternalAccessibleObject[256];
                    int n4 = 0;
                    while (n4 < 16) {
                        int n5 = 0;
                        while (n5 < 16) {
                            InternalAccessibleObject internalAccessibleObject = (InternalAccessibleObject)this.accessibleTable.getAccessibleCellAt(n4, n5);
                            internalAccessibleObject.parent = this;
                            this.cachedChildren[n4 * 16 + n5] = internalAccessibleObject;
                            ++n5;
                        }
                        ++n4;
                    }
                    System.err.println("getChildren() returned 256(16x16) table cells.");
                    return this.cachedChildren;
                }
            }
            return new InternalAccessibleObject[0];
        }
        this.cachedChildren = new InternalAccessibleObject[n];
        if (n > 0) {
            Variant[] variantArray = new Variant[n];
            MSAA.getAccessibleChildren(this.getIAccessible().getAddress(), variantArray);
            int n6 = 0;
            while (n6 < n) {
                if (variantArray[n6] != null) {
                    this.cachedChildren[n6] = this.getChildObject(variantArray[n6]);
                }
                ++n6;
            }
        }
        return this.cachedChildren;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getChildCount() {
        try {
            if (this.varChildIndex.getInt() != 0) return 0;
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.getIAccessible().get_accChildCount(nativeIntAccess.getAddress()) != 0) return 0;
                int n = nativeIntAccess.getInt();
                return n;
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        catch (Exception exception) {}
        return 0;
    }

    public int getWindow() {
        if (-1 == this.accWindow) {
            try {
                this.accWindow = MSAA.WindowFromAccessibleObject(this.getIAccessible().getAddress());
            }
            catch (Exception exception) {
                this.accWindow = 0;
            }
        }
        return this.accWindow;
    }

    public int getAccRole() {
        return this.accRole;
    }

    public String getRoleText() {
        block5: {
            if (-1 == this.accRole) {
                NativeVariantAccess nativeVariantAccess = new NativeVariantAccess();
                try {
                    if (this.getIAccessible().get_accRole(3, 0, this.varChildIndex.getInt(), 0, nativeVariantAccess.getAddress()) == 0) {
                        String string = nativeVariantAccess.getString();
                        return string;
                    }
                    break block5;
                }
                finally {
                    nativeVariantAccess.dispose();
                }
            }
            return MSAA.getRoleText(this.accRole);
        }
        return STR_NULL;
    }

    public String getClassName() {
        if (this.strClassName == null) {
            int n = this.getWindow();
            this.strClassName = STR_NULL;
            if (n != 0) {
                this.strClassName = WindowUtil.GetWindowClassName((int)n);
            }
        }
        return this.strClassName;
    }

    public int getAccState() {
        NativeVariantAccess nativeVariantAccess = new NativeVariantAccess();
        try {
            if (this.getIAccessible().get_accState(3, 0, this.varChildIndex.getInt(), 0, nativeVariantAccess.getAddress()) == 0) {
                int n = nativeVariantAccess.getInt();
                return n;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nativeVariantAccess.dispose();
        }
        return 0;
    }

    public String getAccName() {
        NativeStringAccess nativeStringAccess = new NativeStringAccess();
        try {
            if (this.getIAccessible().get_accName(3, 0, this.varChildIndex.getInt(), 0, nativeStringAccess.getAddress()) == 0) {
                String string = nativeStringAccess.getString();
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nativeStringAccess.dispose();
        }
        return STR_NULL;
    }

    public String getAccValue() {
        NativeStringAccess nativeStringAccess = new NativeStringAccess();
        try {
            if (this.getIAccessible().get_accValue(3, 0, this.varChildIndex.getInt(), 0, nativeStringAccess.getAddress()) == 0) {
                String string = nativeStringAccess.getString();
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nativeStringAccess.dispose();
        }
        return STR_NULL;
    }

    public String getAccDescription() {
        NativeStringAccess nativeStringAccess = new NativeStringAccess();
        try {
            if (this.getIAccessible().get_accDescription(3, 0, this.varChildIndex.getInt(), 0, nativeStringAccess.getAddress()) == 0) {
                String string = nativeStringAccess.getString();
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nativeStringAccess.dispose();
        }
        return STR_NULL;
    }

    public String getAccHelp() {
        NativeStringAccess nativeStringAccess = new NativeStringAccess();
        try {
            if (this.getIAccessible().get_accHelp(3, 0, this.varChildIndex.getInt(), 0, nativeStringAccess.getAddress()) == 0) {
                String string = nativeStringAccess.getString();
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nativeStringAccess.dispose();
        }
        return STR_NULL;
    }

    public String getAccKeyboardShortcut() {
        NativeStringAccess nativeStringAccess = new NativeStringAccess();
        try {
            if (this.getIAccessible().get_accKeyboardShortcut(3, 0, this.varChildIndex.getInt(), 0, nativeStringAccess.getAddress()) == 0) {
                String string = nativeStringAccess.getString();
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nativeStringAccess.dispose();
        }
        return STR_NULL;
    }

    public String getAccDefaultAction() {
        NativeStringAccess nativeStringAccess = new NativeStringAccess();
        try {
            if (this.getIAccessible().get_accDefaultAction(3, 0, this.varChildIndex.getInt(), 0, nativeStringAccess.getAddress()) == 0) {
                String string = nativeStringAccess.getString();
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nativeStringAccess.dispose();
        }
        return STR_NULL;
    }

    public boolean getAccHelpTopic(int[] nArray, String[] stringArray) {
        NativeStringAccess nativeStringAccess = new NativeStringAccess();
        NativeIntAccess nativeIntAccess = new NativeIntAccess();
        try {
            if (this.getIAccessible().get_accHelpTopic(nativeStringAccess.getAddress(), 3, 0, this.varChildIndex.getInt(), 0, nativeIntAccess.getAddress()) == 0) {
                nArray[0] = nativeIntAccess.getInt();
                stringArray[0] = nativeStringAccess.getString();
                return true;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nativeIntAccess.dispose();
            nativeStringAccess.dispose();
        }
        return false;
    }

    public Rectangle getAccLocation() {
        if (this.disposed) {
            return null;
        }
        NativeIntAccess nativeIntAccess = new NativeIntAccess(4);
        try {
            if (this.getIAccessible().accLocation(nativeIntAccess.getAddress(0), nativeIntAccess.getAddress(1), nativeIntAccess.getAddress(2), nativeIntAccess.getAddress(3), 3, 0, this.varChildIndex.getInt(), 0) == 0) {
                Rectangle rectangle = new Rectangle(nativeIntAccess.getInt(0), nativeIntAccess.getInt(1), nativeIntAccess.getInt(2), nativeIntAccess.getInt(3));
                return rectangle;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nativeIntAccess.dispose();
        }
        return null;
    }

    public boolean doDefaultAction() {
        return this.getIAccessible().accDoDefaultAction(3, 0, this.varChildIndex.getInt(), 0) == 0;
    }

    public boolean select(int n) {
        return this.getIAccessible().accSelect(n, 3, 0, this.varChildIndex.getInt(), 0) == 0;
    }

    public boolean setAccName(String string) {
        NativeStringAccess nativeStringAccess = new NativeStringAccess();
        try {
            nativeStringAccess.setString(string);
            boolean bl = this.getIAccessible().put_accName(3, 0, this.varChildIndex.getInt(), 0, nativeStringAccess.getAddress()) == 0;
            return bl;
        }
        finally {
            nativeStringAccess.dispose();
        }
    }

    public boolean setAccValue(String string) {
        NativeStringAccess nativeStringAccess = new NativeStringAccess();
        try {
            nativeStringAccess.setString(string);
            boolean bl = this.getIAccessible().put_accValue(3, 0, this.varChildIndex.getInt(), 0, nativeStringAccess.getAddress()) == 0;
            return bl;
        }
        finally {
            nativeStringAccess.dispose();
        }
    }

    public AccessibleObject getAccParent() {
        NativeIntAccess nativeIntAccess = new NativeIntAccess();
        try {
            if (this.getIAccessible().get_accParent(nativeIntAccess.getAddress()) == 0) {
                AccessibleObject accessibleObject = InternalAccessibleObject.newInstance(nativeIntAccess.getInt());
                return accessibleObject;
            }
        }
        finally {
            nativeIntAccess.dispose();
        }
        return null;
    }

    private Variant getAccChild(Variant variant) {
        NativeIntAccess nativeIntAccess = new NativeIntAccess();
        try {
            if (this.getIAccessible().get_accChild(3, 0, variant.getInt(), 0, nativeIntAccess.getAddress()) == 0) {
                Variant variant2 = new Variant(new IDispatch(nativeIntAccess.getInt()));
                return variant2;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nativeIntAccess.dispose();
        }
        return null;
    }

    public IAccessible getIAccessible() {
        if (this.iAccessible != null) {
            return this.iAccessible;
        }
        if (this.parent != null) {
            return this.parent.getIAccessible();
        }
        return null;
    }

    public Accessible2 getAccessible2() {
        if (this.accessible2 != null) {
            return this.accessible2;
        }
        if (this.parent != null) {
            return this.parent.getAccessible2();
        }
        return null;
    }

    public AccessibleAction getAccessibleAction() {
        if (this.accessibleAction != null) {
            return this.accessibleAction;
        }
        if (this.parent != null) {
            return this.parent.getAccessibleAction();
        }
        return null;
    }

    public AccessibleApplication getAccessibleApplication() {
        if (this.accessibleApplication != null) {
            return this.accessibleApplication;
        }
        if (this.parent != null) {
            return this.parent.getAccessibleApplication();
        }
        return null;
    }

    public AccessibleComponent getAccessibleComponent() {
        if (this.accessibleComponent != null) {
            return this.accessibleComponent;
        }
        if (this.parent != null) {
            return this.parent.getAccessibleComponent();
        }
        return null;
    }

    public AccessibleEditableText getAccessibleEditableText() {
        if (this.accessibleEditableText != null) {
            return this.accessibleEditableText;
        }
        if (this.parent != null) {
            return this.parent.getAccessibleEditableText();
        }
        return null;
    }

    public AccessibleHyperlink getAccessibleHyperlink() {
        if (this.accessibleHyperlink != null) {
            return this.accessibleHyperlink;
        }
        if (this.parent != null) {
            return this.parent.getAccessibleHyperlink();
        }
        return null;
    }

    public AccessibleHypertext getAccessibleHypertext() {
        if (this.accessibleHypertext != null) {
            return this.accessibleHypertext;
        }
        if (this.parent != null) {
            return this.parent.getAccessibleHypertext();
        }
        return null;
    }

    public AccessibleImage getAccessibleImage() {
        if (this.accessibleImage != null) {
            return this.accessibleImage;
        }
        if (this.parent != null) {
            return this.parent.getAccessibleImage();
        }
        return null;
    }

    public AccessibleTable getAccessibleTable() {
        if (this.accessibleTable != null) {
            return this.accessibleTable;
        }
        if (this.parent != null) {
            return this.parent.getAccessibleTable();
        }
        return null;
    }

    public AccessibleText getAccessibleText() {
        if (this.accessibleText != null) {
            return this.accessibleText;
        }
        if (this.parent != null) {
            return this.parent.getAccessibleText();
        }
        return null;
    }

    public AccessibleValue getAccessibleValue() {
        if (this.accessibleValue != null) {
            return this.accessibleValue;
        }
        if (this.parent != null) {
            return this.parent.getAccessibleValue();
        }
        return null;
    }

    private InternalAccessibleObject getChildObject(Variant variant) {
        String string = variant.toString();
        InternalAccessibleObject internalAccessibleObject = this.childMap.get(string);
        if (internalAccessibleObject == null) {
            internalAccessibleObject = new InternalAccessibleObject(this, variant);
            this.childMap.put(string, internalAccessibleObject);
            if (internalAccessibleObject.checkInactiveControl()) {
                internalAccessibleObject.reset();
            }
        }
        return internalAccessibleObject;
    }

    private void removeChildObject(InternalAccessibleObject internalAccessibleObject) {
        for (String string : this.childMap.keySet()) {
            if (internalAccessibleObject != this.childMap.get(string)) continue;
            this.childMap.remove(string);
            break;
        }
    }

    private boolean checkInactiveControl() {
        if ("Inactive Control".equals(this.getAccName()) && 43 == this.getAccRole()) {
            return this.doDefaultAction();
        }
        return false;
    }

    protected void finalize() throws Throwable {
        if (!this.disposed) {
            this.dispose();
        }
        super.finalize();
    }

    public String toString() {
        if (this.disposed) {
            return String.valueOf(super.toString()) + " disposed";
        }
        return "AccessibleObject role=" + this.getRoleText() + ", name=" + this.getAccName() + ", state=" + this.getAccState() + ", location=" + this.getAccLocation();
    }

    public int getRealAccRole() {
        return this.ia1Role;
    }

    public String getRealRoleText() {
        block5: {
            if (-1 == this.ia1Role) {
                NativeVariantAccess nativeVariantAccess = new NativeVariantAccess();
                try {
                    if (this.getIAccessible().get_accRole(3, 0, this.varChildIndex.getInt(), 0, nativeVariantAccess.getAddress()) == 0) {
                        String string = nativeVariantAccess.getString();
                        return string;
                    }
                    break block5;
                }
                finally {
                    nativeVariantAccess.dispose();
                }
            }
            return MSAA.getRoleText(this.ia1Role);
        }
        return STR_NULL;
    }

    public Object getAdapter(Class clazz) {
        return Platform.getAdapterManager().getAdapter((Object)this, clazz);
    }

    public int getPtr() {
        return this.getIAccessible().getAddress();
    }
}

