/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind.html.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.actf.visualization.engines.blind.html.IVisualizeMapData;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.IElementViewerInfoProvider;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl.ElementInfoProviderExtension;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualizationAttributeInfo {
    String attributeName;
    String attributeValue;
    String tagName;
    String category = "";
    String helpUrl = "";
    String description = "";
    int nodeId;
    private static IElementViewerInfoProvider[] provider = ElementInfoProviderExtension.getProviders();

    VisualizationAttributeInfo(Element element, IVisualizeMapData iVisualizeMapData, String string) {
        Object object;
        int n;
        this.attributeName = string;
        this.tagName = element.getNodeName();
        this.attributeValue = element.getAttribute(string);
        try {
            this.nodeId = iVisualizeMapData.getIdOfOrigNode(element);
        }
        catch (Exception exception) {
            this.nodeId = -1;
        }
        if (this.attributeName.equalsIgnoreCase("id")) {
            n = 0;
            while (n < provider.length) {
                object = provider[n].getIdInfo(this.attributeValue);
                if (object != null) {
                    this.category = object.getCategory();
                    this.helpUrl = object.getHelpUrl();
                }
                ++n;
            }
        }
        if (this.attributeName.equalsIgnoreCase("accesskey")) {
            n = 0;
            while (n < provider.length) {
                object = provider[n].getAccessKeyInfo(this.attributeValue);
                if (object != null) {
                    this.description = object.getDescription();
                    this.helpUrl = object.getHelpUrl();
                }
                ++n;
            }
            this.attributeValue = "Alt+ " + this.attributeValue;
        }
    }

    public String getAttribtueName() {
        return this.attributeName;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getHelpUrl() {
        return this.helpUrl;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return String.valueOf(this.tagName) + " : " + this.attributeValue + " : " + this.nodeId;
    }

    public static List<VisualizationAttributeInfo> listUp(Document document, IVisualizeMapData iVisualizeMapData, String string) {
        ArrayList<VisualizationAttributeInfo> arrayList = new ArrayList<VisualizationAttributeInfo>();
        NodeList nodeList = document.getElementsByTagName("body");
        if (nodeList.getLength() > 0) {
            Node node = nodeList.item(0);
            Stack<Node> stack = new Stack<Node>();
            while (node != null) {
                Element element;
                if (node.getNodeType() == 1 && (element = (Element)node).hasAttribute(string)) {
                    arrayList.add(new VisualizationAttributeInfo(element, iVisualizeMapData, string));
                }
                if (node.hasChildNodes()) {
                    stack.push(node);
                    node = node.getFirstChild();
                    continue;
                }
                if (node.getNextSibling() != null) {
                    node = node.getNextSibling();
                    continue;
                }
                node = null;
                while (node == null && stack.size() > 0) {
                    node = (Node)stack.pop();
                    node = node.getNextSibling();
                }
            }
        }
        return arrayList;
    }
}

