/*******************************************************************************
 * Copyright (c) 1998, 2008 IBM Corporation and Others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Goh KONDOH - initial API and implementation
 *******************************************************************************/

package org.eclipse.actf.model.internal.dom.sgml.impl;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * This class represents intermediate data of end tag. Instances of this class
 * are used intermediately by parsers, so they are not included in DOM tree
 * generated by parsers.
 */
public class EndTag extends SGMLNode {
	/**
	 * 
	 */
	private static final long serialVersionUID = -733947607719596232L;
	private String tagName;

	EndTag(String name) {
		super(null);
		tagName = name;
	}

	public String getNodeName() {
		return tagName;
	}

	/**
	 * @return always -1
	 */
	public short getNodeType() {
		return -1;
	}

	/**
	 * @return always ""
	 */
	public String getNodeValue() {
		return ""; //$NON-NLS-1$
	}

	/**
	 * does nothing.
	 */
	public void setNodeValue(String value) {
	}

	public String toString() {
		return "</" + tagName + '>'; //$NON-NLS-1$
	}

	public boolean equals(Node node) {
		return node instanceof EndTag
				&& node.getNodeName().equalsIgnoreCase(tagName);
	}

	private Element element;

	/**
	 * Gets an element this end tag closes.
	 * 
	 * @return an element this end tag closes. <code>null</code>if this end
	 *         tag is an error node.
	 */
	public Element getElement() {
		return element;
	}

	/**
	 * Set an element this end tag closes.
	 * 
	 * @param an
	 *            element this end tag closes.
	 */
	public void setElement(Element element) {
		this.element = element;
	}

	public Node getParentNode() {
		return element == null ? null : element.getParentNode();
	}
}
