/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.internal.util;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.ia2.Accessible2;
import org.eclipse.actf.accservice.swtbridge.ia2.IA2Util;
import org.eclipse.actf.model.flash.util.FlashMSAAUtil;
import org.eclipse.actf.visualization.gui.internal.util.Messages;
import org.eclipse.actf.visualization.gui.internal.util.TextMap;
import org.eclipse.actf.visualization.gui.ui.views.IFlashDOMView;
import org.eclipse.actf.visualization.gui.ui.views.MSAATreeContentProvider;
import org.eclipse.actf.visualization.gui.ui.views.MSAAViewRegistory;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class ScreenReaderRenderer {
    private static final String SPACE = " ";
    private int lastHwnd = 0;
    private String lastText = "";
    private StyledText text;
    private TextMap textMap;
    private static final MSAATreeContentProvider provider = MSAATreeContentProvider.getDefault();
    private static final Display display = Display.getCurrent();
    private static RenderThread renderThread = null;
    private static DisposeListener disposeListener = null;
    private static final int IDLE_WAIT = 5;
    private static final int BUSY_WAIT = 500;
    public static int waitMS = 5;
    private IFlashDOMView flashDOMView = (IFlashDOMView)MSAAViewRegistory.findView("org.eclipse.actf.visualization.flash.ui.views.FlashDOMView");
    private static final String[] BROWSER_CONTENT_CLASSNAMES = new String[]{"Internet Explorer_Server", "MozillaWindowClass", "MozillaContentWindowClass"};

    private static boolean isBrowserContent(String string) {
        int n = 0;
        while (n < BROWSER_CONTENT_CLASSNAMES.length) {
            if (BROWSER_CONTENT_CLASSNAMES[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public ScreenReaderRenderer(StyledText styledText, TextMap textMap) {
        this.text = styledText;
        this.textMap = textMap;
        if (disposeListener == null) {
            disposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    if (renderThread != null) {
                        renderThread.cancel = true;
                        renderThread.interrupt();
                        ScreenReaderRenderer.renderThread = null;
                        ScreenReaderRenderer.disposeListener = null;
                    }
                }
            };
            styledText.addDisposeListener(disposeListener);
        }
    }

    public void renderAll(AccessibleObject accessibleObject) {
        AccessibleObject accessibleObject2;
        if (renderThread != null) {
            ScreenReaderRenderer.renderThread.cancel = true;
            renderThread.interrupt();
        }
        this.text.setText("");
        if (this.textMap != null) {
            this.textMap.clear();
        }
        if ((accessibleObject2 = accessibleObject.getCachedParent()) != null) {
            renderThread = new RenderThread(provider.getElements(accessibleObject2));
            renderThread.start();
            Thread.yield();
        }
    }

    public static void setBusy(boolean bl) {
        waitMS = bl ? 500 : 5;
    }

    public String renderItem(AccessibleObject accessibleObject, boolean bl, int n) {
        String[] stringArray;
        boolean bl2;
        String string = accessibleObject.getAccName();
        String string2 = string == null ? "" : string.replace('\u00a0', ' ').trim();
        int n2 = accessibleObject.getAccState();
        int n3 = accessibleObject.getAccRole();
        boolean bl3 = FlashMSAAUtil.isFlash((int)accessibleObject.getPtr());
        boolean bl4 = ScreenReaderRenderer.isBrowserContent(accessibleObject.getClassName());
        String string3 = "";
        String string4 = "";
        String string5 = accessibleObject.getAccDefaultAction();
        boolean bl5 = string5 != null && string5.length() > 0;
        boolean bl6 = bl2 = (accessibleObject.getAccState() & 0x8000) == 0;
        int n4 = bl2 ? (bl5 ? 9 : -1) : 15;
        int n5 = bl ? 13 : -1;
        block1 : switch (n3) {
            case 42: {
                boolean bl7;
                boolean bl8 = bl7 = (n2 & 0x40) == 0;
                if (!bl4 || bl7) {
                    string3 = bl7 ? Messages.msaa_edit : Messages.msaa_edit_readonly;
                    string2 = accessibleObject.getAccValue();
                    if (string2 != null && string2.length() != 0) break;
                    string2 = SPACE;
                    break;
                }
            }
            case 41: {
                if (!string2.equals(this.lastText)) break;
                string2 = "";
                break;
            }
            case 40: {
                if (bl3) {
                    string3 = Messages.msaa_graphic;
                } else {
                    string4 = Messages.msaa_graphic;
                }
                if (!string2.equals(this.lastText)) break;
                string2 = "";
                break;
            }
            case 30: {
                string3 = Messages.msaa_link;
                break;
            }
            case 44: {
                string3 = String.valueOf(Messages.msaa_checkbox) + SPACE;
                string3 = String.valueOf(string3) + ((n2 & 0x10) != 0 ? Messages.msaa_checked : Messages.msaa_not_checked);
                break;
            }
            case 45: {
                string3 = String.valueOf(Messages.msaa_radiobutton) + SPACE;
                string3 = String.valueOf(string3) + ((n2 & 0x10) != 0 ? Messages.msaa_checked : Messages.msaa_not_checked);
                break;
            }
            case 51: {
                string2 = accessibleObject.getAccValue();
                string4 = Messages.msaa_updown_scrollbat;
                break;
            }
            case 48: {
                string2 = accessibleObject.getAccValue();
                string4 = Messages.msaa_progressbar;
                break;
            }
            case 52: {
                string2 = accessibleObject.getAccValue();
                string4 = Messages.msaa_editspinbox;
                break;
            }
            case 46: {
                string3 = Messages.msaa_combobox;
                string2 = accessibleObject.getAccValue();
                if (string2 != null && string2.length() != 0) break;
                string2 = accessibleObject.getAccName();
                break;
            }
            case 43: 
            case 56: 
            case 62: {
                string4 = Messages.msaa_button;
                if (string2.length() != 0) break;
                if (bl3) {
                    string2 = Integer.toString(n);
                    n4 = 3;
                    break;
                }
                string2 = SPACE;
                break;
            }
            case 34: {
                AccessibleObject accessibleObject2 = accessibleObject.getCachedParent();
                if (accessibleObject2 == null) break;
                switch (accessibleObject2.getAccRole()) {
                    case 33: {
                        string4 = Messages.msaa_listbox;
                        if ((n2 & 2) == 0) break block1;
                        string4 = String.valueOf(string4) + SPACE + Messages.msaa_selected;
                        break;
                    }
                    case 46: {
                        string3 = Messages.msaa_combobox;
                    }
                }
                break;
            }
            case 24: {
                string4 = Messages.msaa_table;
                break;
            }
            case 29: {
                string4 = Messages.msaa_cell;
                break;
            }
            case 25: {
                string4 = Messages.msaa_columnheader;
                break;
            }
            case 26: {
                string4 = Messages.msaa_rowheader;
                break;
            }
            case 37: {
                string4 = Messages.msaa_tab;
                break;
            }
            case 36: {
                string4 = Messages.msaa_treeview;
                if ((n2 & 2) != 0) {
                    string4 = String.valueOf(string4) + SPACE + Messages.msaa_selected;
                    break;
                }
                if (!bl3) break;
                string2 = "";
                break;
            }
            case 35: {
                string4 = Messages.msaa_tree;
                break;
            }
            case 2: {
                string4 = Messages.msaa_menubar;
                break;
            }
            case 11: 
            case 12: {
                if ((n2 & 1) != 0) {
                    string4 = Messages.msaa_unavailable;
                    break;
                }
                if (accessibleObject.getChildCount() > 0) {
                    AccessibleObject accessibleObject3 = accessibleObject.getCachedParent();
                    if (accessibleObject3 != null && 12 == accessibleObject3.getAccRole()) {
                        string4 = Messages.msaa_submenu;
                        break;
                    }
                    string4 = Messages.msaa_menu;
                    break;
                }
                if ((n2 & 0x10) == 0) break;
                string4 = Messages.msaa_checked;
                break;
            }
            case 22: {
                string4 = Messages.msaa_toolbar;
                break;
            }
            case 23: {
                string4 = Messages.msaa_statusbar;
                break;
            }
            case 3: {
                string4 = Messages.msaa_scrollbar;
                break;
            }
            case 39: {
                string4 = Messages.msaa_indicator;
                break;
            }
            case 14: {
                string4 = Messages.msaa_application;
                break;
            }
            case 15: {
                string4 = Messages.msaa_document;
                break;
            }
            case 9: 
            case 16: {
                if (bl3) {
                    string2 = "";
                    break;
                }
                string4 = Messages.msaa_window;
                break;
            }
            case 10: {
                if (!bl3 && !bl4 && !string2.equals(this.lastText)) break;
                string2 = "";
                break;
            }
            case 1052: 
            case 1057: {
                break;
            }
            case 1061: {
                String string6 = null;
                stringArray = accessibleObject.getAccessible2();
                if (stringArray != null) {
                    string6 = IA2Util.getAttribute(stringArray.getAttributes(), "style");
                }
                if (string6 != null) {
                    string4 = MessageFormat.format((String)Messages.ia2_style_shape, (Object[])new Object[]{string6});
                    break;
                }
                string4 = String.valueOf(string4) + Messages.ia2_shape;
                break;
            }
            case 1027: 
            case 1055: {
                if ((n2 & 1) != 0) {
                    string4 = Messages.msaa_unavailable;
                    break;
                }
                Accessible2 accessible2 = accessibleObject.getAccessible2();
                if (accessible2 == null || !IA2Util.getExtendedState(stringArray = accessible2.getExtendedStates(8), "CHECKED")) break;
                string4 = Messages.msaa_checked;
                break;
            }
            case 1044: {
                String string7 = "?";
                try {
                    stringArray = accessibleObject.getAccessible2();
                    if (stringArray != null) {
                        string7 = IA2Util.getAttribute(stringArray.getAttributes(), "heading-level");
                    }
                }
                catch (Exception exception) {}
                string3 = MessageFormat.format((String)Messages.ia2_heading_level, (Object[])new Object[]{string7});
            }
            case 1054: {
                string2 = accessibleObject.getAccValue();
                if (string2 != null && string2.length() != 0) break;
                string2 = accessibleObject.getAccName();
                break;
            }
            default: {
                string3 = "[" + accessibleObject.getRoleText() + " 0x" + Integer.toHexString(n3) + "]";
            }
        }
        String string8 = "";
        stringArray = new Point(this.text.getCharCount(), 0);
        if (string2 != null && string2.length() > 0) {
            if (SPACE.equals(string2)) {
                string2 = "";
            }
            if (string3.length() > 0) {
                if (string2.length() > 0) {
                    string3 = String.valueOf(string3) + SPACE;
                }
                this.appendText(string3, 15, n5, false);
                string8 = String.valueOf(string8) + string3;
            }
            if (string2.length() > 0) {
                this.appendText(string2, n4, n5, bl5);
                string8 = String.valueOf(string8) + string2;
            }
            if (string4.length() > 0) {
                if (string8.length() > 0) {
                    string4 = SPACE + string4;
                }
                this.appendText(string4, 15, n5, false);
                string8 = String.valueOf(string8) + string4;
            }
            this.text.append("\n");
            this.lastText = string2;
        }
        stringArray.y = this.text.getCharCount();
        if (this.textMap != null) {
            this.textMap.put(accessibleObject, (Point)stringArray);
        }
        return string8;
    }

    public String renderEvent(int n) {
        String string = "";
        switch (n) {
            case 4: {
                string = Messages.msaa_menu_start;
                break;
            }
            case 6: {
                string = Messages.msaa_popup_start;
                break;
            }
            case 5: {
                string = Messages.msaa_menu_end;
                break;
            }
            case 7: {
                string = Messages.msaa_popup_end;
            }
        }
        if (string.length() > 0) {
            this.appendText(string, 15, -1, false);
            this.text.append("\n");
            this.lastText = string;
        }
        return string;
    }

    private void appendText(String string, int n, int n2, boolean bl) {
        StyleRange styleRange = new StyleRange();
        if (n >= 0) {
            styleRange.foreground = Display.getCurrent().getSystemColor(n);
        }
        if (n2 >= 0) {
            styleRange.background = Display.getCurrent().getSystemColor(n2);
        }
        styleRange.underline = bl;
        styleRange.start = this.text.getCharCount();
        styleRange.length = string.length();
        this.text.append(string);
        this.text.setStyleRange(styleRange);
    }

    private class RenderThread
    extends Thread {
        private Object[] startElements;
        public boolean cancel = false;

        public RenderThread(Object[] objectArray) {
            this.startElements = objectArray;
        }

        public void run() {
            try {
                this.renderElements(this.startElements);
                display.syncExec(new Runnable(){

                    public void run() {
                        if (!RenderThread.this.cancel && !ScreenReaderRenderer.this.text.isDisposed() && ScreenReaderRenderer.this.text.getCharCount() <= 0) {
                            ScreenReaderRenderer.this.appendText(provider.isHideHtml() ? Messages.msaa_no_flash : Messages.msaa_empty_page, 15, -1, false);
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {}
        }

        private void renderElements(Object[] objectArray) throws InterruptedException {
            if (objectArray == null) {
                return;
            }
            int n = 0;
            while (n < objectArray.length) {
                if (this.cancel) {
                    throw new InterruptedException();
                }
                if (objectArray[n] instanceof AccessibleObject) {
                    final int n2 = n;
                    final boolean[] blArray = new boolean[1];
                    final Object[][] objectArray2 = new Object[1][];
                    final AccessibleObject accessibleObject = (AccessibleObject)objectArray[n];
                    display.syncExec(new Runnable(){

                        public void run() {
                            if (!RenderThread.this.cancel && !ScreenReaderRenderer.this.text.isDisposed()) {
                                int n = accessibleObject.getWindow();
                                if (n != ScreenReaderRenderer.this.lastHwnd) {
                                    if (FlashMSAAUtil.isFlash((int)accessibleObject.getPtr())) {
                                        String string = null;
                                        if (n == 0) {
                                            string = FlashMSAAUtil.getHtmlAttribute((int)accessibleObject.getPtr(), (String)"WMode");
                                        }
                                        if (string == null) {
                                            AccessibleObject accessibleObject2 = accessibleObject.getCachedParent();
                                            if (accessibleObject2 != null && n != accessibleObject2.getWindow()) {
                                                ScreenReaderRenderer.this.appendText(String.valueOf(Messages.msaa_flash_start) + "\n", 15, 13, false);
                                                blArray[0] = true;
                                            }
                                        } else {
                                            ScreenReaderRenderer.this.appendText(String.valueOf(Messages.msaa_flash_inaccessible) + " wmode=" + string + "\n", 15, 3, false);
                                            if (ScreenReaderRenderer.this.flashDOMView != null) {
                                                ScreenReaderRenderer.this.flashDOMView.addWindowlessElement(accessibleObject);
                                            }
                                        }
                                    }
                                    ScreenReaderRenderer.this.lastHwnd = n;
                                }
                                ScreenReaderRenderer.this.renderItem(accessibleObject, false, n2);
                                objectArray2[0] = provider.getChildren(accessibleObject);
                            }
                        }
                    });
                    this.renderElements(objectArray2[0]);
                    if (blArray[0]) {
                        display.syncExec(new Runnable(){

                            public void run() {
                                if (!RenderThread.this.cancel && !ScreenReaderRenderer.this.text.isDisposed()) {
                                    ScreenReaderRenderer.this.appendText(String.valueOf(Messages.msaa_flash_end) + "\n", 15, 13, false);
                                }
                            }
                        });
                    }
                    Thread.yield();
                    Thread.sleep(waitMS);
                    ScreenReaderRenderer.setBusy(false);
                }
                ++n;
            }
        }
    }
}

