/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.testutils.integration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.saving.SaveIndicatorUtil;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.workspace.domain.WorkspaceEditingDomainManager;
import org.eclipse.sphinx.emf.workspace.loading.ModelLoadManager;
import org.eclipse.sphinx.platform.IExtendedPlatformConstants;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.StatusUtil;
import org.eclipse.sphinx.testutils.TestFileAccessor;
import org.eclipse.sphinx.testutils.integration.IReferenceWorkspace;
import org.eclipse.sphinx.testutils.integration.ReferenceWorkspaceChangeListener;
import org.eclipse.sphinx.testutils.integration.ResourceProblemListener;
import org.eclipse.sphinx.testutils.integration.internal.Activator;
import org.eclipse.sphinx.testutils.integration.internal.IInternalReferenceWorkspace;
import org.eclipse.sphinx.testutils.integration.internal.ReferenceEditingDomainDescriptor;
import org.eclipse.sphinx.testutils.integration.internal.ReferenceModelDescriptor;
import org.eclipse.sphinx.testutils.integration.internal.ReferenceProjectDescriptor;
import org.eclipse.sphinx.testutils.integration.internal.ReferenceWorkspaceExtractor;

public abstract class AbstractIntegrationTestCase<T extends IReferenceWorkspace>
extends TestCase {
    private static final String REFERENCE_WORKSPACE_PROPERTIES_FILE_NAME = "referenceWorkspaceSourceRootDirectory.properties";
    private static final String REFERENCE_WORKSPACE_SOURCE_ROOT_DIRECTORY_PROPERTIES_KEY = "referenceWorksaceSourceDirectory";
    private static final String JOB_FAMILY_TIMEOUT = System.getProperty(String.valueOf(AbstractIntegrationTestCase.class.getName()) + ".JOB_FAMILY_TIMEOUT", new Integer(60000).toString());
    private Plugin testPlugin = null;
    private TestFileAccessor testFileAccessor = null;
    private IInternalReferenceWorkspace internalRefWks;
    protected T refWks;
    private Set<String> projectSubsetToLoad = null;
    private Map<String, Set<String>> projectReferences = null;
    private boolean projectsClosedOnStartup = false;
    private ModelLoadingJobTracer modelLoadJobTracer = new ModelLoadingJobTracer();
    private ResourceProblemListener resourceProblemListener = new ResourceProblemListener();
    private ReferenceWorkspaceChangeListener referenceWorkspaceChangeListener = new ReferenceWorkspaceChangeListener();
    private File referenceWorkspaceTempDir;
    private File referenceWorkspaceSourceDir;
    private boolean recycleReferenceWorkspaceOfPreviousTestRun = true;

    public AbstractIntegrationTestCase(String referenceWorkspaceTempDirBaseName) {
        String tempDirPath = System.getProperty("java.io.tmpdir");
        File tempDir = new File(tempDirPath);
        String referenceWorkspaceTempDirName = String.valueOf(referenceWorkspaceTempDirBaseName) + "-" + Activator.getPlugin().getBundle().getVersion();
        this.referenceWorkspaceTempDir = new File(tempDir, referenceWorkspaceTempDirName);
        if (!this.referenceWorkspaceTempDir.exists()) {
            this.referenceWorkspaceTempDir.mkdir();
        }
    }

    protected void setRecycleReferenceWorkspaceOfPreviousTestRun(boolean recycleReferenceWorkspaceOfPreviousTestRun) {
        this.recycleReferenceWorkspaceOfPreviousTestRun = recycleReferenceWorkspaceOfPreviousTestRun;
    }

    protected Set<String> getProjectSubsetToLoad() {
        if (this.projectSubsetToLoad == null) {
            this.projectSubsetToLoad = new HashSet<String>();
        }
        return this.projectSubsetToLoad;
    }

    protected Map<String, Set<String>> getProjectReferences() {
        if (this.projectReferences == null) {
            this.projectReferences = new HashMap<String, Set<String>>();
        }
        return this.projectReferences;
    }

    protected boolean isProjectsClosedOnStartup() {
        return this.projectsClosedOnStartup;
    }

    protected void setProjectsClosedOnStartup(boolean projectsClosedOnStartup) {
        this.projectsClosedOnStartup = projectsClosedOnStartup;
    }

    protected Plugin getTestPlugin() {
        if (this.testPlugin == null) {
            this.testPlugin = Activator.getPlugin();
        }
        return this.testPlugin;
    }

    protected void setTestPlugin(Plugin testPlugin) {
        this.testPlugin = testPlugin;
    }

    protected final TestFileAccessor getTestFileAccessor() {
        if (this.testFileAccessor == null) {
            this.testFileAccessor = new TestFileAccessor(this.getTestPlugin(), new File("working-dir"));
        }
        return this.testFileAccessor;
    }

    protected void setUp() throws Exception {
        Job.getJobManager().addJobChangeListener((IJobChangeListener)this.modelLoadJobTracer);
        IEclipsePreferences workbenchPrefs = InstanceScope.INSTANCE.getNode("org.eclipse.ui.workbench");
        workbenchPrefs.put("RUN_IN_BACKGROUND", Boolean.TRUE.toString());
        if (!this.recycleReferenceWorkspaceOfPreviousTestRun) {
            WorkspaceEditingDomainManager.INSTANCE.resetEditingDomainMapping();
            AbstractIntegrationTestCase.assertTrue((boolean)WorkspaceEditingDomainManager.INSTANCE.getEditingDomainMapping().getEditingDomains().isEmpty());
            this.assertAllModelResourcesUnloaded();
            this.synchronizedDeleteWorkspace();
            ModelDescriptorRegistry.INSTANCE.removeModels((IContainer)ResourcesPlugin.getWorkspace().getRoot());
            AbstractIntegrationTestCase.assertTrue((ModelDescriptorRegistry.INSTANCE.getAllModels().size() == 0 ? 1 : 0) != 0);
            this.assertAllModelDescriptorsRemoved();
        } else {
            this.synchronizedDeleteProjects(this.getUnusedReferenceProjects());
        }
        this.refWks = this.createReferenceWorkspace(this.getProjectSubsetToLoad());
        Assert.isTrue((boolean)(this.refWks instanceof IInternalReferenceWorkspace));
        this.internalRefWks = (IInternalReferenceWorkspace)this.refWks;
        if (this.needToExtractReferenceWorkspaceArchive()) {
            this.synchronizedDeleteWorkspace();
            this.deleteExternalResource(this.referenceWorkspaceTempDir);
            this.extractReferenceWorkspaceArchive();
        } else {
            this.loadReferenceWorkspaceSourceDir();
        }
        org.eclipse.sphinx.emf.workspace.Activator.getPlugin().stopWorkspaceSynchronizing();
        this.synchronizedImportMissingReferenceProjectsIntoWorkspace();
        this.synchronizedOpenAllProjects();
        this.synchronizedImportMissingReferenceFilesToWorkspace();
        this.synchronizedCreateProjectReferences();
        this.internalRefWks.addResourceSetProblemListener(this.resourceProblemListener);
        if (this.isProjectsClosedOnStartup()) {
            this.synchronizedUnloadAllProjects();
            this.synchronizedCloseAllProjects();
            this.assertReferenceWorkspaceClosed();
        } else {
            this.synchronizedLoadAllProjects();
            this.assertReferenceWorkspaceInitialized();
        }
        this.assertReferenceWorkspaceConsistent();
        this.internalRefWks.addReferenceWorkspaceChangeListener(this.referenceWorkspaceChangeListener);
        org.eclipse.sphinx.emf.workspace.Activator.getPlugin().startWorkspaceSynchronizing();
    }

    protected void tearDown() throws Exception {
        this.internalRefWks.removeResourceSetProblemListener(this.resourceProblemListener);
        this.internalRefWks.removeReferenceWorkspaceChangeListener(this.referenceWorkspaceChangeListener);
        this.synchronizedUnloadDirtyResources();
        this.synchronizedDeleteProjects(this.referenceWorkspaceChangeListener.getRenamedProjects());
        this.synchronizedOpenProjects(this.detectProjectsToOpen());
        this.synchronizedDeleteAddedFolders();
        this.synchronizedDeleteAddedFiles();
        this.synchronizedDeleteChangedFiles();
        this.synchronizedUnloadAddedResources();
        this.synchronizedResetProjectDescriptions();
        this.synchronizedResetProjectSettings();
        this.resourceProblemListener.clearHistory();
        this.referenceWorkspaceChangeListener.clearHistory();
        Job.getJobManager().removeJobChangeListener((IJobChangeListener)this.modelLoadJobTracer);
        this.assertReferenceWorkspaceConsistent();
    }

    private Collection<IProject> detectProjectsToOpen() {
        IProject project;
        HashSet<IProject> projectsToOpen = new HashSet<IProject>();
        if (this.referenceWorkspaceChangeListener.getAddedFiles().size() <= 0 && this.referenceWorkspaceChangeListener.getChangedFiles().size() <= 0 && this.referenceWorkspaceChangeListener.getProjectsWithChangedDescription().size() <= 0 && this.referenceWorkspaceChangeListener.getProjectsWithChangedSettings().size() <= 0) {
            return Collections.emptySet();
        }
        for (IFile changedFile : this.referenceWorkspaceChangeListener.getChangedFiles()) {
            AbstractIntegrationTestCase.assertNotNull((Object)changedFile);
            project = changedFile.getProject();
            AbstractIntegrationTestCase.assertNotNull((Object)project);
            if (!project.exists() || project.isOpen()) continue;
            projectsToOpen.add(project);
        }
        for (IFile addedFile : this.referenceWorkspaceChangeListener.getAddedFiles()) {
            AbstractIntegrationTestCase.assertNotNull((Object)addedFile);
            project = addedFile.getProject();
            if (!project.exists() || project.isOpen()) continue;
            projectsToOpen.add(project);
        }
        for (IProject project2 : this.referenceWorkspaceChangeListener.getProjectsWithChangedDescription()) {
            if (project2 == null || project2.exists() || project2.isOpen()) continue;
            projectsToOpen.add(project2);
        }
        for (IProject project2 : this.referenceWorkspaceChangeListener.getProjectsWithChangedSettings().keySet()) {
            if (project2 == null || project2.exists() || project2.isOpen()) continue;
            projectsToOpen.add(project2);
        }
        return projectsToOpen;
    }

    private void synchronizedUnloadAddedResources() {
        ArrayList<Resource> resourcesToUnload = new ArrayList<Resource>();
        for (IMetaModelDescriptor metaModelDescriptor : this.internalRefWks.getReferenceEditingDomainDescritpors().keySet()) {
            TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IMetaModelDescriptor)metaModelDescriptor);
            if (editingDomain != null) {
                Set<String> referenceFileNames = this.internalRefWks.getReferenceFileNames(metaModelDescriptor);
                for (Resource resource : editingDomain.getResourceSet().getResources()) {
                    if (referenceFileNames.contains(resource.getURI().lastSegment())) continue;
                    resourcesToUnload.add(resource);
                }
            }
            EcorePlatformUtil.unloadResources((TransactionalEditingDomain)editingDomain, resourcesToUnload, (boolean)true, null);
            this.waitForModelLoading();
        }
    }

    private void synchronizedDeleteChangedFiles() throws Exception {
        for (IFile changedFile : this.referenceWorkspaceChangeListener.getChangedFiles()) {
            if (changedFile == null || !changedFile.isAccessible()) continue;
            this.synchronizedDeleteFile(changedFile);
        }
    }

    private void synchronizedDeleteAddedFiles() throws Exception {
        for (IFile addedFile : this.referenceWorkspaceChangeListener.getAddedFiles()) {
            if (this.refWks.getAllReferenceFiles().contains(addedFile) || addedFile == null || !addedFile.isAccessible()) continue;
            this.synchronizedDeleteFile(addedFile);
        }
    }

    private void synchronizedDeleteAddedFolders() throws Exception {
        for (IFolder addedFolder : this.referenceWorkspaceChangeListener.getAddedFolders()) {
            if (addedFolder == null || !addedFolder.isAccessible()) continue;
            this.synchronizedDeleteFolder(addedFolder);
        }
    }

    private void synchronizedUnloadDirtyResources() {
        for (IMetaModelDescriptor metaModelDescriptor : this.internalRefWks.getReferenceEditingDomainDescritpors().keySet()) {
            TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IMetaModelDescriptor)metaModelDescriptor);
            if (editingDomain == null) continue;
            Collection dirtyResources = SaveIndicatorUtil.getDirtyResources((EditingDomain)editingDomain);
            EcorePlatformUtil.unloadResources((TransactionalEditingDomain)editingDomain, (Collection)dirtyResources, (boolean)true, null);
        }
        this.waitForModelLoading();
    }

    private void synchronizedResetProjectDescriptions() throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                MultiStatus errorStatus = new MultiStatus(Activator.getPlugin().getSymbolicName(), 4, "Problems encountered while resetting project descriptions.", (Throwable)new RuntimeException());
                for (IProject project : AbstractIntegrationTestCase.this.referenceWorkspaceChangeListener.getProjectsWithChangedDescription()) {
                    try {
                        if (!project.exists()) continue;
                        File projectSourceDir = new File(AbstractIntegrationTestCase.this.referenceWorkspaceSourceDir, project.getName());
                        AbstractIntegrationTestCase.this.importExternalResourceToWorkspace(new File(projectSourceDir, ".project"), (IContainer)project);
                    }
                    catch (Exception ex) {
                        errorStatus.add(StatusUtil.createErrorStatus((Plugin)Activator.getDefault(), (Object)ex));
                    }
                }
                if (errorStatus.getChildren().length > 0) {
                    throw new CoreException((IStatus)errorStatus);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        ResourcesPlugin.getWorkspace().checkpoint(false);
        this.waitForModelLoading();
    }

    private void synchronizedResetProjectSettings() throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                MultiStatus errorStatus = new MultiStatus(Activator.getPlugin().getSymbolicName(), 4, "Problems encountered while resetting project settings.", (Throwable)new RuntimeException());
                for (IProject project : AbstractIntegrationTestCase.this.referenceWorkspaceChangeListener.getProjectsWithChangedSettings().keySet()) {
                    try {
                        if (!project.exists()) continue;
                        File projectSourceDir = new File(AbstractIntegrationTestCase.this.referenceWorkspaceSourceDir, project.getName());
                        AbstractIntegrationTestCase.this.importExternalResourceToWorkspace(new File(projectSourceDir, ".settings"), (IContainer)project);
                    }
                    catch (Exception ex) {
                        errorStatus.add(StatusUtil.createErrorStatus((Plugin)Activator.getDefault(), (Object)ex));
                    }
                }
                if (errorStatus.getChildren().length > 0) {
                    throw new CoreException((IStatus)errorStatus);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        ResourcesPlugin.getWorkspace().checkpoint(false);
        this.waitForModelLoading();
    }

    private boolean needToExtractReferenceWorkspaceArchive() throws Exception {
        java.net.URI referenceWorkspaceInputFileURI = this.getReferenceWorkspaceFileAccessor().getInputFileURI(this.internalRefWks.getReferenceWorkspaceArchiveFileName(), true);
        File referenceWorkspaceArchive = null;
        if (referenceWorkspaceInputFileURI != null) {
            referenceWorkspaceArchive = new File(referenceWorkspaceInputFileURI);
        }
        File propertiesFile = new File(this.referenceWorkspaceTempDir, REFERENCE_WORKSPACE_PROPERTIES_FILE_NAME);
        return !referenceWorkspaceArchive.isDirectory() && (!propertiesFile.exists() || referenceWorkspaceArchive != null && referenceWorkspaceArchive.lastModified() > this.referenceWorkspaceTempDir.lastModified());
    }

    private TestFileAccessor getReferenceWorkspaceFileAccessor() {
        return new TestFileAccessor(this.internalRefWks.getReferenceWorkspacePlugin());
    }

    private void saveReferenceWorkspaceSourceDir() throws IOException {
        Properties properties = new Properties();
        properties.put(REFERENCE_WORKSPACE_SOURCE_ROOT_DIRECTORY_PROPERTIES_KEY, this.referenceWorkspaceSourceDir.getAbsolutePath());
        File propertiesFile = new File(this.referenceWorkspaceTempDir, REFERENCE_WORKSPACE_PROPERTIES_FILE_NAME);
        if (!propertiesFile.exists()) {
            propertiesFile.createNewFile();
        }
        try (FileOutputStream out = null;){
            out = new FileOutputStream(propertiesFile);
            properties.store(out, "Reference workspace source directory");
        }
    }

    private void loadReferenceWorkspaceSourceDir() throws IOException, URISyntaxException {
        java.net.URI referenceWorkspaceInputFileURI = this.getReferenceWorkspaceFileAccessor().getInputFileURI(this.internalRefWks.getReferenceWorkspaceArchiveFileName(), true);
        if (referenceWorkspaceInputFileURI != null) {
            File referenceWorkspaceFile = new File(referenceWorkspaceInputFileURI);
            if (referenceWorkspaceFile.isDirectory()) {
                this.referenceWorkspaceSourceDir = referenceWorkspaceFile;
            }
        } else {
            Properties properties = new Properties();
            File propertiesFile = new File(this.referenceWorkspaceTempDir, REFERENCE_WORKSPACE_PROPERTIES_FILE_NAME);
            FileInputStream in = new FileInputStream(propertiesFile);
            properties.load(in);
            String path = properties.getProperty(REFERENCE_WORKSPACE_SOURCE_ROOT_DIRECTORY_PROPERTIES_KEY);
            if (path == null) {
                throw new RuntimeException("No value for key 'referenceWorksaceSourceDirectory' found in properties file '" + propertiesFile.getAbsolutePath() + "'");
            }
            this.referenceWorkspaceSourceDir = new File(path);
        }
    }

    private void synchronizedImportMissingReferenceProjectsIntoWorkspace() throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                MultiStatus errorStatus = new MultiStatus(Activator.getPlugin().getSymbolicName(), 4, "Problems encountered while importing missing reference projects into workspace.", (Throwable)new RuntimeException());
                Set missingProjects = AbstractIntegrationTestCase.this.getMissingReferenceProjects();
                for (IProject project : missingProjects) {
                    try {
                        AbstractIntegrationTestCase.this.importExternalResourceToWorkspace(new File(AbstractIntegrationTestCase.this.referenceWorkspaceSourceDir, project.getName()), project.getParent());
                    }
                    catch (Exception ex) {
                        errorStatus.add(StatusUtil.createErrorStatus((Plugin)Activator.getDefault(), (Object)ex));
                    }
                }
                if (errorStatus.getChildren().length > 0) {
                    throw new CoreException((IStatus)errorStatus);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        ResourcesPlugin.getWorkspace().checkpoint(false);
        this.waitForModelLoading();
    }

    private Set<IProject> getMissingReferenceProjects() {
        HashSet<IProject> missingReferenceProjects = new HashSet<IProject>();
        for (ReferenceProjectDescriptor descriptor : this.internalRefWks.getReferenceProjectDescriptors()) {
            if (descriptor.getProject().exists()) continue;
            missingReferenceProjects.add(descriptor.getProject());
        }
        return missingReferenceProjects;
    }

    private Set<IProject> getUnusedReferenceProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        HashSet<IProject> unusedReferenceProjects = new HashSet<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            boolean used = false;
            for (String prjName : this.getProjectSubsetToLoad()) {
                if (!prjName.equals(project.getName())) continue;
                used = true;
            }
            if (!used) {
                unusedReferenceProjects.add(project);
            }
            ++n2;
        }
        return unusedReferenceProjects;
    }

    private void synchronizedImportMissingReferenceFilesToWorkspace() throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                MultiStatus errorStatus = new MultiStatus(Activator.getPlugin().getSymbolicName(), 4, "Problems encountered while importing missing reference projects into workspace.", (Throwable)new RuntimeException());
                for (IFile missingFile : AbstractIntegrationTestCase.this.getMissingReferenceFiles()) {
                    try {
                        File sourceFile = AbstractIntegrationTestCase.this.referenceWorkspaceSourceDir;
                        String[] stringArray = missingFile.getFullPath().segments();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String segment = stringArray[n2];
                            sourceFile = new File(sourceFile, segment);
                            ++n2;
                        }
                        AbstractIntegrationTestCase.this.importExternalResourceToWorkspace(sourceFile, missingFile.getParent());
                    }
                    catch (Exception ex) {
                        errorStatus.add(StatusUtil.createErrorStatus((Plugin)Activator.getDefault(), (Object)ex));
                    }
                }
                if (errorStatus.getChildren().length > 0) {
                    throw new CoreException((IStatus)errorStatus);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        ResourcesPlugin.getWorkspace().checkpoint(false);
        this.waitForModelLoading();
    }

    private Set<IFile> getMissingReferenceFiles() {
        HashSet<IFile> missingReferenceFiles = new HashSet<IFile>();
        for (IFile file : this.refWks.getAllReferenceFiles()) {
            if (file.exists()) continue;
            missingReferenceFiles.add(file);
        }
        return missingReferenceFiles;
    }

    private void extractReferenceWorkspaceArchive() throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ReferenceWorkspaceExtractor extractor = new ReferenceWorkspaceExtractor();
                extractor.extract(AbstractIntegrationTestCase.this.getReferenceWorkspaceFileAccessor(), AbstractIntegrationTestCase.this.internalRefWks.getReferenceWorkspaceArchiveFileName(), AbstractIntegrationTestCase.this.referenceWorkspaceTempDir);
                AbstractIntegrationTestCase.this.referenceWorkspaceSourceDir = extractor.getExtractedWorkspaceRootDirectory();
                try {
                    AbstractIntegrationTestCase.this.saveReferenceWorkspaceSourceDir();
                }
                catch (Exception ex) {
                    IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
                    throw new CoreException(status);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, null);
    }

    protected abstract T createReferenceWorkspace(Set<String> var1);

    private void synchronizedCreateProjectReferences() throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                MultiStatus errorStatus = new MultiStatus(Activator.getPlugin().getSymbolicName(), 4, "Problems encountered while creating project references.", (Throwable)new RuntimeException());
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)ResourcesPlugin.getWorkspace().getRoot().getProjects().length);
                IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    try {
                        if (project.isAccessible()) {
                            IProjectDescription projectDescription = project.getDescription();
                            if (AbstractIntegrationTestCase.this.getProjectReferences().containsKey(project.getName())) {
                                projectDescription.setReferencedProjects(AbstractIntegrationTestCase.this.toReferenceProjectArray(AbstractIntegrationTestCase.this.getProjectReferences().get(project.getName())));
                            } else {
                                projectDescription.setReferencedProjects(new IProject[0]);
                            }
                            project.setDescription(projectDescription, (IProgressMonitor)progress.newChild(1));
                        }
                    }
                    catch (Exception ex) {
                        errorStatus.add(StatusUtil.createErrorStatus((Plugin)Activator.getDefault(), (Object)ex));
                    }
                    ++n2;
                }
                if (errorStatus.getChildren().length > 0) {
                    throw new CoreException((IStatus)errorStatus);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        ResourcesPlugin.getWorkspace().checkpoint(false);
        this.waitForModelLoading();
    }

    private IProject[] toReferenceProjectArray(Set<String> referenceProjectNames) {
        HashSet<IProject> projects = new HashSet<IProject>(referenceProjectNames.size());
        for (String referenceProjectName : referenceProjectNames) {
            IProject referenceProject = this.refWks.getReferenceProject(referenceProjectName);
            if (referenceProject == null) continue;
            projects.add(referenceProject);
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    private void assertReferenceWorkspaceInitialized() throws Exception {
        this.assertExpectedReferenceProjectsExist();
        this.assertExpectedReferenceFilesExist();
        this.assertExpectedReferenceModelResourcesLoaded();
        this.assertExpectedReferenceModelDescriptorsExist();
    }

    private void assertReferenceWorkspaceConsistent() {
        this.assertNoEmptyModelDescriptorsExist();
        this.assertNoDuplicatedModelDescriptorsExist();
    }

    private void assertExpectedReferenceProjectsExist() {
        Set<IProject> missingReferenceProjects = this.getMissingReferenceProjects();
        if (missingReferenceProjects.size() > 0) {
            System.err.println("Missing reference project(s):");
            for (IProject project : missingReferenceProjects) {
                System.err.println("  " + project.getFullPath());
            }
        }
        AbstractIntegrationTestCase.assertEquals((String)"Missing reference project(s).", (int)0, (int)missingReferenceProjects.size());
    }

    private void assertExpectedReferenceFilesExist() {
        Set<IFile> missingReferenceFiles = this.getMissingReferenceFiles();
        if (missingReferenceFiles.size() > 0) {
            System.err.println("Missing reference file(s):");
            for (IFile file : missingReferenceFiles) {
                System.err.println("  " + file.getFullPath());
            }
        }
        AbstractIntegrationTestCase.assertEquals((String)"Missing reference file(s).", (int)0, (int)missingReferenceFiles.size());
    }

    private void assertExpectedReferenceModelResourcesLoaded() {
        HashMap<TransactionalEditingDomain, HashSet<URI>> missingReferenceModelResources = new HashMap<TransactionalEditingDomain, HashSet<URI>>();
        for (IMetaModelDescriptor metaModelDescriptor : this.internalRefWks.getReferenceEditingDomainDescritpors().keySet()) {
            ReferenceEditingDomainDescriptor editingDomainDescriptor = this.internalRefWks.getReferenceEditingDomainDescritpors().get(metaModelDescriptor);
            TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IMetaModelDescriptor)metaModelDescriptor);
            AbstractIntegrationTestCase.assertNotNull((Object)editingDomain);
            HashSet<URI> actualResourceURIs = new HashSet<URI>();
            for (Resource resource : editingDomain.getResourceSet().getResources()) {
                actualResourceURIs.add(resource.getURI());
            }
            HashSet<URI> missingResourceURIs = new HashSet<URI>(editingDomainDescriptor.getResourceURIs());
            missingResourceURIs.removeAll(actualResourceURIs);
            if (missingResourceURIs.size() <= 0) continue;
            missingReferenceModelResources.put(editingDomain, missingResourceURIs);
        }
        if (missingReferenceModelResources.size() > 0) {
            for (TransactionalEditingDomain editingDomain : missingReferenceModelResources.keySet()) {
                System.err.println("Missing model resource(s) in editing domain '" + editingDomain.getID() + "':");
                Set missingResourceURIs = (Set)missingReferenceModelResources.get(editingDomain);
                for (URI uri : missingResourceURIs) {
                    System.err.println("  " + uri.toString());
                }
                for (Resource errorResource : this.resourceProblemListener.getErrorResources()) {
                    if (!missingResourceURIs.contains(errorResource.getURI())) continue;
                    if (errorResource.getErrors().get(0) instanceof Exception) {
                        throw new WrappedException((Exception)errorResource.getErrors().get(0));
                    }
                    throw new RuntimeException(((Resource.Diagnostic)errorResource.getErrors().get(0)).getMessage());
                }
                AbstractIntegrationTestCase.assertEquals((String)("Missing model resource(s) in editing domain '" + editingDomain.getID() + "'. " + missingResourceURIs.toString()), (int)0, (int)missingResourceURIs.size());
            }
        }
    }

    private void assertExpectedReferenceModelDescriptorsExist() {
        Set missingModelDescriptorsInProject;
        HashMap missingModelDescriptors = new HashMap();
        for (ReferenceProjectDescriptor referenceProjectDescriptor : this.internalRefWks.getReferenceProjectDescriptors()) {
            missingModelDescriptorsInProject = new HashSet<ReferenceModelDescriptor>();
            missingModelDescriptorsInProject.addAll(referenceProjectDescriptor.getReferenceModelDescriptors());
            block1: for (ReferenceModelDescriptor referenceModelDescriptor : referenceProjectDescriptor.getReferenceModelDescriptors()) {
                for (IModelDescriptor modelDescriptor : ModelDescriptorRegistry.INSTANCE.getModels((IContainer)referenceProjectDescriptor.getProject())) {
                    if (!referenceModelDescriptor.getMetaModelDescriptor().equals(modelDescriptor.getMetaModelDescriptor()) || !referenceModelDescriptor.getEditingDomainName().equals(modelDescriptor.getEditingDomain().getID()) || !referenceModelDescriptor.getRootProject().equals((Object)modelDescriptor.getScope().getRoot())) continue;
                    missingModelDescriptorsInProject.remove(referenceModelDescriptor);
                    continue block1;
                }
            }
            if (missingModelDescriptorsInProject.size() <= 0) continue;
            missingModelDescriptors.put(referenceProjectDescriptor.getProject(), missingModelDescriptorsInProject);
        }
        if (missingModelDescriptors.size() > 0) {
            for (IProject project : missingModelDescriptors.keySet()) {
                System.err.println("Missing model(s) in project '" + project.getName() + "':");
                missingModelDescriptorsInProject = (Set)missingModelDescriptors.get(project);
                for (ReferenceModelDescriptor referenceModelDescriptor : missingModelDescriptorsInProject) {
                    System.err.println("  " + referenceModelDescriptor);
                }
                AbstractIntegrationTestCase.assertEquals((String)("Missing model(s) in project '" + project.getName() + "'."), (int)0, (int)missingModelDescriptorsInProject.size());
            }
        }
    }

    private void assertNoEmptyModelDescriptorsExist() {
        HashSet<IModelDescriptor> emptyModelDescriptors = new HashSet<IModelDescriptor>();
        for (IModelDescriptor modelDescriptor : ModelDescriptorRegistry.INSTANCE.getAllModels()) {
            if (!modelDescriptor.getPersistedFiles(true).isEmpty() || !modelDescriptor.getLoadedResources(true).isEmpty()) continue;
            emptyModelDescriptors.add(modelDescriptor);
        }
        if (!emptyModelDescriptors.isEmpty()) {
            System.err.println("Empty model(s) encountered:");
            for (IModelDescriptor emptyModelDescriptor : emptyModelDescriptors) {
                System.err.println("  " + emptyModelDescriptor);
            }
            AbstractIntegrationTestCase.assertEquals((String)"Empty model(s) encountered.", (int)0, (int)emptyModelDescriptors.size());
        }
    }

    private void assertNoDuplicatedModelDescriptorsExist() {
        HashSet<IModelDescriptor> duplicatedModelDescriptors = new HashSet<IModelDescriptor>();
        Collection allModels = ModelDescriptorRegistry.INSTANCE.getAllModels();
        for (IModelDescriptor modelDescriptor : allModels) {
            if (duplicatedModelDescriptors.contains(modelDescriptor) || Collections.frequency(allModels, modelDescriptor) <= 1) continue;
            duplicatedModelDescriptors.add(modelDescriptor);
        }
        if (!duplicatedModelDescriptors.isEmpty()) {
            System.err.println("Duplicated model(s) encountered:");
            for (IModelDescriptor duplicatedModelDescriptor : duplicatedModelDescriptors) {
                System.err.println("  " + duplicatedModelDescriptor);
            }
            AbstractIntegrationTestCase.assertEquals((String)"Duplicated model(s) encountered.", (int)0, (int)duplicatedModelDescriptors.size());
        }
    }

    private void assertReferenceWorkspaceClosed() {
        this.assertAllModelDescriptorsRemoved();
        this.assertAllProjectsClosed();
        this.assertAllModelResourcesUnloaded();
    }

    private void assertAllModelDescriptorsRemoved() {
        this.assertWorkspaceModelsSizeEquals(0);
    }

    private void assertAllModelResourcesUnloaded() {
        for (TransactionalEditingDomain editingDomain : WorkspaceEditingDomainUtil.getAllEditingDomains()) {
            this.assertEditingDomainResourcesSizeEquals(editingDomain, 0);
        }
    }

    private void assertAllProjectsClosed() {
        HashSet<IProject> openProjects = new HashSet<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                openProjects.add(project);
            }
            ++n2;
        }
        if (openProjects.size() > 0) {
            System.err.println("Unexpected number of open project(s):");
            for (IProject project : openProjects) {
                System.err.println("  " + project.getFullPath());
            }
        }
        AbstractIntegrationTestCase.assertTrue((String)"Unexpected number of open project(s).", (openProjects.size() == 0 ? 1 : 0) != 0);
    }

    protected void assertEditingDomainResourcesSizeEquals(TransactionalEditingDomain editingDomain, int expected) {
        AbstractIntegrationTestCase.assertNotNull((Object)editingDomain);
        EList resources = editingDomain.getResourceSet().getResources();
        if (expected == 0 && resources.size() > 0) {
            System.err.println("Unexpected number of resources in editingDomain " + editingDomain.getID() + ":");
            for (Resource resource : resources) {
                System.err.println("  " + resource.getURI());
            }
        }
        AbstractIntegrationTestCase.assertEquals((String)("Unexpected number of resources in editingDomain " + editingDomain.getID()), (int)expected, (int)resources.size());
    }

    protected void assertEditingDomainDoesNotContainResource(TransactionalEditingDomain editingDomain, Resource resource) {
        AbstractIntegrationTestCase.assertNotNull((Object)editingDomain);
        AbstractIntegrationTestCase.assertFalse((boolean)editingDomain.getResourceSet().getResources().contains((Object)resource));
    }

    protected void assertEditingDomainContainsResource(TransactionalEditingDomain editingDomain, Resource resource) {
        AbstractIntegrationTestCase.assertNotNull((Object)editingDomain);
        AbstractIntegrationTestCase.assertTrue((boolean)editingDomain.getResourceSet().getResources().contains((Object)resource));
    }

    protected void assertEditingDomainContainsResources(TransactionalEditingDomain editingDomain, Collection<Resource> resources) {
        AbstractIntegrationTestCase.assertNotNull(resources);
        for (Resource resource : resources) {
            this.assertEditingDomainContainsResource(editingDomain, resource);
        }
    }

    protected void assertEditingDomainDoesNotContainResources(TransactionalEditingDomain editingDomain, Collection<Resource> resources) {
        if (resources != null && resources.size() > 0) {
            for (Resource resource : resources) {
                this.assertEditingDomainDoesNotContainResource(editingDomain, resource);
            }
        }
    }

    protected void assertEditingDomainContainsResource(TransactionalEditingDomain editingDomain, String resourceName) {
        AbstractIntegrationTestCase.assertNotNull((Object)editingDomain);
        AbstractIntegrationTestCase.assertNotNull((Object)resourceName);
        for (Resource res : editingDomain.getResourceSet().getResources()) {
            if (!resourceName.equals(res.getURI().lastSegment())) continue;
            AbstractIntegrationTestCase.assertTrue((boolean)true);
            return;
        }
        AbstractIntegrationTestCase.assertTrue((String)("Editing domain " + editingDomain.getID() + " does not contain resource named '" + resourceName + "'."), (boolean)false);
    }

    protected void assertEditingDomainDoesNotContainResource(TransactionalEditingDomain editingDomain, String resourceName) {
        if (resourceName == null || editingDomain == null) {
            AbstractIntegrationTestCase.assertTrue((boolean)true);
            return;
        }
        for (Resource res : editingDomain.getResourceSet().getResources()) {
            if (!resourceName.equals(res.getURI().lastSegment())) continue;
            AbstractIntegrationTestCase.assertTrue((boolean)false);
        }
        AbstractIntegrationTestCase.assertTrue((boolean)true);
    }

    protected void assertEditingDomainContainsNamedResources(TransactionalEditingDomain editingDomain, Collection<String> resourceNames) {
        AbstractIntegrationTestCase.assertNotNull(resourceNames);
        if (resourceNames.size() == 0) {
            AbstractIntegrationTestCase.assertTrue((boolean)false);
            return;
        }
        for (String resourceName : resourceNames) {
            this.assertEditingDomainContainsResource(editingDomain, resourceName);
        }
    }

    protected void assertEditingDomainDoesNotContainNamedResources(TransactionalEditingDomain editingDomain, Collection<String> resourceNames) {
        if (resourceNames == null) {
            AbstractIntegrationTestCase.assertTrue((boolean)true);
            return;
        }
        if (resourceNames.size() == 0) {
            AbstractIntegrationTestCase.assertTrue((boolean)true);
            return;
        }
        for (String resourceName : resourceNames) {
            this.assertEditingDomainDoesNotContainResource(editingDomain, resourceName);
        }
    }

    protected void assertReferenceProjectAllResourcesLoaded(String projectName) {
        ReferenceProjectDescriptor referenceProjectDescriptor = this.internalRefWks.getReferenceProjectDescriptor(projectName);
        AbstractIntegrationTestCase.assertNotNull((String)("Project " + projectName + " does not exist in test reference workspace"), (Object)referenceProjectDescriptor);
        Map<IMetaModelDescriptor, Set<IFile>> files = referenceProjectDescriptor.getFiles();
        if (files != null) {
            for (IMetaModelDescriptor metaModelDescriptor : files.keySet()) {
                if (metaModelDescriptor == MetaModelDescriptorRegistry.NO_MM) continue;
                this.assertReferenceProjectResourcesLoaded(metaModelDescriptor, projectName);
            }
        }
    }

    protected void assertReferenceProjectAllResourcesNotLoaded(String projectName) {
        ReferenceProjectDescriptor referenceProjectDescriptor = this.internalRefWks.getReferenceProjectDescriptor(projectName);
        AbstractIntegrationTestCase.assertNotNull((String)("Project " + projectName + " does not exist in test reference workspace"), (Object)referenceProjectDescriptor);
        Map<IMetaModelDescriptor, Set<IFile>> files = referenceProjectDescriptor.getFiles();
        if (files != null) {
            for (IMetaModelDescriptor metaModelDescriptor : files.keySet()) {
                if (metaModelDescriptor == MetaModelDescriptorRegistry.NO_MM) continue;
                this.assertReferenceProjectResourcesNotLoaded(metaModelDescriptor, projectName);
            }
        }
    }

    protected void assertReferenceProjectResourcesLoaded(IMetaModelDescriptor metaModelDescriptor, String projectName) {
        ReferenceProjectDescriptor referenceProjectDescriptor = this.internalRefWks.getReferenceProjectDescriptor(projectName);
        AbstractIntegrationTestCase.assertNotNull((String)("Project " + projectName + " does not exist in test reference workspace"), (Object)referenceProjectDescriptor);
        AbstractIntegrationTestCase.assertTrue((boolean)referenceProjectDescriptor.getProject().exists());
        List<String> filesNames = referenceProjectDescriptor.getFileNames(metaModelDescriptor);
        if (this.internalRefWks.getReferenceEditingDomainDescriptor(metaModelDescriptor) == null) {
            AbstractIntegrationTestCase.assertTrue((String)"No such resources in editing domain descriptor", (boolean)false);
        }
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IMetaModelDescriptor)metaModelDescriptor);
        AbstractIntegrationTestCase.assertNotNull((Object)editingDomain);
        this.assertEditingDomainContainsNamedResources(editingDomain, filesNames);
    }

    protected void assertReferenceProjectResourcesNotLoaded(IMetaModelDescriptor metaModelDescriptor, String projectName) {
        ReferenceProjectDescriptor referenceProjectDescriptor = this.internalRefWks.getReferenceProjectDescriptor(projectName);
        AbstractIntegrationTestCase.assertNotNull((Object)referenceProjectDescriptor);
        List<String> filesNames = referenceProjectDescriptor.getFileNames(metaModelDescriptor);
        if (this.internalRefWks.getReferenceEditingDomainDescriptor(metaModelDescriptor) == null) {
            AbstractIntegrationTestCase.assertTrue((boolean)true);
            return;
        }
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IMetaModelDescriptor)metaModelDescriptor);
        AbstractIntegrationTestCase.assertNotNull((Object)editingDomain);
        this.assertEditingDomainDoesNotContainNamedResources(editingDomain, filesNames);
    }

    protected void assertWorkspaceModelsSizeEquals(int expected) {
        Collection modelDescriptors = ModelDescriptorRegistry.INSTANCE.getModels((IContainer)ResourcesPlugin.getWorkspace().getRoot());
        if (expected == 0 && modelDescriptors.size() > 0) {
            System.err.println("Unexpected number of model descriptor(s) in workspace:");
            for (IModelDescriptor modelDescriptor : modelDescriptors) {
                System.err.println("  " + modelDescriptor);
            }
        }
        AbstractIntegrationTestCase.assertEquals((String)"Unexpected number of model descriptors in workspace.", (int)expected, (int)modelDescriptors.size());
    }

    protected void assertProjectModelsSizeEquals(IProject project, int expected) {
        Collection modelDescriptors = ModelDescriptorRegistry.INSTANCE.getModels((IContainer)project);
        if (expected == 0 && modelDescriptors.size() > 0) {
            System.err.println("Unexpected number of model descriptor(s) in project '" + project.getName() + "':");
            for (IModelDescriptor modelDescriptor : modelDescriptors) {
                System.err.println("  " + modelDescriptor);
            }
        }
        AbstractIntegrationTestCase.assertEquals((String)("Unexpected number of model descriptor(s) in project '" + project.getName() + "'."), (int)expected, (int)modelDescriptors.size());
    }

    protected void assertProjectHasModels(IProject project, IMetaModelDescriptor metaModelDescriptor) {
        Collection models = ModelDescriptorRegistry.INSTANCE.getModels((IContainer)project, metaModelDescriptor);
        AbstractIntegrationTestCase.assertTrue((String)("Missing '" + metaModelDescriptor + "' model descriptor in project '" + project.getName() + "'."), (!models.isEmpty() ? 1 : 0) != 0);
    }

    protected void assertProjectHasNoModels(IProject project, IMetaModelDescriptor metaModelDescriptor) {
        Collection models = ModelDescriptorRegistry.INSTANCE.getModels((IContainer)project, metaModelDescriptor);
        AbstractIntegrationTestCase.assertTrue((String)("Unexpected '" + metaModelDescriptor + "' model descriptor in project '" + project.getName() + "'."), (boolean)models.isEmpty());
    }

    protected void synchronizedLoadFile(IFile file) {
        ModelLoadManager.INSTANCE.loadFile(file, true, null);
        this.waitForModelLoading();
    }

    protected void synchronizedUnloadFile(IFile file) {
        ModelLoadManager.INSTANCE.unloadFile(file, true, null);
        this.waitForModelLoading();
    }

    protected void synchronizedDeleteFile(final IFile file) throws CoreException {
        AbstractIntegrationTestCase.assertNotNull((Object)file);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                file.delete(true, true, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        ResourcesPlugin.getWorkspace().checkpoint(false);
        this.waitForModelLoading();
    }

    protected void synchronizedMoveFile(final IFile file, final IPath target) throws CoreException {
        AbstractIntegrationTestCase.assertNotNull((Object)file);
        AbstractIntegrationTestCase.assertNotNull((Object)target);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                file.move(target, true, (IProgressMonitor)new NullProgressMonitor());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        ResourcesPlugin.getWorkspace().checkpoint(false);
        this.waitForModelLoading();
    }

    protected void synchronizedRenameFile(final IFile file, String newname) throws CoreException {
        AbstractIntegrationTestCase.assertNotNull((Object)file);
        AbstractIntegrationTestCase.assertNotNull((Object)newname);
        AbstractIntegrationTestCase.assertFalse((newname.length() == 0 ? 1 : 0) != 0);
        final IPath newPath = file.getFullPath().removeLastSegments(1).append(newname);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                file.move(newPath, true, (IProgressMonitor)new NullProgressMonitor());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        ResourcesPlugin.getWorkspace().checkpoint(false);
        this.waitForModelLoading();
    }

    protected void synchronizedSetFileContents(final IFile file, final InputStream source) throws CoreException {
        AbstractIntegrationTestCase.assertNotNull((Object)source);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                file.setContents(source, true, true, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        this.waitForModelLoading();
    }

    protected void deleteExternalResource(String path) throws IOException {
        URI uri = URI.createURI((String)path, (boolean)true);
        URI fileURI = EcoreResourceUtil.convertToAbsoluteFileURI((URI)uri);
        File file = new File(fileURI.toFileString());
        this.deleteExternalResource(file);
    }

    protected void deleteExternalResource(File file) throws IOException {
        Assert.isNotNull((Object)file);
        if (file.isDirectory()) {
            String[] children;
            String[] stringArray = children = file.list();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                this.deleteExternalResource(new File(file, child));
                ++n2;
            }
            if (!file.delete()) {
                throw new IOException("Unable to delete external directory: '" + file.getPath() + "'");
            }
        } else if (file.exists() && !file.delete()) {
            throw new IOException("Unable to delete external file: '" + file.getPath() + "'");
        }
    }

    protected void synchronizedDeleteFolder(final IFolder folder) throws Exception {
        AbstractIntegrationTestCase.assertNotNull((Object)folder);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                folder.delete(true, true, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        ResourcesPlugin.getWorkspace().checkpoint(false);
        this.waitForModelLoading();
    }

    protected void synchronizedMoveFolder(final IFolder folder, final IPath target) throws CoreException {
        AbstractIntegrationTestCase.assertNotNull((Object)folder);
        AbstractIntegrationTestCase.assertNotNull((Object)target);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                folder.move(target, true, (IProgressMonitor)new NullProgressMonitor());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        ResourcesPlugin.getWorkspace().checkpoint(false);
        this.waitForModelLoading();
    }

    protected void synchronizedLoadProject(IProject project, boolean includeReferencedProjects) {
        ModelLoadManager.INSTANCE.loadProject(project, includeReferencedProjects, true, null);
        this.waitForModelLoading();
    }

    protected void synchronizedLoadAllProjects() {
        ModelLoadManager.INSTANCE.loadProjects(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()), true, true, null);
        this.waitForModelLoading();
    }

    protected void synchronizedUnloadProject(IProject project, boolean includeReferencedProjects) {
        ModelLoadManager.INSTANCE.unloadProject(project, includeReferencedProjects, true, null);
        this.waitForModelLoading();
    }

    protected void synchronizedUnloadProjects(Collection<IProject> projectsToUnload, boolean includeReferenceProjects) {
        ModelLoadManager.INSTANCE.unloadProjects(projectsToUnload, includeReferenceProjects, true, null);
        this.waitForModelLoading();
    }

    protected void synchronizedUnloadAllProjects() {
        ModelLoadManager.INSTANCE.unloadProjects(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()), false, true, null);
        this.waitForModelLoading();
    }

    protected void synchronizedOpenProject(final IProject project) throws Exception {
        AbstractIntegrationTestCase.assertNotNull((Object)project);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.open(monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        ResourcesPlugin.getWorkspace().checkpoint(false);
        this.waitForModelLoading();
    }

    protected void synchronizedOpenProjects(final Collection<IProject> projects) throws Exception {
        AbstractIntegrationTestCase.assertNotNull(projects);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                for (IProject project : projects) {
                    project.open(monitor);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        ResourcesPlugin.getWorkspace().checkpoint(false);
        this.waitForModelLoading();
    }

    protected void synchronizedOpenAllProjects() throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                MultiStatus errorStatus = new MultiStatus(Activator.getPlugin().getSymbolicName(), 4, "Problems encountered while opening projects.", (Throwable)new RuntimeException());
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)ResourcesPlugin.getWorkspace().getRoot().getProjects().length);
                IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    try {
                        project.open((IProgressMonitor)progress.newChild(1));
                    }
                    catch (CoreException ex) {
                        errorStatus.add(ex.getStatus());
                    }
                    ++n2;
                }
                if (errorStatus.getChildren().length > 0) {
                    throw new CoreException((IStatus)errorStatus);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        ResourcesPlugin.getWorkspace().checkpoint(false);
        this.waitForModelLoading();
    }

    protected void synchronizedRenameProject(final IProject project, final String newName) throws Exception {
        AbstractIntegrationTestCase.assertNotNull((Object)project);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.move(project.getFullPath().removeLastSegments(1).append(newName), true, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        ResourcesPlugin.getWorkspace().checkpoint(false);
        this.waitForModelLoading();
    }

    protected void synchronizedCloseProject(final IProject project) throws Exception {
        AbstractIntegrationTestCase.assertNotNull((Object)project);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.close(monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        ResourcesPlugin.getWorkspace().checkpoint(false);
        this.waitForModelLoading();
    }

    protected void synchronizedCloseAllProjects() throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                MultiStatus errorStatus = new MultiStatus(Activator.getPlugin().getSymbolicName(), 4, "Problems encountered while closing projects.", (Throwable)new RuntimeException());
                ArrayList<IProject> safeProjects = new ArrayList<IProject>(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()));
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)safeProjects.size());
                for (IProject project : safeProjects) {
                    try {
                        project.close((IProgressMonitor)progress.newChild(1));
                    }
                    catch (CoreException ex) {
                        errorStatus.add(ex.getStatus());
                    }
                }
                if (errorStatus.getChildren().length > 0) {
                    throw new CoreException((IStatus)errorStatus);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        ResourcesPlugin.getWorkspace().checkpoint(false);
        this.waitForModelLoading();
    }

    protected void synchronizedDeleteProject(final IProject project) throws Exception {
        AbstractIntegrationTestCase.assertNotNull((Object)project);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                AbstractIntegrationTestCase.this.safeDeleteProject(project, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        ResourcesPlugin.getWorkspace().checkpoint(false);
        this.waitForModelLoading();
    }

    protected void synchronizedDeleteProjects(final Collection<IProject> projects) throws Exception {
        AbstractIntegrationTestCase.assertNotNull(projects);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                MultiStatus errorStatus = new MultiStatus(Activator.getPlugin().getSymbolicName(), 4, "Problems encountered while closing projects.", (Throwable)new RuntimeException());
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)projects.size());
                for (IProject project : projects) {
                    try {
                        AbstractIntegrationTestCase.this.safeDeleteProject(project, (IProgressMonitor)progress.newChild(1));
                    }
                    catch (CoreException ex) {
                        errorStatus.add(ex.getStatus());
                    }
                }
                if (errorStatus.getChildren().length > 0) {
                    throw new CoreException((IStatus)errorStatus);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        ResourcesPlugin.getWorkspace().checkpoint(false);
        this.waitForModelLoading();
    }

    private void safeDeleteProject(IProject project, IProgressMonitor monitor) throws CoreException {
        int i = 0;
        while (i < 5) {
            try {
                project.delete(true, true, monitor);
                return;
            }
            catch (CoreException ex) {
                if (i == 4) {
                    throw ex;
                }
                try {
                    Thread.sleep(500L + Math.round(1500.0 * Math.random()));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    protected void synchronizedDeleteWorkspace() throws CoreException {
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                workspace.getRoot().delete(true, true, null);
            }
        };
        workspace.run(runnable, (ISchedulingRule)workspace.getRoot(), 1, null);
        workspace.checkpoint(false);
        this.waitForModelLoading();
    }

    protected Resource getProjectResource(IProject project, String fileName) {
        AbstractIntegrationTestCase.assertNotNull((Object)project);
        AbstractIntegrationTestCase.assertNotNull((Object)fileName);
        IFile file = project.getFile(fileName);
        return EcorePlatformUtil.getResource((IFile)file);
    }

    protected Collection<IFile> getAllModelFiles() {
        HashSet<IFile> allFiles = new HashSet<IFile>();
        for (IProject project : ExtendedPlatform.getRootProjects()) {
            for (IFile file : ExtendedPlatform.getAllFiles((IProject)project, (boolean)true)) {
                String fileName = file.getName();
                String fileExtension = file.getFileExtension();
                if (fileName.startsWith(".") || this.hasDotParent((IResource)file) || fileExtension.equals("java") || fileExtension.equals("xtend") || fileExtension.equals("_trace") || fileExtension.equals("class") || fileExtension.equals("MF") || fileName.equals("pom.xml") || fileName.equals("plugin.xml") || fileName.equals("plugin.properties") || fileName.equals("build.properties")) continue;
                allFiles.add(file);
            }
        }
        return allFiles;
    }

    private boolean hasDotParent(IResource resource) {
        AbstractIntegrationTestCase.assertNotNull((Object)resource);
        IContainer parent = resource.getParent();
        if (parent != null) {
            if (parent.getName().startsWith(".")) {
                return true;
            }
            return this.hasDotParent((IResource)parent);
        }
        return false;
    }

    protected void assertProxiesResolved(Resource inputResource) {
        AbstractIntegrationTestCase.assertNotNull((Object)inputResource);
        TreeIterator allContents = inputResource.getAllContents();
        while (allContents.hasNext()) {
            EObject object = (EObject)allContents.next();
            AbstractIntegrationTestCase.assertFalse((boolean)object.eIsProxy());
        }
    }

    protected void waitForModelLoading() {
        this.waitForFamily(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
    }

    protected void waitForModelSaving() {
        this.waitForFamily(IExtendedPlatformConstants.FAMILY_MODEL_SAVING);
    }

    protected void waitForAutoBuild() {
        this.waitForFamily(ResourcesPlugin.FAMILY_AUTO_BUILD);
    }

    private void waitForFamily(final Object family) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Job.getJobManager().join(family, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.setDaemon(true);
        t.start();
        try {
            t.join(Integer.parseInt(JOB_FAMILY_TIMEOUT));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (t.isAlive()) {
            throw new RuntimeException("Timeout while waiting for job family '" + family + "'.");
        }
    }

    protected void importExternalResourceToWorkspace(File externalResource, IContainer targetContainer) throws Exception {
        AbstractIntegrationTestCase.assertNotNull((Object)externalResource);
        AbstractIntegrationTestCase.assertNotNull((Object)targetContainer);
        if (externalResource.exists()) {
            if (externalResource.isDirectory()) {
                Object importedContainer = targetContainer instanceof IWorkspaceRoot ? ((IWorkspaceRoot)targetContainer).getProject(externalResource.getName()) : targetContainer.getFolder((IPath)new Path(externalResource.getName()));
                File[] fileArray = externalResource.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    this.importExternalResourceToWorkspace(file, (IContainer)importedContainer);
                    ++n2;
                }
            } else {
                this.createContainerTree(targetContainer);
                IFile importedFile = targetContainer.getFile((IPath)new Path(externalResource.getName()));
                FileInputStream externalFileContents = new FileInputStream(externalResource);
                if (importedFile.exists()) {
                    importedFile.setCharset(null, null);
                    importedFile.setContents((InputStream)externalFileContents, true, false, null);
                } else {
                    try {
                        importedFile.create((InputStream)externalFileContents, true, null);
                        importedFile.setCharset(null, null);
                    }
                    catch (Exception ex) {
                        if (ex.getMessage().contains("already exists")) {
                            externalFileContents = new FileInputStream(externalResource);
                            importedFile.setCharset(null, null);
                            importedFile.setContents((InputStream)externalFileContents, true, false, null);
                        }
                        throw ex;
                    }
                }
                importedFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    private void createContainerTree(IContainer container) throws Exception {
        Assert.isNotNull((Object)container);
        IProject project = container.getProject();
        if (!project.exists()) {
            project.create(null);
            project.open(null);
        } else if (!project.isAccessible()) {
            project.open(null);
        }
        if (container.getFullPath().segmentCount() > 1) {
            IProject parentContainer = project;
            int i = 1;
            while (i < container.getFullPath().segmentCount()) {
                IFolder folder;
                block8: {
                    folder = parentContainer.getFolder((IPath)new Path(container.getFullPath().segment(i)));
                    if (!folder.exists()) {
                        try {
                            folder.create(true, true, null);
                        }
                        catch (Exception ex) {
                            if (ex.getMessage().contains("already exists")) break block8;
                            throw ex;
                        }
                    }
                }
                parentContainer = folder;
                ++i;
            }
        }
    }

    protected void synchronizedImportExternalResourceToWorkspace(final File externalResource, final IContainer targetContainer) throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    AbstractIntegrationTestCase.this.importExternalResourceToWorkspace(externalResource, targetContainer);
                }
                catch (Exception ex) {
                    IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
                    throw new CoreException(status);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        ResourcesPlugin.getWorkspace().checkpoint(false);
        this.waitForModelLoading();
    }

    protected void synchronizedImportInputFileToWorkspace(String inputFileName, IContainer targetContainer) throws Exception {
        java.net.URI inputFileURI = this.getTestFileAccessor().getInputFileURI(inputFileName, true);
        this.synchronizedImportExternalResourceToWorkspace(new File(inputFileURI), targetContainer);
    }

    protected ReferenceWorkspaceChangeListener getReferenceWorkspaceChangeListener() {
        return this.referenceWorkspaceChangeListener;
    }

    private class ModelLoadingJobTracer
    extends JobChangeAdapter {
        private ModelLoadingJobTracer() {
        }

        private boolean isModelLoadingJob(IJobChangeEvent event) {
            Job job;
            if (event != null && (job = event.getJob()) != null) {
                return job.belongsTo(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
            }
            return false;
        }

        public void scheduled(IJobChangeEvent event) {
            this.isModelLoadingJob(event);
        }

        public void running(IJobChangeEvent event) {
            this.isModelLoadingJob(event);
        }

        public void done(IJobChangeEvent event) {
            this.isModelLoadingJob(event);
        }
    }
}

