/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.jdt.util;

import com.google.common.base.Objects;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.sphinx.jdt.loaders.ProjectClassLoader;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ClassLoaderExtensions {
    public static void printHierarchy(ClassLoader classLoader) {
        ArrayList<ClassLoader> classLoaderHierarchy = new ArrayList<ClassLoader>();
        classLoaderHierarchy.add(classLoader);
        ClassLoader parentClassLoader = classLoader.getParent();
        while (!Objects.equal((Object)parentClassLoader, null)) {
            classLoaderHierarchy.add(parentClassLoader);
            parentClassLoader = parentClassLoader.getParent();
        }
        ListExtensions.reverse(classLoaderHierarchy);
        Consumer<ClassLoader> _function = new Consumer<ClassLoader>(){

            @Override
            public void accept(ClassLoader it) {
                ClassLoaderExtensions.print(it);
            }
        };
        classLoaderHierarchy.forEach(_function);
    }

    public static void print(ClassLoader classLoader) {
        String classLoaderAsString = null;
        if (classLoader instanceof ProjectClassLoader) {
            classLoaderAsString = ((ProjectClassLoader)classLoader).toString();
        } else if (classLoader instanceof URLClassLoader) {
            String _plus_2;
            String _name = ((URLClassLoader)classLoader).getClass().getName();
            String _plus = String.valueOf(_name) + " [urls=";
            String _string = Arrays.toString(((URLClassLoader)classLoader).getURLs());
            String _plus_1 = String.valueOf(_plus) + _string;
            classLoaderAsString = _plus_2 = String.valueOf(_plus_1) + "]";
        } else {
            classLoaderAsString = classLoader.toString();
        }
        InputOutput.println((Object)classLoaderAsString);
    }
}

