/**
 * <copyright>
 * 
 * Copyright (c) 2014 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 * 
 * </copyright>
 */
package org.eclipse.sphinx.examples.workflows.model;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.sphinx.emf.mwe.dynamic.components.AbstractModelWorkflowComponent;
import org.eclipse.sphinx.examples.workflows.lib.ModelWorkflowExtensions;
import org.eclipse.xtext.xbase.lib.InputOutput;

@SuppressWarnings("all")
public class PrintModelSlotWorkflowComponent extends AbstractModelWorkflowComponent {
  @Override
  protected void invokeInternal(final WorkflowContext ctx, final ProgressMonitor monitor, final Issues issues) {
    InputOutput.<String>println("Executing Print Model Slot workflow component");
    final List<EObject> modelObjects = ModelWorkflowExtensions.getModelSlot(ctx);
    String msg = "Model slot contains: ";
    final Iterator<EObject> iter = modelObjects.iterator();
    while (iter.hasNext()) {
      {
        String _msg = msg;
        String _label = ModelWorkflowExtensions.getLabel(iter.next());
        msg = (_msg + _label);
        boolean _hasNext = iter.hasNext();
        if (_hasNext) {
          String _msg_1 = msg;
          msg = (_msg_1 + ", ");
        }
      }
    }
    InputOutput.<String>println(msg);
    InputOutput.<String>println("Done!");
  }
}
