/**
 * <copyright>
 * 
 * Copyright (c) 2014 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 * 
 * </copyright>
 */
package org.eclipse.sphinx.emf.serialization.generators.xsd;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.sphinx.emf.serialization.generators.util.JavaXSDPrimitiveTypeMapping;
import org.eclipse.sphinx.emf.serialization.generators.xsd.Ecore2XSDFactory;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class Ecore2XSDConverter {
  protected Ecore2XSDFactory xsdFactory;
  
  protected XSDSchema xsdSchema;
  
  protected ArrayList<EClass> referencedClass = new ArrayList<EClass>();
  
  public Ecore2XSDConverter(final Ecore2XSDFactory xsdFactory, final XSDSchema xsdSchema) {
    this.xsdFactory = xsdFactory;
    this.xsdSchema = xsdSchema;
  }
  
  /**
   * convert Package schema
   */
  public XSDSchema doConvertRMFPackageSchema2(final EPackage rootEPackageModel, final IProgressMonitor monitor) {
    final SubMonitor progress = SubMonitor.convert(monitor, 100);
    boolean _isCanceled = progress.isCanceled();
    if (_isCanceled) {
      throw new OperationCanceledException();
    }
    progress.subTask("create XSD global element");
    this.xsdFactory.createGlobalElement3(rootEPackageModel, this.xsdSchema);
    progress.worked(5);
    final SubMonitor classProgress = progress.newChild(70);
    classProgress.subTask("create XSD class type definitions");
    this.doConvertToRMFClassTypeDef5(rootEPackageModel, classProgress);
    final SubMonitor enumProgress = progress.newChild(10);
    enumProgress.subTask("create XSD Enum schema");
    this.doConvertToRMFEnumSchema6(rootEPackageModel, enumProgress);
    final SubMonitor dtProgress = progress.newChild(10);
    dtProgress.subTask("create XSD Data type schema");
    this.doConvertToRMFDataTypeSchema7(rootEPackageModel, dtProgress);
    final SubMonitor rstProgress = progress.newChild(5);
    rstProgress.subTask("create referenced simple types");
    this.doConvertToReferencedSimpleType8(rootEPackageModel, rstProgress);
    return this.xsdSchema;
  }
  
  /**
   * convert to Class type def
   */
  public void doConvertToRMFClassTypeDef5(final EPackage rootEPackageModel, final IProgressMonitor monitor) {
    final SubMonitor progress = SubMonitor.convert(monitor, 100);
    boolean _isCanceled = progress.isCanceled();
    if (_isCanceled) {
      throw new OperationCanceledException();
    }
    final SubMonitor classProgress = progress.newChild(50).setWorkRemaining(rootEPackageModel.getEClassifiers().size());
    final Function1<EClassifier, Boolean> _function = new Function1<EClassifier, Boolean>() {
      @Override
      public Boolean apply(final EClassifier it) {
        return Boolean.valueOf((it instanceof EClass));
      }
    };
    final Consumer<EClassifier> _function_1 = new Consumer<EClassifier>() {
      @Override
      public void accept(final EClassifier it) {
        Ecore2XSDConverter.this.xsdFactory.createClassTypeDefinition5(((EClass) it), Ecore2XSDConverter.this.xsdSchema, Ecore2XSDConverter.this.referencedClass, classProgress);
      }
    };
    IterableExtensions.<EClassifier>filter(rootEPackageModel.getEClassifiers(), _function).forEach(_function_1);
    final SubMonitor subProgress = progress.newChild(50).setWorkRemaining(rootEPackageModel.getESubpackages().size());
    final Consumer<EPackage> _function_2 = new Consumer<EPackage>() {
      @Override
      public void accept(final EPackage it) {
        Ecore2XSDConverter.this.doConvertToRMFClassTypeDef5(it, subProgress);
        subProgress.worked(1);
        boolean _isCanceled = subProgress.isCanceled();
        if (_isCanceled) {
          throw new OperationCanceledException();
        }
      }
    };
    rootEPackageModel.getESubpackages().forEach(_function_2);
  }
  
  /**
   * convert to EEnum schema
   */
  public void doConvertToRMFEnumSchema6(final EPackage rootEPackageModel, final IProgressMonitor monitor) {
    final SubMonitor progress = SubMonitor.convert(monitor, 100);
    boolean _isCanceled = progress.isCanceled();
    if (_isCanceled) {
      throw new OperationCanceledException();
    }
    final SubMonitor classProgress = progress.newChild(50).setWorkRemaining(rootEPackageModel.getEClassifiers().size());
    final Function1<EClassifier, Boolean> _function = new Function1<EClassifier, Boolean>() {
      @Override
      public Boolean apply(final EClassifier it) {
        return Boolean.valueOf((it instanceof EEnum));
      }
    };
    final Consumer<EClassifier> _function_1 = new Consumer<EClassifier>() {
      @Override
      public void accept(final EClassifier it) {
        Ecore2XSDConverter.this.xsdFactory.createEnumSchema6(((EEnum) it), Ecore2XSDConverter.this.xsdSchema);
        classProgress.worked(1);
        boolean _isCanceled = classProgress.isCanceled();
        if (_isCanceled) {
          throw new OperationCanceledException();
        }
      }
    };
    IterableExtensions.<EClassifier>filter(rootEPackageModel.getEClassifiers(), _function).forEach(_function_1);
    final SubMonitor subProgress = progress.newChild(50).setWorkRemaining(rootEPackageModel.getESubpackages().size());
    final Consumer<EPackage> _function_2 = new Consumer<EPackage>() {
      @Override
      public void accept(final EPackage it) {
        Ecore2XSDConverter.this.doConvertToRMFEnumSchema6(it, subProgress);
        subProgress.worked(1);
        boolean _isCanceled = subProgress.isCanceled();
        if (_isCanceled) {
          throw new OperationCanceledException();
        }
      }
    };
    rootEPackageModel.getESubpackages().forEach(_function_2);
  }
  
  /**
   * convert to EDataType schema
   */
  public void doConvertToRMFDataTypeSchema7(final EPackage rootEPackageModel, final IProgressMonitor monitor) {
    final SubMonitor progress = SubMonitor.convert(monitor, 100);
    boolean _isCanceled = progress.isCanceled();
    if (_isCanceled) {
      throw new OperationCanceledException();
    }
    final SubMonitor classProgress = progress.newChild(50).setWorkRemaining(rootEPackageModel.getEClassifiers().size());
    final Function1<EClassifier, Boolean> _function = new Function1<EClassifier, Boolean>() {
      @Override
      public Boolean apply(final EClassifier it) {
        return Boolean.valueOf(((it instanceof EDataType) && (!(it instanceof EEnum))));
      }
    };
    final Consumer<EClassifier> _function_1 = new Consumer<EClassifier>() {
      @Override
      public void accept(final EClassifier it) {
        Boolean _isGeneralPrimitiveType = Ecore2XSDConverter.this.isGeneralPrimitiveType(((EDataType) it));
        if ((_isGeneralPrimitiveType).booleanValue()) {
          Boolean _isXMLPrimitiveXsdType = Ecore2XSDConverter.this.xsdFactory.isXMLPrimitiveXsdType(((EDataType) it));
          boolean _not = (!(_isXMLPrimitiveXsdType).booleanValue());
          if (_not) {
            Ecore2XSDConverter.this.xsdFactory.createDataTypeSchema7b(((EDataType) it), Ecore2XSDConverter.this.xsdSchema);
          }
        } else {
          Ecore2XSDConverter.this.xsdFactory.createDataTypeSchema7a(((EDataType) it), Ecore2XSDConverter.this.xsdSchema);
        }
        classProgress.worked(1);
        boolean _isCanceled = classProgress.isCanceled();
        if (_isCanceled) {
          throw new OperationCanceledException();
        }
      }
    };
    IterableExtensions.<EClassifier>filter(rootEPackageModel.getEClassifiers(), _function).forEach(_function_1);
    final SubMonitor subProgress = progress.newChild(50).setWorkRemaining(rootEPackageModel.getEClassifiers().size());
    final Consumer<EPackage> _function_2 = new Consumer<EPackage>() {
      @Override
      public void accept(final EPackage it) {
        Ecore2XSDConverter.this.doConvertToRMFDataTypeSchema7(it, subProgress);
        subProgress.worked(1);
        boolean _isCanceled = subProgress.isCanceled();
        if (_isCanceled) {
          throw new OperationCanceledException();
        }
      }
    };
    rootEPackageModel.getESubpackages().forEach(_function_2);
  }
  
  /**
   * convert EDataType
   */
  public void doConvertToReferencedSimpleType8(final EPackage rootEPackageModel, final IProgressMonitor monitor) {
    final SubMonitor progress = SubMonitor.convert(monitor, 100);
    boolean _isCanceled = progress.isCanceled();
    if (_isCanceled) {
      throw new OperationCanceledException();
    }
    final SubMonitor classProgress = progress.newChild(50).setWorkRemaining(rootEPackageModel.getEClassifiers().size());
    final Function1<EClassifier, Boolean> _function = new Function1<EClassifier, Boolean>() {
      @Override
      public Boolean apply(final EClassifier it) {
        return Boolean.valueOf((it instanceof EClass));
      }
    };
    final Consumer<EClassifier> _function_1 = new Consumer<EClassifier>() {
      @Override
      public void accept(final EClassifier it) {
        Ecore2XSDConverter.this.xsdFactory.createSimpleType8(((EClass) it), Ecore2XSDConverter.this.xsdSchema);
        classProgress.worked(1);
        boolean _isCanceled = classProgress.isCanceled();
        if (_isCanceled) {
          throw new OperationCanceledException();
        }
      }
    };
    IterableExtensions.<EClassifier>filter(rootEPackageModel.getEClassifiers(), _function).forEach(_function_1);
    final SubMonitor subProgress = progress.newChild(50).setWorkRemaining(rootEPackageModel.getEClassifiers().size());
    final Consumer<EPackage> _function_2 = new Consumer<EPackage>() {
      @Override
      public void accept(final EPackage it) {
        Ecore2XSDConverter.this.doConvertToReferencedSimpleType8(it, subProgress);
        subProgress.worked(1);
        boolean _isCanceled = subProgress.isCanceled();
        if (_isCanceled) {
          throw new OperationCanceledException();
        }
      }
    };
    rootEPackageModel.getESubpackages().forEach(_function_2);
  }
  
  protected Boolean isGeneralPrimitiveType(final EDataType dataType) {
    final Class<?> instanceClass = dataType.getInstanceClass();
    String _get = JavaXSDPrimitiveTypeMapping.javaXsdPrimitiveTypeMapping.get(instanceClass);
    boolean _notEquals = (!Objects.equal(_get, null));
    if (_notEquals) {
      return Boolean.valueOf(true);
    }
    return Boolean.valueOf(false);
  }
}
